/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.internal.StringHasher;
import java.io.InputStream;

final class UTF8CharReader
extends XMLReader {
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected XMLScanner fScanner;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLErrorHandler fErrorHandler;
    protected StringPool fStringPool;
    protected InputStream fInputStream;
    protected UTF8CharDataChunk fCurrentChunk;
    protected int fCurrentIndex;
    protected char[] fMostRecentData;
    protected int fMostRecentChar;
    protected int fLength;
    protected boolean fCheckOverflow = false;
    protected byte[] fOverflow;
    protected int fOverflowOffset;
    protected int fOverflowEnd;
    protected boolean fSkipLinefeed = false;
    protected int fPartialMultiByteIn;
    protected byte[] fPartialMultiByteChar = new byte[3];
    protected int fPartialSurrogatePair;
    protected boolean fPartialMultiByteResult = false;
    protected int fFastCopyCount;
    protected int fOutputOffset;

    UTF8CharReader(ParserState parserState, String string, String string2, InputStream inputStream) throws Exception {
        super(parserState, string, string2);
        this.fInputStream = inputStream;
        this.fScanner = parserState.getScanner();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fCurrentChunk = new UTF8CharDataChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    protected int addSymbol(int n, int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, n3);
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        this.fCurrentChunk.append(chunkyCharArray, n, n2);
    }

    protected int slowLoadNextChar() throws Exception {
        UTF8CharDataChunk uTF8CharDataChunk = this.fCurrentChunk;
        if (uTF8CharDataChunk.fNextChunk != null) {
            uTF8CharDataChunk = this.fCurrentChunk;
            this.fCurrentChunk = uTF8CharDataChunk.fNextChunk;
            this.fCurrentIndex = 0;
            uTF8CharDataChunk = this.fCurrentChunk;
            this.fMostRecentData = uTF8CharDataChunk.fData;
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
            return this.fMostRecentChar;
        }
        this.fCurrentChunk = new UTF8CharDataChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    protected int loadNextChar() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextChar();
        }
        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        return this.fMostRecentChar;
    }

    protected void checkEOF(int n) {
        if (n > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public int skipOneChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n == 0) {
            int n2 = this.fCurrentOffset + 1;
            if (n2 > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n >= 55296 && n < 56320) {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (n < 56320 || n >= 57344) {
                return this.fCurrentOffset;
            }
        } else {
            ++this.fCharacterCounter;
        }
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws Exception {
        ++this.fCharacterCounter;
        this.loadNextChar();
        return this.fCurrentOffset;
    }

    public int skipToChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (n != c) {
            if (n == 0) {
                int n2 = this.fCurrentOffset + 1;
                if (n2 > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (true) {
            if (n == c) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return this.fCurrentOffset;
            }
            if (n == 0) {
                int n2 = this.fCurrentOffset + 1;
                if (n2 > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n >= 55296 && n < 56320) {
                ++this.fCharacterCounter;
                n = this.loadNextChar();
                if (n < 56320 || n >= 57344) {
                    continue;
                }
            } else {
                ++this.fCharacterCounter;
            }
            n = this.loadNextChar();
        }
    }

    public boolean skippedValidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 55296) {
            int n2;
            if (n >= 32 || n == 9) {
                ++this.fCharacterCounter;
                this.loadNextChar();
                return true;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                this.loadNextChar();
                return true;
            }
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        if (n > 65533) {
            return false;
        }
        if (n < 56320 ? (n = this.loadNextChar()) < 56320 || n >= 57344 : n < 57344) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean lookingAtValidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 32) {
            int n2;
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return n == 9 || n == 10 || n == 13;
        }
        return n <= 65533;
    }

    public int skipInvalidChar(int n) throws Exception {
        int n2 = this.fMostRecentChar;
        if (n2 == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
        } else {
            ++this.fCharacterCounter;
            if (n2 >= 55296 && n2 < 56320) {
                int n3 = this.loadNextChar();
                if (n3 >= 56320 && n3 < 57344) {
                    n2 = (n2 - 55296 << 10) + (n3 - 56320) + 65536;
                    this.loadNextChar();
                }
            } else {
                this.loadNextChar();
            }
        }
        switch (n) {
            case 63: 
            case 85: {
                String string = Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String string = n2 < 65536 ? new Character((char)n2).toString() : Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 43: {
                String string = n2 < 65536 ? new Character((char)n2).toString() : Integer.toHexString(n2);
                String string2 = Integer.toHexString(n2);
                this.fErrorHandler.error2(n, this.fStringPool.addString(string), this.fStringPool.addString(string2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n != c) {
            int n2;
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        return n == c;
    }

    public boolean skippedSpace() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            ++this.fCharacterCounter;
        } else if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            int n2;
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 0xFFFF;
        }
        return true;
    }

    public boolean lookingAtSpace() {
        int n = this.fMostRecentChar;
        return n == 32 || n == 9 || n == 10;
    }

    public int skipPastSpaces() throws Exception {
        int n = this.fMostRecentChar;
        int n2 = this.fCurrentOffset;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                int n3;
                if (n == 0 && n2 == this.fCurrentOffset && (n3 = this.fCurrentOffset + 1) > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.fCurrentOffset;
            }
            n = this.loadNextChar();
        }
    }

    public int skipDecimalDigit() throws Exception {
        int n = this.fMostRecentChar;
        if (n < 48 || n > 57) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return n - 48;
    }

    public int skipHexDigit() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 102 || XMLReader.fgAsciiXDigitChar[n] == 0) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws Exception {
        int n = this.fMostRecentChar;
        if (n > 122 || XMLReader.fgAsciiAlphaChar[n] == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    protected boolean skippedAsciiCharWithFlag(byte by) throws Exception {
        int n = this.fMostRecentChar;
        if (n >= 128 || (XMLReader.fgCharFlags[n] & by) == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextChar();
        return true;
    }

    public boolean skippedVersionNum() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)1);
    }

    public boolean skippedEncName() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)2);
    }

    public boolean skippedPubidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n >= 128) {
            return false;
        }
        if ((XMLReader.fgCharFlags[n] & 4) != 0) {
            ++this.fCharacterCounter;
            this.loadNextChar();
            return true;
        }
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextChar();
            return true;
        }
        return false;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = cArray.length;
        char[] cArray2 = this.fMostRecentData;
        int n2 = this.fCurrentIndex;
        if (n2 + n <= 16384) {
            int n3 = 0;
            while (n3 < n) {
                if (cArray2[n2++] != cArray[n3]) {
                    return false;
                }
                ++n3;
            }
            this.fCharacterCounter += n;
            this.fCurrentOffset += n;
            this.fCurrentIndex = n2;
            if (n2 == 16384) {
                this.slowLoadNextChar();
            } else {
                this.fMostRecentChar = cArray2[n2] & 0xFFFF;
            }
            return true;
        }
        UTF8CharDataChunk uTF8CharDataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentOffset;
        int n5 = n2;
        int n6 = 0;
        while (n2 < 16384) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            return false;
        }
        this.slowLoadNextChar();
        cArray2 = this.fMostRecentData;
        n2 = 0;
        while (n6 < n) {
            if (cArray2[n2++] == cArray[n6++]) continue;
            this.fCurrentChunk = uTF8CharDataChunk;
            this.fCurrentIndex = n5;
            this.fCurrentOffset = n4;
            this.fMostRecentData = uTF8CharDataChunk.fData;
            this.fMostRecentChar = this.fMostRecentData[n5] & 0xFFFF;
            return false;
        }
        this.fCharacterCounter += n;
        this.fCurrentOffset += n;
        this.fCurrentIndex = n2;
        if (n2 == 16384) {
            this.slowLoadNextChar();
        } else {
            this.fMostRecentChar = cArray2[n2] & 0xFFFF;
        }
        return true;
    }

    public int scanName(char c, int n) throws Exception {
        int n2;
        int n3 = this.fMostRecentChar;
        if (n3 < 128 ? XMLReader.fgAsciiInitialNameChar[n3] == 0 : (XMLReader.fgCharFlags[n3] & 0x10) == 0) {
            return -1;
        }
        int n4 = this.fCurrentOffset;
        int n5 = this.fCurrentIndex;
        char[] cArray = this.fMostRecentData;
        if (++n5 == 16384) {
            this.fCurrentChunk = new UTF8CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n5 = 0;
            cArray = this.fMostRecentData;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            n6 = StringHasher.hashChar(n6, n7++, n3);
            n3 = cArray[n5] & 0xFFFF;
            if (c == n3 || (n3 >= 128 ? (XMLReader.fgCharFlags[n3] & 0x20) == 0 : XMLReader.fgAsciiNameChar[n3] == 0)) break;
            if (++n5 == 16384) {
                this.fCurrentChunk = new UTF8CharDataChunk(this.fStringPool, this.fCurrentChunk);
                this.fillCurrentChunk();
                n5 = 0;
                cArray = this.fMostRecentData;
            }
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
        }
        this.fCurrentIndex = n5;
        this.fMostRecentChar = n3;
        int n8 = n6;
        n6 = (n8 &= Integer.MAX_VALUE) == 0 ? 1 : n8;
        n8 = this.fCurrentOffset - n4;
        int n9 = n2 = n8 == 0 ? 0 : this.fCurrentChunk.addSymbol(n4, n8, n6);
        if (n == -1 || n == n2) {
            return n2;
        }
        return -1;
    }

    public int skipPastName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128 ? XMLReader.fgAsciiInitialNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCharacterCounter;
            n = this.loadNextChar();
            if (c != n) continue;
            return this.fCurrentOffset;
        } while (!(n < 128 ? XMLReader.fgAsciiNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x20) == 0));
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (c != n) {
            if (n < 128 ? XMLReader.fgAsciiNameChar[n] == 0 : (XMLReader.fgCharFlags[n] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            ++this.fCharacterCounter;
            n = this.loadNextChar();
        }
        return this.fCurrentOffset;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState var1_1) throws Exception {
        block61: {
            var2_2 = this.fCurrentChunk;
            if (var2_2.fPreviousChunk != null) {
                var2_2.fPreviousChunk.fNextChunk = null;
                var2_2.fPreviousChunk = null;
            }
            var2_3 = this.fCurrentOffset++;
            var3_4 = this.fMostRecentChar;
            if (var3_4 >= 128) ** GOTO lbl66
            switch (XMLReader.fgAsciiWSCharData[var3_4]) {
                case 0: {
                    ++this.fCharacterCounter;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        ** break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    ** break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (var1_1.inCDSect) ** break;
                    return 1;
                }
                case 2: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                    } else {
                        this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    }
                    if (var1_1.inCDSect) ** break;
                    return 2;
                }
                case 3: {
                    ++this.fCharacterCounter;
                    var3_4 = this.loadNextChar();
                    if (var3_4 != 93) ** break;
                    if (this.fCurrentIndex + 1 == 16384) {
                        var4_5 = this.fCurrentChunk;
                        var5_8 = this.fCurrentIndex;
                        var6_11 = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = var4_5;
                            this.fCurrentIndex = var5_8;
                            this.fCurrentOffset = var6_11;
                            this.fMostRecentData = var4_5.fData;
                            this.fMostRecentChar = 93;
                            ** break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') ** break;
                        ++this.fCurrentIndex;
                        ++this.fCurrentOffset;
                    }
                    this.loadNextChar();
                    this.fCharacterCounter += 2;
                    if (var1_1.inCDSect == false) return 3;
                    var1_1.inCDSect = false;
                    return this.scanContent(var1_1);
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    break;
                }
lbl66:
                // 1 sources

                if (this.skipMultiByteCharData(var3_4)) ** break;
                return 4;
                default: {
                    break block61;
                }
            }
            do {
                if (var3_4 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++this.fCurrentOffset;
            } while ((var3_4 = ++this.fCurrentIndex == 16384 ? this.slowLoadNextChar() : (this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535)) == 32 || var3_4 == 9 || var3_4 == 10);
            if (var3_4 >= 128) ** GOTO lbl152
            switch (XMLReader.fgAsciiCharData[var3_4]) {
                case 0: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 1: {
                    if (!var1_1.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(var2_3, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 25;
                    }
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextChar();
                        break;
                    }
                    this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                    break;
                }
                case 2: {
                    if (!var1_1.inCDSect) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(var2_3, this.fCurrentOffset, false);
                        }
                        ++this.fCharacterCounter;
                        this.loadNextChar();
                        return 26;
                    }
                    ++this.fCharacterCounter;
                    this.loadNextChar();
                    break;
                }
                case 3: {
                    var4_6 = this.fCurrentOffset++;
                    var3_4 = this.loadNextChar();
                    if (var3_4 != 93) {
                        ++this.fCharacterCounter;
                        break;
                    }
                    if (this.fCurrentIndex + 1 == 16384) {
                        var5_9 = this.fCurrentChunk;
                        var6_11 = this.fCurrentIndex;
                        var7_12 = this.fCurrentOffset;
                        if (this.loadNextChar() != 62) {
                            this.fCurrentChunk = var5_9;
                            this.fCurrentIndex = var6_11;
                            this.fCurrentOffset = var7_12;
                            this.fMostRecentData = var5_9.fData;
                            this.fMostRecentChar = 93;
                            ++this.fCharacterCounter;
                            break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                            ++this.fCharacterCounter;
                            break;
                        }
                        ++this.fCurrentIndex;
                    }
                    this.loadNextChar();
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(var2_3, var4_6, var1_1.inCDSect);
                    }
                    this.fCharacterCounter += 3;
                    if (var1_1.inCDSect == false) return 27;
                    var1_1.inCDSect = false;
                    return this.scanContent(var1_1);
                }
                case 4: {
                    if (this.fDocumentHandler == null) return 28;
                    this.callWSCharDataHandler(var2_3, this.fCurrentOffset, var1_1.inCDSect);
                    return 28;
                }
lbl152:
                // 1 sources

                if (this.skipMultiByteCharData(var3_4)) break;
                if (this.fDocumentHandler == null) return 28;
                this.callWSCharDataHandler(var2_3, this.fCurrentOffset, var1_1.inCDSect);
                return 28;
            }
        }
        var3_4 = this.skipAsciiCharData();
        while (true) {
            if (var3_4 < 128) {
                switch (XMLReader.fgAsciiCharData[var3_4]) {
                    case 0: {
                        ++this.fCharacterCounter;
                        var3_4 = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_3, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextChar();
                                return 9;
                            }
                            this.fMostRecentChar = this.fMostRecentData[this.fCurrentIndex] & 65535;
                            return 9;
                        }
                        ++this.fCharacterCounter;
                        var3_4 = this.loadNextChar();
                        break;
                    }
                    case 2: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_3, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            this.loadNextChar();
                            return 10;
                        }
                        ++this.fCharacterCounter;
                        var3_4 = this.loadNextChar();
                        break;
                    }
                    case 3: {
                        var4_7 = this.fCurrentOffset++;
                        var3_4 = this.loadNextChar();
                        if (var3_4 != 93) {
                            ++this.fCharacterCounter;
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            var5_10 = this.fCurrentChunk;
                            var6_11 = this.fCurrentIndex;
                            var7_12 = this.fCurrentOffset;
                            if (this.loadNextChar() != 62) {
                                this.fCurrentChunk = var5_10;
                                this.fCurrentIndex = var6_11;
                                this.fCurrentOffset = var7_12;
                                this.fMostRecentData = var5_10.fData;
                                this.fMostRecentChar = 93;
                                ++this.fCharacterCounter;
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != '>') {
                                ++this.fCharacterCounter;
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextChar();
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(var2_3, var4_7, var1_1.inCDSect);
                        }
                        this.fCharacterCounter += 3;
                        if (var1_1.inCDSect == false) return 11;
                        var1_1.inCDSect = false;
                        return this.scanContent(var1_1);
                    }
                    case 4: {
                        if (var3_4 != 10) {
                            if (this.fDocumentHandler == null) return 12;
                            this.callCharDataHandler(var2_3, this.fCurrentOffset, var1_1.inCDSect);
                            return 12;
                        }
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        var3_4 = this.loadNextChar();
                        break;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(var3_4)) {
                if (this.fDocumentHandler == null) return 12;
                this.callCharDataHandler(var2_3, this.fCurrentOffset, var1_1.inCDSect);
                return 12;
            }
            var3_4 = this.fMostRecentChar;
        }
    }

    protected boolean skipMultiByteCharData(int n) throws Exception {
        if (n > 65533) {
            return false;
        }
        if (n >= 901120 && n < 57344) {
            return false;
        }
        if (n >= 884736 && n < 56320 && ((n = this.loadNextChar()) < 901120 || n >= 57344)) {
            return false;
        }
        this.loadNextChar();
        return true;
    }

    protected int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        while (true) {
            char[] cArray = this.fMostRecentData;
            while (n < 16384) {
                int n3 = cArray[n] & 0xFFFF;
                if (n3 >= 128) {
                    this.fCurrentOffset = n2 + n;
                    this.fCurrentIndex = n;
                    this.fMostRecentChar = n3;
                    return n3;
                }
                if (XMLReader.fgAsciiCharData[n3] != 0) {
                    if (n3 != 10) {
                        this.fCurrentOffset = n2 + n;
                        this.fCurrentIndex = n;
                        this.fMostRecentChar = n3;
                        return n3;
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++n;
            }
            n2 += n;
            this.fCurrentChunk = new UTF8CharDataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n = 0;
        }
    }

    public void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n4 = n3 == 0 ? 0 : this.fCurrentChunk.addString(n, n3);
            this.fDocumentHandler.characters(n4, bl);
            return;
        }
        UTF8CharDataChunk uTF8CharDataChunk = this.fCurrentChunk.chunkFor(n);
        int n5 = n & 0x3FFF;
        if (n5 + n3 <= 16384) {
            if (n3 != 0) {
                this.fDocumentHandler.characters(uTF8CharDataChunk.fData, n5, n3, bl);
            }
            return;
        }
        int n6 = n3;
        int n7 = 16384 - n5;
        this.fDocumentHandler.characters(uTF8CharDataChunk.fData, n5, n7, bl);
        n6 -= n7;
        do {
            if ((uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk) == null) {
                this.fErrorHandler.error(167);
            }
            n7 = n6 <= 16384 ? n6 : 16384;
            this.fDocumentHandler.characters(uTF8CharDataChunk.fData, 0, n7, bl);
        } while ((n6 -= n7) > 0);
    }

    public void callWSCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fScanner.getCurrentContentSpecType();
        if (n3 != 4) {
            this.callCharDataHandler(n, n2, bl);
            return;
        }
        int n4 = n2 - n;
        if (!this.fDocumentHandler.sendCharDataAsCharArray()) {
            int n5 = n4 == 0 ? 0 : this.fCurrentChunk.addString(n, n4);
            this.fDocumentHandler.ignorableWhitespace(n5, bl);
            return;
        }
        UTF8CharDataChunk uTF8CharDataChunk = this.fCurrentChunk.chunkFor(n);
        int n6 = n & 0x3FFF;
        if (n6 + n4 <= 16384) {
            if (n4 != 0) {
                this.fDocumentHandler.ignorableWhitespace(uTF8CharDataChunk.fData, n6, n4, bl);
            }
            return;
        }
        int n7 = n4;
        int n8 = 16384 - n6;
        this.fDocumentHandler.ignorableWhitespace(uTF8CharDataChunk.fData, n6, n8, bl);
        n7 -= n8;
        do {
            uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk;
            n8 = n7 <= 16384 ? n7 : 16384;
            this.fDocumentHandler.ignorableWhitespace(uTF8CharDataChunk.fData, 0, n8, bl);
        } while ((n7 -= n8) > 0);
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            if (this.fOverflowEnd < 16384) {
                if (this.fOverflowEnd > 0) {
                    this.fMostRecentData = new char[1 + this.fOverflowEnd - this.fOverflowOffset];
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else {
                    this.fMostRecentData = new char[1];
                }
                this.fMostRecentData[this.fOutputOffset] = '\u0000';
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                var1_1 = this.fCurrentChunk;
                var2_4 = this.fMostRecentData;
                var1_1.fData = var2_4;
                this.fMostRecentChar = this.fMostRecentData[0];
                return this.fMostRecentChar;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new byte[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block12: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                var1_2 = 16384;
                var2_5 = 0;
                do {
                    if ((var2_5 = this.fInputStream.read(this.fOverflow, this.fOverflowEnd, var1_2)) == -1) {
                        this.fInputStream.close();
                        this.fInputStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = new char[1 + this.fOverflowEnd];
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        var3_7 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (var3_7) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = '\u0000';
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (var2_5 <= 0) continue;
                    this.fOverflowEnd += var2_5;
                    var1_2 -= var2_5;
                } while (var1_2 > 0);
                if (var2_5 == -1) break;
                if (this.fMostRecentData == null) break block12;
                var3_7 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (var3_7) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = new char[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        var1_3 = this.fCurrentChunk;
        var2_6 = this.fMostRecentData;
        var1_3.fData = var2_6;
        this.fMostRecentChar = this.fMostRecentData[0];
        return this.fMostRecentChar;
    }

    protected boolean copyNormalize(byte[] byArray, int n, char[] cArray, int n2) throws Exception {
        int n3;
        int n4 = this.fOverflowEnd;
        int n5 = cArray.length;
        if (n == n4) {
            return true;
        }
        byte by = byArray[n];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (by == 10) {
                if (++n == n4) {
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n2;
                    return true;
                }
                by = byArray[n];
            }
        } else if (this.fPartialMultiByteIn > 0) {
            if (!this.handlePartialMultiByteChar(by, byArray, n, n4, cArray, n2, n5)) {
                return this.fPartialMultiByteResult;
            }
            n = this.fOverflowOffset;
            n2 = this.fOutputOffset;
            by = byArray[n];
        }
        while (n2 < n5) {
            n3 = n4 - n;
            int n6 = n5 - n2;
            if (n3 > n6) {
                n3 = n6;
            }
            ++n;
            while (true) {
                if (by == 13 || (by & 0x80) != 0) {
                    if (by == 13) {
                        cArray[n2++] = 10;
                        if (n == n4) {
                            this.fSkipLinefeed = true;
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n2;
                            return true;
                        }
                        by = byArray[n];
                        if (by == 10) {
                            if (++n == n4) {
                                this.fOverflowOffset = n;
                                this.fOutputOffset = n2;
                                return true;
                            }
                            by = byArray[n];
                        }
                        if (n2 == n5) {
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n2;
                            return false;
                        }
                    } else {
                        if (!this.handleMultiByteChar(by, byArray, n, n4, cArray, n2, n5)) {
                            return this.fPartialMultiByteResult;
                        }
                        n = this.fOverflowOffset;
                        n2 = this.fOutputOffset;
                        by = byArray[n];
                    }
                    if ((n3 = n4 - n) > (n6 = n5 - n2)) {
                        n3 = n6;
                    }
                    ++n;
                    continue;
                }
                do {
                    cArray[n2++] = (char)by;
                } while (--n3 != 0 && (by = byArray[n++]) != 13 && by >= 0);
                if (n3 == 0) break;
            }
            if (n == n4) break;
        }
        n3 = n != n4 ? 0 : 1;
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return n3 != 0;
    }

    protected boolean exitNormalize(int n, int n2, boolean bl) {
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return bl;
    }

    protected void savePartialMultiByte(int n, byte by, byte by2, byte by3) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
        this.fPartialMultiByteChar[--n] = by3;
    }

    protected void savePartialMultiByte(int n, byte by, byte by2) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
    }

    protected void savePartialMultiByte(int n, byte by) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteChar[n] = by;
    }

    protected boolean handleMultiByteChar(byte by, byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws Exception {
        byte by2;
        if (n == n2) {
            int n5 = 1;
            this.fPartialMultiByteIn = n5--;
            this.fPartialMultiByteChar[n5] = by;
            this.fOverflowOffset = n;
            this.fOutputOffset = n3;
            this.fPartialMultiByteResult = true;
            return false;
        }
        if (((by2 = byArray[n++]) & 0xC0) != 128) {
            this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)));
        }
        if ((by & 0xE0) == 192) {
            int n6 = ((0x1F & by) << 6) + (0x3F & by2);
            cArray[n3++] = (char)n6;
            if (n == n2 || n3 == n4) {
                boolean bl = n == n2;
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = bl;
                return false;
            }
        } else {
            byte by3;
            if (n == n2) {
                this.savePartialMultiByte(2, by2, by);
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = true;
                return false;
            }
            if (((by3 = byArray[n++]) & 0xC0) != 128) {
                this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)));
            }
            if ((by & 0xF0) == 224) {
                int n7 = ((0xF & by) << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                cArray[n3++] = (char)n7;
                if (n == n2 || n3 == n4) {
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
            } else {
                int n8;
                byte by4;
                if ((by & 0xF8) != 240) {
                    this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(by)));
                }
                if (n == n2) {
                    this.savePartialMultiByte(3, by3, by2, by);
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (((by4 = byArray[n++]) & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)), this.fStringPool.addString(Integer.toHexString(by4)));
                }
                if ((n8 = ((0xF & by) << 18) + ((0x3F & by2) << 12) + ((0x3F & by3) << 6) + (0x3F & by4)) >= 65536) {
                    cArray[n3++] = (char)((n8 - 65536 >> 10) + 55296);
                    n8 = (n8 - 65536 & 0x3FF) + 56320;
                    if (n3 == n4) {
                        this.fPartialSurrogatePair = n8;
                        boolean bl = n == n2;
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = bl;
                        return false;
                    }
                }
                cArray[n3++] = (char)n8;
                if (n == n2 || n3 == n4) {
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
            }
        }
        this.fOverflowOffset = n;
        this.fOutputOffset = n3;
        return true;
    }

    protected boolean handlePartialMultiByteChar(byte by, byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws Exception {
        if (n3 == n4) {
            boolean bl = n == n2;
            this.fOverflowOffset = n;
            this.fOutputOffset = n3;
            this.fPartialMultiByteResult = bl;
            return false;
        }
        if (this.fPartialMultiByteIn == 4) {
            cArray[n3++] = (char)this.fPartialSurrogatePair;
            if (n3 == n4) {
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = false;
                return false;
            }
            this.fOutputOffset = n3;
            return true;
        }
        int n5 = this.fPartialMultiByteIn;
        this.fPartialMultiByteIn = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        switch (n5) {
            case 1: {
                by2 = by;
                break;
            }
            case 2: {
                by3 = by;
                break;
            }
            case 3: {
                by4 = by;
            }
        }
        int n6 = n5;
        switch (n5) {
            case 3: {
                by3 = this.fPartialMultiByteChar[--n6];
            }
            case 2: {
                by2 = this.fPartialMultiByteChar[--n6];
            }
            case 1: {
                by = this.fPartialMultiByteChar[--n6];
            }
        }
        switch (n5) {
            case 1: {
                if ((by2 & 0xC0) != 128) {
                    this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)));
                }
            }
            case 2: {
                if ((by & 0xE0) == 192) {
                    int n7 = ((0x1F & by) << 6) + (0x3F & by2);
                    cArray[n3++] = (char)n7;
                    if (n3 == n4) {
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = false;
                        return false;
                    }
                    if (n5 >= 2 || ++n != n2) break;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (n5 < 2) {
                    if (++n == n2) {
                        int n8 = 2;
                        this.fPartialMultiByteIn = n8--;
                        this.fPartialMultiByteChar[n8] = by2;
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    by3 = byArray[n];
                }
                if ((by3 & 0xC0) != 128) {
                    this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)));
                }
            }
            case 3: {
                int n9;
                if ((by & 0xF0) == 224) {
                    int n10 = ((0xF & by) << 12) + ((0x3F & by2) << 6) + (0x3F & by3);
                    cArray[n3++] = (char)n10;
                    if (n3 == n4) {
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = false;
                        return false;
                    }
                    if (n5 >= 3 || ++n != n2) break;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (n5 < 3) {
                    if ((by & 0xF8) != 240) {
                        this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(by)));
                    }
                    if (++n == n2) {
                        this.savePartialMultiByte(3, by3, by2);
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    by4 = byArray[n];
                }
                if ((by4 & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)), this.fStringPool.addString(Integer.toHexString(by4)));
                }
                if ((n9 = ((0xF & by) << 18) + ((0x3F & by2) << 12) + ((0x3F & by3) << 6) + (0x3F & by4)) >= 65536) {
                    cArray[n3++] = (char)((n9 - 65536 >> 10) + 55296);
                    n9 = (n9 - 65536 & 0x3FF) + 56320;
                    if (n3 == n4) {
                        this.fPartialSurrogatePair = n9;
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = false;
                        return false;
                    }
                }
                cArray[n3++] = (char)n9;
                if (n3 == n4) {
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = false;
                    return false;
                }
                if (++n != n2) break;
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = true;
                return false;
            }
        }
        this.fOverflowOffset = n;
        this.fOutputOffset = n3;
        return true;
    }

    protected final class UTF8CharDataChunk
    implements StringProducer {
        protected StringPool fInnerStringPool;
        protected int fChunk;
        protected char[] fData;
        protected UTF8CharDataChunk fPreviousChunk;
        protected UTF8CharDataChunk fNextChunk;

        public UTF8CharDataChunk(StringPool stringPool, UTF8CharDataChunk uTF8CharDataChunk) throws Exception {
            UTF8CharReader.this = UTF8CharReader.this;
            this.fInnerStringPool = stringPool;
            this.fChunk = uTF8CharDataChunk == null ? 0 : uTF8CharDataChunk.fChunk + 1;
            this.fPreviousChunk = uTF8CharDataChunk;
            if (uTF8CharDataChunk != null) {
                uTF8CharDataChunk.fNextChunk = this;
            }
        }

        protected UTF8CharDataChunk(UTF8CharDataChunk uTF8CharDataChunk) {
            UTF8CharReader.this = UTF8CharReader.this;
            this.fInnerStringPool = uTF8CharDataChunk.fInnerStringPool;
            this.fChunk = uTF8CharDataChunk.fChunk;
            this.fData = uTF8CharDataChunk.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        public UTF8CharDataChunk chunkFor(int n) {
            int n2 = n >> 14;
            UTF8CharDataChunk uTF8CharDataChunk = this;
            while (n2 != uTF8CharDataChunk.fChunk) {
                uTF8CharDataChunk = uTF8CharDataChunk.fPreviousChunk;
            }
            return uTF8CharDataChunk;
        }

        public char[] toCharArray() {
            return this.fData;
        }

        public void setCharArray(char[] cArray) {
            this.fData = cArray;
        }

        public UTF8CharDataChunk nextChunk() {
            return this.fNextChunk;
        }

        public void clearPreviousChunk() {
            if (this.fPreviousChunk != null) {
                this.fPreviousChunk.fNextChunk = null;
                this.fPreviousChunk = null;
            }
        }

        public String toString(int n, int n2) {
            if (n + n2 <= 16384) {
                return new String(this.fData, n, n2);
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            int n3 = 16384 - n;
            stringBuffer.append(this.fData, n, n3);
            n2 -= n3;
            UTF8CharDataChunk uTF8CharDataChunk = this.fNextChunk;
            do {
                n3 = n2 <= 16384 ? n2 : 16384;
                stringBuffer.append(uTF8CharDataChunk.fData, 0, n3);
                uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk;
            } while ((n2 -= n3) > 0);
            String string = stringBuffer.toString();
            stringBuffer = null;
            return string;
        }

        public boolean equalsString(int n, int n2, String string, int n3) {
            if (n2 != n3) {
                return false;
            }
            if (n + n2 <= 16384) {
                int n4 = 0;
                while (n4 < n2) {
                    if (this.fData[n++] != string.charAt(n4)) {
                        return false;
                    }
                    ++n4;
                }
                return true;
            }
            int n5 = 16384 - n;
            int n6 = 0;
            while (n6 < n5) {
                if (this.fData[n++] == string.charAt(n6++)) continue;
                return false;
            }
            n2 -= n5;
            UTF8CharDataChunk uTF8CharDataChunk = this.fNextChunk;
            do {
                n = 0;
                n5 = n2 <= 16384 ? n2 : 16384;
                n2 -= n5;
                while (n5-- > 0) {
                    if (uTF8CharDataChunk.fData[n++] == string.charAt(n6++)) continue;
                    return false;
                }
                uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk;
            } while (n2 > 0);
            return true;
        }

        protected UTF8CharDataChunk createClump(int n) {
            UTF8CharDataChunk uTF8CharDataChunk = new UTF8CharDataChunk(this);
            UTF8CharDataChunk uTF8CharDataChunk2 = this.fNextChunk;
            UTF8CharDataChunk uTF8CharDataChunk3 = uTF8CharDataChunk;
            do {
                UTF8CharDataChunk uTF8CharDataChunk4;
                uTF8CharDataChunk3.fNextChunk = uTF8CharDataChunk4 = new UTF8CharDataChunk(uTF8CharDataChunk2);
                uTF8CharDataChunk2 = uTF8CharDataChunk2.fNextChunk;
                uTF8CharDataChunk3 = uTF8CharDataChunk4;
            } while (uTF8CharDataChunk3.fChunk != n);
            return uTF8CharDataChunk;
        }

        public int addString(int n, int n2) {
            int n3 = n >> 14;
            if (n3 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(n, n2);
                }
                try {
                    UTF8CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n4 = n + n2 - 1 >> 14;
            if (n3 == n4) {
                return this.fInnerStringPool.addString(this, n & 0x3FFF, n2);
            }
            return this.fInnerStringPool.addString(this.createClump(n4), n & 0x3FFF, n2);
        }

        public int addSymbol(int n, int n2, int n3) {
            int n4 = n >> 14;
            if (n4 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(n, n2, n3);
                }
                try {
                    UTF8CharReader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n5 = n + n2 - 1 >> 14;
            int n6 = n & 0x3FFF;
            if (n4 == n5) {
                if (n3 == 0) {
                    int n7 = 0;
                    while (n7 < n2) {
                        n3 = StringHasher.hashChar(n3, n7, this.fData[n6++] & 0xFFFF);
                        ++n7;
                    }
                    int n8 = n3;
                    n3 = (n8 &= Integer.MAX_VALUE) == 0 ? 1 : n8;
                }
                return this.fInnerStringPool.addSymbol(this, n & 0x3FFF, n2, n3);
            }
            if (n3 == 0) {
                int n9 = 0;
                int n10 = n2;
                int n11 = 16384 - n6;
                while (n6 < 16384) {
                    n3 = StringHasher.hashChar(n3, n9++, this.fData[n6++] & 0xFFFF);
                }
                n10 -= n11;
                UTF8CharDataChunk uTF8CharDataChunk = this.fNextChunk;
                do {
                    n6 = 0;
                    n11 = n10 <= 16384 ? n10 : 16384;
                    while (n6 < n11) {
                        n3 = StringHasher.hashChar(n3, n9++, uTF8CharDataChunk.fData[n6++] & 0xFFFF);
                    }
                    uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk;
                } while ((n10 -= n11) > 0);
                int n12 = n3;
                n3 = (n12 &= Integer.MAX_VALUE) == 0 ? 1 : n12;
            }
            return this.fInnerStringPool.addSymbol(this.createClump(n5), n & 0x3FFF, n2, n3);
        }

        public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
            UTF8CharDataChunk uTF8CharDataChunk = this.chunkFor(n);
            int n3 = n & 0x3FFF;
            int n4 = n3 + n2 <= 16384 ? n2 : 16384 - n3;
            while (true) {
                chunkyCharArray.append(uTF8CharDataChunk.fData, n3, n4);
                if ((n2 -= n4) == 0) break;
                uTF8CharDataChunk = uTF8CharDataChunk.fNextChunk;
                n3 = 0;
                n4 = n2 <= 16384 ? n2 : 16384;
            }
        }
    }
}

