/*
 * Decompiled with CFR 0.152.
 */
package com.saflink.BSPTest;

import com.saflink.BSPTest.ActivityLog;
import com.saflink.BSPTest.AssertionLog;
import com.saflink.BSPTest.BSPInterface;
import com.saflink.BSPTest.CheckNode;
import com.saflink.BSPTest.CheckRenderer;
import com.saflink.BSPTest.CommandRunner;
import com.saflink.BSPTest.LogDialog;
import com.saflink.BSPTest.PackageLog;
import com.saflink.BSPTest.PropDialog;
import com.saflink.BSPTest.ReturnLog;
import com.saflink.BSPTest.SwingWorker;
import com.saflink.BSPTest.TestEngine;
import com.saflink.BSPTest.TimeoutDialog;
import com.saflink.BSPTest.XMLLog;
import com.saflink.bioapi.Win32;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.doomdark.uuid.TagURI;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;

public class TestPanel
extends JPanel
implements ActionListener,
ItemListener,
WindowListener {
    TestEngine testEngine = null;
    public static boolean doMinimize = true;
    public static int bspProviderIndex = -1;
    public static String bspProviderName = null;
    public static LinkedList fileList = null;
    public static boolean isRunning = false;
    private static String currentDir = null;
    JComboBox comboBSP;
    static JScrollPane treeArea;
    static JTextArea textArea;
    static JTextArea commentArea;
    static JFrame frame;
    JButton runButton;
    JButton cancelButton;
    static JTree tree;
    JProgressBar progressBar;
    static JLabel labelTestRunErrFail;
    private static int tRun;
    private static int tPass;
    private static int tFail;
    private static int tUndecided;
    private static int tError;
    private static int iRun;
    private static int iPass;
    private static int iFail;
    private static int iUndecided;
    private static int iError;
    private static String iStatusText;
    final JFileChooser fc = new JFileChooser();
    CheckNode[] nodes;
    static final String newline = "\n";
    static final String appName = "BioAPI Test Environment";
    public static final String ASSERTION_PATH = "assertions/";
    public static final String MESSAGE_PATH = "message/";
    public static final String WHITELISTBSP = "_WhiteListBSPs.txt";
    private final String TAGAUTH = "www.saflink.com";
    private final String TAGURI = "bte.1.10";
    private int useFileName = 1;
    public LinkedList packageLog;
    XMLLog xmllog = null;
    public boolean isContinue = true;

    public TestPanel() {
        frame.addWindowListener(this);
    }

    public Container createContentPane() {
        this.fc.setFileSelectionMode(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(true);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("BSP:");
        this.comboBSP = new JComboBox();
        this.comboBSP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                bspProviderIndex = TestPanel.this.comboBSP.getSelectedIndex() - 1;
                bspProviderName = (String)TestPanel.this.comboBSP.getSelectedItem();
            }
        });
        this.populateComboBSP();
        JLabel jLabel2 = new JLabel("Test Assertions:");
        tree = this.makeTree(new File(ASSERTION_PATH));
        tree.setMaximumSize(new Dimension(100, 100));
        treeArea = new JScrollPane();
        treeArea.setViewportView(tree);
        treeArea.setMinimumSize(new Dimension(150, 100));
        treeArea.setMaximumSize(new Dimension(100, 100));
        this.runButton = new JButton("Run Test");
        this.runButton.setToolTipText("Click here to run a test assertion");
        this.runButton.setMnemonic(82);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingWorker swingWorker = new SwingWorker(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        TestPanel.access$100(2.access$000(this.this$1));
                        return null;
                    }

                    public void finished() {
                    }
                };
                swingWorker.start();
            }

            static /* synthetic */ TestPanel access$000(2 var0) {
                return var0.TestPanel.this;
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Click here to cancel test assertion");
        this.cancelButton.setMnemonic(82);
        this.cancelButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPanel.this.cancelTestRun();
            }
        });
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(null);
        labelTestRunErrFail = new JLabel("Runs:      Pass:      Fail:    Undecided:   Error:   ");
        labelTestRunErrFail.setHorizontalAlignment(0);
        JLabel jLabel3 = new JLabel("Test Results:");
        textArea = new JTextArea();
        textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(textArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setMinimumSize(new Dimension(40, 40));
        jScrollPane.setMaximumSize(new Dimension(40, 40));
        commentArea = new JTextArea(4, 200);
        commentArea.setEditable(true);
        commentArea.setLineWrap(true);
        JScrollPane jScrollPane2 = new JScrollPane(commentArea);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setMinimumSize(new Dimension(40, 40));
        jScrollPane.setMaximumSize(new Dimension(40, 40));
        JLabel jLabel4 = new JLabel("Comments:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.comboBSP, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.runButton, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)labelTestRunErrFail, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)treeArea, gridBagConstraints);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane2, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(900, 450));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        return jPanel;
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.getAccessibleContext().setAccessibleDescription("File Menu");
        jMenuBar.add(jMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Assertion Name");
        jRadioButtonMenuItem.setMnemonic(65);
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TestPanel.this.useFileName = 1;
                    tree = TestPanel.this.makeTree(new File(TestPanel.ASSERTION_PATH));
                    treeArea.setViewportView(tree);
                }
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Package Name");
        jRadioButtonMenuItem.setMnemonic(80);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TestPanel.this.useFileName = 2;
                    tree = TestPanel.this.makeTree(new File(TestPanel.ASSERTION_PATH));
                    treeArea.setViewportView(tree);
                }
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("File Name");
        jRadioButtonMenuItem.setMnemonic(70);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    TestPanel.this.useFileName = 3;
                    tree = TestPanel.this.makeTree(new File(TestPanel.ASSERTION_PATH));
                    treeArea.setViewportView(tree);
                }
            }
        });
        jMenu.add(jRadioButtonMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Properties", 80);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PropDialog.showDialog(frame, null, "", "BTE Properties", null, null, "");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Timeout Values", 84);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = TimeoutDialog.showDialog(frame, null, "", "BTE Timeout Values", null, null, "");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit", 88);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Win32.stopBioAPI();
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Test Log");
        jMenu.setMnemonic(76);
        jMenu.getAccessibleContext().setAccessibleDescription("Test Log Menu");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("View Log File", 86);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TestPanel.this.xmllog == null) {
                    JOptionPane.showMessageDialog(frame, "Currently no log file to save. You must first run some tests.", "Log File", -1);
                    return;
                }
                LogDialog.showDialog(frame, null, TestPanel.this.xmllog);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save XML Log", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TestPanel.this.xmllog == null) {
                    JOptionPane.showMessageDialog(frame, "Currently no log file to save. You must first run some tests.", "Log File", -1);
                    return;
                }
                int n = TestPanel.this.fc.showSaveDialog(frame);
                if (n == 0) {
                    File file = TestPanel.this.fc.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(frame, "Would you like to overwrite existing file?", "Overwrite File", 0) == 1) {
                        System.out.println("no overwrite");
                        return;
                    }
                    boolean bl = TestPanel.this.xmllog.printLogToFile(file.getAbsolutePath());
                    if (!bl) {
                        JOptionPane.showMessageDialog(frame, "Error Saving File!", "Save Error", 0);
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Clear Test Results Window", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestPanel.writeTestResults("", false);
                TestPanel.this.resetStats();
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenu.getAccessibleContext().setAccessibleDescription("This is the help menu");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Show Installed BSPs", 83);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                BSPInterface bSPInterface = new BSPInterface();
                File file = new File(TestPanel.WHITELISTBSP);
                if (file.exists()) {
                    String string2 = null;
                    try {
                        FileReader fileReader = new FileReader(TestPanel.WHITELISTBSP);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        string2 = new String();
                        while ((string2 = bufferedReader.readLine()) != null) {
                            if (bSPInterface.verifyBSPByName(string2) <= -1) continue;
                            string = string + string2 + TestPanel.newline;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("Unable to read _WhiteListBSPs.txt");
                    }
                } else {
                    Vector vector = bSPInterface.getInstalledBSPByName();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        string = string + (String)enumeration.nextElement() + TestPanel.newline;
                    }
                }
                if (string.equals("")) {
                    string = "No BSP's installed.";
                }
                JOptionPane.showMessageDialog(frame, string, "Installed BSPs", -1);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About", 67);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(frame, "NIST BioAPI Test Environment (BTE)\nVersion 1.1\nFebruary 6, 2006.", "About BTE", -1);
            }
        });
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    private void populateComboBSP() {
        BSPInterface bSPInterface = new BSPInterface();
        this.comboBSP.removeAllItems();
        this.comboBSP.addItem(new String(""));
        File file = new File(WHITELISTBSP);
        if (file.exists()) {
            String string = null;
            try {
                FileReader fileReader = new FileReader(WHITELISTBSP);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                string = new String();
                while ((string = bufferedReader.readLine()) != null) {
                    if (bSPInterface.verifyBSPByName(string) <= -1) continue;
                    this.comboBSP.addItem(string);
                }
            }
            catch (IOException iOException) {
                System.out.println("Unable to read _WhiteListBSPs.txt");
            }
        } else {
            Vector vector = bSPInterface.getInstalledBSPByName();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.comboBSP.addItem((String)enumeration.nextElement());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = "Action event detected.\n    Event source: " + jMenuItem.getText();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JMenuItem jMenuItem = (JMenuItem)itemEvent.getSource();
        String string = "Item event detected.\n    Event source: " + jMenuItem.getText() + newline + "    New state: " + (itemEvent.getStateChange() == 1 ? "selected" : "unselected");
    }

    private Vector getSelectedNodes(CheckNode checkNode) {
        CheckNode checkNode2 = checkNode;
        Vector<String> vector = new Vector<String>();
        Enumeration<TreeNode> enumeration = checkNode2.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode3 = (CheckNode)enumeration.nextElement();
            checkNode3.setStatusText("");
            if (!checkNode3.isSelected()) continue;
            TreeNode[] treeNodeArray = checkNode3.getPath();
            for (int i = 1; i < treeNodeArray.length; ++i) {
                vector.addElement(treeNodeArray[i].toString());
            }
        }
        return vector;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame(appName);
        frame.setDefaultCloseOperation(3);
        TestPanel testPanel = new TestPanel();
        frame.setContentPane(testPanel.createContentPane());
        frame.setJMenuBar(testPanel.createMenuBar());
        frame.pack();
        frame.setVisible(true);
    }

    public static void writeTestResults(String string, boolean bl) {
        if (bl) {
            textArea.append(string + newline);
        } else {
            textArea.setText(string + newline);
        }
        textArea.setCaretPosition(textArea.getDocument().getLength());
    }

    public static void writeIndividualResults(String string) {
        iStatusText = iStatusText + string + "<BR>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doTestRun() {
        String string;
        String string2;
        long l;
        Date date;
        block37: {
            block36: {
                block35: {
                    block34: {
                        block33: {
                            fileList = new LinkedList();
                            LinkedList<String> linkedList = new LinkedList<String>();
                            this.resetStats();
                            date = new Date();
                            long l2 = date.getTime();
                            l = 0L;
                            string2 = this.getMachineUUID();
                            TestPanel.writeTestResults("Machine UUID->" + string2, true);
                            UUID uUID = UUIDGenerator.getInstance().generateTimeBasedUUID();
                            string = uUID.toString();
                            TestPanel.writeTestResults("Test UUID->" + string, true);
                            this.xmllog = new XMLLog();
                            this.packageLog = new LinkedList();
                            try {
                                try {
                                    Object object;
                                    int n;
                                    Object[] objectArray;
                                    Cloneable cloneable;
                                    if (bspProviderIndex < 0) {
                                        JOptionPane.showMessageDialog(frame, "No BSP Provider chosen.....\nPlease choose one before continuing.", "Run Test", 2);
                                        Object var23_8 = null;
                                        break block33;
                                    }
                                    CheckNode checkNode = this.nodes[0];
                                    String string3 = null;
                                    Enumeration<TreeNode> enumeration = checkNode.breadthFirstEnumeration();
                                    while (enumeration.hasMoreElements()) {
                                        cloneable = (CheckNode)enumeration.nextElement();
                                        ((CheckNode)cloneable).setStatusText("");
                                        if (!((CheckNode)cloneable).isSelected()) continue;
                                        ((CheckNode)cloneable).setStatus(1);
                                        objectArray = ((DefaultMutableTreeNode)cloneable).getPath();
                                        string3 = objectArray[0].toString();
                                        for (n = 1; n < objectArray.length; ++n) {
                                            string3 = string3 + System.getProperty("file.separator") + ((CheckNode)cloneable).getFileName();
                                        }
                                        if (!string3.endsWith(".xml")) continue;
                                        linkedList.add(string3);
                                        fileList.add(cloneable);
                                    }
                                    if (linkedList.size() == 0) {
                                        JOptionPane.showMessageDialog(frame, "No Test files chosen.....\nPlease choose one before continuing.", "Run Test", 2);
                                        break block34;
                                    }
                                    cloneable = new Properties();
                                    try {
                                        objectArray = new FileInputStream("bte.properties");
                                        ((Properties)cloneable).load((InputStream)objectArray);
                                        objectArray.close();
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Unable to load bte.properties");
                                    }
                                    if (((Properties)cloneable).getProperty("labName").equals("") || ((Properties)cloneable).getProperty("bspProduct").equals("") || ((Properties)cloneable).getProperty("ctsIDField").equals("") || ((Properties)cloneable).getProperty("tester").equals("")) {
                                        JOptionPane.showMessageDialog(frame, "Please fill in the mandatory (*) fields.\n You can do this by choosing File/Properties from the menu.", "Mandatory Fields", 2);
                                        break block35;
                                    }
                                    if (!((Properties)cloneable).getProperty("bspProduct").equals(bspProviderName)) {
                                        objectArray = new Object[]{"Stop Testing", "Continue Testing", "Change the Product Name and Continue Testing"};
                                        n = JOptionPane.showOptionDialog(frame, "The Product Name (" + ((Properties)cloneable).getProperty("bspProduct") + ") and the choosen BSP (" + bspProviderName + ") do not match?", "Product Name", 1, 3, null, objectArray, objectArray[0]);
                                        if (n < 1) {
                                            break block36;
                                        }
                                        if (n == 2) {
                                            ((Properties)cloneable).put("bspProduct", bspProviderName);
                                            try {
                                                object = new FileOutputStream("bte.properties");
                                                ((Properties)cloneable).store((OutputStream)object, "");
                                                ((FileOutputStream)object).close();
                                            }
                                            catch (Exception exception) {
                                                System.out.println("Unable to open bte.properties for writing");
                                            }
                                        }
                                    }
                                    this.runButton.setEnabled(false);
                                    this.cancelButton.setEnabled(true);
                                    this.isContinue = true;
                                    if (doMinimize) {
                                        frame.setState(1);
                                    } else {
                                        frame.toBack();
                                    }
                                    TestPanel.writeTestResults("======== Starting Test Run ===========", true);
                                    TestPanel.writeTestResults("BSP Provider: " + bspProviderName, true);
                                    objectArray = linkedList.toArray(new String[0]);
                                    for (n = 0; n < objectArray.length && this.isContinue; ++n) {
                                        try {
                                            object = this.getAssertionName((String)objectArray[n]);
                                            TestPanel.writeTestResults("***************************************", true);
                                            TestPanel.writeTestResults("Package: " + ((FileData)object).pkgname, true);
                                            TestPanel.writeTestResults("***************************************", true);
                                            TestPanel.writeTestResults("Assertion: " + ((FileData)object).name, true);
                                            this.showAssertionMessage(((FileData)object).filebase, ((FileData)object).name);
                                            String string4 = "runassertion.bat \"" + bspProviderName + "\" \"" + (String)objectArray[n] + "\"";
                                            CommandRunner commandRunner = new CommandRunner();
                                            commandRunner.setCommand(string4);
                                            commandRunner.setStdErrorStream(System.err);
                                            commandRunner.setStdOutputStream(System.out);
                                            commandRunner.evaluate();
                                            System.out.println("command return->" + commandRunner.getExitValue());
                                            PackageLog packageLog = null;
                                            try {
                                                Object object2;
                                                Object object3;
                                                try {
                                                    object3 = new XMLDecoder(new BufferedInputStream(new FileInputStream("save/_lastpkg.obj")));
                                                    object2 = ((XMLDecoder)object3).readObject();
                                                    ((XMLDecoder)object3).close();
                                                    packageLog = (PackageLog)object2;
                                                }
                                                catch (Exception exception) {
                                                    packageLog = new PackageLog();
                                                    packageLog.testResult = -2;
                                                    packageLog.packageName = ((FileData)object).pkgname;
                                                    object2 = new AssertionLog();
                                                    ((AssertionLog)object2).assertionName = ((FileData)object).name;
                                                    packageLog.assertionLog.add(object2);
                                                }
                                                this.packageLog.add(packageLog);
                                                object3 = new XMLLog();
                                                ((XMLLog)object3).startLog(date, l += packageLog.duration, string2, string, TestPanel.getComments());
                                                ((XMLLog)object3).addPackageLog(this.packageLog);
                                                boolean bl = ((XMLLog)object3).printLogToFile("_lastlog.xml");
                                                iStatusText = this.getReturnFromLog(packageLog);
                                                TestPanel.writeTestResults(iStatusText.replaceAll("<BR>", ""), true);
                                                TestPanel.updateStats(packageLog.testResult);
                                                TestPanel.setNodeStatus(n, packageLog.testResult);
                                                TestPanel.writeTestResults("Test Duration: " + packageLog.duration + " milliseconds.", true);
                                            }
                                            catch (Exception exception) {
                                                exception.printStackTrace();
                                                TestPanel.writeTestResults("ERROR - Unable to retrieved package object. (" + exception.getMessage() + ")", true);
                                            }
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("ERROR RUNNING ASSERTION");
                                            exception.printStackTrace();
                                        }
                                    }
                                    break block37;
                                }
                                catch (Exception exception) {
                                    TestPanel.writeTestResults(exception.getMessage(), true);
                                    exception.printStackTrace();
                                    System.out.println("ERROR");
                                    Object var23_13 = null;
                                    this.runButton.setEnabled(true);
                                    this.cancelButton.setEnabled(false);
                                    this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
                                    this.xmllog.addPackageLog(this.packageLog);
                                    TestPanel.writeTestResults("======== End Test Run ===========", true);
                                    if (doMinimize) {
                                        frame.setState(0);
                                        return;
                                    }
                                    frame.toFront();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var23_14 = null;
                                this.runButton.setEnabled(true);
                                this.cancelButton.setEnabled(false);
                                this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
                                this.xmllog.addPackageLog(this.packageLog);
                                TestPanel.writeTestResults("======== End Test Run ===========", true);
                                if (doMinimize) {
                                    frame.setState(0);
                                    throw throwable;
                                }
                                frame.toFront();
                                throw throwable;
                            }
                        }
                        this.runButton.setEnabled(true);
                        this.cancelButton.setEnabled(false);
                        this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
                        this.xmllog.addPackageLog(this.packageLog);
                        TestPanel.writeTestResults("======== End Test Run ===========", true);
                        if (doMinimize) {
                            frame.setState(0);
                            return;
                        }
                        frame.toFront();
                        return;
                    }
                    Object var23_9 = null;
                    this.runButton.setEnabled(true);
                    this.cancelButton.setEnabled(false);
                    this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
                    this.xmllog.addPackageLog(this.packageLog);
                    TestPanel.writeTestResults("======== End Test Run ===========", true);
                    if (doMinimize) {
                        frame.setState(0);
                        return;
                    }
                    frame.toFront();
                    return;
                }
                Object var23_10 = null;
                this.runButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
                this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
                this.xmllog.addPackageLog(this.packageLog);
                TestPanel.writeTestResults("======== End Test Run ===========", true);
                if (doMinimize) {
                    frame.setState(0);
                    return;
                }
                frame.toFront();
                return;
            }
            Object var23_11 = null;
            this.runButton.setEnabled(true);
            this.cancelButton.setEnabled(false);
            this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
            this.xmllog.addPackageLog(this.packageLog);
            TestPanel.writeTestResults("======== End Test Run ===========", true);
            if (doMinimize) {
                frame.setState(0);
                return;
            }
            frame.toFront();
            return;
        }
        Object var23_12 = null;
        this.runButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.xmllog.startLog(date, l, string2, string, TestPanel.getComments());
        this.xmllog.addPackageLog(this.packageLog);
        TestPanel.writeTestResults("======== End Test Run ===========", true);
        if (doMinimize) {
            frame.setState(0);
            return;
        }
        frame.toFront();
    }

    private void cancelTestRun() {
        this.isContinue = false;
        this.runButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        TestPanel.writeTestResults("!!!! TEST RUN CANCELLED !!!!", true);
    }

    private JTree makeTree(File file) {
        JTree jTree = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        try {
            Object[] objectArray;
            int n;
            currentDir = file.getCanonicalPath();
            String[] stringArray = file.list();
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].endsWith(".xml")) continue;
                objectArray = this.getAssertionName(stringArray[n]);
                linkedList2.add(objectArray.name);
                String string = null;
                switch (this.useFileName) {
                    case 1: {
                        string = objectArray.name;
                        break;
                    }
                    case 2: {
                        string = objectArray.pkgname;
                        break;
                    }
                    case 3: {
                        string = objectArray.filename;
                    }
                }
                linkedList.add(string);
                hashMap.put(string, objectArray);
            }
            this.nodes = new CheckNode[linkedList.size() + 1];
            n = 0;
            this.nodes[n] = new CheckNode(currentDir, null, null);
            if (linkedList.size() > 0) {
                objectArray = linkedList.toArray(new String[0]);
                Arrays.sort(objectArray);
                int n2 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    FileData fileData = (FileData)hashMap.get(object);
                    if (!fileData.filename.equals("Auxiliary_package.xml")) {
                        this.nodes[++n] = new CheckNode(object, fileData.name, fileData.filename);
                        this.nodes[0].add(this.nodes[n]);
                    }
                    ++n2;
                }
            }
            jTree = new JTree(this.nodes[0]);
            jTree.setCellRenderer(new CheckRenderer());
            ToolTipManager.sharedInstance().registerComponent(jTree);
            jTree.getSelectionModel().setSelectionMode(1);
            jTree.putClientProperty("JTree.lineStyle", "Angled");
            jTree.addMouseListener(new NodeSelectionListener(jTree));
        }
        catch (Exception exception) {
            System.out.println("Unable to get available test files....");
        }
        return jTree;
    }

    private void resetStats() {
        tRun = 0;
        tPass = 0;
        tFail = 0;
        tUndecided = 0;
        tError = 0;
        iRun = 0;
        iPass = 0;
        iFail = 0;
        iUndecided = 0;
        iError = 0;
        labelTestRunErrFail.setText("Runs:    Pass:    Fail:    Undecided:   Error:   ");
    }

    public static void updateStats(int n) {
        switch (n) {
            case -2: {
                ++tError;
                ++iError;
                break;
            }
            case 0: {
                ++tUndecided;
                ++iUndecided;
                break;
            }
            case 1: {
                ++tPass;
                ++iPass;
                break;
            }
            case -1: {
                ++tFail;
                ++iFail;
            }
        }
        ++iRun;
        labelTestRunErrFail.setText("Runs: " + ++tRun + "   Pass: " + tPass + "   Fail: " + tFail + "   Undecided: " + tUndecided + "   Errors: " + tError);
    }

    public static void clearIndividualStats() {
        iRun = 0;
        iPass = 0;
        iFail = 0;
        iUndecided = 0;
        iStatusText = "";
    }

    public static int getIndividualFail() {
        return iFail;
    }

    public static void setNodeStatus(int n, int n2) {
        System.out.println("ind->" + n);
        CheckNode checkNode = (CheckNode)fileList.get(n);
        String string = "";
        switch (n2) {
            case 1: {
                checkNode.setStatus(2);
                string = "PASS";
                break;
            }
            case 0: {
                checkNode.setStatus(4);
                string = "UNDECIDED";
                break;
            }
            case -1: {
                checkNode.setStatus(3);
                string = "FAIL";
                break;
            }
            case -2: {
                checkNode.setStatus(5);
                string = "ERROR";
            }
        }
        checkNode.setStatusText(iStatusText);
        TestPanel.writeTestResults("Assertion Status...." + string, true);
        tree.repaint();
    }

    public static void run(String string) {
        doMinimize = string.equals("minimize");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestPanel.createAndShowGUI();
            }
        });
    }

    public FileData getAssertionName(String string) {
        String string2 = "Not found";
        String string3 = "Not found";
        try {
            String string4;
            StringBuffer stringBuffer = new StringBuffer();
            FileReader fileReader = string.indexOf(92) > -1 ? new FileReader(string) : new FileReader(ASSERTION_PATH + string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string4 = bufferedReader.readLine()) != null) {
                int n;
                int n2;
                if (string4.indexOf("<package") > -1) {
                    try {
                        n2 = string4.indexOf("name=\"");
                        n = string4.indexOf("\"", n2 + 8);
                        if (n2 <= 0 || n <= n2) continue;
                        string2 = string4.substring(n2 + 6, n);
                    }
                    catch (Exception exception) {
                        string2 = "Not found";
                    }
                    continue;
                }
                if (string4.indexOf("<assertion") <= -1) continue;
                try {
                    n2 = string4.indexOf("name=\"");
                    n = string4.indexOf("\"", n2 + 8);
                    if (n2 > 0 && n > n2) {
                        string3 = string4.substring(n2 + 6, n);
                    }
                }
                catch (Exception exception) {
                    string3 = "Not found";
                }
                break;
            }
        }
        catch (Exception exception) {
            string3 = "Assertion Name Not found";
            string2 = "Package Not found";
        }
        return new FileData(string, string2, string3);
    }

    public static String getComments() {
        return commentArea.getText();
    }

    private String getMachineUUID() {
        String string = "machineguid";
        String string2 = "machine.guid";
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            String string3 = properties.getProperty(string);
            fileInputStream.close();
            return string3;
        }
        catch (Exception exception) {
            UUID uUID = null;
            try {
                UUIDGenerator uUIDGenerator = UUIDGenerator.getInstance();
                InetAddress inetAddress = InetAddress.getLocalHost();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                TagURI tagURI = new TagURI("www.saflink.com", "bte.1.10/" + inetAddress.getHostName(), gregorianCalendar);
                uUID = uUIDGenerator.generateTagURIBasedUUID(tagURI);
                Properties properties = new Properties();
                properties.setProperty(string, uUID.toString());
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                properties.store(fileOutputStream, "assigned machineguid");
            }
            catch (Exception exception2) {
                System.out.println("Error generating machine guid");
            }
            return uUID.toString();
        }
    }

    private String getReturnFromLog(PackageLog packageLog) {
        String string = "";
        try {
            ListIterator listIterator = packageLog.activityLog.listIterator();
            while (listIterator.hasNext()) {
                ActivityLog activityLog = (ActivityLog)listIterator.next();
                ListIterator listIterator2 = activityLog.dueLog.listIterator();
                while (listIterator2.hasNext()) {
                    Object e = listIterator2.next();
                    if (!(e instanceof ReturnLog)) continue;
                    ReturnLog returnLog = (ReturnLog)e;
                    string = string + returnLog.returnName + " =  " + returnLog.returnValue + "<BR>\n";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void clearToolTip() {
        CheckNode checkNode = this.nodes[0];
        Object var2_2 = null;
        Enumeration<TreeNode> enumeration = checkNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckNode checkNode2 = (CheckNode)enumeration.nextElement();
            checkNode2.setStatusText("");
        }
    }

    private void showAssertionMessage(String string, String string2) {
        String string3 = "";
        String string4 = null;
        boolean bl = false;
        System.out.println("Looking for->message/" + string + ".msg");
        try {
            FileReader fileReader = new FileReader(MESSAGE_PATH + string + ".msg");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            string4 = new String();
            while ((string4 = bufferedReader.readLine()) != null) {
                string3 = string3 + string4 + newline;
            }
            if (doMinimize) {
                frame.setState(0);
            } else {
                frame.toFront();
            }
            JOptionPane.showMessageDialog(frame, string3, string2, -1);
            if (doMinimize) {
                frame.setState(1);
            } else {
                frame.toBack();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing");
        try {
            Win32.stopBioAPI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    static /* synthetic */ void access$100(TestPanel testPanel) {
        testPanel.doTestRun();
    }

    static {
        tRun = 0;
        tPass = 0;
        tFail = 0;
        tUndecided = 0;
        tError = 0;
        iRun = 0;
        iPass = 0;
        iFail = 0;
        iUndecided = 0;
        iError = 0;
    }

    private class FileData {
        public String filename;
        public String pkgname;
        public String name;
        public String filebase;

        public FileData(String string, String string2, String string3) {
            this.filename = string;
            this.pkgname = string2;
            this.name = string3;
            if (this.filename.indexOf("\\") > -1) {
                int n = this.filename.lastIndexOf("\\");
                this.filebase = this.filename.substring(n + 1).replaceAll("\\..*$", "");
            } else {
                this.filebase = string.replaceAll("\\..*$", "");
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null) {
                CheckNode checkNode = (CheckNode)treePath.getLastPathComponent();
                boolean bl = !checkNode.isSelected();
                checkNode.setSelected(bl);
                if (checkNode.getSelectionMode() == 4) {
                    // empty if block
                }
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(checkNode);
                if (n3 == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }
}

