/*
 * Decompiled with CFR 0.152.
 */
package com.saflink.BSPTest;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CommandRunner {
    private boolean _waitForExit = true;
    private String _command;
    private int _timeout = 0;
    private boolean _destroyOnTimeout = true;
    private InputStream _stdin;
    private OutputStream _stdout;
    private OutputStream _stderr;
    private static final int BUF = 4096;
    private int _xit;
    private Throwable _thrownError;
    private CyclicBarrier _barrier;

    public int getExitValue() {
        return this._xit;
    }

    public void setCommand(String string) {
        this._command = string;
    }

    public String getCommand() {
        return this._command;
    }

    public void setInputStream(InputStream inputStream) {
        this._stdin = inputStream;
    }

    public void setStdOutputStream(OutputStream outputStream) {
        this._stdout = outputStream;
    }

    public void setStdErrorStream(OutputStream outputStream) {
        this._stderr = outputStream;
    }

    public void evaluate() throws IOException {
        Process process = Runtime.getRuntime().exec(this._command);
        this._barrier = new CyclicBarrier(3 + (this._stdin != null ? 1 : 0));
        PullerThread pullerThread = new PullerThread("STDOUT", process.getInputStream(), this._stdout);
        pullerThread.start();
        PullerThread pullerThread2 = new PullerThread("STDERR", process.getErrorStream(), this._stderr);
        pullerThread2.start();
        PusherThread pusherThread = null;
        if (this._stdin != null) {
            pusherThread = new PusherThread("STDIN", this._stdin, process.getOutputStream());
            pusherThread.start();
        }
        boolean bl = false;
        long l = System.currentTimeMillis() + (long)(this._timeout * 1000);
        try {
            if (this._timeout == 0) {
                this._barrier.barrier();
            } else {
                this._barrier.attemptBarrier(this._timeout * 1000);
            }
        }
        catch (TimeoutException timeoutException) {
            bl = true;
            if (pusherThread != null) {
                pusherThread.interrupt();
            }
            pullerThread.interrupt();
            pullerThread2.interrupt();
            if (this._destroyOnTimeout) {
                process.destroy();
            }
        }
        catch (BrokenBarrierException brokenBarrierException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._xit = -1;
        if (!bl) {
            if (this._waitForExit) {
                while (true) {
                    try {
                        this._xit = process.exitValue();
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (!(bl = System.currentTimeMillis() > l)) continue;
                    }
                    break;
                }
            }
            try {
                this._xit = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                bl = true;
            }
        }
        if (bl && this._destroyOnTimeout) {
            process.destroy();
        }
    }

    public Throwable getThrownError() {
        return this._thrownError;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int n) {
        this._timeout = n;
    }

    public boolean getDestroyOnTimeout() {
        return this._destroyOnTimeout;
    }

    public void setDestroyOnTimeout(boolean bl) {
        this._destroyOnTimeout = bl;
    }

    public boolean getWaitForExit() {
        return this._waitForExit;
    }

    public void setWaitForExit(boolean bl) {
        this._waitForExit = bl;
    }

    private class PullerThread
    extends PumperThread {
        PullerThread(String string, InputStream inputStream, OutputStream outputStream) {
            super(string, inputStream, outputStream, true);
        }
    }

    private class PusherThread
    extends PumperThread {
        PusherThread(String string, InputStream inputStream, OutputStream outputStream) {
            super(string, inputStream, outputStream, false);
        }
    }

    private class PumperThread
    extends Thread {
        private OutputStream _os;
        private InputStream _is;
        private volatile boolean _kaput;
        private boolean _closeInput;

        protected PumperThread(String string, InputStream inputStream, OutputStream outputStream, boolean bl) {
            super(string);
            this._is = inputStream;
            this._os = outputStream;
            this._closeInput = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block17: {
                this._kaput = false;
                byte[] byArray = new byte[4096];
                int n = 0;
                while (!this.isInterrupted() && (n = this._is.read(byArray)) != -1) {
                    if (n == 0) continue;
                    this._os.write(byArray, 0, n);
                    this._os.flush();
                }
                Object var4_6 = null;
                try {
                    if (this._closeInput) {
                        this._is.close();
                        break block17;
                    }
                    this._os.close();
                }
                catch (IOException iOException) {}
                break block17;
                {
                    catch (Throwable throwable) {
                        CommandRunner.this._thrownError = throwable;
                        Object var4_7 = null;
                        try {
                            if (this._closeInput) {
                                this._is.close();
                            } else {
                                this._os.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    try {
                        if (this._closeInput) {
                            this._is.close();
                        } else {
                            this._os.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                CommandRunner.this._barrier.barrier();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
    }
}

