/*
 * Decompiled with CFR 0.152.
 */
package com.saflink.bioapi;

import com.saflink.bioapi.BioAPIData;
import com.saflink.bioapi.BioAPIRuntimeException;
import com.saflink.bioapi.Bir;
import com.saflink.bioapi.BirBiometricDataFormat;
import com.saflink.bioapi.BirHandle;
import com.saflink.bioapi.BirHeader;
import com.saflink.bioapi.BspSchema;
import com.saflink.bioapi.ByteArrayHolder;
import com.saflink.bioapi.IModuleEventHandler;
import com.saflink.bioapi.InputBir;
import com.saflink.bioapi.ModuleEvent;
import com.saflink.bioapi.ModuleEventMask;
import com.saflink.bioapi.ModuleHandle;
import com.saflink.bioapi.Result;
import com.saflink.bioapi.Version;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.IntHolder;

public class Win32 {
    private static IModuleEventHandler globalEventListener = null;

    private static void setGlobalEventListener(IModuleEventHandler listener) {
        globalEventListener = listener;
    }

    private static IModuleEventHandler getGlobalEventListener() {
        return globalEventListener;
    }

    private static void handleModuleEventStatic(long eventCode) {
        ModuleEvent event = new ModuleEvent((int)eventCode);
        IModuleEventHandler globalListener = Win32.getGlobalEventListener();
        if (globalListener != null) {
            globalListener.handleModuleEvent(null, event);
        }
    }

    protected static native byte[] nConvertToUint32(long var0);

    protected static native byte[] nConvertToUint16(int var0);

    protected static native byte[] nConvertToUint8(int var0);

    protected static native byte[] nConvertToSint8(int var0);

    public Win32() {
    }

    public Win32(IModuleEventHandler listener) {
        Win32.setGlobalEventListener(listener);
    }

    public Version BioAPI_Init() {
        long longVersion = this.nBioAPI_Init();
        Version version = new Version();
        version.Major = (int)(longVersion / 0x80000000L);
        version.Minor = (int)(longVersion % 0x80000000L);
        return version;
    }

    private native long nBioAPI_Init();

    public BspSchema[] BioAPI_EnumModules() {
        BspSchema[] modules = this.nBioAPI_EnumModules();
        if (modules != null) {
            System.out.println("Java: Module count = " + modules.length);
            for (int i = 0; i < modules.length; ++i) {
                System.out.println("Java: " + modules[i].description);
            }
        }
        return modules;
    }

    private native BspSchema[] nBioAPI_EnumModules();

    public void beginBspTest(BspSchema bsp) {
        this.nBeginBspTest(bsp.moduleId);
    }

    private native void nBeginBspTest(byte[] var1);

    public void endBspTest() {
        this.nEndBspTest();
    }

    private native void nEndBspTest();

    public void BioAPI_Terminate() {
        this.nBioAPI_Terminate();
    }

    private native void nBioAPI_Terminate();

    public void BioSPI_ModuleLoad(byte[] moduleGuid) throws BioAPIRuntimeException {
        this.nBioSPI_ModuleLoad(moduleGuid);
        Win32.CheckBioAPIRuntimeException();
    }

    private native void nBioSPI_ModuleLoad(byte[] var1);

    public void BioSPI_ModuleUnload(byte[] moduleGuid) throws BioAPIRuntimeException {
        this.nBioSPI_ModuleUnload(moduleGuid);
        Win32.CheckBioAPIRuntimeException();
    }

    private native void nBioSPI_ModuleUnload(byte[] var1);

    public Result BioSPI_ModuleAttach(byte[] moduleGuid, Version version, int deviceId, IntHolder testModuleHandle, IntHolder actualModuleHandle) throws BioAPIRuntimeException {
        int bioResult = 0;
        if (moduleGuid != null && moduleGuid.length == 16 && version != null) {
            ModuleHandle handle = new ModuleHandle();
            bioResult = this.nBioSPI_ModuleAttachInOut(moduleGuid, version.Major, version.Minor, deviceId, testModuleHandle, actualModuleHandle);
            Win32.CheckBioAPIRuntimeException();
            return new Result(bioResult);
        }
        return null;
    }

    private native int nBioSPI_ModuleAttachInOut(byte[] var1, long var2, long var4, int var6, IntHolder var7, IntHolder var8);

    private native long nBioSPI_ModuleAttach(byte[] var1, long var2, long var4);

    public Result BioSPI_ModuleDetach(ModuleHandle moduleHandle) throws BioAPIRuntimeException {
        int bioResult = 0;
        if (moduleHandle != null) {
            bioResult = this.nBioSPI_ModuleDetach(moduleHandle.Handle);
            Win32.CheckBioAPIRuntimeException();
        }
        return new Result(bioResult);
    }

    private native int nBioSPI_ModuleDetach(long var1);

    public Bir BioSPI_GetBirFromHandle(ModuleHandle moduleHandle, BirHandle birHandle) throws BioAPIRuntimeException {
        Bir bir = null;
        int bioApiResult = 0;
        bioApiResult = this.nGetBIRFromHandle(moduleHandle.Handle, birHandle.Handle);
        Win32.CheckBioAPIRuntimeException();
        if (bioApiResult == 0) {
            bir = new Bir();
            bir.Header = new BirHeader();
            bir.Header.length = this.nGetBirLength();
            bir.Header.headerVersion = this.nGetBirHeaderVersion();
            bir.Header.type = this.nGetBirType();
            bir.Header.format = new BirBiometricDataFormat();
            bir.Header.format.formatID = this.nGetBirFormatId();
            bir.Header.format.formatOwner = this.nGetBirFormatOwner();
            bir.Header.quality = this.nGetBirQuality();
            bir.Header.purpose = this.nGetBirPurpose();
            bir.Header.factorsMask = this.nGetBirFactorsMask();
            bir.Header.bytes = this.nGetBytesFromHeader();
            bir.BiometricData = this.nGetBirBiometricData();
            bir.Signature = this.nGetBirSignature();
        }
        return bir;
    }

    private native int nGetBIRFromHandle(long var1, int var3);

    private native long nGetBirLength();

    private native short nGetBirHeaderVersion();

    private native short nGetBirType();

    private native int nGetBirFormatOwner();

    private native int nGetBirFormatId();

    private native byte nGetBirQuality();

    private native short nGetBirPurpose();

    private native long nGetBirFactorsMask();

    private native byte[] nGetBirBiometricData();

    private native byte[] nGetBirBytes();

    private native byte[] nGetBirSignature();

    public void BioSPI_FreeBirHandle(ModuleHandle moduleHandle, BirHandle birHandle) throws BioAPIRuntimeException {
        this.nBioSPI_FreeBirHandle(moduleHandle.Handle, birHandle.Handle);
        Win32.CheckBioAPIRuntimeException();
    }

    private native void nBioSPI_FreeBirHandle(long var1, int var3);

    public BirHeader BioSPI_GetHeaderFromHandle(ModuleHandle moduleHandle, BirHandle birHandle) throws BioAPIRuntimeException {
        BirHeader header = null;
        int bioApiResult = 0;
        bioApiResult = this.nGetHeaderFromHandle(moduleHandle.Handle, birHandle.Handle);
        Win32.CheckBioAPIRuntimeException();
        if (bioApiResult == 0) {
            header = new BirHeader();
            header.length = this.nGetBirLengthFromHeader();
            header.type = this.nGetBirTypeFromHeader();
            header.format = new BirBiometricDataFormat();
            header.format.formatOwner = this.nGetBirFormatOwnerFromHeader();
            header.format.formatID = this.nGetBirFormatIdFromHeader();
            header.quality = this.nGetBirQualityFromHeader();
            header.purpose = this.nGetBirPurposeFromHeader();
            header.factorsMask = this.nGetBirFactorsMaskFromHeader();
            header.bytes = this.nGetBytesFromHeader();
        }
        return header;
    }

    private native int nGetHeaderFromHandle(long var1, int var3);

    private native long nGetBirLengthFromHeader();

    private native short nGetBirHeaderVersionFromHeader();

    private native short nGetBirTypeFromHeader();

    private native int nGetBirFormatOwnerFromHeader();

    private native int nGetBirFormatIdFromHeader();

    private native byte nGetBirQualityFromHeader();

    private native short nGetBirPurposeFromHeader();

    private native long nGetBirFactorsMaskFromHeader();

    private native byte[] nGetBytesFromHeader();

    public Result BioSPI_CaptureInOut(ModuleHandle moduleHandle, int purpose, BirHandle newTemplate, int timeout, BirHandle auditData) throws BioAPIRuntimeException {
        IntHolder newTemplateReturn = this.intHolderFromBirHandle(newTemplate);
        IntHolder auditDataReturn = this.intHolderFromBirHandle(auditData);
        int bioResult = this.nBioSPI_CaptureInOut(moduleHandle.Handle, purpose, newTemplateReturn, timeout, auditDataReturn);
        Win32.CheckBioAPIRuntimeException();
        this.intHolderToBirHandle(newTemplateReturn, newTemplate);
        this.intHolderToBirHandle(auditDataReturn, auditData);
        return new Result(bioResult);
    }

    private native int nBioSPI_CaptureInOut(long var1, int var3, IntHolder var4, int var5, IntHolder var6);

    public Result BioSPI_EnrollInOut(ModuleHandle moduleHandle, int purpose, InputBir storedTemplate, BirHandle newTemplate, BioAPIData payload, int timeout, BirHandle auditData) throws BioAPIRuntimeException {
        IntHolder newTemplateReturn = this.intHolderFromBirHandle(newTemplate);
        IntHolder auditDataReturn = this.intHolderFromBirHandle(auditData);
        int bioResult = this.nBioSPI_EnrollInOut(moduleHandle.Handle, purpose, InputBir.getIsNull(storedTemplate), InputBir.getForm(storedTemplate), InputBir.getHandle(storedTemplate), InputBir.getBytes(storedTemplate), newTemplateReturn, payload, timeout, auditDataReturn);
        Win32.CheckBioAPIRuntimeException();
        this.intHolderToBirHandle(newTemplateReturn, newTemplate);
        this.intHolderToBirHandle(auditDataReturn, auditData);
        return new Result(bioResult);
    }

    private native int nBioSPI_EnrollInOut(long var1, int var3, boolean var4, int var5, int var6, byte[] var7, IntHolder var8, ByteArrayHolder var9, int var10, IntHolder var11);

    public Result BioSPI_VerifyInOut(ModuleHandle moduleHandle, IntHolder maxFARRequested, IntHolder maxFRRRequested, BooleanHolder FARPrecedence, InputBir storedTemplate, BirHandle adaptedBIR, BooleanHolder result, IntHolder FARAchieved, IntHolder FRRAchieved, int timeout, BioAPIData payload, BirHandle auditData) throws BioAPIRuntimeException {
        IntHolder adaptedBirReturn = this.intHolderFromBirHandle(adaptedBIR);
        IntHolder auditDataReturn = this.intHolderFromBirHandle(auditData);
        int bioReturn = this.nBioSPI_VerifyInOut(moduleHandle.Handle, maxFARRequested, maxFRRRequested, FARPrecedence, storedTemplate == null, storedTemplate.Form, storedTemplate.Form == 2 ? storedTemplate.BirInBsp.Handle : 0, storedTemplate.Form == 3 ? storedTemplate.Bir.toByteArray() : null, adaptedBirReturn, result, FARAchieved, FRRAchieved, payload, timeout, auditDataReturn);
        Win32.CheckBioAPIRuntimeException();
        this.intHolderToBirHandle(adaptedBirReturn, adaptedBIR);
        this.intHolderToBirHandle(auditDataReturn, auditData);
        return new Result(bioReturn);
    }

    private native int nBioSPI_VerifyInOut(long var1, IntHolder var3, IntHolder var4, BooleanHolder var5, boolean var6, int var7, int var8, byte[] var9, IntHolder var10, BooleanHolder var11, IntHolder var12, IntHolder var13, ByteArrayHolder var14, int var15, IntHolder var16);

    public Result BioSPI_VerifyMatchInOut(ModuleHandle moduleHandle, IntHolder maxFARRequested, IntHolder maxFRRRequested, BooleanHolder FARPrecedence, InputBir processedBir, InputBir storedTemplate, BirHandle adaptedBIR, BooleanHolder result, IntHolder FARAchieved, IntHolder FRRAchieved, BioAPIData payload) throws BioAPIRuntimeException {
        IntHolder adaptedBirHolder = this.intHolderFromBirHandle(adaptedBIR);
        int bioReturn = this.nBioSPI_VerifyMatchInOut(moduleHandle.Handle, maxFARRequested, maxFRRRequested, FARPrecedence, InputBir.getIsNull(processedBir), InputBir.getForm(processedBir), InputBir.getHandle(processedBir), InputBir.getBytes(processedBir), InputBir.getIsNull(storedTemplate), InputBir.getForm(storedTemplate), InputBir.getHandle(storedTemplate), InputBir.getBytes(storedTemplate), adaptedBirHolder, result, FARAchieved, FRRAchieved, payload);
        Win32.CheckBioAPIRuntimeException();
        this.intHolderToBirHandle(adaptedBirHolder, adaptedBIR);
        return new Result(bioReturn);
    }

    private native int nBioSPI_VerifyMatchInOut(long var1, IntHolder var3, IntHolder var4, BooleanHolder var5, boolean var6, int var7, int var8, byte[] var9, boolean var10, int var11, int var12, byte[] var13, IntHolder var14, BooleanHolder var15, IntHolder var16, IntHolder var17, ByteArrayHolder var18);

    public BirHandle BioSPI_Process(ModuleHandle moduleHandle, InputBir capturedBir) throws BioAPIRuntimeException {
        BirHandle processedBirHandle = new BirHandle();
        processedBirHandle.Handle = this.nBioSPI_Process(moduleHandle.Handle, capturedBir.Form, capturedBir.Form == 2 ? capturedBir.BirInBsp.Handle : 0, capturedBir.Form == 3 ? capturedBir.Bir.toByteArray() : null);
        Win32.CheckBioAPIRuntimeException();
        return processedBirHandle;
    }

    private native int nBioSPI_Process(long var1, int var3, int var4, byte[] var5);

    public Result BioSPI_CreateTemplateInOut(ModuleHandle moduleHandle, InputBir capturedBir, InputBir storedTemplate, BirHandle newTemplate, BioAPIData payload) throws BioAPIRuntimeException {
        IntHolder newTemplateHolder = this.intHolderFromBirHandle(newTemplate);
        int bioReturn = this.nBioSPI_CreateTemplateInOut(moduleHandle.Handle, InputBir.getIsNull(capturedBir), InputBir.getForm(capturedBir), InputBir.getHandle(capturedBir), InputBir.getBytes(capturedBir), InputBir.getIsNull(storedTemplate), InputBir.getForm(storedTemplate), InputBir.getHandle(storedTemplate), InputBir.getBytes(storedTemplate), newTemplateHolder, payload);
        Win32.CheckBioAPIRuntimeException();
        this.intHolderToBirHandle(newTemplateHolder, newTemplate);
        return new Result(bioReturn);
    }

    private native int nBioSPI_CreateTemplateInOut(long var1, boolean var3, int var4, int var5, byte[] var6, boolean var7, int var8, int var9, byte[] var10, IntHolder var11, ByteArrayHolder var12);

    public void BioSPI_EnableEvents(ModuleHandle moduleHandle, ModuleEventMask events) throws BioAPIRuntimeException {
        System.out.println("*****BioSPI_EnableEvents*****");
        this.nBioSPI_EnableEvents(moduleHandle.Handle, events.mask);
        Win32.CheckBioAPIRuntimeException();
    }

    private native void nBioSPI_EnableEvents(long var1, int var3);

    public static void stopBioAPI() {
        Win32.stopBioapi();
    }

    private static native boolean stopBioapi();

    public Result getLastError() {
        Result lastError = new Result(this.getErrorCode());
        return lastError;
    }

    private native long getErrorCode();

    private void intHolderToBirHandle(IntHolder holder, BirHandle birHandle) {
        if (holder != null && birHandle != null) {
            birHandle.Handle = holder.value;
        }
    }

    private IntHolder intHolderFromBirHandle(BirHandle birHandle) {
        return birHandle == null ? null : new IntHolder(birHandle.Handle);
    }

    public native boolean testJNI();

    private static native long getExceptionCode();

    public static void CheckBioAPIRuntimeException() throws BioAPIRuntimeException {
        long exceptionCode = Win32.getExceptionCode();
        if (exceptionCode != 0L) {
            throw new BioAPIRuntimeException(exceptionCode);
        }
    }

    static {
        System.loadLibrary("bioapi100");
    }
}

