/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttDef;
import com.ibm.xml.framework.Attr;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDecl;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLValidationHandler;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DefaultElementDeclPool
implements ElementDeclPool {
    private static final int CHUNK_SHIFT = 5;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState;
    private StringPool fStringPool;
    private AttrPool fAttrPool;
    private XMLErrorHandler fErrorHandler;
    private XMLValidationHandler fValidationHandler;
    private int fRootElement = -1;
    private Attr fAttr = new Attr();
    private int fElementCount;
    private int[][] fElementName = new int[32][];
    private byte[][] fContentSpecType = new byte[32][];
    private int[][] fContentSpec = new int[32][];
    private ContentModel[][] fContentModel = new ContentModel[32][];
    private int[][] fAttlistHead = new int[32][];
    private int[][] fAttlistTail = new int[32][];
    private int fNodeCount;
    private byte[][] fNodeType = new byte[32][];
    private int[][] fNodeValue = new int[32][];
    private int fAttDefCount;
    private int[][] fAttName = new int[32][];
    private byte[][] fAttType = new byte[32][];
    private int[][] fEnumeration = new int[32][];
    private byte[][] fAttDefaultType = new byte[32][];
    private int[][] fAttValue = new int[32][];
    private int[][] fNextAttDef = new int[32][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fElementNameHashtable = new int[128][];
    private int fXMLSpace = -1;
    private int fDefault = -1;
    private int fPreserve = -1;
    private Hashtable fIdDefs;
    private Hashtable fIdRefs;
    private Object fNullValue;
    private int[] localpartcache = new int[8];
    private int[] nsnamecache = new int[8];

    public DefaultElementDeclPool(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fValidationHandler = parserState.getValidationHandler();
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fValidationHandler = parserState.getValidationHandler();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fElementCount) {
            this.fContentModel[n][n2] = null;
            if (++n2 == 32) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 128) {
            this.fElementNameHashtable[n4] = null;
            ++n4;
        }
        this.fRootElement = -1;
        this.fElementCount = 0;
        this.fNodeCount = 0;
        this.fAttDefCount = 0;
        this.fXMLSpace = -1;
        this.fDefault = -1;
        this.fPreserve = -1;
        if (this.fIdDefs != null) {
            this.fIdDefs.clear();
        }
        if (this.fIdRefs != null) {
            this.fIdRefs.clear();
        }
    }

    public ElementDeclPool resetOrCopy(ParserState parserState) {
        return new DefaultElementDeclPool(parserState);
    }

    public void setRootElement(int n) {
        this.fRootElement = n;
    }

    public int getRootElement() {
        return this.fRootElement;
    }

    private boolean ensureElementCapacity(int n) {
        try {
            return this.fElementName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fContentSpecType, 0, byArray, 0, n);
            this.fContentSpecType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fElementName, 0, nArray, 0, n);
            this.fElementName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fContentSpec, 0, nArray, 0, n);
            this.fContentSpec = nArray;
            ContentModel[][] contentModelArray = new ContentModel[n * 2][];
            System.arraycopy(this.fContentModel, 0, contentModelArray, 0, n);
            this.fContentModel = contentModelArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistHead, 0, nArray, 0, n);
            this.fAttlistHead = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttlistTail, 0, nArray, 0, n);
            this.fAttlistTail = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fElementName[n] = new int[32];
        this.fContentSpecType[n] = new byte[32];
        this.fContentSpec[n] = new int[32];
        this.fContentModel[n] = new ContentModel[32];
        this.fAttlistHead[n] = new int[32];
        this.fAttlistTail[n] = new int[32];
        return true;
    }

    public int getElement(int n) {
        int n2 = n % 128;
        int[] nArray = this.fElementNameHashtable[n2];
        if (nArray != null) {
            int n3 = 1;
            int n4 = 0;
            while (n4 < nArray[0]) {
                if (nArray[n3] == n) {
                    return nArray[n3 + 1];
                }
                n3 += 2;
                ++n4;
            }
        }
        return -1;
    }

    public int addElement(int n) {
        int n2;
        int n3;
        int n4 = n % 128;
        int[] nArray = this.fElementNameHashtable[n4];
        if (nArray != null) {
            n3 = 1;
            n2 = 0;
            while (n2 < nArray[0]) {
                if (nArray[n3] == n) {
                    return nArray[n3 + 1];
                }
                n3 += 2;
                ++n2;
            }
        }
        n3 = this.fElementCount >> 5;
        n2 = this.fElementCount & 0x1F;
        this.ensureElementCapacity(n3);
        this.fElementName[n3][n2] = n;
        this.fContentSpecType[n3][n2] = 0;
        this.fContentSpec[n3][n2] = -1;
        this.fContentModel[n3][n2] = null;
        this.fAttlistHead[n3][n2] = -1;
        this.fAttlistTail[n3][n2] = -1;
        if (nArray == null) {
            nArray = new int[9];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = this.fElementCount;
            this.fElementNameHashtable[n4] = nArray;
        } else {
            int n5 = nArray[0];
            int n6 = 1 + n5 * 2;
            if (n6 == nArray.length) {
                int n7 = n5 + 4;
                int[] nArray2 = new int[1 + n7 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n6);
                nArray = nArray2;
                this.fElementNameHashtable[n4] = nArray;
            }
            nArray[n6++] = n;
            nArray[n6++] = this.fElementCount;
            nArray[0] = ++n5;
        }
        return this.fElementCount++;
    }

    public int addElementDecl(ElementDecl elementDecl) {
        int n;
        int n2;
        int n3 = elementDecl.elementName;
        int n4 = n3 % 128;
        int[] nArray = this.fElementNameHashtable[n4];
        if (nArray != null) {
            n2 = 1;
            n = 0;
            while (n < nArray[0]) {
                if (nArray[n2] == n3) {
                    int n5 = nArray[n2 + 1];
                    int n6 = n5 >> 5;
                    int n7 = n5 & 0x1F;
                    if (this.fContentSpecType[n6][n7] != 0) {
                        return -1;
                    }
                    this.fContentSpecType[n6][n7] = (byte)elementDecl.contentSpecType;
                    this.fContentSpec[n6][n7] = elementDecl.contentSpec;
                    this.fContentModel[n6][n7] = null;
                    return n5;
                }
                n2 += 2;
                ++n;
            }
        }
        n2 = this.fElementCount >> 5;
        n = this.fElementCount & 0x1F;
        this.ensureElementCapacity(n2);
        this.fElementName[n2][n] = elementDecl.elementName;
        this.fContentSpecType[n2][n] = (byte)elementDecl.contentSpecType;
        this.fContentSpec[n2][n] = elementDecl.contentSpec;
        this.fContentModel[n2][n] = null;
        this.fAttlistHead[n2][n] = -1;
        this.fAttlistTail[n2][n] = -1;
        if (nArray == null) {
            nArray = new int[9];
            nArray[0] = 1;
            nArray[1] = n3;
            nArray[2] = this.fElementCount;
            this.fElementNameHashtable[n4] = nArray;
        } else {
            int n8 = nArray[0];
            int n9 = 1 + n8 * 2;
            if (n9 == nArray.length) {
                int n10 = n8 + 4;
                int[] nArray2 = new int[1 + n10 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n9);
                nArray = nArray2;
                this.fElementNameHashtable[n4] = nArray;
            }
            nArray[n9++] = n3;
            nArray[n9++] = this.fElementCount;
            nArray[0] = ++n8;
        }
        return this.fElementCount++;
    }

    public int getElementName(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fElementName[n2][n3];
    }

    public int getContentSpecType(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentSpecType[n2][n3];
    }

    public int getContentSpec(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentSpec[n2][n3];
    }

    public String getContentSpecAsString(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        switch (this.fContentSpecType[n2][n3]) {
            case 1: {
                return "EMPTY";
            }
            case 2: {
                return "ANY";
            }
            case 3: 
            case 4: {
                return this.getContentSpecNodeAsString(this.fContentSpec[n2][n3]);
            }
        }
        return null;
    }

    public ContentModel getContentModel(int n) {
        if (n < 0 || n >= this.fElementCount) {
            return null;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fContentModel[n2][n3];
    }

    public void setContentModel(int n, ContentModel contentModel) {
        if (n < 0 || n >= this.fElementCount) {
            return;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        this.fContentModel[n2][n3] = contentModel;
    }

    private boolean ensureNodeCapacity(int n) {
        try {
            return this.fNodeType[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fNodeType, 0, byArray, 0, n);
            this.fNodeType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fNodeValue, 0, nArray, 0, n);
            this.fNodeValue = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fNodeType[n] = new byte[32];
        this.fNodeValue[n] = new int[32];
        return true;
    }

    public int addContentSpecNode(ContentSpecNode contentSpecNode) {
        int n = this.fNodeCount >> 5;
        int n2 = this.fNodeCount & 0x1F;
        this.ensureNodeCapacity(n);
        switch (contentSpecNode.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fNodeType[n][n2] = (byte)contentSpecNode.type;
                this.fNodeValue[n][n2] = contentSpecNode.value;
                return this.fNodeCount++;
            }
            case 4: 
            case 5: {
                this.fNodeType[n][n2] = (byte)contentSpecNode.type;
                this.fNodeValue[n][n2] = contentSpecNode.value;
                int n3 = this.fNodeCount++;
                if (++n2 == 32) {
                    this.ensureNodeCapacity(++n);
                    n2 = 0;
                }
                this.fNodeType[n][n2] = (byte)(contentSpecNode.type | 0x40);
                this.fNodeValue[n][n2] = contentSpecNode.otherValue;
                ++this.fNodeCount;
                return n3;
            }
        }
        return -1;
    }

    public void getContentSpecNode(int n, ContentSpecNode contentSpecNode) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        contentSpecNode.type = this.fNodeType[n2][n3];
        contentSpecNode.value = this.fNodeValue[n2][n3];
        if (contentSpecNode.type == 4 || contentSpecNode.type == 5) {
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            contentSpecNode.otherValue = this.fNodeValue[n2][n3];
            return;
        }
        contentSpecNode.otherValue = -1;
    }

    private void appendContentSpecNode(int n, StringBuffer stringBuffer, boolean bl) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        switch (by) {
            case 0: {
                stringBuffer.append(n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4));
                return;
            }
            case 1: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('?');
                return;
            }
            case 2: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('*');
                return;
            }
            case 3: {
                this.appendContentSpecNode(n4, stringBuffer, false);
                stringBuffer.append('+');
                return;
            }
            case 4: 
            case 5: {
                int n5;
                int n6;
                byte by2;
                if (!bl) {
                    stringBuffer.append('(');
                }
                this.appendContentSpecNode(n4, stringBuffer, (by2 = this.fNodeType[n6 = n4 >> 5][n5 = n4 & 0x1F]) == by);
                stringBuffer.append(by == 4 ? (char)'|' : ',');
                if (++n3 == 32) {
                    ++n2;
                    n3 = 0;
                }
                this.appendContentSpecNode(this.fNodeValue[n2][n3], stringBuffer, false);
                if (!bl) {
                    stringBuffer.append(')');
                }
                return;
            }
        }
    }

    public String getContentSpecNodeAsString(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte by = this.fNodeType[n2][n3];
        int n4 = this.fNodeValue[n2][n3];
        StringBuffer stringBuffer = new StringBuffer();
        switch (by) {
            case 0: {
                stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")");
                break;
            }
            case 1: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")?");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 2: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")*");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 3: {
                n2 = n4 >> 5;
                n3 = n4 & 0x1F;
                if (this.fNodeType[n2][n3] == 0) {
                    n4 = this.fNodeValue[n2][n3];
                    stringBuffer.append("(" + (n4 == -1 ? "#PCDATA" : this.fStringPool.toString(n4)) + ")+");
                    break;
                }
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            case 4: 
            case 5: {
                this.appendContentSpecNode(n, stringBuffer, false);
                break;
            }
            default: {
                return null;
            }
        }
        return stringBuffer.toString();
    }

    private boolean ensureAttrCapacity(int n) {
        try {
            return this.fAttName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fAttType, 0, byArray, 0, n);
            this.fAttType = byArray;
            byArray = new byte[n * 2][];
            System.arraycopy(this.fAttDefaultType, 0, byArray, 0, n);
            this.fAttDefaultType = byArray;
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fAttName, 0, nArray, 0, n);
            this.fAttName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fEnumeration, 0, nArray, 0, n);
            this.fEnumeration = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttValue, 0, nArray, 0, n);
            this.fAttValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNextAttDef, 0, nArray, 0, n);
            this.fNextAttDef = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttType[n] = new byte[32];
        this.fAttDefaultType[n] = new byte[32];
        this.fAttName[n] = new int[32];
        this.fEnumeration[n] = new int[32];
        this.fAttValue[n] = new int[32];
        this.fNextAttDef[n] = new int[32];
        return true;
    }

    public int addAttDef(int n, AttDef attDef) throws Exception {
        int n2;
        int n3;
        int n4 = n >> 5;
        int n5 = n & 0x1F;
        int n6 = this.fAttlistHead[n4][n5];
        while (n6 != -1) {
            n3 = n6 >> 5;
            n2 = n6 & 0x1F;
            if (this.fAttName[n3][n2] == attDef.attName) {
                if (this.fParserState.getWarningOnDuplicateAttDef()) {
                    this.fErrorHandler.error1(15, attDef.attName);
                }
                return -1;
            }
            if (attDef.attType == 1 && this.fAttType[n3][n2] == 1) {
                this.fErrorHandler.error1(13, attDef.attName);
                return -1;
            }
            n6 = this.fNextAttDef[n3][n2];
        }
        if (this.fXMLSpace == -1) {
            this.fXMLSpace = this.fStringPool.addSymbol("xml:space".intern());
            this.fDefault = this.fStringPool.addSymbol("default".intern());
            this.fPreserve = this.fStringPool.addSymbol("preserve".intern());
        }
        if (attDef.attName == this.fXMLSpace) {
            n3 = 0;
            if (attDef.attType == 9 && (n2 = attDef.enumeration) != -1) {
                int n7 = n3 = this.fStringPool.stringListLength(n2) != 2 || !this.fStringPool.stringInList(n2, this.fDefault) || !this.fStringPool.stringInList(n2, this.fPreserve) ? 0 : 1;
            }
            if (n3 == 0) {
                this.fErrorHandler.error(14);
            }
        }
        n3 = this.fAttDefCount >> 5;
        n2 = this.fAttDefCount & 0x1F;
        this.ensureAttrCapacity(n3);
        this.fAttName[n3][n2] = attDef.attName;
        this.fAttType[n3][n2] = (byte)attDef.attType;
        this.fEnumeration[n3][n2] = attDef.enumeration;
        this.fAttDefaultType[n3][n2] = (byte)attDef.attDefaultType;
        this.fAttValue[n3][n2] = attDef.attValue;
        int n8 = -1;
        if (attDef.attValue != -1) {
            n8 = this.fAttlistHead[n4][n5];
            this.fAttlistHead[n4][n5] = this.fAttDefCount;
            if (n8 == -1) {
                this.fAttlistTail[n4][n5] = this.fAttDefCount;
            }
        } else {
            n8 = this.fAttlistTail[n4][n5];
            this.fAttlistTail[n4][n5] = this.fAttDefCount;
            if (n8 == -1) {
                this.fAttlistHead[n4][n5] = this.fAttDefCount;
            } else {
                this.fNextAttDef[n8 >> 5][n8 & 0x1F] = this.fAttDefCount;
                n8 = -1;
            }
        }
        this.fNextAttDef[n3][n2] = n8;
        return this.fAttDefCount++;
    }

    public int getAttDef(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fElementCount) {
            if (this.fElementName[n3][n4] == n) {
                int n6 = this.fAttlistHead[n3][n4];
                while (true) {
                    if (n6 == -1) {
                        return -1;
                    }
                    n3 = n6 >> 5;
                    n4 = n6 & 0x1F;
                    if (this.fAttName[n3][n4] == n2) {
                        return n6;
                    }
                    n6 = this.fNextAttDef[n3][n4];
                }
            }
            if (++n4 == 32) {
                ++n3;
                n4 = 0;
            }
            ++n5;
        }
        return -1;
    }

    public int getAttName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttName[n2][n3];
    }

    public int getAttValue(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttValue[n2][n3];
    }

    public int getAttType(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttType[n2][n3];
    }

    public int getAttDefaultType(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttDefaultType[n2][n3];
    }

    public int getEnumeration(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fEnumeration[n2][n3];
    }

    public int addDefaultAttributes(int n, AttrPool attrPool, int n2, int n3) throws Exception {
        int n4 = n >> 5;
        int n5 = n & 0x1F;
        int n6 = this.fAttlistHead[n4][n5];
        int n7 = n2;
        int n8 = n3;
        while (n6 != -1) {
            int n9 = n6 >> 5;
            int n10 = n6 & 0x1F;
            byte by = this.fAttDefaultType[n9][n10];
            if (by != 3) {
                int n11 = this.fAttName[n9][n10];
                boolean bl = false;
                if (n7 != -1) {
                    int n12 = n7;
                    while (n12 <= n8) {
                        attrPool.getAttrName(n12);
                        if (attrPool.getAttrName(n12) == n11) {
                            if (by == 4 && attrPool.getAttValue(n12) != this.fAttValue[n9][n10]) {
                                this.fErrorHandler.error3(134, n11, this.fAttValue[n9][n10], attrPool.getAttValue(n12));
                            }
                            bl = true;
                            break;
                        }
                        ++n12;
                    }
                }
                if (!bl) {
                    if (by == 2) {
                        this.fErrorHandler.error1(133, n11);
                    } else {
                        this.fAttr.attName = n11;
                        this.fAttr.attType = this.fAttType[n9][n10];
                        this.fAttr.attValue = this.fAttValue[n9][n10];
                        this.fAttr.specified = false;
                        n3 = attrPool.addAttr(this.fAttr, -1);
                        if (n2 == -1) {
                            n2 = n3;
                        }
                    }
                }
            }
            n6 = this.fNextAttDef[n9][n10];
        }
        if (n3 != -1) {
            attrPool.setIsLastAttr(n3);
        }
        return n2;
    }

    public boolean addId(int n, int n2) {
        Integer n3 = new Integer(n);
        if (this.fIdDefs == null) {
            this.fIdDefs = new Hashtable();
        } else if (this.fIdDefs.containsKey(n3)) {
            return false;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdDefs.put(n3, this.fNullValue);
        return true;
    }

    public void addIdRef(int n, int n2) {
        Integer n3 = new Integer(n);
        if (this.fIdDefs != null && this.fIdDefs.containsKey(n3)) {
            return;
        }
        if (this.fIdRefs == null) {
            this.fIdRefs = new Hashtable();
        } else if (this.fIdRefs.containsKey(n3)) {
            return;
        }
        if (this.fNullValue == null) {
            this.fNullValue = new Object();
        }
        this.fIdRefs.put(n3, this.fNullValue);
    }

    public void checkIdRefs() throws Exception {
        if (this.fIdRefs == null) {
            return;
        }
        Enumeration enumeration = this.fIdRefs.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (this.fIdDefs != null && this.fIdDefs.containsKey(n)) continue;
            this.fErrorHandler.error1(84, n);
        }
    }

    public void checkNamespace(int n, int n2) throws Exception {
        String string;
        int n3;
        int n4;
        if (n2 != -1) {
            int n5;
            String string2;
            n4 = n2;
            int n6 = this.fAttrPool.getAttrName(n4);
            String string3 = this.fStringPool.toString(n6);
            int n7 = this.checkQName(n, string3);
            if (n7 != -1) {
                this.fErrorHandler.error1(n7, n6);
            }
            if ((string2 = this.fStringPool.toString(n5 = this.fAttrPool.getAttValue(n4))).length() == 0 && string3.startsWith("xmlns:")) {
                this.fErrorHandler.error1(142, n6);
            }
            if (this.localpartcache.length == 0) {
                int[] nArray = new int[]{};
                System.arraycopy(this.localpartcache, 0, nArray, 0, 0);
                this.localpartcache = nArray;
                nArray = new int[]{};
                System.arraycopy(this.nsnamecache, 0, nArray, 0, 0);
                this.nsnamecache = nArray;
            }
            this.localpartcache[0] = this.getNSLocalName(string3, n6);
            this.nsnamecache[0] = this.getNSName(n, string3);
            if (this.nsnamecache[0] != -1) {
                int n8 = 0;
                while (n8 < 0) {
                    int n9;
                    if (this.localpartcache[n8] == this.localpartcache[0] && (n9 = this.nsnamecache[n8]) != -1 && n9 == this.nsnamecache[0]) {
                        this.fErrorHandler.error4(144, n6, this.nsnamecache[0], this.localpartcache[0], this.fAttrPool.getAttrName(n2 + n8));
                    }
                    ++n8;
                }
            }
        }
        if ((n3 = this.checkQName(n, string = this.fStringPool.toString(n4 = this.getElementName(n)))) != -1) {
            this.fErrorHandler.error1(n3, n4);
        }
    }

    public void checkDeclaredElements() throws Exception {
        if (this.fParserState.getValidationHandler() != null) {
            int n = 0;
            while (n < this.fElementCount) {
                int n2 = this.getContentSpecType(n);
                if (n2 == 3 || n2 == 4) {
                    int n3 = n >> 5;
                    int n4 = n & 0x1F;
                    int n5 = this.fContentSpec[n3][n4];
                    this.checkDeclaredElements(n, n5);
                }
                ++n;
            }
        }
    }

    private void checkDeclaredElements(int n, int n2) throws Exception {
        int n3 = n2 >> 5;
        int n4 = n2 & 0x1F;
        byte by = this.fNodeType[n3][n4];
        int n5 = this.fNodeValue[n3][n4];
        switch (by) {
            case 0: {
                if (n5 == -1 || this.getElement(n5) != -1) break;
                int n6 = n >> 5;
                int n7 = n & 0x1F;
                int n8 = this.fElementName[n6][n7];
                this.fErrorHandler.error2(165, n8, n5);
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.checkDeclaredElements(n, n5);
                return;
            }
            case 4: 
            case 5: {
                this.checkDeclaredElements(n, n5);
                if (++n4 == 32) {
                    ++n3;
                    n4 = 0;
                }
                this.checkDeclaredElements(n, this.fNodeValue[n3][n4]);
                return;
            }
        }
    }

    private int checkQName(int n, String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return -1;
        }
        string.substring(0, n2);
        if (-1 == -1) {
            return 136;
        }
        if (string.indexOf(58, n2 + 1) >= 0) {
            return 135;
        }
        return -1;
    }

    private int getNSLocalName(String string, int n) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return n;
        }
        return this.fStringPool.addSymbol(string.substring(n2 + 1));
    }

    private int getNSName(int n, String string) {
        int n2 = string.indexOf(58);
        String string2 = n2 < 0 ? "" : string.substring(0, n2);
        return -1;
    }

    private int getNamespaceForPrefix(int n, String string) {
        return -1;
    }
}

