/*
 * Decompiled with CFR 0.152.
 */
package org.doomdark.uuid;

import java.util.Random;

public class UUIDTimer {
    private static final long kClockOffset = 122192928000000000L;
    private static final long kClockMultiplier = 10000L;
    private static final long kClockMultiplierL = 10000L;
    private final Random mRnd;
    private final byte[] mClockSequence = new byte[2];
    private long mLastTimeStamp = 0L;
    private int mClockCounter = 0;

    public UUIDTimer(Random random) {
        this.mRnd = random;
        this.initTimeStamps();
    }

    private void initTimeStamps() {
        this.mRnd.nextBytes(this.mClockSequence);
        byte[] byArray = new byte[1];
        this.mRnd.nextBytes(byArray);
        this.mClockCounter = byArray[0] & 0xFF;
        this.mLastTimeStamp = 0L;
    }

    public void getTimestamp(byte[] byArray) {
        byArray[8] = this.mClockSequence[0];
        byArray[9] = this.mClockSequence[1];
        long l = System.currentTimeMillis();
        if (l < this.mLastTimeStamp) {
            this.initTimeStamps();
        } else if (l == this.mLastTimeStamp) {
            if ((long)this.mClockCounter == 10000L) {
                this.mClockCounter &= 0xFF;
                do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((l = System.currentTimeMillis()) == this.mLastTimeStamp);
                this.mLastTimeStamp = l;
            }
        } else {
            this.mClockCounter &= 0xFF;
            this.mLastTimeStamp = l;
        }
        l *= 10000L;
        l += 122192928000000000L;
        int n = (int)((l += (long)this.mClockCounter) >>> 32);
        int n2 = (int)l;
        byArray[6] = (byte)(n >>> 24);
        byArray[7] = (byte)(n >>> 16);
        byArray[4] = (byte)(n >>> 8);
        byArray[5] = (byte)n;
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)n2;
        ++this.mClockCounter;
    }
}

