/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parsers;

import com.ibm.xml.framework.ParserState;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parsers.TXDOMParser;
import org.w3c.dom.Node;

public class TXRevalidatingDOMParser
extends TXDOMParser {
    private transient Node errorElement;
    private static final boolean DEBUG_VALIDATE = false;

    public Node getErrorElement() {
        return this.errorElement;
    }

    public Node validate(Node node) {
        if (node.getNodeType() != 1 || !(node instanceof TXElement)) {
            throw new IllegalArgumentException("Can't revalidate a non element");
        }
        DTD dTD = ((TXDocument)node.getOwnerDocument()).getDTD();
        ParserState parserState = this.getParserState();
        try {
            Node node2 = this.recursiveValidate((TXElement)node, dTD, parserState);
            return node2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private Node recursiveValidate(TXElement tXElement, DTD dTD, ParserState parserState) {
        Node node = dTD.validate(tXElement, parserState);
        if (node != null) {
            Node node2 = this.errorElement = node.getNodeType() == 2 ? tXElement : null;
        }
        if (node == null && tXElement.hasChildNodes()) {
            Node node3 = tXElement.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeType() == 1 && (node = this.recursiveValidate((TXElement)node3, dTD, parserState)) != null) {
                    this.errorElement = node.getNodeType() == 2 ? node3 : null;
                    break;
                }
                node3 = node3.getNextSibling();
            }
        }
        return node;
    }

    private static void print(Node node, String string) {
    }

    private static String normalize(String string) {
        return null;
    }

    private static String type(int n) {
        return null;
    }
}

