/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.GeneralReference;
import com.ibm.xml.parser.TXDOMException;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TXNodeList;
import java.util.Enumeration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Parent
extends Child {
    static final long serialVersionUID = -5379012622242611200L;
    TXNodeList children = new TXNodeList();

    public NodeList getChildNodes() {
        return this.children;
    }

    public boolean hasChildNodes() {
        return this.children.getLength() > 0;
    }

    public Enumeration elements() {
        return this.children.elements();
    }

    public Child[] getChildrenArray() {
        Object[] objectArray = new Child[this.children.getLength()];
        this.children.nodes.copyInto(objectArray);
        return objectArray;
    }

    public Node getFirstChild() {
        if (this.children.getLength() > 0) {
            return this.children.item(0);
        }
        return null;
    }

    public Node getFirstWithoutReference() {
        Node node = this.getFirstChild();
        while (node != null && node.getNodeType() == 5) {
            Node node2 = node.getFirstChild();
            if (node2 == null) {
                node = ((Child)node).getNextWithoutReference();
                break;
            }
            node = node2;
        }
        return node;
    }

    public Node getLastChild() {
        int n = this.children.getLength();
        if (n > 0) {
            return this.children.item(n - 1);
        }
        return null;
    }

    public Node getLastWithoutReference() {
        Node node = this.getLastChild();
        while (node != null && node.getNodeType() == 5) {
            Node node2 = node.getLastChild();
            if (node2 == null) {
                node = ((Child)node).getPreviousWithoutReference();
                break;
            }
            node = node2;
        }
        return node;
    }

    protected abstract void checkChildType(Node var1) throws DOMException;

    protected void realInsert(Node node, int n) throws DOMException {
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        this.checkChildType(node);
        if (node == this) {
            throw new TXDOMException(3, "Can't have itself as child.");
        }
        TXDocument tXDocument = this.getFactory();
        if (tXDocument != null) {
            if (tXDocument.isCheckOwnerDocument() && tXDocument != node.getOwnerDocument()) {
                throw new TXDOMException(4, "Specified child was created from a different document. The parent is \"" + this.getNodeName() + "\", the child is \"" + node.getNodeName() + "\".");
            }
            if (tXDocument.isCheckNodeLoop()) {
                Node node2 = this;
                while ((node2 = node2.getParentNode()) != null) {
                    if (node2 != node) continue;
                    throw new TXDOMException(3, "Can't have an ancestor as child");
                }
            }
        }
        this.children.insert(n, node);
        ((Child)node).setParentNode(this);
        this.clearDigest();
    }

    public synchronized void insert(Node node, int n) throws DOMException {
        if (node instanceof DocumentFragment) {
            Node node2;
            while ((node2 = node.getLastChild()) != null) {
                node.removeChild(node2);
                this.insert(node2, n);
            }
            return;
        }
        this.realInsert(node, n);
    }

    public synchronized Node insertBefore(Node node, Node node2) throws DOMException {
        if (node2 == null) {
            this.insert(node, this.children.getLength());
        } else {
            int n = this.children.indexOf(node2);
            if (n < 0) {
                throw new TXDOMException(8, "com.ibm.xml.parser.Parent#insertBefore(): Node " + node2 + " is not found in the child list.");
            }
            this.insert(node, n);
        }
        return node;
    }

    public synchronized Node insertAfter(Node node, Node node2) throws DOMException {
        if (node2 == null) {
            this.insert(node, 0);
        } else {
            this.insertBefore(node, node2.getNextSibling());
        }
        return node;
    }

    public synchronized Node insertFirst(Node node) {
        this.insert(node, 0);
        return node;
    }

    public synchronized Node insertLast(Node node) {
        this.insert(node, this.children.getLength());
        return node;
    }

    public synchronized void addElement(Child child) {
        if (child != null) {
            this.insert(child, this.children.getLength());
        }
    }

    public synchronized Node appendChild(Node node) {
        if (node != null) {
            this.insert(node, this.children.getLength());
        }
        return node;
    }

    public synchronized Node replaceChild(Node node, Node node2) throws DOMException {
        int n = this.children.indexOf(node2);
        if (n < 0) {
            throw new TXDOMException(8, "com.ibm.xml.parser.Parent#replaceChild(): Node " + node2 + " is not found in the child list.");
        }
        if (node == node2) {
            return node;
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
        }
        Child child = (Child)node;
        this.children.replace(n, child);
        child.setParentNode(this);
        this.clearDigest();
        return node2;
    }

    public synchronized Node removeChild(Node node) throws DOMException {
        int n = this.children.indexOf(node);
        if (n < 0) {
            throw new TXDOMException(8, "com.ibm.xml.parser.Parent#removeChild(): Node " + node + " is not found in the child list.");
        }
        this.children.remove(n);
        this.clearDigest();
        return node;
    }

    protected void processAfterRemove(Node node) {
        short s = node.getNodeType();
        if (s == 1) {
            ((TXElement)node).collectNamespaceAttributes(this);
            return;
        }
        if (s == 5) {
            ((GeneralReference)node).collectNamespaceAttributes(this);
        }
    }

    public void expandEntityReferences() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof Parent) {
                ((Parent)node).expandEntityReferences();
                if (node instanceof EntityReference) {
                    Node node2;
                    while ((node2 = node.getLastChild()) != null) {
                        node.removeChild(node2);
                        this.insertAfter(node2, node);
                    }
                    node2 = node.getNextSibling();
                    this.removeChild(node);
                    node = node2;
                    continue;
                }
            }
            node = node.getNextSibling();
        }
    }

    public String getText() {
        int n;
        if (this.children == null || (n = this.children.getLength()) == 0) {
            return "";
        }
        if (n == 1) {
            return ((Child)this.children.item(0)).getText();
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        TXNodeList tXNodeList = this.children;
        synchronized (tXNodeList) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(((Child)this.children.item(n2)).getText());
                ++n2;
            }
        }
        return stringBuffer.toString().intern();
    }
}

