/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyByteArray;
import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.internal.StringHasher;
import java.io.IOException;

final class UCSReader
extends XMLReader
implements StringProducer {
    private static final boolean DEBUG_UTF16_BIG = false;
    static final int E_UCS4B = 0;
    static final int E_UCS4L = 1;
    static final int E_UCS2B = 2;
    static final int E_UCS2L = 3;
    static final int E_UCS2B_NOBOM = 4;
    static final int E_UCS2L_NOBOM = 5;
    private ChunkyByteArray fData;
    private int fEncoding = -1;
    private StringPool fStringPool;
    private XMLDocumentHandler fDocumentHandler;
    private XMLErrorHandler fErrorHandler;
    private int fBytesPerChar = -1;
    private boolean fBigEndian = true;
    private ChunkyCharArray fStringCharArray;
    private static char[] fCharacters = new char[256];
    private int fCharDataLength;

    UCSReader(ParserState parserState, String string, String string2, ChunkyByteArray chunkyByteArray, int n) throws IOException {
        super(parserState, string, string2);
        this.fCurrentOffset = n == 2 || n == 3 ? 2 : 0;
        this.fData = chunkyByteArray;
        this.fEncoding = n;
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fBytesPerChar = this.fEncoding == 0 || this.fEncoding == 1 ? 4 : 2;
        this.fBigEndian = this.fEncoding == 0 || this.fEncoding == 2 || this.fEncoding == 4;
    }

    private int getChar(int n) {
        int n2;
        if ((n2 = this.fData.byteAt(n++) & 0xFF) == 255 && this.fData.atEOF(n)) {
            return -1;
        }
        int n3 = this.fData.byteAt(n++) & 0xFF;
        if (this.fBytesPerChar == 4) {
            int n4 = this.fData.byteAt(n++) & 0xFF;
            int n5 = this.fData.byteAt(n++) & 0xFF;
            if (this.fBigEndian) {
                return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            }
            return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
        }
        if (this.fBigEndian) {
            return (n2 << 8) + n3;
        }
        return (n3 << 8) + n2;
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addString(this, n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this, n, n2, this.getHashcode(n, n2));
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = this.getChar(n);
            chunkyCharArray.append((char)n4);
            n += this.fBytesPerChar;
        }
    }

    public String toString(int n, int n2) {
        if (this.fStringCharArray == null) {
            this.fStringCharArray = new ChunkyCharArray(this.fStringPool);
        }
        int n3 = this.fStringCharArray.length();
        this.append(this.fStringCharArray, n, n2);
        int n4 = this.fStringCharArray.length() - n3;
        int n5 = this.fStringCharArray.addString(n3, n4);
        return this.fStringPool.toString(n5);
    }

    private int getHashcode(int n, int n2) {
        int n3;
        int n4 = n + n2;
        int n5 = 0;
        int n6 = 0;
        while (n < n4) {
            n3 = this.getChar(n);
            n5 = StringHasher.hashChar(n5, n6++, n3);
            n += this.fBytesPerChar;
        }
        n3 = n5;
        if ((n3 &= Integer.MAX_VALUE) == 0) {
            return 1;
        }
        return n3;
    }

    public boolean equalsString(int n, int n2, String string, int n3) {
        int n4 = n + n2;
        int n5 = n3;
        int n6 = 0;
        while (n < n4) {
            if (n5-- == 0) {
                return false;
            }
            int n7 = this.getChar(n);
            if (n7 != string.charAt(n6++)) {
                return false;
            }
            n += this.fBytesPerChar;
        }
        return n5 == 0;
    }

    private void appendCharData(int n) {
        if (fCharacters.length == this.fCharDataLength) {
            char[] cArray = new char[fCharacters.length * 2];
            System.arraycopy(fCharacters, 0, cArray, 0, fCharacters.length);
            fCharacters = cArray;
        }
        UCSReader.fCharacters[this.fCharDataLength++] = (char)n;
    }

    public void callWSCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3;
        int n4 = n + n2;
        while (n < n4) {
            n3 = this.getChar(n);
            this.appendCharData(n3);
            n += this.fBytesPerChar;
        }
        if (this.fDocumentHandler.sendCharDataAsCharArray()) {
            this.fDocumentHandler.ignorableWhitespace(fCharacters, 0, this.fCharDataLength, bl);
        } else {
            n3 = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            this.fDocumentHandler.ignorableWhitespace(n3, bl);
        }
        this.fCharDataLength = 0;
    }

    public void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3;
        int n4 = n + n2;
        while (n < n4) {
            n3 = this.getChar(n);
            this.appendCharData(n3);
            n += this.fBytesPerChar;
        }
        if (this.fDocumentHandler.sendCharDataAsCharArray()) {
            this.fDocumentHandler.characters(fCharacters, 0, this.fCharDataLength, bl);
        } else {
            n3 = this.fStringPool.addString(new String(fCharacters, 0, this.fCharDataLength));
            this.fDocumentHandler.characters(n3, bl);
        }
        this.fCharDataLength = 0;
    }

    public int skipOneChar() throws IOException {
        this.fCurrentOffset += this.fBytesPerChar;
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws IOException {
        this.fCurrentOffset += this.fBytesPerChar;
        return this.fCurrentOffset;
    }

    public int skipToChar(char c) throws IOException {
        int n;
        while ((n = this.getChar(this.fCurrentOffset)) != c) {
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char c) throws IOException {
        int n;
        do {
            n = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        } while (n != c);
        return this.fCurrentOffset;
    }

    public boolean skippedValidChar() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        this.fCurrentOffset += this.fBytesPerChar;
        if (n < 32) {
            if (n == 9) {
                ++this.fCharacterCounter;
                return true;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            --this.fCurrentOffset;
            if (n == -1) {
                this.fData.checkEOF(this.fCurrentOffset + 1);
            }
            return false;
        }
        ++this.fCharacterCounter;
        if (n <= 55295) {
            return true;
        }
        if (n <= 57343) {
            ++this.fCurrentOffset;
            return true;
        }
        if (n <= 65533) {
            return true;
        }
        --this.fCharacterCounter;
        this.fCurrentOffset -= this.fBytesPerChar;
        return false;
    }

    public boolean lookingAtValidChar() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n < 32) {
            if (n == -1) {
                this.fData.checkEOF(this.fCurrentOffset + 1);
            }
            return n == 9 || n == 10 || n == 13;
        }
        return n <= 55295 || n >= 57344 && (n <= 65533 || n >= 65536 && n <= 0x10FFFF);
    }

    public int skipInvalidChar(int n) throws Exception {
        int n2 = this.getChar(this.fCurrentOffset);
        this.fCurrentOffset += this.fBytesPerChar;
        switch (n) {
            case 63: 
            case 85: {
                String string = Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String string = new Character((char)n2).toString();
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 43: {
                String string = new Character((char)n2).toString();
                String string2 = Integer.toHexString(n2);
                this.fErrorHandler.error2(n, this.fStringPool.addString(string), this.fStringPool.addString(string2));
            }
        }
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char c) throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n == c) {
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        return false;
    }

    public boolean lookingAtChar(char c) throws IOException {
        return c == this.getChar(this.fCurrentOffset);
    }

    public boolean skippedSpace() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n == 32 || n == 9 || n == 10 || n == 13) {
            this.fCurrentOffset += this.fBytesPerChar;
            return true;
        }
        return false;
    }

    public boolean lookingAtSpace() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    public int skipPastSpaces() throws IOException {
        int n;
        while ((n = this.getChar(this.fCurrentOffset)) == 32 || n == 9 || n == 10 || n == 13) {
            this.fCurrentOffset += this.fBytesPerChar;
        }
        return this.fCurrentOffset;
    }

    public int skipDecimalDigit() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n < 48 || n > 57) {
            return -1;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        ++this.fCharacterCounter;
        return n - 48;
    }

    public int skipHexDigit() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n > 102 || XMLReader.fgAsciiXDigitChar[n] == 0) {
            return -1;
        }
        this.fCurrentOffset += this.fBytesPerChar;
        ++this.fCharacterCounter;
        return n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if (n <= 122 && XMLReader.fgAsciiAlphaChar[n] == 1) {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            return true;
        }
        return false;
    }

    private boolean skippedCharWithFlag(byte by) {
        int n = this.getChar(this.fCurrentOffset);
        if (n < 128 && (XMLReader.fgCharFlags[n] & by) != 0) {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            return true;
        }
        return false;
    }

    public final boolean skippedVersionNum() {
        return this.skippedCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() {
        return this.skippedCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() {
        int n = this.getChar(this.fCurrentOffset);
        if (n < 128) {
            if ((XMLReader.fgCharFlags[n] & 4) != 0) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fCharacterCounter;
                return true;
            }
            if (n == 10) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return true;
            }
            if (n == 13) {
                this.fCurrentOffset += this.fBytesPerChar;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                return true;
            }
        }
        return false;
    }

    public boolean skippedString(char[] cArray) throws IOException {
        int n = this.fCurrentOffset;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (this.getChar(n) != cArray[n2]) {
                return false;
            }
            n += this.fBytesPerChar;
            ++n2;
        }
        this.fCurrentOffset = n;
        this.fCharacterCounter += cArray.length;
        return true;
    }

    public int scanName(char c, int n) throws IOException {
        int n2;
        int n3 = this.fCurrentOffset;
        int n4 = this.skipPastName(c) - n3;
        if (n4 == 0) {
            return -1;
        }
        int n5 = n2 = n4 == 0 ? 0 : this.fStringPool.addSymbol(this, n3, n4, this.getHashcode(n3, n4));
        if (n == -1 || n == n2) {
            return n2;
        }
        return -1;
    }

    public int skipPastName(char c) throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        if ((XMLReader.fgCharFlags[n] & 0x10) == 0) {
            return this.fCurrentOffset;
        }
        do {
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            n = this.getChar(this.fCurrentOffset);
            if (c != n) continue;
            return this.fCurrentOffset;
        } while ((XMLReader.fgCharFlags[n] & 0x20) != 0);
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char c) throws IOException {
        int n = this.getChar(this.fCurrentOffset);
        while (c != n) {
            if ((XMLReader.fgCharFlags[n] & 0x20) == 0) {
                return this.fCurrentOffset;
            }
            this.fCurrentOffset += this.fBytesPerChar;
            ++this.fCharacterCounter;
            n = this.getChar(this.fCurrentOffset);
        }
        return this.fCurrentOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanContent(ScanContentState scanContentState) throws Exception {
        byte by;
        int n;
        int n2;
        block52: {
            block56: {
                block54: {
                    block55: {
                        n2 = this.fCurrentOffset;
                        n = this.getChar(this.fCurrentOffset);
                        this.fCurrentOffset += this.fBytesPerChar;
                        if (n >= 128) break block54;
                        if (n == -1) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            return 4;
                        }
                        by = XMLReader.fgCharFlags[n];
                        if ((by & 8) != 0 || n == 10 || n == 13) break block55;
                        if (n == 60) {
                            ++this.fCharacterCounter;
                            return 1;
                        }
                        if (n == 38) {
                            ++this.fCharacterCounter;
                            return 2;
                        }
                        if (n != 93) {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            return 4;
                        }
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 3;
                        }
                        break block52;
                    }
                    if (n != 32 && n != 9 && n != 10 && n != 13) break block52;
                    break block56;
                }
                if (n >= 55296 && n <= 57343) {
                    this.fCurrentOffset += this.fBytesPerChar;
                    break block52;
                } else if (n == 65534 || n == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    return 4;
                }
                break block52;
            }
            do {
                if (n == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else if (n == 13) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                n = this.getChar(this.fCurrentOffset);
                this.fCurrentOffset += this.fBytesPerChar;
            } while (n == 32 || n == 9 || n == 10 || n == 13);
            if (n < 128) {
                if (n == -1) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    if (this.fDocumentHandler != null) {
                        this.callWSCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                    }
                    return 28;
                }
                by = XMLReader.fgCharFlags[n];
                if ((by & 8) == 0) {
                    if (n == 60) {
                        ++this.fCharacterCounter;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                        }
                        return 25;
                    }
                    if (n == 38) {
                        ++this.fCharacterCounter;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                        }
                        return 26;
                    }
                    if (n == 93) {
                        if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                            }
                            this.fCharacterCounter += 3;
                            this.fCurrentOffset += 2 * this.fBytesPerChar;
                            return 27;
                        }
                    } else {
                        this.fCurrentOffset -= this.fBytesPerChar;
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                        }
                        return 28;
                    }
                }
            } else if (n >= 55296 && n <= 57343) {
                this.fCurrentOffset += this.fBytesPerChar;
            } else if (n == 65534 || n == 65535) {
                this.fCurrentOffset -= this.fBytesPerChar;
                if (this.fDocumentHandler != null) {
                    this.callWSCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                }
                return 28;
            }
        }
        ++this.fCharacterCounter;
        while (true) {
            n = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
            if (n >= 128 || n < 0) break;
            by = XMLReader.fgCharFlags[n];
            if ((by & 8) == 0) {
                if (n == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    continue;
                }
                if (n != 13) break;
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                continue;
            }
            ++this.fCharacterCounter;
        }
        while (true) {
            block53: {
                block57: {
                    block58: {
                        block59: {
                            if (n >= 128) break block57;
                            if (n == -1) {
                                this.fCurrentOffset -= this.fBytesPerChar;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                                }
                                return 12;
                            }
                            by = XMLReader.fgCharFlags[n];
                            if ((by & 8) != 0) break block58;
                            if (n == 60) {
                                ++this.fCharacterCounter;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                                }
                                return 9;
                            }
                            if (n == 38) {
                                ++this.fCharacterCounter;
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                                }
                                return 10;
                            }
                            if (n != 10) break block59;
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            break block53;
                        }
                        if (n == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            break block53;
                        } else if (n == 93) {
                            if (this.getChar(this.fCurrentOffset) == 93 && this.getChar(this.fCurrentOffset + this.fBytesPerChar) == 62) {
                                if (this.fDocumentHandler != null) {
                                    this.callCharDataHandler(n2, this.fCurrentOffset - this.fBytesPerChar - n2, scanContentState.inCDSect);
                                }
                                this.fCharacterCounter += 3;
                                this.fCurrentOffset += 2 * this.fBytesPerChar;
                                return 11;
                            }
                            ++this.fCharacterCounter;
                            break block53;
                        } else {
                            this.fCurrentOffset -= this.fBytesPerChar;
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                            }
                            return 12;
                        }
                    }
                    ++this.fCharacterCounter;
                    break block53;
                }
                if (n >= 55296 && n <= 57343) {
                    ++this.fCharacterCounter;
                    this.fCurrentOffset += this.fBytesPerChar;
                } else if (n == 65534 || n == 65535) {
                    this.fCurrentOffset -= this.fBytesPerChar;
                    if (this.fDocumentHandler != null) {
                        this.callCharDataHandler(n2, this.fCurrentOffset - n2, scanContentState.inCDSect);
                    }
                    return 12;
                }
                ++this.fCharacterCounter;
            }
            n = this.getChar(this.fCurrentOffset);
            this.fCurrentOffset += this.fBytesPerChar;
        }
    }
}

