/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parsers;

import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLParser;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.Attlist;
import com.ibm.xml.parser.CM1op;
import com.ibm.xml.parser.CM2op;
import com.ibm.xml.parser.CMLeaf;
import com.ibm.xml.parser.CMNode;
import com.ibm.xml.parser.ContentModel;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.ElementDecl;
import com.ibm.xml.parser.EntityDecl;
import com.ibm.xml.parser.EntityPool;
import com.ibm.xml.parser.ExternalID;
import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXNotation;
import com.ibm.xml.parser.TXText;
import java.util.Stack;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;

public class NonValidatingTXDOMParser
extends XMLParser {
    public static final boolean DEBUG = false;
    protected String fDocumentClass = "com.ibm.xml.parser.TXDocument";
    protected int fRootElementName = -1;
    protected TXDocument fDocument;
    protected DTD fDocumentType;
    protected EntityPool fEntityPool;
    protected Node fCurrentParent;
    protected Node fCurrentNode;
    protected Stack fNodeStack = new Stack();
    protected boolean fWithinElement = false;
    protected boolean fNormalizeTextNodes = true;
    protected boolean fExpandEntityReferences = false;
    int fAmpIndex = -1;
    int fLtIndex = -1;
    int fGtIndex = -1;
    int fAposIndex = -1;
    int fQuotIndex = -1;

    public NonValidatingTXDOMParser() {
        this.setDocumentHandler(this);
        this.setDocumentTypeHandler(this);
        this.getParserState().useDefaultStringPool();
        this.getParserState().useDefaultAttrPool();
        this.getParserState().useDefaultEntityPool();
        this.getParserState().useDefaultElementDeclPool();
        this.init();
    }

    public void reset() {
        super.reset();
        this.init();
    }

    protected void resetOrCopy() {
        super.resetOrCopy();
        this.init();
    }

    protected void init() {
        this.fRootElementName = -1;
        this.fDocument = null;
        this.fDocumentType = null;
        this.fCurrentParent = null;
        this.fCurrentNode = null;
        this.fNodeStack.removeAllElements();
        this.fWithinElement = false;
        this.fNormalizeTextNodes = true;
        this.fExpandEntityReferences = false;
        StringPool stringPool = this.getParserState().getStringPool();
        this.fAmpIndex = stringPool.addSymbol("amp");
        this.fLtIndex = stringPool.addSymbol("lt");
        this.fGtIndex = stringPool.addSymbol("gt");
        this.fAposIndex = stringPool.addSymbol("apos");
        this.fQuotIndex = stringPool.addSymbol("quot");
    }

    protected void checkHandlers() throws Exception {
        super.checkHandlers();
        if (this.fDocument == null) {
            this.fDocument = (TXDocument)Class.forName(this.fDocumentClass).newInstance();
        }
    }

    private void initDTDEntityPool() {
        this.fEntityPool = new EntityPool();
        this.fEntityPool.add(this.fDocument.createEntityDecl("lt", "&#60;", false));
        this.fEntityPool.add(this.fDocument.createEntityDecl("gt", "&#62;", false));
        this.fEntityPool.add(this.fDocument.createEntityDecl("amp", "&#38;", false));
        this.fEntityPool.add(this.fDocument.createEntityDecl("apos", "&#39;", false));
        this.fEntityPool.add(this.fDocument.createEntityDecl("quot", "&#34;", false));
    }

    public void setNormalizeTextNodes(boolean bl) {
        this.fNormalizeTextNodes = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        this.fExpandEntityReferences = bl;
    }

    public boolean getExpandEntityReferences() {
        return this.fExpandEntityReferences;
    }

    public void doctypeDecl(int n) throws Exception {
        this.fRootElementName = n;
        StringPool stringPool = this.getParserState().getStringPool();
        String string = stringPool.toString(this.fRootElementName);
        this.fDocumentType = this.fDocument.createDTD(string, null);
        if (this.fDocumentType == null) {
            return;
        }
        this.initDTDEntityPool();
        this.fDocumentType.setEntityPool(this.fEntityPool);
        this.fCurrentParent.appendChild(this.fDocumentType);
        this.fCurrentNode = this.fDocumentType;
    }

    public void startInternalSubset() throws Exception {
        if (this.fDocumentType == null) {
            return;
        }
        this.fDocumentType.setParsingExternal(false);
    }

    public void endInternalSubset() throws Exception {
    }

    public void startExternalSubset(int n, int n2) throws Exception {
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        stringPool.toString(this.fRootElementName);
        if (n != -1 && n2 != -1) {
            this.fDocumentType.setExternalID(new ExternalID(stringPool.toString(n), stringPool.toString(n2)));
        } else if (n2 != -1) {
            this.fDocumentType.setExternalID(new ExternalID(stringPool.toString(n2)));
        }
        this.fDocumentType.setParsingExternal(true);
    }

    public void endExternalSubset() throws Exception {
        if (this.fDocumentType == null) {
            return;
        }
        this.fDocumentType.setParsingExternal(false);
    }

    public void elementDecl(int n) throws Exception {
        if (this.fDocumentType == null) {
            return;
        }
        ElementDeclPool elementDeclPool = this.getParserState().getElementDeclPool();
        String string = this.getParserState().getStringPool().toString(elementDeclPool.getElementName(n));
        int n2 = elementDeclPool.getContentSpecType(n);
        ContentModel contentModel = null;
        ElementDecl elementDecl = null;
        switch (n2) {
            case 1: {
                contentModel = this.fDocument.createContentModel(1);
                break;
            }
            case 2: {
                contentModel = this.fDocument.createContentModel(2);
                break;
            }
            case 3: 
            case 4: {
                int n3 = elementDeclPool.getContentSpec(n);
                contentModel = this.fDocument.createContentModel(this.buildCMNode(n, n3));
            }
        }
        if (contentModel != null) {
            elementDecl = this.fDocument.createElementDecl(string, contentModel);
            if (elementDecl == null) {
                return;
            }
            this.fDocumentType.appendChild(elementDecl);
            this.fCurrentNode = elementDecl;
        }
    }

    protected CMNode buildCMNode(int n, int n2) {
        StringPool stringPool = this.getParserState().getStringPool();
        ElementDeclPool elementDeclPool = this.getParserState().getElementDeclPool();
        ContentSpecNode contentSpecNode = new ContentSpecNode();
        ContentSpecNode contentSpecNode2 = new ContentSpecNode();
        elementDeclPool.getContentSpecNode(n2, contentSpecNode);
        int n3 = contentSpecNode.type;
        int n4 = contentSpecNode.value;
        switch (n3) {
            case 0: {
                String string = n4 == -1 ? "#PCDATA" : stringPool.toString(n4);
                return new CMLeaf(string);
            }
            case 1: {
                elementDeclPool.getContentSpecNode(n2, contentSpecNode2);
                return new CM1op(63, this.buildCMNode(n, contentSpecNode2.value));
            }
            case 2: {
                elementDeclPool.getContentSpecNode(n2, contentSpecNode2);
                return new CM1op(42, this.buildCMNode(n, contentSpecNode2.value));
            }
            case 3: {
                elementDeclPool.getContentSpecNode(n2, contentSpecNode2);
                return new CM1op(43, this.buildCMNode(n, contentSpecNode2.value));
            }
            case 4: {
                elementDeclPool.getContentSpecNode(n2, contentSpecNode2);
                return new CM2op(124, this.buildCMNode(n, contentSpecNode2.value), this.buildCMNode(n, contentSpecNode2.otherValue));
            }
            case 5: {
                elementDeclPool.getContentSpecNode(n2, contentSpecNode2);
                return new CM2op(44, this.buildCMNode(n, contentSpecNode2.value), this.buildCMNode(n, contentSpecNode2.otherValue));
            }
        }
        return null;
    }

    public void attlistDecl(int n, int n2) throws Exception {
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        ElementDeclPool elementDeclPool = this.getParserState().getElementDeclPool();
        int n3 = elementDeclPool.getElementName(n);
        stringPool.toString(n3);
        Attlist attlist = this.fDocument.createAttlist(stringPool.toString(n3));
        AttDef attDef = this.fDocument.createAttDef(stringPool.toString(elementDeclPool.getAttName(n2)));
        if (attlist == null || attDef == null) {
            return;
        }
        if (elementDeclPool.getAttType(n2) < 9) {
            attDef.setDeclaredType(elementDeclPool.getAttType(n2) + 1);
        } else if (elementDeclPool.getAttType(n2) == 9) {
            attDef.setDeclaredType(10);
        } else {
            System.err.println("ERROR: UNKNOWN AttType:" + elementDeclPool.getAttType(n2));
            return;
        }
        if (elementDeclPool.getAttType(n2) == 9 | elementDeclPool.getAttType(n2) == 8) {
            int[] nArray = stringPool.stringsInList(elementDeclPool.getEnumeration(n2));
            int n4 = 0;
            while (n4 < nArray.length) {
                attDef.addElement(stringPool.toString(nArray[n4]));
                ++n4;
            }
        }
        switch (elementDeclPool.getAttDefaultType(n2)) {
            case 1: {
                attDef.setDefaultType(-1);
                break;
            }
            case 2: {
                attDef.setDefaultType(2);
                break;
            }
            case 3: {
                attDef.setDefaultType(3);
                break;
            }
            case 4: {
                attDef.setDefaultType(1);
                break;
            }
            default: {
                attDef.setDefaultType(0);
            }
        }
        int n5 = elementDeclPool.getAttValue(n2);
        if (n5 != -1) {
            attDef.setDefaultStringValue(stringPool.toString(n5));
        }
        attlist.addElement(attDef);
        this.fDocumentType.appendChild(attlist);
        this.fCurrentNode = attlist;
    }

    public void internalEntityDecl(int n) throws Exception {
        String string;
        com.ibm.xml.framework.EntityPool entityPool;
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        String string2 = stringPool.toString((entityPool = this.getParserState().getEntityPool()).getEntityName(n));
        EntityDecl entityDecl = this.fDocument.createEntityDecl(string2, string = stringPool.toString(entityPool.getEntityValue(n)), false);
        if (entityDecl == null) {
            return;
        }
        Text text = this.fDocument.createTextNode(string);
        if (text != null) {
            entityDecl.appendChild(text);
        }
        this.fDocumentType.appendChild(entityDecl);
        this.fEntityPool.add(entityDecl);
        this.fCurrentNode = entityDecl;
    }

    public void externalEntityDecl(int n) throws Exception {
        String string;
        String string2;
        com.ibm.xml.framework.EntityPool entityPool;
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        String string3 = stringPool.toString((entityPool = this.getParserState().getEntityPool()).getEntityName(n));
        EntityDecl entityDecl = this.fDocument.createEntityDecl(string3, new ExternalID(string2 = stringPool.toString(entityPool.getPublicId(n)), string = stringPool.toString(entityPool.getSystemId(n))), false, null);
        if (entityDecl == null) {
            return;
        }
        this.fDocumentType.appendChild(entityDecl);
        this.fEntityPool.add(entityDecl);
        this.fCurrentNode = entityDecl;
    }

    public void unparsedEntityDecl(int n) throws Exception {
        String string;
        String string2;
        String string3;
        com.ibm.xml.framework.EntityPool entityPool;
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        String string4 = stringPool.toString((entityPool = this.getParserState().getEntityPool()).getEntityName(n));
        EntityDecl entityDecl = this.fDocument.createEntityDecl(string4, new ExternalID(string3 = stringPool.toString(entityPool.getPublicId(n)), string2 = stringPool.toString(entityPool.getSystemId(n))), false, string = stringPool.toString(entityPool.getNotationName(n)));
        if (entityDecl == null) {
            return;
        }
        this.fDocumentType.appendChild(entityDecl);
        this.fEntityPool.add(entityDecl);
        this.fCurrentNode = entityDecl;
    }

    public void notationDecl(int n) throws Exception {
        String string;
        String string2;
        com.ibm.xml.framework.EntityPool entityPool;
        if (this.fDocumentType == null) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        String string3 = stringPool.toString((entityPool = this.getParserState().getEntityPool()).getNotationName(n));
        TXNotation tXNotation = this.fDocument.createNotation(string3, new ExternalID(string2 = stringPool.toString(entityPool.getPublicId(n)), string = stringPool.toString(entityPool.getSystemId(n))));
        if (tXNotation == null) {
            return;
        }
        this.fDocumentType.appendChild(tXNotation);
        this.fCurrentNode = tXNotation;
    }

    public void setDocumentClass(String string) {
        this.fDocumentClass = string;
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public void startDocument(int n, int n2, int n3) throws Exception {
        if (this.fDocument == null) {
            return;
        }
        this.fCurrentParent = this.fDocument;
        this.fCurrentNode = this.fDocument;
        StringPool stringPool = this.getParserState().getStringPool();
        String string = stringPool.orphanString(n);
        String string2 = stringPool.orphanString(n2);
        String string3 = stringPool.orphanString(n3);
        if (string != null) {
            this.fDocument.setVersion(string);
        }
        if (string2 != null) {
            this.fDocument.setEncoding(string2);
        }
        if (string3 != null) {
            this.fDocument.setStandalone(string3);
        }
    }

    public void endDocument() throws Exception {
    }

    public void startElement(int n, int n2) throws Exception {
        String string = this.getParserState().getStringPool().toString(n);
        AttributeList attributeList = this.getParserState().getAttrPool().getAttributeList(n2);
        Element element = this.fDocument.createElement(string);
        if (element == null) {
            return;
        }
        int n3 = attributeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            element.setAttribute(attributeList.getName(n4), attributeList.getValue(n4));
            if (this.fDocumentType != null && attributeList.getType(n4).equals("ID")) {
                this.fDocumentType.registID(element, attributeList.getValue(n4));
            }
            ++n4;
        }
        this.getParserState().getAttrPool().releaseAttrList(n2);
        this.fCurrentParent.appendChild(element);
        this.fNodeStack.push(this.fCurrentParent);
        this.fCurrentParent = element;
        this.fCurrentNode = element;
        this.fWithinElement = true;
    }

    public void endElement(int n) throws Exception {
        this.fCurrentNode = this.fCurrentParent = (Node)this.fNodeStack.pop();
        this.fWithinElement = false;
    }

    public void startEntityReference(int n) throws Exception {
        if (this.fExpandEntityReferences) {
            return;
        }
        com.ibm.xml.framework.EntityPool entityPool = this.getParserState().getEntityPool();
        int n2 = entityPool.getEntityName(n);
        if (n2 == this.fAmpIndex || n2 == this.fGtIndex || n2 == this.fLtIndex || n2 == this.fAposIndex || n2 == this.fQuotIndex) {
            return;
        }
        StringPool stringPool = this.getParserState().getStringPool();
        String string = stringPool.toString(entityPool.getEntityName(n));
        EntityReference entityReference = this.fDocument.createEntityReference(string);
        if (entityReference == null) {
            return;
        }
        this.fCurrentParent.appendChild(entityReference);
        this.fNodeStack.push(this.fCurrentParent);
        this.fCurrentParent = entityReference;
        this.fCurrentNode = entityReference;
    }

    public void endEntityReference(int n) throws Exception {
        if (this.fExpandEntityReferences) {
            return;
        }
        int n2 = this.getParserState().getEntityPool().getEntityName(n);
        if (n2 == this.fAmpIndex || n2 == this.fGtIndex || n2 == this.fLtIndex || n2 == this.fAposIndex || n2 == this.fQuotIndex) {
            return;
        }
        this.fCurrentNode = this.fCurrentParent = (Node)this.fNodeStack.pop();
    }

    public void characters(int n, boolean bl) throws Exception {
        Text text = null;
        if (bl) {
            text = this.fDocument.createCDATASection(this.getParserState().getStringPool().orphanString(n));
        } else {
            if (this.fNormalizeTextNodes && this.fWithinElement && this.fCurrentNode.getNodeType() == 3 && this.fCurrentNode.getParentNode().getNodeType() == 1) {
                ((Text)this.fCurrentNode).appendData(this.getParserState().getStringPool().orphanString(n));
                return;
            }
            text = this.fDocument.createTextNode(this.getParserState().getStringPool().orphanString(n));
        }
        if (text == null) {
            return;
        }
        this.fCurrentParent.appendChild(text);
        this.fCurrentNode = text;
    }

    public void ignorableWhitespace(int n, boolean bl) throws Exception {
        Text text = null;
        text = bl ? this.fDocument.createCDATASection(this.getParserState().getStringPool().orphanString(n)) : this.fDocument.createTextNode(this.getParserState().getStringPool().orphanString(n));
        if (text == null) {
            return;
        }
        ((TXText)text).setIsIgnorableWhitespace(true);
        this.fCurrentParent.appendChild(text);
        this.fCurrentNode = text;
    }

    public void processingInstruction(int n, int n2) throws Exception {
        String string = this.getParserState().getStringPool().orphanString(n);
        String string2 = null;
        string2 = n2 >= 0 ? this.getParserState().getStringPool().orphanString(n2) : "";
        ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, string2);
        if (processingInstruction == null) {
            return;
        }
        this.fCurrentParent.appendChild(processingInstruction);
        this.fCurrentNode = processingInstruction;
    }

    public void comment(int n) throws Exception {
        Comment comment = this.fDocument.createComment(this.getParserState().getStringPool().orphanString(n));
        if (comment == null) {
            return;
        }
        this.fCurrentParent.appendChild(comment);
        this.fCurrentNode = comment;
    }

    public void characters(char[] cArray, int n, int n2, boolean bl) throws Exception {
        Text text = null;
        if (bl) {
            text = this.fDocument.createCDATASection(new String(cArray, n, n2));
        } else {
            if (this.fNormalizeTextNodes && this.fWithinElement && this.fCurrentNode.getNodeType() == 3 && this.fCurrentNode.getParentNode().getNodeType() == 1) {
                ((Text)this.fCurrentNode).appendData(new String(cArray, n, n2));
                return;
            }
            text = this.fDocument.createTextNode(new String(cArray, n, n2));
        }
        if (text == null) {
            return;
        }
        this.fCurrentParent.appendChild(text);
        this.fCurrentNode = text;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2, boolean bl) throws Exception {
        Text text = null;
        text = bl ? this.fDocument.createCDATASection(new String(cArray, n, n2)) : this.fDocument.createTextNode(new String(cArray, n, n2));
        if (text == null) {
            return;
        }
        ((TXText)text).setIsIgnorableWhitespace(true);
        this.fCurrentParent.appendChild(text);
        this.fCurrentNode = text;
    }
}

