/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.EntityDecl;
import com.ibm.xml.framework.EntityPool;
import com.ibm.xml.framework.NotationDecl;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;

public final class DefaultEntityPool
implements EntityPool {
    private static final boolean DEBUG_530 = false;
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;
    private ParserState fParserState;
    private StringPool fStringPool;
    private int fEntityCount;
    private int[][] fEntityName = new int[32][];
    private int[][] fEntityValue = new int[32][];
    private int[][] fPublicId = new int[32][];
    private int[][] fSystemId = new int[32][];
    private int[][] fNotationName = new int[32][];
    private int fNotationListHead = -1;
    private EntityDecl fInternalEntityDecl;

    public DefaultEntityPool(ParserState parserState, boolean bl) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        if (bl) {
            this.fInternalEntityDecl = new EntityDecl();
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    public void reset(ParserState parserState) {
        this.fParserState = parserState;
        this.fStringPool = parserState.cacheStringPool();
        this.fEntityCount = 0;
        this.fNotationListHead = -1;
        if (this.fInternalEntityDecl != null) {
            this.createInternalEntity("lt", "&#60;");
            this.createInternalEntity("gt", ">");
            this.createInternalEntity("amp", "&#38;");
            this.createInternalEntity("apos", "'");
            this.createInternalEntity("quot", "\"");
        }
    }

    public EntityPool resetOrCopy(ParserState parserState) {
        return new DefaultEntityPool(parserState, this.fInternalEntityDecl != null);
    }

    private void createInternalEntity(String string, String string2) {
        this.fInternalEntityDecl.entityName = this.fStringPool.addSymbol(string);
        this.fInternalEntityDecl.entityValue = this.fStringPool.addString(string2);
        this.fInternalEntityDecl.publicId = -1;
        this.fInternalEntityDecl.systemId = -1;
        this.fInternalEntityDecl.notationName = -1;
        this.addEntityDecl(this.fInternalEntityDecl);
    }

    private boolean ensureCapacity(int n) {
        try {
            return this.fEntityName[n][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fEntityName, 0, nArray, 0, n);
            this.fEntityName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fEntityValue, 0, nArray, 0, n);
            this.fEntityValue = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fPublicId, 0, nArray, 0, n);
            this.fPublicId = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fSystemId, 0, nArray, 0, n);
            this.fSystemId = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fNotationName, 0, nArray, 0, n);
            this.fNotationName = nArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fEntityName[n] = new int[32];
        this.fEntityValue[n] = new int[32];
        this.fPublicId[n] = new int[32];
        this.fSystemId[n] = new int[32];
        this.fNotationName[n] = new int[32];
        return true;
    }

    public int addEntityDecl(EntityDecl entityDecl) {
        int n = this.fEntityCount >> 5;
        int n2 = this.fEntityCount & 0x1F;
        this.ensureCapacity(n);
        this.fEntityName[n][n2] = entityDecl.entityName;
        this.fEntityValue[n][n2] = entityDecl.entityValue;
        this.fPublicId[n][n2] = entityDecl.publicId;
        this.fSystemId[n][n2] = entityDecl.systemId;
        this.fNotationName[n][n2] = entityDecl.notationName;
        int n3 = this.fEntityCount++;
        return n3;
    }

    public int addNotationDecl(NotationDecl notationDecl) {
        int n;
        int n2;
        int n3 = this.fNotationListHead;
        while (n3 != -1) {
            n2 = n3 >> 5;
            n = n3 & 0x1F;
            if (this.fNotationName[n2][n] == notationDecl.notationName) {
                return -1;
            }
            n3 = this.fEntityValue[n2][n];
        }
        n2 = this.fEntityCount >> 5;
        n = this.fEntityCount & 0x1F;
        this.ensureCapacity(n2);
        this.fEntityName[n2][n] = -1;
        this.fEntityValue[n2][n] = this.fNotationListHead;
        this.fPublicId[n2][n] = notationDecl.publicId;
        this.fSystemId[n2][n] = notationDecl.systemId;
        this.fNotationName[n2][n] = notationDecl.notationName;
        this.fNotationListHead = this.fEntityCount++;
        return this.fNotationListHead;
    }

    public int lookupEntity(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fEntityCount) {
            if (this.fEntityName[n2][n3] == n) {
                return n4;
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return -1;
    }

    public boolean isExternal(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fEntityValue[n2][n3] == -1;
    }

    public boolean isUnparsed(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fNotationName[n2][n3] != -1;
    }

    public int getEntityName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fEntityName[n2][n3];
    }

    public int getEntityValue(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fEntityValue[n2][n3];
    }

    public int getPublicId(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fPublicId[n2][n3];
    }

    public int getSystemId(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fSystemId[n2][n3];
    }

    public int lookupNotation(int n) {
        int n2 = this.fNotationListHead;
        while (n2 != -1) {
            int n3 = n2 >> 5;
            int n4 = n2 & 0x1F;
            if (this.fNotationName[n3][n4] == n) {
                return n2;
            }
            n2 = this.fEntityValue[n3][n4];
        }
        return -1;
    }

    public int getNotationName(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fNotationName[n2][n3];
    }

    public void checkUnparsedEntities() throws Exception {
        XMLErrorHandler xMLErrorHandler = this.fParserState.getErrorHandler();
        int n = 0;
        while (n < this.fEntityCount) {
            int n2;
            int n3 = n >> 5;
            int n4 = n & 0x1F;
            if (this.fEntityName[n3][n4] != -1 && (n2 = this.fNotationName[n3][n4]) != -1 && this.lookupNotation(n2) == -1) {
                xMLErrorHandler.error1(68, n2);
            }
            ++n;
        }
    }
}

