/*
 * Decompiled with CFR 0.152.
 */
package com.etcee.util.peer;

import com.etcee.util.adapter.TreeAdapter;
import com.etcee.util.loader.Loader;
import com.etcee.util.loader.LoaderException;
import com.etcee.util.peer.Filter;
import com.etcee.util.peer.Peer;
import com.etcee.util.peer.PeerContext;
import com.etcee.util.peer.PeerDictionary;
import com.etcee.util.peer.PeerFactoryException;
import com.etcee.util.peer.PeerInitializationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PeerFactory {
    private HashMap _hashmapObjects = new HashMap();
    private HashMap _hashmapPeers = new HashMap();
    private TreeAdapter _treeadapter = null;
    private PeerContext _peercontext = new PeerContext(){

        public Object findAssociatedObject(Peer peer) {
            return PeerFactory.this._hashmapObjects.get(peer);
        }

        public Peer findParentOf(Peer peer) {
            Peer peer2 = null;
            Object object = PeerFactory.this._hashmapObjects.get(peer);
            while (object != null && (object = PeerFactory.this._treeadapter.findParentOf(object)) != null && (peer2 = (Peer)PeerFactory.this._hashmapPeers.get(object)) == null) {
            }
            return peer2;
        }

        public Iterator findChildrenOf(Peer peer) {
            LinkedList linkedList = new LinkedList();
            Object v = PeerFactory.this._hashmapObjects.get(peer);
            if (v != null) {
                this.findChildrenOf(linkedList, v);
            }
            return linkedList.iterator();
        }

        private void findChildrenOf(List list, Object object) {
            Iterator iterator = PeerFactory.this._treeadapter.findChildrenOf(object);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Peer peer = null;
                peer = (Peer)PeerFactory.this._hashmapPeers.get(e);
                if (peer != null) {
                    list.add(peer);
                    continue;
                }
                this.findChildrenOf(list, e);
            }
        }

        public boolean addChildTo(Peer peer, Peer peer2, Object object) {
            Object v = PeerFactory.this._hashmapObjects.get(peer);
            Object v2 = PeerFactory.this._hashmapObjects.get(peer2);
            if (v == null) {
                throw new IllegalArgumentException("unassociated parent");
            }
            if (v2 == null) {
                throw new IllegalArgumentException("unassociated child");
            }
            return PeerFactory.this._treeadapter.addChildTo(v, v2, object);
        }

        public boolean removeChildFrom(Peer peer, Peer peer2) {
            Object v = PeerFactory.this._hashmapObjects.get(peer);
            Object v2 = PeerFactory.this._hashmapObjects.get(peer2);
            if (v == null) {
                throw new IllegalArgumentException("unassociated parent");
            }
            if (v2 == null) {
                throw new IllegalArgumentException("unassociated child");
            }
            return PeerFactory.this._treeadapter.removeChildFrom(v, v2);
        }
    };
    private PeerDictionary _peerdictionary = null;
    private Loader _loader = null;

    public PeerFactory(TreeAdapter treeAdapter, PeerDictionary peerDictionary, Loader loader) {
        this._treeadapter = treeAdapter;
        this._peerdictionary = peerDictionary;
        this._loader = loader;
    }

    public Peer createPeer(Object object, Object object2, boolean bl, boolean bl2) throws PeerInitializationException, PeerFactoryException {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        try {
            return this.createPeer(linkedList, linkedList2, object, object2, bl, bl2);
        }
        catch (PeerFactoryException peerFactoryException) {
            this._hashmapObjects.entrySet().removeAll(linkedList2);
            this._hashmapPeers.entrySet().removeAll(linkedList);
            throw peerFactoryException;
        }
        catch (PeerInitializationException peerInitializationException) {
            this._hashmapObjects.entrySet().removeAll(linkedList2);
            this._hashmapPeers.entrySet().removeAll(linkedList);
            throw peerInitializationException;
        }
        catch (RuntimeException runtimeException) {
            this._hashmapObjects.entrySet().removeAll(linkedList2);
            this._hashmapPeers.entrySet().removeAll(linkedList);
            throw runtimeException;
        }
        catch (Error error) {
            this._hashmapObjects.entrySet().removeAll(linkedList2);
            this._hashmapPeers.entrySet().removeAll(linkedList);
            throw error;
        }
    }

    private Peer createPeer(LinkedList linkedList, LinkedList linkedList2, Object object, Object object2, boolean bl, boolean bl2) throws PeerInitializationException, PeerFactoryException {
        String string = null;
        Peer peer = null;
        try {
            string = this._peerdictionary.findClassName(object);
            if (string == null && !bl2) {
                throw new PeerFactoryException("unsupported object: " + object);
            }
            if (string != null) {
                peer = (Peer)this._loader.instantiate(string);
            }
            if (bl) {
                Iterator iterator = this._treeadapter.findChildrenOf(object);
                while (iterator.hasNext()) {
                    this.createPeer(linkedList, linkedList2, iterator.next(), object2, bl, bl2);
                }
            }
            if (peer != null) {
                linkedList.add(object);
                linkedList2.add(peer);
                this._hashmapObjects.put(peer, object);
                this._hashmapPeers.put(object, peer);
                peer.initialize(this._peercontext, object2);
            }
        }
        catch (LoaderException loaderException) {
            Throwable throwable = loaderException.getWrappedThrowable();
            throw new PeerFactoryException(throwable, throwable.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new PeerFactoryException(classCastException, classCastException.getMessage());
        }
        return peer;
    }

    public Iterator findPeers(Filter filter) {
        LinkedList linkedList = new LinkedList();
        Set set = this._hashmapObjects.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!filter.match(k)) continue;
            linkedList.add(k);
        }
        return linkedList.iterator();
    }
}

