using System;
using System.IO;
using GOV.CSD.ITL.NIST.AN_CTS;
using GOV.CSD.ITL.NIST.AN_CTS.Classes.Traditional;
using GOV.CSD.ITL.NIST.CTS.AN2K11;
using GOV.CSD.ITL.NIST.Library;
using System.Collections.Generic;
using System.Text;


namespace GOV.CSD.ITL.NIST.Map
{

	class MainClass
	{
		public static void Main (string[] args)
		{
			string line;
			while ((line = Console.ReadLine()) != null) {
				TraditionalCts _loadedCts;

				var split = line.Split('\t');
				var filename = split[0];
				var contents = split[1];
				var partialC = Convert(contents);
				var converted = System.Convert.FromBase64String(partialC);
				_loadedCts = new AN2K11();
				_loadedCts.FileUnderTestPath = filename;
				((TraditionalTransaction) _loadedCts.TransactionUnderTest).CreateInstance(converted, string.Empty);
				_loadedCts.ParseFileAsTransaction();
				Console.WriteLine (string.Format ("BEGIN LOG{0}{1}{0}END LOG",Environment.NewLine,_loadedCts.PrintResultsReport()));
			}

		}

		private static string Convert (string value)
		{
			StringBuilder tmp = new StringBuilder ();
			var split = value.Split (' ');
			foreach (var s in split) {
				tmp.Append(System.Convert.ToChar(System.Convert.ToUInt32(s, 16)));
			}
			return tmp.ToString();
		}
	
	}
}
