#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <bios.h>
#include <dos.h>
#include "msmouse.h"
#include "keybrd.h"

//Mouse object
MouseObject *mouse;

struct MouseStuff {
   unsigned Me;
   int X;
   int Y;
};

struct MenuBox{
   int Limit;
   int Top;
   int Bot;
   int CurX;
   char *Letters;
};

FILE *Ofile = NULL;
const int   TRUE = -1;                 //Logical True &
const int   FALSE = 0;                 //        False
const int   Marker = 0XC3;             //On screen poiter to current value
const float LengthFactor = 0.3048;     //Converts ft to Meters
const float AreaFactor = 0.0929;       //Converts ft^2 to m^2
const float EnergyFactor = 1.055;      //Converts Btus to kW
const float MassFlowFactor = 2.204623; //Converts kg/s to lb/s
const float VolFlowFactor = 0.000472;  //Converts m^3/s to cfm
const float Cp = 1.005;                //Specific Heat
const float G = 9.80665;               //Acceleration of gravity
const float PAtmos = 101325.0;         //Atmospheric pressure
const float R = 287.0;                 //Universal gass constant
const float Factor = 1000.0;           //Rounding factor
const char  Seperator[]={"\n\r-----------------------------------------------"};


int SI;    //Flag for units selected (SI = TRUE => units are SI!)

//Function prototypes
void  Banner(void);
void  MainLoop(void);
void  ShowMenu(void);
void  Sfill(void);
void  SfillT(void);
void  USfill(void);
void  USfillT(void);
void  Splume(void);
void  Hplume(void);
void  Cplume(void);
void  GetFloat(int, int, float &, char *);
int   ValidChar(char);
void  Beep(void);
void  ClrBlk(int, int);
void  Message(char *);
void  PrintAt(int, int, float, char *, int);
void  PutAt(int, int, char, int);
float AlgMenu(void);
float Length(float);
float Area(float);
float Energy(float);
float ToC(float);
float ToF(float);
float Temperature(float);
char  GetKey(int &, int &, MouseStuff &, MenuBox);
void  GetFileName(char *);
int   ValidName(char, char &);
unsigned GetAction(MouseStuff &);
int   PrintToFile(int &, int);
char  Pause(void);
void  Asetc(void);
long  InRange(float, float, float);
long  InRange1(float, float, float);
long  Under(float, float);
long  UnderEq(float, float);
long  Over(float, float);
long  Round(float);



void main(void){
   FILE *Units;

   //Defualt to the units last set (saved in the file 'Units')
   if ((Units = fopen("Units", "rb")) != NULL){
      fread(&SI, sizeof(int), 1, Units);
      fclose(Units);
   }
   else //If 'Units' does not exist default to SI
      SI = TRUE;

   //instantiate and initialize the mouse object
   mouse = new MouseObject();
   mouse->Setup(TextScrn);
   mouse->Hide();

   //Set the screen colors
   textcolor(WHITE);
   textbackground(BLUE);
   clrscr();

   //this is the main menu of the program
   Banner();
   MainLoop();

   //Save the current units setting for next time
   Units = fopen("Units", "wb");
   fwrite(&SI, sizeof(int), 1, Units);
   fclose(Units);
   normvideo();
   clrscr();
   return;
}//End of main()



void Banner(void){
   int i, Left = 11, Top = 5, Right = Left+58, Bottom = Top+10;
   char UL = 0XDA, UR = 0XBF, LR = 0XD9, LL = 0XC0, H = 0XC4, V = 0XB3;

   //Draw the border
   gotoxy(Left, Top);
   putch(UL);
   for (i = Left+1; i < Right; i++)
      putch(H);
   putch(UR);
   for (i = Top+1; i < Bottom; i++){
      gotoxy(Left, i);
      putch(V);
      gotoxy(Right, i);
      putch(V);
   }
   gotoxy(Left, Bottom);
   putch(LL);
   for (i = Left+1; i < Right; i++)
      putch(H);
   putch(LR);
   //Next print the banner
   window(Left+1, Top+1, Right-1, Bottom-1);
   cprintf(" ASMET VERSION 1.0\n\r"
           " WRITTEN BY CHARLES ARNOLD\n\n\r"
           " CONTRIBUTION OF THE NATIONAL INSTITUTE OF STANDARDS AND\n\r"
           " TECHNOLOGY (U.S.)  **  NOT SUBJECT TO COPYRIGHT\n\n\r"
           " DOCUMENTATION: KLOTE, J.H., METHOD OF PREDICTING SMOKE\n\r"
           " MOVEMENT IN ATRIA WITH APPLICATION TO SMOKE MANAGEMENT,\n\r"
           " NISTIR 5516, 1994.");
   window(1, 1, 80, 25);

   //Wait for 5 seconds then remove the window
   delay(4500);
   clrscr();
}//End of Banner()



void MainLoop(void)
//This function serves as the main menu for the program
{
   int Done = FALSE;
   unsigned Key;
   MouseStuff Mse;

   mouse->Show();
   do{
      ShowMenu(); //Display the main menu text
      //select a function by pressing the apropriate 'hot key'
      Key = GetAction(Mse);
      if (Mse.Me == RMouseDown)//Quit on Right mouse click
         Done = TRUE;
      else if (Mse.Me == LMouseDown){
         if (Mse.X > 11 && Mse.X < 51 && Mse.Y > 5 && Mse.Y < 16)
            switch(Mse.Y){
               case 6:     //Steady Filling Equation (Solve for z)
                  Sfill();
                  break;
               case 7:     //Steady Filling Equation (Solve for t)
                  SfillT();
                  break;
               case 8:     //Unsteady Filling Equation (Solve for z)
                  USfill();
                  break;
               case 9:     //Unsteady Filling Equation (Solve for t)
                  USfillT();
                  break;
               case 10:     //Simple Plume Equation
                  Splume();
                  break;
               case 11:     //Plume With Virtual Origin Correction
                  Hplume();
                 break;
               case 12:     //Plume Centerline Temperature
                  Cplume();
                  break;
               case 13:     //ASETB Model
                  Asetc();
                  break;
               case 14:     //Toggle the input units
                  textcolor(LIGHTGREEN);
                  gotoxy(42, 15);
                  if (SI){
                     SI = FALSE;
                     cprintf("English");
                  }
                  else{
                     SI = TRUE;
                     cprintf("SI");
                  }
                  textcolor(WHITE);
                  break;
               case 15:     //Exit the program
                  Done = TRUE;
                  break;
               default:
                  break;
            }
      }
      else //Must have been a key press
         switch(toupper(char(Key))){
            case 'S':     //Steady Filling Equation (Solve for z)
               Sfill();
               break;
            case 'T':     //Steady Filling Equation (Solve for t)
               SfillT();
               break;
            case 'U':     //Unsteady Filling Equation (Solve for z)
               USfill();
               break;
            case 'N':     //Unsteady Filling Equation (Solve for t)
               USfillT();
               break;
            case 'P':     //Simple Plume Equation
               Splume();
               break;
            case 'V':     //Plume With Virtual Origin Correction
               Hplume();
              break;
            case 'C':     //Plume Centerline Temperature
               Cplume();
               break;
            case 'I':     //Toggle the input units
               SI = TRUE;
               textcolor(LIGHTGREEN);
               gotoxy(42, 15);
               cprintf("SI");
               textcolor(WHITE);
               break;
            case 'E':
               SI = FALSE;
               textcolor(LIGHTGREEN);
               gotoxy(42, 15);
               cprintf("English");
               textcolor(WHITE);
               break;
            case 'A':     //ASETB Model
               Asetc();
               break;
            case 'Q':     //Exit the program
            case 'X':     //For those who don't bother to look
               Done = TRUE;
               break;
            default:
               break;
         }
   }while(!Done);
   //Clean up the mess and go home
   mouse->Hide();
   _setcursortype(_NORMALCURSOR);
   clrscr();
}//End of MainLoop()



void ShowMenu(void)
//This function displays the main menu
{
   mouse->Hide();
   clrscr();
   gotoxy(1, 3);
   cputs("         ASMET: Atria Smoke Management Engineering Tools \n\n\r"
         "                           Menu\n\n\r"
         "            Steady Filling Equation (Solve for z)\n\r"
         "            Steady Filling Equation (Solve for t)\n\r"
         "            Unsteady Filling Equation (Solve for z)\n\r"
         "            Unsteady Filling Equation (Solve for t)\n\r"
         "            Simple Plume Equation\n\r"
         "            Plume With Virtual Origin Correction\n\r"
         "            Plume Centerline Temperature\n\r"
         "            ASET-C (C language version of ASET-B)\n\r"
         "            \n\r"
         "            Quit");
   gotoxy(1, 15);
   cprintf("            Input units (SI or English):");
   //Display the current units in light green
   textcolor(LIGHTGREEN);
   gotoxy(42, 15);
   if (SI)
      cprintf("SI");
   else
      cprintf("English");
   _setcursortype(_NOCURSOR);
   //Highlight the Hot Keys
   PutAt(13, 7,  'S', YELLOW);   //[S]teady Filling Equation (Solve for z)
   PutAt(14, 8,  't', YELLOW);   //S[t]eady Filling Equation (Solve for t)
   PutAt(13, 9,  'U', YELLOW);   //[U]nsteady Filling Equation (Solve for z)
   PutAt(14, 10, 'n', YELLOW);   //U[n]steady Filling Equation (Solve for t)
   PutAt(20, 11, 'P', YELLOW);   //Simple [P]lume Equation
   PutAt(24, 12, 'V', YELLOW);   //Plume With [V]irtual Origin Correction
   PutAt(19, 13, 'C', YELLOW);   //Plume [C]enterline Temperature
   PutAt(13, 14, 'A', YELLOW);   //[A]SET-C (C language version of ASET-B)
   PutAt(27, 15, 'I', YELLOW);   //Input units (S[I] or English):
   PutAt(32, 15, 'E', YELLOW);   //Input units (SI or [E]nglish):
   PutAt(13, 16, 'Q', YELLOW);   //[Q]uit
   mouse->Show();
}//End of ShowMenu()



//Units strings are global
char Len[2][3] =    {"m ", "ft"},           //Length
     Enrgy[2][6] =  {"kW   ", "Btu/s"},     //Energy
     Ara[2][5] =    {"m^2 ", "ft^2"},       //Area
     Growth[2][8] = {"kW/s^2 ", "Btu/s^2"}, //Growth rate (Energy per sec.^2)
     Temp[2][3] =   {"C", "F"}; //The funcky character shows up as a
                                  //degree symbol on the screen
void Sfill(void)
/*
   SFILL - Steady smoke filling

   Routine to calculate height of smoke layer during
   atrium filling from a steady fire

Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      HFlg, TFlg, QFlg, AFlg   Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlg                 Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Height of smoke layer
      Q                        Rate of heat release
      H                        Ceiling height
      A                        cross-sectional area of atrium
      t                        Time
      Shape                    Ratio of A/H^2
      Zes
      Tfac
   char
      msg[80]                  Buffer for error messages
*/
{
   const int ValXPos = 48, X1 = 6, Top = 6,
             H_Y = Top,
             A_Y = Top+1,
             Q_Y = Top+2,
             T_Y = Top+3,
             P_Y = Top+4,
             F_Y = Top+5,
             D_Y = Top+6;
   int Done = FALSE, ChangeFlag, HFlg = FALSE, TFlg = FALSE, QFlg = FALSE,
       AFlg = FALSE, Crnt = 0, FirstPrint = TRUE,
       FirstFPrint = TRUE, SlideFlg = TRUE, GronkFlag = FALSE;
   float Z = 0.0, Zes, H = 0.0, t = 0.0, Q = 0.0, A = 0.0, Tfac, Shape;
   char msg[80];
   MouseStuff Mse;
   MenuBox MB = {3, Top, 12, 59, "HAQTPFD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(22, 1);
   cprintf("Steady Filling Equation (Solve for z)");
   gotoxy(9, 3);
   cprintf("Height of smoke layer during atrium filling from a steady fire");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     ceiling height above fire       H (%s):\n\r"
           "     cross-sectional area of atrium  A (%s):\n\r"
           "     heat release rate of fire       Q (%s):\n\r"
           "     time                            t (s):\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Ara[SI+1],
           Enrgy[SI+1]);

   //Highlight the hotkeys
   PutAt(X1+32, H_Y, MB.Letters[0], YELLOW);
   PutAt(X1+32, A_Y, MB.Letters[1], YELLOW);
   PutAt(X1+32, Q_Y, MB.Letters[2], YELLOW);
   PutAt(X1+32, T_Y, tolower(MB.Letters[3]), YELLOW);
   PutAt(X1,    P_Y, MB.Letters[4], YELLOW);
   PutAt(X1+17, F_Y, tolower(MB.Letters[5]), YELLOW);
   PutAt(X1,    D_Y, MB.Letters[6], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'H':  //ceiling height above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = H_Y-Top; //Update default item pointer
            GetFloat(ValXPos, H_Y, H, "%8.2f"); //Read in a value for H
            HFlg = TRUE;
            if (UnderEq(H, 0.0)){
               Message("H must be greater than Zero.");
               //Display H in red to indicate where the problem is
               PrintAt(ValXPos, H_Y, H, "%8.2f", RED);
               HFlg = FALSE;
            }
            else{
               if (!SI) //If not in SI units convert
                  H *= LengthFactor;
               if (AFlg){ //If A has a value...
                  Shape = A/pow(H, 2); //Calculate non dimentional area
                  if (!InRange(Shape, 0.9, 14.)){
                     //Non dimentional area is out of bounds
                     //Display error message
                     sprintf(msg, "A/H^2 = %7.4f "
                            "This is outside the intended range of 0.9 to 14.",
                            Shape);
                     Message(msg);
                     //Display H in red to indicate where the problem is
                     PrintAt(ValXPos, H_Y, Length(H), "%8.2f", RED);
                     GronkFlag = TRUE;
                  }
                  else{
                     /* Everything is fine, redisplay A in Yellow
                        and set value flag for A (in case it was
                        not set before                            */
                     PrintAt(ValXPos, A_Y, Area(A), "%8.2f", YELLOW);
                     GronkFlag = FALSE;
                  }
               }
            }
            break;
         case 'A': //cross-sectional area of atrium
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = A_Y-Top; //Update default item pointer
            GetFloat(ValXPos, A_Y, A, "%8.2f"); //Read in a value for A
            AFlg = TRUE;
            if (!SI)  //If not in SI units convert
               A *= AreaFactor;
            if (HFlg){
               Shape = A/pow(H, 2);
               if (!InRange(Shape, 0.9, 14.)){
                  sprintf(msg, "A/H^2 = %7.4f "
                         "This is outside the intended range of 0.9 to 14.",
                         Shape);
                  Message(msg);
                  //Display A in red to indicate where the problem is
                  PrintAt(ValXPos, A_Y, Area(A), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, H_Y, Length(H), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'Q': //heat release rate of fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Q_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Q_Y, Q, "%8.2f"); //Read in a value for Q
            QFlg = TRUE;
            if (!SI)  //If not in SI units convert
               Q *= EnergyFactor;
            break;
         case 'T': //time
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = T_Y-Top; //Update default item pointer
            GetFloat(ValXPos, T_Y, t, "%8.2f"); //Read in a value for t
            if (t > 0)
               TFlg = TRUE;
            else{
               Message("t must be greater than Zero.");
               //Display t in red to indicate where the problem is
               PrintAt(ValXPos, T_Y, t, "%8.2f", RED);
               TFlg = FALSE;
            }
            break;
         case 'P': //Print results (to LPT1)
            if (HFlg && TFlg && QFlg && AFlg){
               if (FirstPrint){
                  FirstPrint = FALSE;
                  fprintf(stdprn, "\n\r                    Steady Filling "
                          "Equation (Solve for z)\n\n\r");
                  fprintf(stdprn, "          Height of smoke layer during "
                          "atrium filling from a steady fire\n\n\n\r");
               }
               fprintf(stdprn, "ceiling height above fire       H (%s):  "
                       "  %8.2f\n\r"
                       "cross-sectional area of atrium  A (%s):  %8.2f\n\r"
                       "heat release rate of fire       Q (%s): %8.2f\n\r"
                       "time                            t (s):     %8.2f\n\n\r",
                       Len[SI+1], Length(H), Ara[SI+1], Area(A), Enrgy[SI+1],
                       Energy(Q), t);
               if (Under(Z/H, 0.2)){
                  Zes = 0.2*H;
                  fprintf(stdprn, "Outside range of equation, but z is less "
                          "than %7.1f m or %7.1f ft\n\r", Zes,
                          Zes/LengthFactor);
               }
               else if(Over(Z/H, 1.0))
                  fprintf(stdprn, "The smoke layer under the ceiling has not "
                          "yet begun to descend\n\r");
               else
                  fprintf(stdprn, "Height of smoke layer above fire, z is "
                          "%7.1f m or %7.1f ft\n\n\r", Z, Z/LengthFactor);
               if (GronkFlag)
                  fprintf(stdprn, "\n\rCaution: A/H^2 = %-8.2f This is outside "
                          "the intended range of 0.9 to 14.", Shape);
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'F': //Print results to file
            if (HFlg && TFlg && QFlg && AFlg){
               if (PrintToFile(FirstFPrint, 11)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                    Steady Filling "
                             "Equation (Solve for z)\n\n\r");
                     fprintf(Ofile, "          Height of smoke layer during "
                             "atrium filling from a steady fire\n\n\n\r");
                  }
                  fprintf(Ofile, "ceiling height above fire       H (%s):  "
                          "  %8.2f\n\r"
                          "cross-sectional area of atrium  A (%s):  %8.2f\n\r"
                          "heat release rate of fire       Q (%s): %8.2f\n\r"
                          "time                            t (s):     %8.2f"
                          "\n\n\r", Len[SI+1], Length(H), Ara[SI+1], Area(A),
                          Enrgy[SI+1], Energy(Q), t);
                  if (Under(Z/H, 0.2)){
                     Zes = 0.2*H;
                     fprintf(Ofile, "Outside range of equation, but z is less "
                             "than %7.1f m or %7.1f ft\n\r", Zes,
                             Zes/LengthFactor);
                  }
                  else if(Over(Z/H, 1.0))
                     fprintf(Ofile, "The smoke layer under the ceiling has not "
                             "yet begun to descend\n\r");
                  else
                     fprintf(Ofile, "Height of smoke layer above fire, z is "
                             "%7.1f m or %7.1f ft\n\n\r", Z, Z/LengthFactor);
                  if (GronkFlag)
                     fprintf(Ofile, "\n\rCaution: A/H^2 = %-8.2f This is outside "
                             "the intended range of 0.9 to 14.", Shape);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlg && ChangeFlag && Crnt < 3)
         Crnt++;
      if (HFlg && TFlg && QFlg && AFlg && ChangeFlag){
         SlideFlg = FALSE;
         Tfac = t*pow(Q, 1./3.)*pow(H, -4./3.);
         Z = H*(1.11-0.28*log(Tfac/Shape));

         ClrBlk(15, 18);
         gotoxy(3, 16);
         if (Under(Z/H, 0.2)){
            Zes = 0.2*H;
            cprintf("Outside range of equation, but z is less than %7.1f "
                    "m or %7.1f ft", Zes, Zes/LengthFactor);
         }
         else if(Over(Z/H, 1.0))
            cprintf("The smoke layer under the ceiling has not yet begun "
                    "to descend");
         else
             cprintf("Height of smoke layer above fire, z is %7.1f m or "
                     "%7.1f ft", Z, Z/LengthFactor);
         gotoxy(3, 18);
         if (GronkFlag){
            textcolor(LIGHTRED);
            cprintf("Caution: A/H^2 = %-6.2f This is outside "
                    "the intended range of 0.9 to 14.", Shape);
            textcolor(WHITE);
         }
      }
   }while(!Done); //End of main loop
}//End of Sfill()



void SfillT(void)
/*
   SFILLT - Steady smoke filling - time calculation

   Routine to calculate atrium filling time for steady fire
Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      HFlg, ZFlg, QFlg, AFlg   Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlg                 Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Height of smoke layer
      Q                        Rate of heat release
      H                        Ceiling height
      A                        cross-sectional area of atrium
      t                        Time
      Shape                    Ratio of A/H^2
      EEE
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 48, Top = 6,
             H_Y = Top,
             A_Y = Top+1,
             Q_Y = Top+2,
             Z_Y = Top+3,
             P_Y = Top+4,
             F_Y = Top+5,
             D_Y = Top+6;
   int Done = FALSE, ChangeFlag, HFlg = FALSE, ZFlg = FALSE, QFlg = FALSE,
       AFlg = FALSE, Crnt = 0, FirstPrint = TRUE,
       FirstFPrint = TRUE, SlideFlag = TRUE, GronkFlag1 = FALSE,
       GronkFlag2 = FALSE;
   float Z = 0.0, EEE, H, t = 0.0, Q, A = 0.0, Shape;
   char msg[80], Gronk1[128], Gronk2[128];
   MouseStuff Mse;
   MenuBox MB = {3, Top, 12, 59, "HAQZPFD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(22, 1);
   cprintf("Steady Filling Equation (Solve for t)");
   gotoxy(23, 3);
   cprintf("Atrium filling time for steady fire");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     ceiling height above fire        H (%s):\n\r"
           "     cross-sectional area of atrium   A (%s):\n\r"
           "     heat release rate of fire        Q (%s):\n\r"
           "     height of smoke layer above fire z (%s):\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Ara[SI+1], Enrgy[SI+1],
           Len[SI+1]);
   //Highlight the Hot Keys
   PutAt(39, H_Y, MB.Letters[0], YELLOW);
   PutAt(39, A_Y, MB.Letters[1], YELLOW);
   PutAt(39, Q_Y, MB.Letters[2], YELLOW);
   PutAt(39, Z_Y, tolower(MB.Letters[3]), YELLOW);
   PutAt(6,  P_Y, MB.Letters[4], YELLOW);
   PutAt(23, F_Y, tolower(MB.Letters[5]), YELLOW);
   PutAt(6,  D_Y, MB.Letters[6], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'H': //ceiling height above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = H_Y-Top; //Update default item pointer
            GetFloat(ValXPos, H_Y, H, "%8.2f"); //Read in a value for H
            HFlg = TRUE;
            if (UnderEq(H, 0.0)){
               Message("H must be greater than Zero.");
               //Display H in red to indicate where the problem is
               PrintAt(ValXPos, H_Y, H, "%8.2f", RED);
               HFlg = FALSE;
            }
            else{
               if (!SI) //If not in SI units convert
                  H *= LengthFactor;
               if (AFlg){
                  Shape = A/(H*H);
                  if (!InRange(Shape, 0.9, 14.)){
                     sprintf(msg, "A/H^2 = %7.4f "
                             "This is outside the intended range of 0.9 to 14.",
                             Shape);
                     Message(msg);
                     //Display H in red to indicate where the problem is
                     PrintAt(ValXPos, H_Y, Length(H), "%8.2f", RED);
                     GronkFlag1 = TRUE;
                     sprintf(Gronk1, "Caution: A/H^2 = %7.4f "
                             "This is outside the intended range of 0.9 to 14.",
                             Shape);
                  }
                  else{
                     PrintAt(ValXPos, A_Y, Area(A), "%8.2f", YELLOW);
                     GronkFlag1 = FALSE;
                  }
               }
               if (HFlg && ZFlg)
                  if (Under(Z/H, 0.1999)){
                     Message("z out of range, it is not intended to be less than 20% of H");
                     //Display Z in red to indicate where the problem is
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                     sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                             "less than 20%% of H");
                     GronkFlag2 = TRUE;
                  }
                  else if (Over(Z/H, 1.)){
                     Message("z out of range, it is not intended to be greater than H");
                     //Display Z in red to indicate where the problem is
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                     sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                             "greater than H");
                     GronkFlag2 = TRUE;
                  }
                  else{
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                     GronkFlag2 = FALSE;
                  }
            }
            break;
         case 'A': //cross-sectional area of atrium
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = A_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Top+Crnt, A, "%8.2f"); //Read in a value for A
            AFlg = TRUE;
            if (!SI)  //If not in SI units convert
               A *= AreaFactor;
            if (HFlg){
               Shape = A/pow(H, 2);
               if (!InRange(Shape, 0.9, 14.)){
                  sprintf(msg, "A/H^2 = %7.4f "
                          "This is outside the intended range of 0.9 to 14.",
                          Shape);
                  Message(msg);
                  //Display A in red to indicate where the problem is
                  PrintAt(ValXPos, A_Y, Area(A), "%8.2f", RED);
                  sprintf(Gronk1, "Caution: A/H^2 = %7.4f "
                          "This is outside the intended range of 0.9 to 14.",
                          Shape);
                  GronkFlag1 = TRUE;
               }
               else{
                  PrintAt(ValXPos, H_Y, Length(H), "%8.2f", YELLOW);
                  GronkFlag1 = FALSE;
               }
            }
            break;
         case 'Q': //heat release rate of fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Q_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Q_Y, Q, "%8.2f"); //Read in a value for Q
            QFlg = TRUE;
            if (!SI)  //If not in SI units convert
               Q *= EnergyFactor;
            break;
         case 'Z': //height of smoke layer above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Z_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Z_Y, Z, "%8.2f"); //Read in a value for Z
            ZFlg = TRUE;
            if (!SI)  //If not in SI units convert
               Z *= LengthFactor;
            if (HFlg)
               if (Under(Z/H, 0.1999)){
                  Message("z out of range, it is not intended to be less than 20% of H");
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  sprintf(Gronk2, "Caution: z out of range, it is not intended to be less "
                          "than 20%% of H");
                  GronkFlag2 = TRUE;
               }
               else if (Over(Z/H, 1.)){
                  Message("z out of range, it is not intended to be greater than H");
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                          "greater than H");
                  GronkFlag2 = FALSE;
               }
               else
                  GronkFlag2 = FALSE;
            break;
         case 'P': //Print results (to LPT1)
            if (HFlg && AFlg && QFlg && ZFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                     Steady Filling "
                          "Equation (Solve for t)\n\n\r");
                  fprintf(stdprn, "                      Atrium filling time "
                          "for steady fire\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
                 "     ceiling height above fire        H (%s):    %8.2f\n\r"
                 "     cross-sectional area of atrium   A (%s): %8.2f\n\r"
                 "     heat release rate of fire        Q (%s): %8.2f\n\r"
                 "     height of smoke layer above fire z (%s):    %8.2f\n\n\r",
                 Len[SI+1], Length(H), Ara[SI+1], Area(A), Enrgy[SI+1],
                 Energy(Q), Len[SI+1], Length(Z));
               fprintf(stdprn, "Filling time is %7.0f seconds or %7.1f min.\n\r"
                       , t, t/60.0);
               if (GronkFlag1)
                  fprintf(stdprn, "\n\r%s", Gronk1);
               if (GronkFlag2)
                  fprintf(stdprn, "\n\r%s", Gronk2);
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'F': //Print results to file
            if (HFlg && AFlg && QFlg && ZFlg){
               if (PrintToFile(FirstFPrint, 11)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                     Steady Filling "
                             "Equation (Solve for t)\n\n\r");
                     fprintf(Ofile, "                      Atrium filling time "
                             "for steady fire\n\n\n\r");
                  }
                  fprintf(Ofile,
                  "     ceiling height above fire        H (%s):    %8.2f\n\r"
                  "     cross-sectional area of atrium   A (%s): %8.2f\n\r"
                  "     heat release rate of fire        Q (%s): %8.2f\n\r"
                  "     height of smoke layer above fire z (%s):    %8.2f\n\n\r"
                  , Len[SI+1], Length(H), Ara[SI+1], Area(A), Enrgy[SI+1],
                  Energy(Q), Len[SI+1], Length(Z));
                  fprintf(Ofile, "Filling time is %7.0f seconds or %7.1f "
                          "min.\n\r", t, t/60.0);
                  if (GronkFlag1)
                     fprintf(Ofile, "\n\r%s", Gronk1);
                  if (GronkFlag2)
                     fprintf(Ofile, "\n\r%s", Gronk2);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 3)
         Crnt++;
      if (HFlg && AFlg && QFlg && ZFlg && ChangeFlag){
         SlideFlag = FALSE;
         EEE = (1.11-(Z/H))/.28;
         t = Shape*pow(H, 4./3.)*pow(Q, -1./3.)*exp(EEE);
         ClrBlk(15, 19);
         gotoxy(3, 16);
         cprintf("Filling time is %7.0f seconds or %7.1f min.", t, t/60.0);
         if (GronkFlag1){
            gotoxy(3, 18);
            textcolor(LIGHTRED);
            cprintf("%s", Gronk1);
            textcolor(WHITE);
         }
         if (GronkFlag2){
            gotoxy(3, 19);
            textcolor(LIGHTRED);
            cprintf("%s", Gronk2);
            textcolor(WHITE);
         }
      }
   }while(!Done);
}//End of SfillT()



void USfill(void)
/*
   USFILL - Unsteady filling

   Routine to calculate height of smoke layer during
   atrium filling from an unsteady fire
Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      HFlg, AFlg, GFlg, TFlg   Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlag                Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Height of smoke layer
      Q                        Rate of heat release
      H                        Ceiling height
      A                        cross-sectional area of atrium
      t                        Time
      Shape                    Ratio of A/H^2
      Alg                      Fire growth constant
      Tg
      Zes
      EEE
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 50, Top = 6,
             H_Y = Top,
             A_Y = Top+1,
             M_Y = Top+2,
             T_Y = Top+3,
             P_Y = Top+4,
             F_Y = Top+5,
             D_Y = Top+6;
   int Done = FALSE, ChangeFlag, Crnt = 0, HFlg = FALSE, AFlg = FALSE,
       GFlg = FALSE, TFlg = FALSE, SlideFlag = TRUE,
       FirstFPrint = TRUE, FirstPrint = TRUE, GronkFlag = FALSE;
   float H, A = 0.0, t, Alg, Alg0, Shape, Tg, Q = 0.0, Z = 0.0, Zes, EEE;
   char msg[80];
   MouseStuff Mse;
   MenuBox MB = {3, Top, 12, 58, "HAMTPFD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(21, 1);
   cprintf("Unsteady Filling Equation (Solve for z)");
   gotoxy(22, 3);
   cprintf("Atrium filling time for unsteady fire");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     ceiling height above fire       H (%s):\n\r"
           "     cross-sectional area of atrium  A (%s):\n\r"
           "     fire growth constant (Menu)     a (%s):\n\r"
           "     time                            t (s):\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Ara[SI+1],
           Growth[SI+1]);
   //Highlight the Hot Keys
   PutAt(38, H_Y, MB.Letters[0], YELLOW);
   PutAt(38, A_Y, MB.Letters[1], YELLOW);
   PutAt(28, M_Y, MB.Letters[2], YELLOW);
   PutAt(11, M_Y, 'g', YELLOW);
   PutAt(38, T_Y, tolower(MB.Letters[3]), YELLOW);
   PutAt(6,  P_Y, MB.Letters[4], YELLOW);
   PutAt(23, F_Y, tolower(MB.Letters[5]), YELLOW);
   PutAt(6,  D_Y, MB.Letters[6], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'H': //ceiling height above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = H_Y-Top; //Update default item pointer
            GetFloat(ValXPos, H_Y, H, "%8.2f"); //Read in a value for H
            HFlg = TRUE;
            if (UnderEq(H, 0.0)){
               Message("H must be greater than Zero.");
               //Display H in red to indicate where the problem is
               PrintAt(ValXPos, H_Y, H, "%8.2f", RED);
               HFlg = FALSE;
            }
            else{
               if (!SI) //If not in SI units convert
                  H *= LengthFactor;
               if (AFlg){
                  Shape = A/(H*H);
                  if (!InRange(Shape, 1.0, 23.)){
                     sprintf(msg, "A/H^2 = %7.4f "
                             "This is outside the intended range of 1. to 23.",
                             Shape);
                     Message(msg);
                     //Display H in red to indicate where the problem is
                     PrintAt(ValXPos, H_Y, Length(H), "%8.2f", RED);
                     GronkFlag = TRUE;
                  }
                  else{
                     PrintAt(ValXPos, A_Y, Area(A), "%8.2f", YELLOW);
                     GronkFlag = FALSE;
                  }
               }
            }
            break;
         case 'A': //cross-sectional area of atrium
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = A_Y-Top; //Update default item pointer
            GetFloat(ValXPos, A_Y, A, "%8.2f"); //Read in a value for A
            AFlg = TRUE;
            if (!SI)  //If not in SI units convert
               A *= AreaFactor;
            if (HFlg){
               Shape = A/(H*H);
               if (!InRange(Shape, 1.0, 23.)){
                  sprintf(msg, "A/H^2 = %7.4f "
                          "This is outside the intended range of 1. to 23.",
                          Shape);
                  Message(msg);
                  //Display A in red to indicate where the problem is
                  PrintAt(ValXPos, A_Y, Area(A), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, H_Y, Length(H), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'M': //fire growth constant (Menu)
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Alg0 = AlgMenu();
            GFlg = TRUE;
            Crnt = M_Y-Top; //Update default item pointer
            PrintAt(ValXPos, M_Y, Alg0, "%7.5f", YELLOW);
            Alg = Alg0;
            if (!SI) //If not in SI units convert
               Alg *= EnergyFactor;
            break;
         case 'G': //fire growth constant
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = M_Y-Top; //Update default item pointer
            GetFloat(ValXPos, M_Y, Alg0, "%7.5f"); //Read in a value for Alg0
            GFlg = TRUE;
            Alg = Alg0;
            if (!SI) //If not in SI units convert
               Alg *= EnergyFactor;
            break;
         case 'T': //time
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = T_Y-Top; //Update default item pointer
            GetFloat(ValXPos, T_Y, t, "%8.2f"); //Read in a value for t
            if (t > 0)
               TFlg = TRUE;
            else{
               Message("t must be greater than Zero.");
               //Display t in red to indicate where the problem is
               PrintAt(ValXPos, T_Y, t, "%8.2f", RED);
            }
            break;
         case 'P': //Print results (to LPT1)
            if (HFlg && AFlg && GFlg && TFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                    Unsteady Filling "
                          "Equation (Solve for z)\n\n\r");
                  fprintf(stdprn, "                     Atrium filling time for"
                          " unsteady fire\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
                     "    ceiling height above fire       H (%s):   %8.2f\n\r"
                     "    cross-sectional area of atrium  A (%s): %8.2f\n\r"
                     "    fire growth constant (Menu)     a (%s):  %7.5f\n\r"
                     "    time                            t (s):    %8.2f\n\n\r"
                     ,Len[SI+1], Length(H), Ara[SI+1], Area(A), Growth[SI+1],
                     Alg0, t);
               fprintf(stdprn, "At %7.0f seconds, the fire is %9.0f kW or %9.0f"
                       " Btu/s.\n\n\r",
                       t, Q, Q/EnergyFactor);
               if (Under(Z/H, 0.19999)){
                  Zes = 0.2*H;
                  fprintf(stdprn, "Outside range of equation, but z is less "
                          "than %6.1f m or %7.1f ft\n\n\r",
                          Zes, Zes/LengthFactor);
               }
               else if(Over(Z/H, 1.0))
                  fprintf(stdprn, "The smoke layer under the ceiling has not "
                          "yet begun to descend\n\n\r");
               else
                  fprintf(stdprn, "Height of smoke layer above fire, z is %7.1f"
                          " m or %7.1f ft\n\n\r", Z, Z/LengthFactor);
                  if (GronkFlag)
                     fprintf(stdprn, "\n\rCaution: A/H^2 = %7.4f "
                             "This is outside the intended range of 1. to 23.",
                             Shape);
               fprintf(stdprn, "%s", Seperator);
           }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'F': //Print results to file
            if (HFlg && AFlg && GFlg && TFlg){
               if (PrintToFile(FirstFPrint, 11)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                    Unsteady Filling "
                             "Equation (Solve for z)\n\n\r");
                     fprintf(Ofile, "                     Atrium filling time for"
                             " unsteady fire\n\n\n\r");
                  }
                  fprintf(Ofile,
                     "    ceiling height above fire       H (%s):   %8.2f\n\r"
                     "    cross-sectional area of atrium  A (%s): %8.2f\n\r"
                     "    fire growth constant (Menu)     a (%s):  %7.5f\n\r"
                     "    time                            t (s):    %8.2f\n\n\r"
                     ,Len[SI+1], Length(H), Ara[SI+1], Area(A), Growth[SI+1],
                     Alg0, t);
                  fprintf(Ofile, "At %7.0f seconds, the fire is %9.0f kW or %9.0f"
                          " Btu/s.\n\n\r",
                          t, Q, Q/EnergyFactor);
                  if (Under(Z/H, 0.19999)){
                     Zes = 0.2*H;
                     fprintf(Ofile, "Outside range of equation, but z is less "
                             "than %6.1f m or %7.1f ft\n\n\r",
                             Zes, Zes/LengthFactor);
                  }
                  else if(Over(Z/H, 1.0))
                     fprintf(Ofile, "The smoke layer under the ceiling has not "
                             "yet begun to descend\n\n\r");
                  else
                     fprintf(Ofile, "Height of smoke layer above fire, z is %7.1f"
                             " m or %7.1f ft\n\n\r", Z, Z/LengthFactor);
                  if (GronkFlag)
                     fprintf(Ofile, "\n\rCaution: A/H^2 = %7.4f "
                             "This is outside the intended range of 1. to 23.",
                             Shape);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 3)
         Crnt++;
      if (HFlg && AFlg && GFlg && TFlg && ChangeFlag){
         SlideFlag = FALSE;
         Tg = sqrt(1055./Alg);
         Q = Alg*pow(t, 2);
         ClrBlk(15, 18);
         gotoxy(3, 15);
         cprintf("At %7.0f seconds, the fire is %9.0f kW or %9.0f Btu/s.",
                 t, Q, Q/EnergyFactor);
         EEE = t*pow(Tg, -.4)*pow(H, -.8);
         Z = H*0.91*pow(EEE*pow(Shape, -.6), -1.45);
         gotoxy(3, 16);
         if (Under(Z/H, 0.19999)){
            Zes = 0.2*H;
            cprintf("Outside range of equation, but z is less than %6.1f m or "
                    "%7.1f ft", Zes, Zes/LengthFactor);
         }
         else if(Over(Z/H, 1.0))
            cprintf("The smoke layer under the ceiling has not yet begun to "
                    "descend");
         else
            cprintf("Height of smoke layer above fire, z is %7.1f m or %7.1f ft"
                    , Z, Z/LengthFactor);
         if (GronkFlag){
            gotoxy(1, 18);
            textcolor(LIGHTRED);
            cprintf("Caution: A/H^2 = %7.4f "
                    "This is outside the intended range of 1. to 23.",
                    Shape);
            textcolor(WHITE);
         }
      }
   } while(!Done);
}//End of USfill()



void USfillT(void)
/*
   USFILLT - Unsteady smoke filling - time calculation

   Routine to calculate atrium filling time for unsteady fire
Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      HFlg, AFlg, GFlg, ZFlg   Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlag                Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Height of smoke layer
      Q                        Rate of heat release
      H                        Ceiling height
      A                        cross-sectional area of atrium
      t                        Time
      Shape                    Ratio of A/H^2
      Alg                      Fire growth constant
      Tg
      EEE
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 51, Top = 6,
             H_Y = Top,
             A_Y = Top+1,
             M_Y = Top+2,
             Z_Y = Top+3,
             P_Y = Top+4,
             F_Y = Top+5,
             D_Y = Top+6;
   int Done = FALSE, ChangeFlag, Crnt = 0, HFlg = FALSE, AFlg = FALSE,
       GFlg = FALSE, ZFlg = FALSE, SlideFlag = TRUE,
       FirstFPrint = TRUE, FirstPrint = TRUE, GronkFlag1 =FALSE,
       GronkFlag2 =FALSE;
   float H, A = 0.0, t = 0.0, Alg, Alg0, Shape, Tg, Q = 0.0, Z = 0.0, EEE;
   char msg[80], Gronk1[128], Gronk2[128];
   MouseStuff Mse;
   MenuBox MB = {3, Top, 12, 59, "HAMZPFD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(21, 1);
   cprintf("Unsteady Filling Equation (Solve for t)");
   gotoxy(22, 3);
   cprintf("Atrium filling time for unsteady fire");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     ceiling height above fire        H (%s):\n\r"
           "     cross-sectional area of atrium   A (%s):\n\r"
           "     fire growth constant (Menu)      a (%s):\n\r"
           "     height of smoke layer above fire z (%s)\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Ara[SI+1],
           Growth[SI+1], Len[SI+1]);
   //Highlight the Hot Keys
   PutAt(39, H_Y, MB.Letters[0], YELLOW);
   PutAt(39, A_Y, MB.Letters[1], YELLOW);
   PutAt(28, M_Y, MB.Letters[2], YELLOW);
   PutAt(11, M_Y, 'g', YELLOW);
   PutAt(39, Z_Y, tolower(MB.Letters[3]), YELLOW);
   PutAt(6,  P_Y, MB.Letters[4], YELLOW);
   PutAt(23, F_Y, tolower(MB.Letters[5]), YELLOW);
   PutAt(6,  D_Y, MB.Letters[6], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'H': //ceiling height above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = H_Y-Top; //Update default item pointer
            GetFloat(ValXPos, H_Y, H, "%8.2f"); //Read in a value for H
            HFlg = TRUE;
            if (UnderEq(H, 0.0)){
               Message("H must be greater than Zero.");
               //Display H in red to indicate where the problem is
               PrintAt(ValXPos, H_Y, H, "%8.2f", RED);
               HFlg = FALSE;
            }
            else{
               if (!SI) //If not in SI units convert
                  H *= LengthFactor;
               if (AFlg){
                  Shape = A/pow(H, 2);
                  if (!InRange(Shape, 1.0, 23.)){
                     sprintf(msg, "A/H^2 = %7.4f "
                             "This is outside the intended range of 1. to 23.",
                             Shape);
                     Message(msg);
                     //Display H in red to indicate where the problem is
                     PrintAt(ValXPos, H_Y, Length(H), "%8.2f", RED);
                     GronkFlag1 = TRUE;
                     sprintf(Gronk1, "Caution: A/H^2 = %7.4f "
                             "This is outside the intended range of 1. to 23.",
                             Shape);
                  }
                  else{
                     PrintAt(ValXPos, A_Y, Area(A), "%8.2f", YELLOW);
                     GronkFlag1 = FALSE;
                  }
               }
               if (HFlg && ZFlg){
                  if (Under(Z/H, 0.1999)){
                     Message("z out of range, it is not intended to be less than 20% of H");
                     //Display Z in red to indicate where the problem is
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                     GronkFlag2 = TRUE;
                     sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                             "less than 20%% of H");
                  }
                  else if (Over(Z/H, 1.)){
                     Message("z out of range, it is not intended to be greater than H");
                     //Display Z in red to indicate where the problem is
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                     GronkFlag2 = TRUE;
                     sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                             "greater than H");
                  }
                  else{
                     PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                     GronkFlag2 = FALSE;
                  }
               }
            }
            break;
         case 'A': //cross-sectional area of atrium
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = A_Y-Top; //Update default item pointer
            GetFloat(ValXPos, A_Y, A, "%8.2f"); //Read in a value for A
            AFlg = TRUE;
            if (!SI)  //If not in SI units convert
               A *= AreaFactor;
            if (HFlg){
               Shape = A/(H*H);
               if (!InRange(Shape, 1.0, 23.)){
                  sprintf(msg, "A/H^2 = %7.4f "
                          "This is outside the intended range of 1. to 23.",
                          Shape);
                  Message(msg);
                  //Display A in red to indicate where the problem is
                  PrintAt(ValXPos, A_Y, Area(A), "%8.2f", RED);
                  GronkFlag1 = TRUE;
                  sprintf(Gronk1, "Caution: A/H^2 = %7.4f "
                          "This is outside the intended range of 1. to 23.",
                          Shape);
               }
               else{
                  PrintAt(ValXPos, H_Y, Length(H), "%8.2f", YELLOW);
                  GronkFlag1 = FALSE;
               }
            }
            break;
         case 'M': //fire growth constant (Menu)
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Alg0 = AlgMenu();
            GFlg = TRUE;
            Crnt = M_Y-Top; //Update default item pointer
            PrintAt(ValXPos, M_Y, Alg0, "%7.5f", YELLOW);
            Alg = Alg0;
            if (!SI) //If not in SI units convert
               Alg *= EnergyFactor;
            break;
         case 'G': //fire growth constant
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = M_Y-Top; //Update default item pointer
            GetFloat(ValXPos, M_Y, Alg0, "%7.5f"); //Read in a value for Alg0
            GFlg = TRUE;
            Alg = Alg0;
            if (!SI) //If not in SI units convert
               Alg *= EnergyFactor;
            break;
         case 'Z': //height of smoke layer above fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Z_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Top+Crnt, Z, "%8.2f"); //Read in a value for Z
            ZFlg = TRUE;
            if (!SI) //If not in SI units convert
               Z *= LengthFactor;
            if (HFlg){
               if (Under(Z/H, 0.1999)){
                  Message("z out of range, it is not intended to be less than 20% of H");
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  GronkFlag2 = TRUE;
                  sprintf(Gronk2, "Caution: z out of range, it is not intended to be less "
                          "than 20%% of H");
               }
               else if (Over(Z/H, 1.)){
                  Message("z out of range, it is not intended to be greater than H");
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  GronkFlag2 = TRUE;
                  sprintf(Gronk2, "Caution: z out of range, it is not intended to be "
                          "greater than H");
               }
               else
                  GronkFlag2 = FALSE;
            }
            break;
         case 'P': //Print results (to LPT1)
            if (HFlg && AFlg && GFlg && ZFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                    Unsteady Filling "
                          "Equation (Solve for t)\n\n\r");
                  fprintf(stdprn, "                     Atrium filling time for"
                          " unsteady fire\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
                 "     ceiling height above fire        H (%s):    %8.2f\n\r"
                 "     cross-sectional area of atrium   A (%s): %8.2f\n\r"
                 "     fire growth constant (Menu)      a (%s):   %7.5f\n\r"
                 "     height of smoke layer above fire z (%s)     %8.2f\n\n\r",
                 Len[SI+1], Length(H), Ara[SI+1], Area(A), Growth[SI+1], Alg0,
                 Len[SI+1], Length(Z));
               fprintf(stdprn, "Filling time is %7.0f seconds or %7.1f min.\n\r"
                       "  At this time, the fire is %9.0f kW or %9.0f Btu/s."
                       "\n\n\r", t, t/60.0, Q, Q/EnergyFactor);
               if (GronkFlag1)
                  fprintf(stdprn, "\n\r%s", Gronk1);
               if (GronkFlag2)
                  fprintf(stdprn, "\n\r%s", Gronk2);
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'F': //Print results to file
            if (HFlg && AFlg && GFlg && ZFlg){
               if (PrintToFile(FirstFPrint, 11)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                    Unsteady Filling "
                             "Equation (Solve for t)\n\n\r");
                     fprintf(Ofile, "                     Atrium filling time for"
                             " unsteady fire\n\n\n\r");
                  }
                  fprintf(Ofile,
                  "     ceiling height above fire        H (%s):    %8.2f\n\r"
                  "     cross-sectional area of atrium   A (%s): %8.2f\n\r"
                  "     fire growth constant (Menu)      a (%s):   %7.5f\n\r"
                  "     height of smoke layer above fire z (%s)     %8.2f\n\n\r"
                  ,Len[SI+1], Length(H), Ara[SI+1], Area(A), Growth[SI+1], Alg0,
                  Len[SI+1], Length(Z));
                  fprintf(Ofile, "Filling time is %7.0f seconds or %7.1f min.\n\r"
                          "  At this time, the fire is %9.0f kW or %9.0f Btu/s."
                          "\n\n\r", t, t/60.0, Q, Q/EnergyFactor);
                  if (GronkFlag1)
                     fprintf(Ofile, "\n\r%s", Gronk1);
                  if (GronkFlag2)
                     fprintf(Ofile, "\n\r%s", Gronk2);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 3)
         Crnt++;
      if (HFlg && AFlg && GFlg && ZFlg && ChangeFlag){
         SlideFlag = FALSE;
         Tg = sqrt(1055./Alg);
         EEE = pow(Tg, .4)*pow(H, .8)*pow(Z/H, -.69);
         t = 0.937*EEE*pow(Shape, .6);
         Q = Alg*pow(t, 2);
         ClrBlk(15, 19);
         gotoxy(3, 15);
         cprintf("Filling time is %7.0f seconds or %7.1f min.\n\r"
                 "  At this time, the fire is %9.0f kW or %9.0f Btu/s.",
                 t, t/60.0, Q, Q/EnergyFactor);
         if (GronkFlag1){
            gotoxy(1, 18);
            textcolor(LIGHTRED);
            cprintf("%s", Gronk1);
            textcolor(WHITE);
         }
         if (GronkFlag2){
            gotoxy(1, 19);
            textcolor(LIGHTRED);
            cprintf("%s", Gronk2);
            textcolor(WHITE);
         }
      }
   } while(!Done);
}//End of USfillT()



const char Tmp[2][2] = {"C", "F"};

void Splume(void)
/*
   SPLUME - Simple plume equation

   Routine calculates mass flow and temperature rise of
   an plume without correction for virtual origin
Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      QFlg, ZFlg               Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlag                Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Elevation
      Q                        Rate of heat release
      Ta                       Ambient temperature
      Zf                       Mean flame height
      M                        Mass flow
      Tp                       Average temperature
      Vflo                     Volumetric flow
      Qc
      Qq13
      Zz35
      Den
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 42, Top = 6,
             Z_Y = Top,
             Q_Y = Top+1,
             T_Y = Top+2,
             P_Y = Top+3,
             F_Y = Top+4,
             D_Y = Top+5;
   int Done = FALSE, ChangeFlag, Crnt = 0,
       QFlg = FALSE, ZFlg = FALSE, SlideFlag = TRUE,
       FirstFPrint = TRUE, FirstPrint = TRUE, GronkFlag = FALSE;
   float Z, Zf = 0.0, Q = 0.0, Qc, Ta = 21.0, Qq13, Zz35, M = 0.0, Tp = 0.0,
         Den, Vflo = 0.0;
   char msg[80];
   MouseStuff Mse;
   MenuBox MB = {2, Top, 11, 50, "ZQTPFD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(30, 1);
   cprintf("Simple plume equation");
   gotoxy(19, 3);
   cprintf("mass flow and temperature rise of an plume\n\r");
   gotoxy(23, 4);
   cprintf("without correction for virtual origin");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     Elevation                  z  (%s):\n\r"
           "     Heat release rate of fire  Q  (%s):\n\r"
           "     Ambient temperature        Ta (%s):\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Enrgy[SI+1],
           Temp[SI+1]);
   if (SI) //Display Ta in the current units
      PrintAt(ValXPos, Top+2, Ta, "%8.2f", YELLOW);
   else
      PrintAt(ValXPos, Top+2, ToF(Ta), "%8.2f", YELLOW);
   //Highlight the Hot Keys
   PutAt(33, Z_Y, tolower(MB.Letters[0]), YELLOW);
   PutAt(33, Q_Y, MB.Letters[1], YELLOW);
   PutAt(33, T_Y, MB.Letters[2], YELLOW);
   PutAt(6,  P_Y, MB.Letters[3], YELLOW);
   PutAt(23, F_Y, tolower(MB.Letters[4]), YELLOW);
   PutAt(6,  D_Y, MB.Letters[5], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'Z': //Elevation
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Z_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Z_Y, Z, "%8.2f"); //Read in a value for Z
            ZFlg = TRUE;
            if (!SI) //If not in SI units convert
               Z *= LengthFactor;
            if (QFlg){
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'Q': //Heat release rate of fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Q_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Q_Y, Q, "%8.2f"); //Read in a value for Q
            QFlg = TRUE;
            if (!SI) //If not in SI units convert
               Q *= EnergyFactor;
            Qc = 0.7*Q;
            Zf = 0.166*pow(Qc, .4);
            if (ZFlg)
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Q in red to indicate where the problem is
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            break;
         case 'T': //Ambient temperature
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = T_Y-Top; //Update default item pointer
            GetFloat(ValXPos, T_Y, Ta, "%8.2f"); //Read in a value for Ta
            if (!SI) //If not in SI units convert
               Ta = ToC(Ta);
            break;
         case 'P': //Print results (to LPT1)
            if (ZFlg && QFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                           Simple plume "
                          "equation\n\n\r");
                  fprintf(stdprn, "                 mass flow and temperature "
                          "rise of an plume\n\n\r");
                  fprintf(stdprn, "                   without correction for "
                          "virtual origin\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
                     "     Elevation                  z  (%s):    %8.2f\n\r"
                     "     Heat release rate of fire  Q  (%s): %8.2f\n\r"
                     "     Ambient temperature        Ta (%s):     %8.2f\n\n\r",
                     Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Tmp[SI+1],
                     Temperature(Ta));
               fprintf(stdprn, "At elevation z, the plume has:\n\r"
                       "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                       "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                       "  Average temperature of %10.0f   C     %10.0f   F\n\r"
                       "  Mean flame height of     %10.1f m       %10.1f ft\n\n\r",
                       M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp,
                       ToF(Tp), Zf, Zf/LengthFactor);
               if (GronkFlag)
                  fprintf(stdprn, "Caution: z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'F': //Print results to file
            if (ZFlg && QFlg){
               if (PrintToFile(FirstFPrint, 10)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                           Simple plume "
                             "equation\n\n\r");
                     fprintf(Ofile, "                 mass flow and temperature "
                             "rise of an plume\n\n\r");

                     fprintf(Ofile, "                   without correction for "
                             "virtual origin\n\n\n\r");
                  }
                  fprintf(Ofile,
                     "     Elevation                  z  (%s):    %8.2f\n\r"
                     "     Heat release rate of fire  Q  (%s): %8.2f\n\r"
                     "     Ambient temperature        Ta (%s):     %8.2f\n\n\r",
                     Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Tmp[SI+1],
                     Temperature(Ta));
                  fprintf(Ofile, "At elevation z, the plume has:\n\r"
                          "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                          "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                          "  Average temperature of %10.0f   C     %10.0f   F\n\r"
                          "  Mean flame height of     %10.1f m       %10.1f ft\n\n\r",
                          M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp,
                          ToF(Tp), Zf, Zf/LengthFactor);
                  if (GronkFlag)
                     fprintf(Ofile, "Caution: z is less than the flame height."
                                  "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 2)
         Crnt++;
      if (ZFlg && QFlg && ChangeFlag){
         SlideFlag = FALSE;
         Qq13 = pow(Qc, 1./3.);
         Zz35 = pow(Z, 5./3.);
         M = 0.071*Qq13*Zz35+0.0018*Qc;
         Tp = Ta+Qc/(M*Cp);
         Den = PAtmos/(R*(Tp+273.));
         Vflo = M/Den;
         ClrBlk(15, 21);
         gotoxy(3, 15);
         cprintf("At elevation z, the plume has:\n\r"
                 "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                 "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                 "  Average temperature of %10.0f   C    %10.0f   F\n\r"
                 "  Mean flame height of     %10.1f m       %10.1f ft",
                 M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp, ToF(Tp),
                 Zf, Zf/LengthFactor);
         if (GronkFlag){
            gotoxy(1, 21);
            textcolor(LIGHTRED);
            cprintf("Caution: z is less than the flame height."
                         "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
            textcolor(WHITE);
         }

      }
   }while(!Done);
}//End of Splume()



void Hplume(void)
/*
   HPLUME - Heskestad's plume equations

   Routine to calculate mass flow rate and average plume temperature
Varaibles:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      QFlg, FFlg, ZFlg         Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlag                Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Elevation
      Q                        Rate of heat release
      Ta                       Ambient temperature
      Zf                       Mean flame height
      Df                       Fire daimeter
      Zo                       Virtual origin
      M                        Mass flow
      Vflo                     Volumetric flow
      Tp                       Average temperature
      EEE
      Qc
      Qq13
      Qq23
      Den
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 45, Top = 6,
             Z_Y = Top,
             Q_Y = Top+1,
             F_Y = Top+2,
             T_Y = Top+3,
             P_Y = Top+4,
             R_Y = Top+5,
             D_Y = Top+6;
   int Done = FALSE, ChangeFlag, Crnt = 0,
       QFlg = FALSE, FFlg = FALSE, ZFlg = FALSE,
       FirstFPrint = TRUE, SlideFlag = TRUE, FirstPrint = TRUE,
       GronkFlag = FALSE;
   float EEE, Z, Zo = 0.0, Zf, Df = 0.0, Q = 0.0, Qc, Ta = 21.0, Qq13, Qq23, M = 0.0, Tp = 0.0, Den, Vflo = 0.0;
   char msg[80];
   MouseStuff Mse;
   MenuBox MB = {3, Top, 12, 53, "ZQFTPRD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(23, 1);
   cprintf("Plume With Virtual Origin Correction");
   gotoxy(18, 3);
   cprintf("Mass flow rate and average plume temperature");

   //Display the menu
   gotoxy(1, Top);
   cprintf("     Elevation                  z  (%s):\n\r"
           "     Heat release rate of fire  Q  (%s):\n\r"
           "     fire diameter              Df (%s):\n\r"
           "     Ambient temperature        Ta (%s):\n\r"
           "     Print results (to LPT1)\n\r"
           "     Print results to file disabled\n\r"
           "     Done (return to main menu)", Len[SI+1], Enrgy[SI+1], Len[SI+1],
           Temp[SI+1]);
   if (SI) //Display Ta in the current units
      PrintAt(ValXPos, Top+3, Ta, "%8.2f", YELLOW);
   else
      PrintAt(ValXPos, Top+3, ToF(Ta), "%8.2f", YELLOW);
   //Highlight the Hot Keys
   PutAt(33, Z_Y, tolower(MB.Letters[0]), YELLOW);
   PutAt(33, Q_Y, MB.Letters[1], YELLOW);
   PutAt(34, F_Y, tolower(MB.Letters[2]), YELLOW);
   PutAt(33, T_Y, MB.Letters[3], YELLOW);
   PutAt(6,  P_Y, MB.Letters[4], YELLOW);
   PutAt(12, R_Y, tolower(MB.Letters[5]), YELLOW);
   PutAt(6,  D_Y, MB.Letters[6], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'Z': //Elevation
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Z_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Z_Y, Z, "%8.2f"); //Read in a value for Z
            ZFlg = TRUE;
            if (!SI) //If not in SI units convert
               Z *= LengthFactor;
            if (QFlg && FFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", YELLOW);
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'Q': //Heat release rate of fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Q_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Q_Y, Q, "%8.2f"); //Read in a value for Q
            QFlg = TRUE;
            if (!SI) //If not in SI units convert
               Q *= EnergyFactor;
            Qc = 0.7*Q;
            if (ZFlg && FFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Q in red to indicate where the problem is
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'F': //fire diameter
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = F_Y-Top; //Update default item pointer
            GetFloat(ValXPos, F_Y, Df, "%8.2f"); //Read in a value for Df
            FFlg = TRUE;
            if (!SI) //If not in SI units convert
               Df *= LengthFactor;
            if (ZFlg && QFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Df in red to indicate where the problem is
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", RED);
                  GronkFlag = TRUE;
               }
               else{
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", YELLOW);
                  GronkFlag = FALSE;
               }
            }
            break;
         case 'T': //Ambient temperature
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = T_Y-Top; //Update default item pointer
            GetFloat(ValXPos, T_Y, Ta, "%8.2f"); //Read in a value for Ta
            if (!SI) //If not in SI units convert
               Ta = ToC(Ta);
            break;
         case 'P': //Print results (to LPT1)
            if (ZFlg && QFlg && FFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                     Plume With Virtual "
                          "Origin Correction\n\n\r");
                  fprintf(stdprn, "                 Mass flow rate and average "
                          "plume temperature\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
                     "     Elevation                  z  (%s):    %8.2f\n\r"
                     "     Heat release rate of fire  Q  (%s): %8.2f\n\r"
                     "     fire diameter              Df (%s):    %8.2f\n\r"
                     "     Ambient temperature        Ta (%s):     %8.2f\n\n\r",
                     Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Len[SI+1],
                     Length(Df), Tmp[SI+1], Temperature(Ta));
               fprintf(stdprn, "At elevation z, the plume has:\n\r"
                       "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                       "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                       "  Average temperature of %10.0f   C     %10.0f   F\n\r"
                       "  Virtual origin at        %10.1f m       %10.1f ft\n\r"
                       "  Mean flame height of     %10.1f m       %10.1f ft\n\n\r"
                       , M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp,
                       ToF(Tp), Zo, Zo/LengthFactor, Zf, Zf/LengthFactor);
               if (GronkFlag)
                  fprintf(stdprn, "\n\rCaution: z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'R': //Print results to file
            if (ZFlg && QFlg && FFlg){
               if (PrintToFile(FirstFPrint, 11)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                     Plume With Virtual "
                             "Origin Correction\n\n\r");
                     fprintf(Ofile, "                 Mass flow rate and average "
                             "plume temperature\n\n\n\r");
                  }
                  fprintf(Ofile,
                     "     Elevation                  z  (%s):    %8.2f\n\r"
                     "     Heat release rate of fire  Q  (%s): %8.2f\n\r"
                     "     fire diameter              Df (%s):    %8.2f\n\r"
                     "     Ambient temperature        Ta (%s):     %8.2f\n\n\r",
                     Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Len[SI+1],
                     Length(Df), Tmp[SI+1], Temperature(Ta));
                  fprintf(Ofile, "At elevation z, the plume has:\n\r"
                       "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                       "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                       "  Average temperature of %10.0f   C     %10.0f   F\n\r"
                       "  Virtual origin at        %10.1f m       %10.1f ft\n\r"
                       "  Mean flame height of     %10.1f m       %10.1f ft\n\n\r"
                       , M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp,
                       ToF(Tp), Zo, Zo/LengthFactor, Zf, Zf/LengthFactor);
                  if (GronkFlag)
                     fprintf(Ofile, "\n\rCaution: z is less than the flame height."
                                  "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 3)
         Crnt++;
      if (ZFlg && QFlg && FFlg && ChangeFlag){
         SlideFlag = FALSE;
         Zo = 0.083*pow(Q, .4)-1.02*Df;
         EEE = pow(Z-Zo, 5./3.);
         Qq13 = pow(Qc, 1./3.);
         Qq23 = pow(Qc, 2./3.);
         M = 0.071*Qq13*EEE*(1.+0.026*Qq23/EEE);
         Tp = Ta+Qc/(M*Cp);
         Den = PAtmos/(R*(Tp+273.));
         Vflo = M/Den;

         ClrBlk(15, 22);
         gotoxy(3, 15);
         cprintf("At elevation z, the plume has:\n\r"
                 "  Mass flow of             %10.1f kg/s    %10.1f lb/s\n\r"
                 "  Volumetric flow of       %10.1f m^3/s %10.0f   cfm\n\r"
                 "  Average temperature of %10.0f   C    %10.0f   F\n\r"
                 "  Virtual origin at        %10.1f m       %10.1f ft\n\r"
                 "  Mean flame height of     %10.1f m       %10.1f ft",
                 M, M*MassFlowFactor, Vflo, Vflo/VolFlowFactor, Tp, ToF(Tp),
                 Zo, Zo/LengthFactor, Zf, Zf/LengthFactor);
         if (GronkFlag){
            gotoxy(1, 22);
            textcolor(LIGHTRED);
            cprintf("Caution: z is less than the flame height."
                         "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
            textcolor(WHITE);
         }
      }
   }while(!Done);
}//End of Hplume()



void Cplume(void)
/*
   CLPLUME - Centerline plume temperature

   Routine to calculate centerline plume temperature
Variables:
   int
      Done                     Flag - user is finished with function
      ChangeFlag               Flag - an equation variable has changed
      QFlg, FFlg, ZFlg, XFlg   Flags - equation variables have values
      FirstPrint               Flag - indicates first time printing this func.
      SlideFlag                Flag - indicates first time through menu
      Crnt                     Points to the current default variable
      CurXPos                  X displacement of the marker character
      ValXPos                  X displacement for value echo
   float
      Z                        Height of smoke layer
      Q                        Rate of heat release
      Ta                       Ambient temperature
      Df                       fire diameter
      Zo                       Virtual origin
      Zf                       Mean flame height
      Tcp                      Centerline temperature
      XX                       Convective fraction of heat release
      Qc
      CC
      Den
   char
      msg[80]                  Buffer for error messages

*/
{
   const int ValXPos = 48, Top = 6,
             Z_Y = Top,
             Q_Y = Top+1,
             F_Y = Top+2,
             C_Y = Top+3,
             T_Y = Top+4,
             P_Y = Top+5,
             R_Y = Top+6,
             D_Y = Top+7;
   int Done = FALSE, ChangeFlag, Crnt = 0, QFlg = FALSE, FFlg = FALSE,
       ZFlg = FALSE, XFlg = FALSE, SlideFlag = TRUE,
       FirstFPrint = TRUE, FirstPrint = TRUE, GronkFlag1 = FALSE,
       GronkFlag2 = FALSE;
   float Z, Zo = 0.0, Zf, Df = 0.0, Q = 0.0, Qc, Tcp = 0.0, CC, Ta = 21.0, Den, XX;
   char msg[80];
   MouseStuff Mse;
   MenuBox MB = {4, Top, 13, 56, "ZQFCTPRD"};

   //Display the onscreen title
   mouse->Hide();
   clrscr();
   gotoxy(26, 1);
   cprintf("Plume Centerline Temperature");
   gotoxy(21, 3);
   cprintf("calculate centerline plume temperature");

   //Display the menu
   gotoxy(1, Top);
   cprintf("Elevation                              z  (%s):\n\r"
           "Heat release rate of fire              Q  (%s):\n\r"
           "fire diameter                          Df (%s):\n\r"
           "Convective fraction of heat release (0.6 to 1):\n\r"
           "Ambient temperature                    Ta (%s):\n\r"
           "Print results (to LPT1)\n\r"
           "Print results to file disabled\n\r"
           "Done (return to main menu)", Len[SI+1], Enrgy[SI+1], Len[SI+1],
           Temp[SI+1]);
   if (SI) //Display Ta in the current units
      PrintAt(ValXPos, 10, Ta, "%8.2f", YELLOW);
   else
      PrintAt(ValXPos, 10, ToF(Ta), "%8.2f", YELLOW);
   //Highlight the Hot Keys
   PutAt(40, Z_Y, tolower(MB.Letters[0]), YELLOW);
   PutAt(40, Q_Y, MB.Letters[1], YELLOW);
   PutAt(41, F_Y, tolower(MB.Letters[2]), YELLOW);
   PutAt(1,  C_Y, MB.Letters[3], YELLOW);
   PutAt(40, T_Y, MB.Letters[4], YELLOW);
   PutAt(1,  P_Y, MB.Letters[5], YELLOW);
   PutAt(7,  R_Y, tolower(MB.Letters[6]), YELLOW);
   PutAt(1,  D_Y, MB.Letters[7], YELLOW);
   mouse->Show();

   do{//Main loop
      //Capture and interpret user keystrokes
      switch (GetKey(Crnt, ChangeFlag, Mse, MB)){
         case 'Z': //Elevation
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Z_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Z_Y, Z, "%8.2f"); //Read in a value for Z
            ZFlg = TRUE;
            if (!SI) //If not in SI units convert
               Z *= LengthFactor;
            if (QFlg && FFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Z in red to indicate where the problem is
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", RED);
                  GronkFlag1 = TRUE;
               }
               else{
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", YELLOW);
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", YELLOW);
                  GronkFlag1 = FALSE;
               }
            }
            break;
         case 'Q': //Heat release rate of fire
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = Q_Y-Top; //Update default item pointer
            GetFloat(ValXPos, Q_Y, Q, "%8.2f"); //Read in a value for Q
            QFlg = TRUE;
            if (!SI) //If not in SI units convert
               Q *= EnergyFactor;
            if (ZFlg && FFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Q in red to indicate where the problem is
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", RED);
                  GronkFlag1 = TRUE;
               }
               else{
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", YELLOW);
                  GronkFlag1 = FALSE;
               }
            }
            break;
         case 'F': //fire diameter
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = F_Y-Top; //Update default item pointer
            GetFloat(ValXPos, F_Y, Df, "%8.2f"); //Read in a value for Df
            FFlg = TRUE;
            if (!SI) //If not in SI units convert
               Df *= LengthFactor;
            if (ZFlg && QFlg){
               Zf = 0.235*pow(Q, .4)-1.02*Df;
               if (UnderEq(Z, Zf)){
                  sprintf(msg, "z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  Message(msg);
                  //Display Df in red to indicate where the problem is
                  PrintAt(ValXPos, F_Y, Length(Df), "%8.2f", RED);
                  GronkFlag1 = TRUE;
               }
               else{
                  PrintAt(ValXPos, Z_Y, Length(Z), "%8.2f", YELLOW);
                  PrintAt(ValXPos, Q_Y, Energy(Q), "%8.2f", YELLOW);
                  GronkFlag1 = FALSE;
               }
            }
            break;
         case 'C': //Convective fraction of heat release
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = C_Y-Top; //Update default item pointer
            GetFloat(ValXPos, C_Y, XX, "%8.2f"); //Read in a value for XX
            XFlg = TRUE;
            if (!InRange1(XX, 0.0, 1.0)){
               Message("Convective fraction must be in range (0.0 > C <= 1.0)");
               //Display XX in red to indicate where the problem is
               PrintAt(ValXPos, C_Y, XX, "%8.2f", RED);
               XFlg = FALSE;
            }
            else if (Under(XX, 0.6)){
               PrintAt(ValXPos, C_Y, XX, "%8.2f", RED);
               Message("Convective fraction is intended to be in range "
                       "(0.6, 1.0)");
               GronkFlag2 = TRUE;
            }
            else
               GronkFlag2 = FALSE;

            break;
         case 'T': //Ambient temperature
            //Erase the previous cursor
            PutAt(MB.CurX, Top+Crnt, ' ', LIGHTRED);
            Crnt = T_Y-Top; //Update default item pointer
            GetFloat(ValXPos, T_Y, Ta, "%8.2f"); //Read in a value for Ta
            if (!SI) //If not in SI units convert
               Ta = ToC(Ta);
            break;
         case 'P': //Print results (to LPT1)
            if (ZFlg && QFlg && FFlg && XFlg){
               if (FirstPrint){
                  fprintf(stdprn, "\n\r                         Plume "
                          "Centerline Temperature\n\n\r");
                  fprintf(stdprn, "                    calculate centerline "
                          "plume temperature\n\n\n\r");
                  FirstPrint = FALSE;
               }
               fprintf(stdprn,
               "Elevation                              z  (%s):    %8.2f\n\r"
               "Heat release rate of fire              Q  (%s): %8.2f\n\r"
               "fire diameter                          Df (%s):    %8.2f\n\r"
               "Convective fraction of heat release (0.6 to 1):    %8.2f\n\r"
               "Ambient temperature                    Ta (%s):     %8.2f\n\n\r"
               ,Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Len[SI+1],
               Length(Df), XX, Tmp[SI+1], Temperature(Ta));
               fprintf(stdprn, "At elevation z, the plume has:\n\r"
                       "Centerline temperature %10.0f   C %10.0f   F\n\r"
                       "Virtual origin at        %10.1f m   %10.1f ft\n\r"
                       "Mean flame height of     %10.1f m   %10.1f ft\n\n\r",
                       Tcp, ToF(Tcp), Zo, Zo/LengthFactor, Zf,
                       Zf/LengthFactor);
               if (GronkFlag1)
                  fprintf(stdprn, "Caution: z is less than the flame height."
                               "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
               if (GronkFlag2)
                  fprintf(stdprn, "Caution: Convective fraction is intended to "
                          "be in range (0.6, 1.0)");
               fprintf(stdprn, "%s", Seperator);
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'R': //Print results to file
            if (ZFlg && QFlg && FFlg && XFlg){
               if (PrintToFile(FirstFPrint, 12)){
                  if (FirstFPrint){
                     fprintf(Ofile, "\n\r                         Plume "
                             "Centerline Temperature\n\n\r");
                     fprintf(Ofile, "                    calculate centerline "
                             "plume temperature\n\n\n\r");
                  }
                  fprintf(Ofile,
                     "Elevation                              z  (%s):    %8.2f\n\r"
                     "Heat release rate of fire              Q  (%s): %8.2f\n\r"
                     "fire diameter                          Df (%s):    %8.2f\n\r"
                     "Convective fraction of heat release (0.6 to 1):    %8.2f\n\r"
                     "Ambient temperature                    Ta (%s):     %8.2f\n\n\r",
                     Len[SI+1], Length(Z), Enrgy[SI+1], Energy(Q), Len[SI+1],
                     Length(Df), XX, Tmp[SI+1], Temperature(Ta));
                  fprintf(Ofile, "At elevation z, the plume has:\n\r"
                          "Centerline temperature %10.0f   C %10.0f   F\n\r"
                          "Virtual origin at        %10.1f m   %10.1f ft\n\r"
                          "Mean flame height of     %10.1f m   %10.1f ft\n\n\r",
                          Tcp, ToF(Tcp), Zo, Zo/LengthFactor, Zf,
                          Zf/LengthFactor);
                  if (GronkFlag1)
                     fprintf(Ofile, "Caution: z is less than the flame height."
                                  "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
                  if (GronkFlag2)
                     fprintf(Ofile, "Caution: Convective fraction is intended to "
                             "be in range (0.6, 1.0)");
                  fprintf(Ofile, "%s", Seperator);
               }
            }
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
         case 'D': //Done (return to main menu)
            fclose(Ofile);
            Done = TRUE;
         default:
            ChangeFlag = FALSE; //Keep cursor at current position
            break;
      }
      if (SlideFlag && ChangeFlag && Crnt < 4)
         Crnt++;
      if (ZFlg && QFlg && FFlg && XFlg && ChangeFlag){
         SlideFlag = FALSE;
         Qc = XX*Q;
         Den = PAtmos/(R*(Ta+273.));
         CC=  9.1*pow((Ta+273.)/(G*pow(Cp, 2)*pow(Den, 2)), 1./3.);
         Zo = 0.083*pow(Q, .4)-1.02*Df;
         Tcp = Ta+CC*pow(Qc, 2./3.)/pow(Z-Zo, 5./3.);
         ClrBlk(15, 21);
         gotoxy(3, 15);
         cprintf("At elevation z, the plume has:\n\r"
                 "Centerline temperature %10.0f   C %10.0f   F\n\r"
                 "Virtual origin at        %10.1f m    %10.1f ft\n\r"
                 "Mean flame height of     %10.1f m    %10.1f ft",
                 Tcp, ToF(Tcp), Zo, Zo/LengthFactor, Zf, Zf/LengthFactor);
         if (GronkFlag1){
            gotoxy(1, 20);
            textcolor(LIGHTRED);
            cprintf("Caution: z is less than the flame height."
                         "(%6.1f[m] %6.1f [ft])", Zf, Zf/LengthFactor);
            textcolor(WHITE);
         }
         if (GronkFlag2){
            gotoxy(1, 21);
            textcolor(LIGHTRED);
            cprintf("Caution: Convective fraction is intended to "
                    "be in range (0.6, 1.0)");
            textcolor(WHITE);
         }
      }
   }while(!Done);
}//End of Cplume()



char State;

void GetFloat(int X, int Y, float &Val, char *form)
/* */
{
   int Pos = 0, Done = FALSE;
   char Ch, Line[80], Blank[21] = {"                    "};
   float PreviousValue = Val;

   _setcursortype(_SOLIDCURSOR);
   textcolor(YELLOW);

   State = 'S';
   mouse->Hide();
   gotoxy(X, Y);
   cprintf("%s", Blank);
   gotoxy(X, Y);
   do {
      switch(Ch = Pause()){
         case 0x1B:            //Escape key
            Pos = 0;
            Done = TRUE;
            break;
         case 0x0D:            //Return key
            Line[Pos] = NULL;
            Done = TRUE;
            break;
         case 0x08:            //Backspace key
            if (Pos > 0){
               gotoxy(X+Pos, Y);
               putch(' ');
               gotoxy(X+Pos, Y);
               Pos--;
               if (State == '2')
                  State = '1';
            }
            break;
         default:
            if (ValidChar(Ch)){
               Line[Pos++] = Ch;
               gotoxy(X+Pos, Y);
               putch(Ch);
               if (State == 'E'){
                  Line[Pos] = NULL;
                  Done = TRUE;
               }
            }
      }
   }while(!Done);
   if (Pos){
      sscanf(Line, "%f", &Val);
   }
   else
      Val = PreviousValue;
   gotoxy(X, Y);
   cprintf("%s", Blank);
   PrintAt(X, Y, Val, form, YELLOW);
   _setcursortype(_NOCURSOR);
   mouse->Show();
}//End of GetFloat()



int ValidChar(char Ch)
/* */
{
   switch (State){
      case 'S':
         switch (toupper(Ch)){
            case '+':
            case '-':
               State = '1';
               return TRUE;
            case '.':
               State = '2';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = '1';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
      case '1':
         switch (toupper(Ch)){
            case 0X0D:
               State = 'E';
               return TRUE;
            case '.':
               State = '2';
               return TRUE;
            case 'E':
               State = '3';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = '1';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
      case '2':
         switch (toupper(Ch)){
            case 0X0D:
               State = 'E';
               return TRUE;
            case 'E':
               State = '3';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = '2';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
      case '3':
         switch (toupper(Ch)){
            case '+':
            case '-':
               State = 'A';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = '4';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
      case 'A':
         if (isdigit(Ch)){
            State = '4';
            return TRUE;
         }
         else{
            Beep();
            return FALSE;
         }
      case '4':
         switch (toupper(Ch)){
            case 0X0D:
               State = 'E';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = '5';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
      case '5':
         switch (toupper(Ch)){
            case 0X0D:
               State = 'E';
               return TRUE;
            default:
               if (isdigit(Ch)){
                  State = 'E';
                  return TRUE;
               }
               else{
                  Beep();
                  return FALSE;
               }
         }
   }
   Beep();
   return FALSE; //Just to satisfy the syntax checker!
}//End of ValidChar()



void Beep(void)
/* */
{
   sound(2000);
   delay(250);
   nosound();
}//End of Beep()



void ClrBlk(int R1, int R2)
//his function clears the specified screen lines
{
   int i;

   mouse->Hide();
   for (i = R1; i <= R2; i++){
      gotoxy(1, i);
      clreol();
   }
   mouse->Show();
}//End of ClrBlk()



void Message(char *Msg)
//This function displays a message in a window
{
   const int Left = 3, Top = 14, Right = Left+75, Bottom = Top+4;
   int i;
   char buffer[(Right-Left+1)*(Bottom-Top+1)*2],
        UL = 0XDA, UR = 0XBF, LL = 0XC0, LR = 0XD9, Hor = 0XC4, Ver = 0XB3;

   mouse->Hide();
   //Save the windows background
   gettext(Left, Top, Right, Bottom, buffer);

   //Clear the area
   window(Left, Top, Right, Bottom);
   textbackground(CYAN);
   clrscr();
   window(1, 1, 80, 25);

   //Draw a border for the window
   PutAt(Left, Top, UL, WHITE);
   for (i = Left+1; i < Right; i++)
      putch(Hor);
   PutAt(Right, Top, UR, WHITE);
   PutAt(Left, Bottom, LL, WHITE);
   for (i = Left+1; i < Right; i++)
      putch(Hor);
   PutAt(Right, Bottom, LR, WHITE);
   for (i = Top+1; i < Bottom; i++){
      PutAt(Left,  i, Ver, WHITE);
      PutAt(Right, i, Ver, WHITE);
   }
   gotoxy(Left+(Right-Left)/2-12, Bottom);
   cprintf("press any key to continue");

   //Display message
   gotoxy(Left+1, Top+1);
   cprintf("%s", Msg);
   mouse->Show();
   Pause();

   //lean up and go home
   mouse->Hide();
   textbackground(BLUE);
   puttext(Left, Top, Right, Bottom, buffer);
   mouse->Show();
}//End of Message()



void PrintAt(int X, int Y, float Val, char *Form, int Color)
//this function prints a float value at the specified location and color
{
   mouse->Hide();
   textcolor(Color);
   gotoxy(X, Y);
   cprintf(Form, Val);
   textcolor(WHITE);
   mouse->Show();
}//End of PrintAt()



void PutAt(int X, int Y, char Ch, int Color)
//This function puts a character at the specified place and color
{
   mouse->Hide();
   textcolor(Color);
   gotoxy(X, Y);
   putch(Ch);
   textcolor(WHITE);
   mouse->Show();
}//End of PutAt()



float AlgMenu(void)
//This function allows the user to choose a growth constant from a list
{
   const int Left = 15, Top = 9, Right = Left+28, Bottom = Top+6;
   int Done;
   float Alg[4][2] = {{0.002931, 0.002778},
                      {0.01172,  0.01111},
                      {0.04689,  0.04444},
                      {0.1878,   0.1778}}, Val;
   char Ch, buffer[(Right-Left+1)*(Bottom-Top+1)*2];
   MouseStuff Mse;

   mouse->Hide();
   gettext(Left, Top, Right, Bottom, buffer);
   window(Left, Top, Right, Bottom);
   textcolor(BLUE);
   textbackground(CYAN);
   clrscr();
   cprintf("Growth ConstantsĿ"
           "Time-Squared Fires %s "
           "Slow              %8.6f "
           "Medium            %8.6f "
           "Fast              %8.6f "
           "Ultra-Fast        %8.6f "
           "",
          Growth[SI+1], Alg[0][SI+1], Alg[1][SI+1], Alg[2][SI+1], Alg[3][SI+1]);
   window(1, 1, 80, 25);
   //Highlight the Hot Keys
   PutAt(Right, Bottom, '', BLUE);
   PutAt(Left+1, Top+2, 'S', YELLOW);
   PutAt(Left+1, Top+3, 'M', YELLOW);
   PutAt(Left+1, Top+4, 'F', YELLOW);
   PutAt(Left+1, Top+5, 'U', YELLOW);
   textbackground(BLUE);
   mouse->Show();
   do{
      Done = TRUE;
      Ch = toupper(char(GetAction(Mse)));
      if (Mse.Me == LMouseDown){
         if (Mse.X > 14 && Mse.X < 42 && Mse.Y > 9 && Mse.Y < 14)
            Val = Alg[Mse.Y-10][SI+1];
         else
            Done = FALSE;
      }
      else
         switch(Ch){
            case 'S':
               Val = Alg[0][SI+1];
               break;
            case 'M':
               Val = Alg[1][SI+1];
               break;
            case 'F':
               Val = Alg[2][SI+1];
               break;
            case 'U':
               Val = Alg[3][SI+1];
               break;
            default:
               Done = FALSE;
               break;
         }
   }while(!Done);
   mouse->Hide();
   puttext(Left, Top, Right, Bottom, buffer);
   mouse->Show();
   return Val;
}//End of AlgMenu()



float Length(float Val)
//
{
   if (SI)
      return Val;
   else
      return Val/LengthFactor; //Return Val converted to SI
}//End of Length()



float Area(float Val)
//
{
   if (SI)
      return Val;
   else
      return Val/AreaFactor; //Return Val converted to SI
}//End of Area()



float Energy(float Val)
//
{
   if (SI)
      return Val;
   else
      return Val/EnergyFactor; //Return Val converted to SI
}//End of Energy()



float ToC(float Val)
//
{
   return (Val-32.0)/1.8;
}//End of ToC()



float ToF(float Val)
//
{
   return Val*1.8+32.0;
}//End of ToF()



float Temperature(float Val)
//
{
   if (SI)
      return Val;
   else
      return ToF(Val); //Return Val converted to SI
}//End of Temperature()



char GetKey(int &Crnt, int &ChangeFlag, MouseStuff &Mse, MenuBox MB)
//
{
   unsigned C;
   char Ch;

   //Set the current cursor
   PutAt(MB.CurX, MB.Top+Crnt, Marker, LIGHTRED);
   ChangeFlag = TRUE;

   C = GetAction(Mse);
   Ch = toupper((char) C);

   if (C == UpKey || C == DownKey){
      //Erase the previous cursor
      PutAt(MB.CurX, MB.Top+Crnt, ' ', LIGHTRED);
      if (C == UpKey)    //Up arrow
         if (Crnt > 0)
            Crnt--;
         else
            Crnt = MB.Limit;
      else              //Down arrow
         if (Crnt < MB.Limit)
            Crnt++;
         else
            Crnt = 0;
      ChangeFlag = FALSE; //Keep cursor at current position
   }
   else if (isdigit(Ch) || Ch == '.'){
      ungetch(Ch);
      Ch = MB.Letters[Crnt];
   }
   else if (C == CrKey)
      Ch = MB.Letters[Crnt];
   else if (Mse.Me == RMouseDown)
      Ch = 'D';
   else if (Mse.Me == LMouseDown)
      if (Mse.Y > MB.Top-2 && Mse.Y < MB.Bot+1)
         Ch = MB.Letters[Mse.Y-MB.Top+1];
      else
         Ch = NULL;
   return Ch;
}//End of GetKey()



void GetFileName(char *FileName)
//
{
   const int Left = 15, Top = 9, Right = Left+47, Bottom = Top+2;
   int Pos = 0, Done = FALSE, X = Left+34, Y = Top+1;
   char buffer[(Right-Left+1)*(Bottom-Top+1)*2];
   char Ch, State = 'S';

   mouse->Hide();
   gettext(Left, Top, Right, Bottom, buffer);
   window(Left, Top, Right, Bottom);
   textcolor(BLUE);
   textbackground(CYAN);
   clrscr();
   _setcursortype(_NORMALCURSOR);
   cprintf("Ŀ"
           "Enter a name for the output file:             "
           "");
   window(1, 1, 80, 25);
   PutAt(Right, Bottom, '', BLUE);
   _setcursortype(_SOLIDCURSOR);
   textcolor(YELLOW);
   textbackground(CYAN);
   gotoxy(X, Y);
   do {
      switch(Ch = Pause()){
         case 0x1B:            //Escape key
            Pos = 0;
            Done = TRUE;
            break;
         case 0x0D:            //Return key
            FileName[Pos] = NULL;
            Done = TRUE;
            break;
         case 0x08:            //Backspace key
            if (Pos > 0){
               gotoxy(X+Pos, Y);
               putch(' ');
               gotoxy(X+Pos, Y);
               Pos--;
            }
            break;
         default:
            if (ValidName(Ch, State)){
               FileName[Pos++] = Ch;
               gotoxy(X+Pos, Y);
               putch(Ch);
               if (State == 'X'){
                  FileName[Pos] = NULL;
                  Done = TRUE;
               }
            }
      }
   }while(!Done);
   textbackground(BLUE);
   _setcursortype(_NOCURSOR);
   puttext(Left, Top, Right, Bottom, buffer);
   mouse->Show();
}//End of GetFileName()



int ValidName(char Ch, char &State)
//
{
   switch (State){
      case 'S':       //First character of file name must be alpha
         if (isalpha(Ch)){
            State = 'A';
            return TRUE;
         }
         break;
      case 'A':       //Next seven (or less) characters may be alpha numeric
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
         if (isalnum(Ch) || Ch == '_' || Ch == '$' || Ch == '-'){
            State++;
            return TRUE;
         }
         else if (Ch == '.'){
            State = 'I';
            return TRUE;
         }
         break;
      case 'H':       //Any additional characters must be after the '.'
         if (Ch == '.'){
            State = 'I';
            return TRUE;
         }
         break;
      case 'I':       //Three 'extension' characters are allowed
      case 'J':
         if (isalnum(Ch) || Ch == '_' || Ch == '$' || Ch == '-'){
            State++;
            return TRUE;
         }
         break;
      case 'K':
         if (isalnum(Ch) || Ch == '_' || Ch == '$' || Ch == '-'){
            State = 'X';  //'X' means force an end here
            return TRUE;
         }
         break;
   }
   return FALSE;
}//End of ValidName()



unsigned GetAction(MouseStuff &Mse)
//
{
   unsigned Key;

   do{
      Mse.Me = mouse->Event(Mse.X, Mse.Y);
      Key  = KeyEvent();
   }while(Mse.Me != LMouseDown && Mse.Me != RMouseDown && Key == 0);
   return Key;
}//End of GetAction()


int PrintToFile(int &FirstFPrint, int Y)
{
   const int X1 = 23, X2 = 42;
   int PrintF = TRUE;
   char Ch, msg[80];
   static char OFileName[13];

   mouse->Hide();
   if (Ofile){
      textbackground(CYAN);
      gotoxy(X2, Y);
      cprintf("Append to the file: %s (Y/N)", OFileName);
      do{
         Ch = toupper(Pause());
      }while(Ch != 'Y' && Ch != 'N');
      if (Ch == 'Y')
         FirstFPrint = FALSE;
      else{
         fclose(Ofile);
         FirstFPrint = TRUE;
      }
      textbackground(BLUE);
      gotoxy(X2, Y);
      clreol();
   }
   else
      FirstFPrint = TRUE;
   if (FirstFPrint){
      GetFileName(OFileName);
      gotoxy(X1, Y);
      clreol();
      cprintf("%s", OFileName);
      if ((Ofile = fopen(OFileName, "at")) == NULL){
         PrintF = FALSE;
         sprintf(msg, "\n        The file: %s could not be opened.", OFileName);
         Message(msg);
         gotoxy(X1, Y);
         clreol();
         cprintf("disabled");
      }
      else
         FirstFPrint = TRUE;
   }
   mouse->Show();
   return PrintF;
}//End of PrintToFile()



long InRange(float Value, float Lower, float Upper)
{
   if (Under(Value, Lower) || Over(Value, Upper))
      return FALSE;
   return TRUE;
}//End of InRange()



long InRange1(float Value, float Lower, float Upper)
{
   if (UnderEq(Value, Lower) || Over(Value, Upper))
      return FALSE;
   return TRUE;
}//End of InRange1()


long Under(float Value, float Limit)
{
   if (Round(Value) < Round(Limit))
      return TRUE;
   return FALSE;
}//End of Under()



long UnderEq(float Value, float Limit)
{
   if (Round(Value) <= Round(Limit))
      return TRUE;
   return FALSE;
}//End of Under()



long Over(float Value, float Limit)
{
   if (Round(Value) > Round(Limit))
      return TRUE;
   return FALSE;
}//End of Over()



long Round(float Value)
{
   return long(Value*Factor);
}//End of Round()