#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <math.h>
#include "msmouse.h"
#include "keybrd.h"

//Mouse object
extern MouseObject *mouse;

struct MouseStuff {
   unsigned Me;
   int X;
   int Y;
};

struct MenuBox{
   int Limit;
   int Top;
   int Bot;
   int CurX;
   char *Letters;
};

const int TRUE = -1;
const int FALSE = 0;
extern int SI;
const float LengthFactor = 0.3048;     //Converts ft to Meters
const float AreaFactor = 0.0929;       //Converts ft^2 to m^2
extern char Len[2][3], Enrgy[2][6], Ara[2][5], Growth[2][8], Temp[2][3];

// Function prototypes
char  GetKey(int &, int &, MouseStuff &, MenuBox);
void  F970(float, float &, float, float, float, float, float, float, float,
           int &, int &, int, int, FILE *);
void  F880(float, float [], float &, float [], int);
void  PutAt(int, int, char, int);
void  PrintAt(int, int, float, char *, int);
void  GetFloat(int, int, float &, char *);
float AlgMenu1(void);
void  Message(char *);
void  XtraPts(float, float, const int);
void  GetFileName(char *);
void  PrintHeader(FILE *, char *, float, float, float, float, float, float,
                  float, float, float [], float [], int);
float min(float, float);
char  Pause(void);
unsigned GetAction(MouseStuff &);


void Asetc(void)
//
{
   const int ArraySize = 1500, Flags = 8, BaseY = 6, ValXPos = 44,
             LC_Y  = BaseY,
             F_Y   = BaseY+1,
             H_Y   = BaseY+2,
             A_Y   = BaseY+3,
             OI_Y  = BaseY+4,
             TL_Y  = BaseY+5,
             Alg_Y = BaseY+6,
             LIM_Y = BaseY+7,
             PRN_Y = BaseY+8, PRN_X = 12,
             FIL_Y = BaseY+9, FIL_X = 18,
             RUN_Y = BaseY+10,
             DON_Y = BaseY+11;
   int N, NQ, IER, LineCount, Pse, First = TRUE, i, Done = FALSE, Crnt,
       ChangeFlag, VFlg[Flags], PRN, FIL, RunFlag, FFset, Hset, MaxSet, OISet;
   float TQ[ArraySize], Q[ArraySize], LR = 0.35, F, F0 = 0.0, FM, H, H0 = 0.0,
         HM, A, A0 = 0.0, AM, Q0 = 0.1, QI, PA, DA, CP, C1, C2, DQ0, Z0, Z1,
         DZ1, P1, DP1, T1, T2, DT, QT, OI = 5.0, OT, P2, Z2, K, DZ2, DP2, Z2C,
         P2C, LC = 0.0, TL = 0.0, Alg = 0.0, Limit;
   char Ch, Strng[83], OFileName[13], TITLE[81] = {"title"},
        Lines[][80] = {{"Heat loss fraction (value < 1.0)"},
                       {"Height at base of fire      ("},
                       {"Room Ceiling height         ("},
                       {"Room Floor area             ("},
                       {"Output interval             (sec)"},
                       {"Maximum simulation time     (sec)"},
                       {"fire growth constant (Menu) ("},
                       {"Optional upper limit on fire curve (kW):"},
                       {"Printer disabled"},
                       {"Print to file disabled"},
                       {"Run simulation"},
                       {"Done"}};
   FILE *Ofile = NULL;
   MouseStuff Mse;
   MenuBox MB = {7, BaseY, 17, 52, "LHCFOSMUPTRD"};

   do{
      mouse->Hide();
      clrscr();
      gotoxy(4, LC_Y);
      cputs(Lines[0]);
      PutAt(9,  LC_Y,  tolower(MB.Letters[0]), YELLOW);
      gotoxy(4, F_Y);
      cprintf("%s%s)",Lines[1], Len[SI+1]);
      PutAt(4,  F_Y,   MB.Letters[1], YELLOW);
      gotoxy(4, H_Y);
      cprintf("%s%s)",Lines[2], Len[SI+1]);
      PutAt(9,  H_Y,   MB.Letters[2], YELLOW);
      gotoxy(4, A_Y);
      cprintf("%s%s)",Lines[3], Ara[SI+1]);
      PutAt(9,  A_Y,   MB.Letters[3], YELLOW);
      gotoxy(4, OI_Y);
      cputs(Lines[4]);
      PutAt(4,  OI_Y,  MB.Letters[4], YELLOW);
      gotoxy(4, TL_Y);
      cputs(Lines[5]);
      PutAt(12, TL_Y,  tolower(MB.Letters[5]), YELLOW);
      gotoxy(4, Alg_Y);
      cprintf("%s%s)",Lines[6], Growth[SI+1]);
      PutAt(26, Alg_Y, MB.Letters[6], YELLOW);
      PutAt(9,  Alg_Y, 'g', YELLOW);
      gotoxy(4, LIM_Y);
      cputs(Lines[7]);
      PutAt(13, LIM_Y, tolower(MB.Letters[7]), YELLOW);
      gotoxy(4, PRN_Y);
      cputs(Lines[8]);
      PutAt(4,  PRN_Y, MB.Letters[8], YELLOW);
      gotoxy(4, FIL_Y);
      cputs(Lines[9]);
      PutAt(10, FIL_Y, tolower(MB.Letters[9]), YELLOW);
      gotoxy(4, RUN_Y);
      cputs(Lines[10]);
      PutAt(4,  RUN_Y, MB.Letters[10], YELLOW);
      gotoxy(4, DON_Y);
      cputs(Lines[11]);
      PutAt(4,  DON_Y, MB.Letters[11], YELLOW);
      Crnt = 0;
      RunFlag = FALSE;
      if (First){
         First  = FALSE;
         PRN    = FALSE;
         FIL    = FALSE;
         FFset  = FALSE;
         Hset   = FALSE;
         MaxSet = FALSE;
         for (i = 0; i < Flags; i++)
            VFlg[i] = FALSE;
         // Output interval has a default of 5 Sec.
         VFlg[4] = TRUE;
         OISet = TRUE;
         PrintAt(ValXPos, OI_Y, OI,  "%8.0f", YELLOW);
         // Fire output limit defaults to 0.0 => no limit
         VFlg[7] = TRUE;
         Limit = 0.0;
      }
      else{
         PrintAt(ValXPos, LC_Y,  LC,  "%8.2f", YELLOW);
         PrintAt(ValXPos, F_Y,   F0,  "%8.2f", YELLOW);
         PrintAt(ValXPos, H_Y,   H0,  "%8.2f", YELLOW);
         PrintAt(ValXPos, A_Y,   A0,  "%8.2f", YELLOW);
         PrintAt(ValXPos, OI_Y,  OI,  "%8.0f", YELLOW);
         PrintAt(ValXPos, TL_Y,  TL,  "%8.0f", YELLOW);
         if (Alg == -1){
            textcolor(YELLOW);
            gotoxy(ValXPos, Alg_Y);
            cprintf("Points");
            textcolor(WHITE);
         }
         else
            PrintAt(ValXPos, Alg_Y, Alg, "%8.6f", YELLOW);
         if (Limit > 0.0)
            PrintAt(ValXPos, LIM_Y, Limit,  "%8.2f", YELLOW);
         else{
            gotoxy(ValXPos, LIM_Y);
            clreol();
         }
         if (PRN){
            gotoxy(PRN_X, PRN_Y);
            cprintf("enabled ");
         }
         else{
            gotoxy(PRN_X, PRN_Y);
            cprintf("disabled");
         }
         gotoxy(FIL_X, FIL_Y);
         clreol();
         if (FIL){
            textcolor(YELLOW);
            cprintf("%s", OFileName);
            textcolor(WHITE);
         }
         else
            cprintf("disabled");
      }
      mouse->Show();
      do{
         ChangeFlag = TRUE;
         switch (Ch = GetKey(Crnt, ChangeFlag, Mse, MB)){
            case 'L':        // Heat loss fraction
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, LC_Y, LC, "%8.2f");
               Crnt = LC_Y-BaseY;
               if (LC < 0.0 || LC >= 1.0){
                  Message("Heat loss fraction must be in range (0.0, 1.0)");
                  PrintAt(ValXPos, LC_Y, LC, "%8.2f", RED);
                  ChangeFlag = FALSE;
                  VFlg[Crnt] = FALSE;
               }
               else
                  VFlg[Crnt] = TRUE;
               break;
            case 'H':        // Height at base of fire
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, F_Y, F0, "%8.2f");
               Crnt = F_Y-BaseY;
               if (Hset)
                  if (F0 >= H0){
                     Message("Height at base of fire must be less than Ceiling "
                             "height");
                     PrintAt(ValXPos, F_Y, F0, "%8.2f", RED);
                     ChangeFlag = FALSE;
                     VFlg[Crnt] = FALSE;
                  }
                  else
                     if (F0 < H0){
                        VFlg[1] = TRUE;
                        PrintAt(ValXPos, F_Y, F0, "%8.2f", YELLOW);
                        VFlg[2] = TRUE;
                        PrintAt(ValXPos, H_Y, H0, "%8.2f", YELLOW);
                     }
                     else
                        VFlg[Crnt] = FALSE;
               else
                  VFlg[Crnt] = TRUE;
               FFset = TRUE;
               break;
            case 'C':        // Room Ceiling height
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, H_Y, H0, "%8.2f");
               Crnt = H_Y-BaseY;
               if (FFset)
                  if (F0 >= H0){
                     Message("Ceiling Height must be greater than Height at "
                             "base of fire");
                     PrintAt(ValXPos, H_Y, H0, "%8.2f", RED);
                     ChangeFlag = FALSE;
                     VFlg[Crnt] = FALSE;
                  }
                  else
                     if (F0 < H0){
                        VFlg[1] = TRUE;
                        PrintAt(ValXPos, F_Y, F0, "%8.2f", YELLOW);
                        VFlg[2] = TRUE;
                        PrintAt(ValXPos, H_Y, H0, "%8.2f", YELLOW);
                     }
                     else
                        VFlg[Crnt] = FALSE;
               else
                  VFlg[Crnt] = TRUE;
               Hset = TRUE;
               break;
            case 'F':        // Room Floor area
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, A_Y, A0, "%8.2f");
               Crnt = A_Y-BaseY;
               VFlg[Crnt] = TRUE;
               break;
            case 'O':        // Output interval
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, OI_Y, OI, "%8.0f");
               Crnt = OI_Y-BaseY;
               if (MaxSet)
                  if (int(TL/OI) > ArraySize){
                     XtraPts(TL, OI, ArraySize);
                     PrintAt(ValXPos, OI_Y, OI, "%8.0f", RED);
                     ChangeFlag = FALSE;
                     VFlg[Crnt] = FALSE;
                  }
                  else{
                     VFlg[Crnt] = TRUE;
                     PrintAt(ValXPos, OI_Y, OI, "%8.0f", YELLOW);
                     VFlg[5] = TRUE;
                     PrintAt(ValXPos, TL_Y, TL, "%8.0f", YELLOW);
                  }
               else
                  VFlg[Crnt] = TRUE;
               OISet = TRUE;
               break;
            case 'S':        // Maximum simulation time
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               GetFloat(ValXPos, TL_Y, TL, "%8.0f");
               Crnt = TL_Y-BaseY;
               if (OISet)
                  if (int(TL/OI) > ArraySize){
                     XtraPts(TL, OI, ArraySize);
                     PrintAt(ValXPos, TL_Y, TL, "%8.0f", RED);
                     ChangeFlag = FALSE;
                     VFlg[Crnt] = FALSE;
                  }
                  else{
                     VFlg[Crnt] = TRUE;
                     PrintAt(ValXPos, TL_Y, TL, "%8.0f", YELLOW);
                     VFlg[4] = TRUE;
                     PrintAt(ValXPos, OI_Y, OI, "%8.0f", YELLOW);
                  }
               else
                  VFlg[Crnt] = TRUE;
               MaxSet = TRUE;
               break;
            case 'G':        // fire growth constant
            case 'M':        //                      Menu
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               if (Ch == 'G')
                  GetFloat(ValXPos, Alg_Y, Alg, "%8.6f");
               else{
                  Alg = AlgMenu1();
                  PrintAt(ValXPos, Alg_Y, Alg, "%8.6f", YELLOW);
               }
               if (Alg == -1){
                  textcolor(YELLOW);
                  gotoxy(ValXPos, Alg_Y);
                  clreol();
                  cprintf("Points");
                  textcolor(WHITE);
               }
               Crnt = Alg_Y-BaseY;
               VFlg[Crnt] = TRUE;
               break;
            case 'U':
               PutAt(MB.CurX, BaseY+Crnt, ' ', LIGHTRED);
               textbackground(CYAN);
               textcolor(YELLOW);
               gotoxy(10, 25);
               cputs("Note: to remove limit enter a value of 0 (Zero)");
               textbackground(BLUE);
               textcolor(WHITE);
               GetFloat(ValXPos, LIM_Y, Limit, "%8.2f");
               Crnt = LIM_Y-BaseY;
               VFlg[Crnt] = TRUE;
               if (Limit <= 0.0){
                  Limit = 0.0;
                  gotoxy(ValXPos, LIM_Y);
                  clreol();
                  cputs("No limit");
               }
               gotoxy(10, 25);
               clreol();
               break;
            case 'P':        // Printer
               if (PRN){
                  PRN = FALSE;
                  gotoxy(PRN_X, PRN_Y);
                  cprintf("disabled");
               }
               else{
                  PRN = TRUE;
                  gotoxy(PRN_X, PRN_Y);
                  cprintf("enabled ");
               }
               ChangeFlag = FALSE;
               break;
            case 'T':        // Output to file
               if (FIL){
                  FIL = FALSE;
                  gotoxy(FIL_X, FIL_Y);
                  clreol();
                  cprintf("disabled");
                  fclose(Ofile);
               }
               else{
                  FIL = TRUE;
                  GetFileName(OFileName);
                  gotoxy(FIL_X, FIL_Y);
                  clreol();
                  cprintf("%s", OFileName);
                  if ((Ofile = fopen(OFileName, "at")) == NULL){
                     sprintf(Strng, "\n        The file: %s could not be "
                             "opened.", OFileName);
                     Message(Strng);
                     FIL = FALSE;
                     gotoxy(FIL_X, FIL_Y);
                     clreol();
                     cprintf("disabled");
                  }
               }
               ChangeFlag = FALSE;
               break;
            case 'R':        // Run simulation
               RunFlag = TRUE;
               for (i = 0; i < Flags; i++)
                  if (!VFlg[i]){
                     RunFlag = FALSE;
                     break;
                  }
               ChangeFlag = FALSE;
               break;
            case 'D':        // Done
               RunFlag = TRUE;
               Done = TRUE;
            default:
               ChangeFlag = FALSE;
               break;
         }
         if (ChangeFlag && Crnt < Flags-1)
            Crnt++;
      }while(!RunFlag);
      if (!Done){
         if (SI){
            FM = F0;
            HM = H0;
            AM = A0;
            F  = F0/LengthFactor;
            H  = H0/LengthFactor;
            A  = A0/AreaFactor;
         }
         else{
            FM = F0*LengthFactor;
            HM = H0*LengthFactor;
            AM = A0*AreaFactor;
            F  = F0;
            H  = H0;
            A  = A0;
         }
         if (Alg == -1){
            clrscr();
            cprintf("\n\rINPUT FIRE TIMES AND HEAT RELEASE RATES (-9,-9 to end "
                    "input)");
            N = 0;
            do{
               cprintf("\n\rTIME (sec), HEAT RELEASE RATE (kW): ");
               Strng[0] = 40;
               cgets(Strng);
               if (strstr(&(Strng[2]), ","))
                  sscanf(&(Strng[2]), "%f, %f", &(TQ[N]), &QI);
               else
                  sscanf(&(Strng[2]), "%f %f", &(TQ[N]), &QI);
               if (TQ[N] < 0.0){
                  Q[N] = Q0;
                  break;
               }
               if (QI < Q0)
                  Q[N] = Q0;
               Q[N] = QI/Q0;
            }while(N++ < ArraySize);
            NQ = N-1;
            if (NQ == ArraySize)
               cprintf("\n\rMAXIMUM OF 100 INPUT VALUES REACHED\n\r");
            if (TQ[0] < Q0)
               TQ[0] = Q0;
         }
         else{
            N = 0;
            for (i = 0; i <= int(TL/OI); i++){
               TQ[i] = N;
               Q[i] = (Alg*pow((float)N, 2))/Q0;
               if (int(ceil(Limit)))
                  Q[i] = min(Limit/Q0, Q[i]);
               N += int(OI);
            }
            TQ[0] = Q0;
            Q[0] = Q0;
            NQ = int(TL/OI);
         }
         PA  = 530.0;
         DA  = .0735;
         CP  = .24;
         C1  = (1.0-LC)*Q0/(DA*CP*PA*A*1.054);
         C2  = .21/A*pow((1.0-LR)*Q0*32.0/(DA*CP*PA*1.054), 1.0/3.0);
         DQ0 = (Q[0]-1.0)/TQ[0];
         Z0  = H-F;
         Z1  = Z0;
         DZ1 = -C1-C2*pow(Z0, 5.0/3.0);
         P1  = 1.0+C1/C2*pow(Z0, -5.0/3.0);
         DP1 = C1/C2*(2.0*DQ0+5.0*(C1+C2*pow(Z0, 5.0/3.0)))/
               (6.0*pow(Z0, 8.0/3.0));
         T1  = 0.0;
         T2  = 0.0;
         DT  = 1.0;
         QT  = 1.0;
         OT  = 0.0;
         LineCount = 0;
         Pse = TRUE;
         if (PRN || FIL){
            clrscr();
            cputs("Enter a title for this run (0 - 80 characters):");
            textcolor(YELLOW);
            textbackground(GREEN);
            gotoxy(1, 2);
            clreol();
            Strng[0] = 80;
            cgets(Strng);
            textcolor(WHITE);
            textbackground(BLUE);
            strcpy(TITLE, &(Strng[2]));
         }
         if (PRN)
            PrintHeader(stdprn, TITLE, LC, F, FM, H, HM, A, AM, Alg, TQ, Q, NQ);
         if (FIL)
            PrintHeader(Ofile,  TITLE, LC, F, FM, H, HM, A, AM, Alg, TQ, Q, NQ);
         clrscr();
         cprintf("\n\rASET-C  VERSION 1.0\n\r"
                 "%s\n\r"
                 "HEAT LOSS FRACTION = %8.2f\n\r"
                 "FIRE HEIGHT = %8.2f ft      %8.2f m\n\r"
                 "ROOM HEIGHT = %8.2f ft      %8.2f m\n\r"
                 "ROOM AREA   = %8.2f sq ft   %8.2f sq m\n\n\r"
                 "    TIME      TEMP      TEMP     LAYER     LAYER      FIRE   "
                 "   FIRE\n\r"
                 "     sec        C         F        m         ft        kW    "
                 "   Btu/s\n\r"
                 ,TITLE, LC, F, FM, H, HM, A, AM);
         window(1, 11, 80, 25);
         F970(T2, OT, OI, QT, Q0, P1, PA, Z1, F, LineCount, Pse, PRN, FIL,
              Ofile);
A:       T1 = T2;
         T2 = T1+DT;
         if (T2 > TL){
            cputs("\n\rRUN COMPLETE\n\r");
            if (PRN)
               fprintf(stdprn, "\n\rRUN COMPLETE\n\r");
            if (FIL)
               fprintf(Ofile, "\n\rRUN COMPLETE\n\r");
            goto G;
         }
         if (T2 > TQ[NQ]){
            cputs("\n\rEND OF INPUT FIRE\n\r");
            if (PRN)
               fprintf(stdprn, "\n\rEND OF INPUT FIRE\n\r");
            if (FIL)
               fprintf(Ofile, "\n\rEND OF INPUT FIRE\n\r");
            goto G;
         }
         F880(T2, TQ, QT, Q, NQ);
         Z2 = Z1+DZ1*DT;
         P2 = P1+DP1*DT;
         IER = 0;
B:       if (Z2 <= 0.0)
            goto C;
         K = C2*pow(QT, 1.0/3.0)*pow(Z2, 5.0/3.0);
         DZ2 = -C1*QT-K;
         DP2 = P2*(C1*QT-(P2-1.0)*K)/(Z0-Z2);
         goto E;
C:       DP2 = (P2*C1*QT)/(Z0-Z2);
         if (Z2 <= -F)
            goto D;
         DZ2 = -C1*QT;
         goto E;
D:       DZ2 = 0.0;
E:       Z2C = Z1+(DZ1+DZ2)/2.0*DT;
         P2C = P1+(DP1+DP2)/2.0*DT;
         if (Z2C < -F){
            Z2 = -F;
            Z2C = -F;
         }
         if (fabs(Z2C-Z2) < .001 && fabs(P2C-P2) < .001)
            goto F;
         if (IER > 30){
            cputs("\n\rWARNING! SOLUTION DID NOT CONVERGE\n\r");
            if (PRN)
               fprintf(stdprn, "\n\rWARNING! SOLUTION DID NOT CONVERGE\n\r");
            if (FIL)
               fprintf(Ofile, "\n\rWARNING! SOLUTION DID NOT CONVERGE\n\r");
            goto F;
         }
         Z2 = Z2C;
         P2 = P2C;
         IER = IER+1;
         goto B;
F:       Z1  = Z2C;
         P1  = P2C;
         DZ1 = DZ2;
         DP1 = DP2;
         F970(T2, OT, OI, QT, Q0, P1, PA, Z1, F, LineCount, Pse, PRN, FIL,
              Ofile);
         goto A;
G:       window(1, 1, 80, 25);
         if (PRN)
            fprintf(stdprn, "%c", 0X0C);
         Pause();
      }
   }while(!Done);
}// End of Asetc()


void  F970(float T2, float &OT, float OI, float QT, float Q0, float P1,
           float PA, float Z1, float F, int &LineCount, int &Pse, int PRN,
           int FIL, FILE *Ofile)
//
{
   int lines = 12;
   float QK, QB, PF, PC, X, XM;
   char *ValueFormat = {"%8.1f  %8.1f  %8.1f  %8.1f  %8.1f  %8.1f  %8.1f\n\r"};

   if (T2 != 0.0 && T2 < OT)
      return;
   OT += OI;
   QK = QT*Q0;
   QB = QK*0.9485;
   PF = (P1*PA)-460.0;
   PC = (PF-32.0)/1.8;
   X  = Z1+F;
   XM = X*0.3048;
   if (PRN)
      fprintf(stdprn, ValueFormat, T2, PC, PF, XM, X, QK, QB);
   if (FIL)
      fprintf(Ofile, ValueFormat, T2, PC, PF, XM, X, QK, QB);
              cprintf(ValueFormat, T2, PC, PF, XM, X, QK, QB);
   if (Pse && LineCount++ == lines){
      LineCount = 0;
      cputs("                 Any key next screen or C for continuous");
      cputs("\n\r");
      if (toupper(Pause()) == 'C')
         Pse = FALSE;
   }
   return;
}// End of F970()



void  F880(float T2, float TQ[], float &QT, float Q[], int NQ)
//
{
   int N;

   if (T2 <= TQ[0]){
      QT = Q[0]-((Q[0]-1.0)/TQ[0])*(TQ[0]-T2);
      return;
   }
   for (N = 0; N <= NQ; N++)
      if (T2 <= TQ[N]){
         QT = Q[N]-((Q[N]-Q[N-1])/(TQ[N]-TQ[N-1]))*(TQ[N]-T2);
         return;
      }
  return;
}// End of F880()



float AlgMenu1(void)
// This function allows the user to choose a growth constant from a list
// With the additional option of entering the curve point by point
{
   const int Left = 15, Top = 9, Right = Left+28, Bottom = Top+7;
   int Done;
   float Alg[4][2] = {{0.002931, 0.002778},
                      {0.01172,  0.01111},
                      {0.04689,  0.04444},
                      {0.1878,   0.1778}}, Val;
   char Ch, buffer[(Right-Left+1)*(Bottom-Top+1)*2];
   MouseStuff Mse;

   mouse->Hide();
   gettext(Left, Top, Right, Bottom, buffer);
   window(Left, Top, Right, Bottom);
   textcolor(BLUE);
   textbackground(CYAN);
   clrscr();
   cprintf("Growth ConstantsĿ"
           "Time-Squared Fires %s "
           "Enter individual points    "
           "Slow              %8.6f "
           "Medium            %8.6f "
           "Fast              %8.6f "
           "Ultra-Fast        %8.6f "
           "", Growth[SI+1], Alg[0][SI+1],
           Alg[1][SI+1], Alg[2][SI+1], Alg[3][SI+1]);
   window(1, 1, 80, 25);
   PutAt(Right, Bottom, '', BLUE);
   PutAt(Left+1, Top+2, 'E', YELLOW);
   PutAt(Left+1, Top+3, 'S', YELLOW);
   PutAt(Left+1, Top+4, 'M', YELLOW);
   PutAt(Left+1, Top+5, 'F', YELLOW);
   PutAt(Left+1, Top+6, 'U', YELLOW);
   textbackground(BLUE);
   mouse->Show();
   do{
      Done = TRUE;
      Ch = toupper(char(GetAction(Mse)));
      if (Mse.Me == LMouseDown){
         if (Mse.X > 14 && Mse.X < 42 && Mse.Y > 9 && Mse.Y < 15)
            if (Mse.Y == 10)
               Val = -1;
            else
               Val = Alg[Mse.Y-11][SI+1];
         else
            Done = FALSE;
      }
      else
         switch(Ch){
            case 'E':
               Val = -1;
               break;
            case 'S':
               Val = Alg[0][SI+1];
               break;
            case 'M':
               Val = Alg[1][SI+1];
               break;
            case 'F':
               Val = Alg[2][SI+1];
               break;
            case 'U':
               Val = Alg[3][SI+1];
               break;
            default:
               Done = FALSE;
               break;
         }
   }while(!Done);
   mouse->Hide();
   puttext(Left, Top, Right, Bottom, buffer);
   mouse->Show();
   return Val;
}// End of AlgMenu1()



void  XtraPts(float TL, float OI, const int ArraySize)
//
{
   const int Left = 15, Top = 9, Right = Left+42, Bottom = Top+7;
   char buffer[(Right-Left+1)*(Bottom-Top+1)*2];

   gettext(Left, Top, Right, Bottom, buffer);
   window(Left, Top, Right, Bottom);
   textcolor(WHITE);
   textbackground(CYAN);
   clrscr();
   cprintf("Ŀ"
           "This program can handle %5.0d fire points"
           "  %5.0f Seconds at %5.0f Second intervals"
           "   would require  %5.0f points.          "
           "   You need to either                    "
           "   decrease Maximum simulation time or   "
           "   increase Output interval              "
           "Press any key to continue", ArraySize, TL, OI,
           TL/OI);
   window(1, 1, 80, 25);
   PutAt(Right, Bottom, '', WHITE);
   Pause();
   textbackground(BLUE);
   puttext(Left, Top, Right, Bottom, buffer);
}// End of XtraPts()


void PrintHeader(FILE *stream, char *TITLE, float LC, float F, float FM,
                 float H, float HM, float A, float AM, float Alg, float TQ[],
                 float Q[], int NQ)
//
{
   int i;

   fprintf(stream, "\n\rASET-C  VERSION 1.0\n\r"
           "%s\n\r"
           "HEAT LOSS FRACTION = %8.2f\n\r"
           "FIRE HEIGHT = %8.2f ft      %8.2f m\n\r"
           "ROOM HEIGHT = %8.2f ft      %8.2f m\n\r"
           "ROOM AREA   = %8.2f sq ft   %8.2f sq m\n\r",
           TITLE, LC, F, FM, H, HM, A, AM);
   if (Alg == -1){
      fprintf(stream, "\nFire curve input manually\n\r");
      for (i = 0; i <= NQ; i++)
         fprintf(stream, "TIME (sec), HEAT RELEASE RATE (kW): %8.0f, %8.0f\n\r",
                 TQ[i], Q[i]/10.);
      fputs("TIME (sec), HEAT RELEASE RATE (kW):       -9,       -9\n\n\r",
            stream);
   }
   else
      fprintf(stream, "fire growth constant (%s) %f\n\n\r",
      Growth[SI+1], Alg);
   fprintf(stream, "    TIME      TEMP      TEMP     LAYER     LAYER     FIRE  "
                   "    FIRE\n\r"
                   "     sec        C         F        m         ft       kW   "
                   "    Btu/s\n\r");
}// End of PrintHeader()


float min(float X, float Y)
// This is the min function that is NOT in stdlib.h!!!
{
   if (X > Y)
      return Y;
   else
      return X;
}// End of min()


char Pause(void)
//
{
   char ch;

   ch = getch();
   while(kbhit()) getch();
   return ch;
}// End of Pause()
