10 KEY OFF
20 CLS
30 SCREEN 1
40 COLOR 0
50 PRINT "ASET-B  VERSION 1.02"
60 PRINT "WRITTEN BY W.D. WALTON  1985"
70 PRINT "CONTRIBUTION OF THE"
80 PRINT "NATIONAL BUREAU OF STANDARDS (U.S.). "
90 PRINT "NOT SUBJECT TO COPYRIGHT."
100 DIM TQ(100),Q(100),TG(2000),PG(2000),XG(2000)
110 DIM XM(26),YM(26),MX(26),MY(26)
120 INPUT"ENTER RUN TITLE";TITLE$
130 LR=.35
140 INPUT"HEAT LOSS FRACTION";LC
150 INPUT"FIRE HEIGHT (ft)";F
160 INPUT"ROOM CEILING HEIGHT (ft)";H
170 INPUT"ROOM FLOOR AREA (sq ft)";A
180 FM=F*.3048
190 HM=H*.3048
200 AM=A*.0929
210 INPUT"MAXIMUM TIME (sec)";TL
220 Q0=.1
230 PRINT"INPUT FIRE TIMES AND HEAT RELEASE RATES"
240 PRINT"(use -9,-9 to end input)"
250 FOR N=1 TO 100
260 INPUT"TIME (sec), HEAT RELEASE (kW)",TQ(N),QI
270 IF TQ(N) < 0 GOTO 320
280 IF QI < Q0 THEN Q(N)=Q0
290 Q(N)=QI/Q0
300 NEXT N
310 PRINT "MAXIMUM OF 100 INPUT VALUES REACHED"
320 NQ=N-1
330 IF TQ(1)<.1 THEN TQ(1)=.1
340 PA=530!
350 DA=.0735
360 CP=.24
370 C1=(1!-LC)*Q0/(DA*CP*PA*A*1.054)
380 C2=.21/A*((1!-LR)*Q0*32!/(DA*CP*PA*1.054))^(1!/3!)
390 DQ0=(Q(1)-1!)/TQ(1)
400 Z0=H-F
410 Z1=Z0
420 DZ1=-C1-C2*Z0^(5!/3!)
430 P1=1!+C1/C2*Z0^(-5!/3!)
440 DP1=C1/C2*(2!*DQ0+5!*(C1+C2*Z0^(5!/3!)))/(6!*Z0^(8!/3!))
450 T1=0!
460 T2=0!
470 DT=1!
480 QT=1!
490 OI=1!
500 OT=0!
510 NG=0
520 GOSUB 2050
530 GOSUB 1060
540 T1=T2
550 T2=T1+DT
560 IF T2>TL THEN LOCATE 24,1:PRINT"RUN COMPLETE";:GOTO 870
570 IF T2>TQ(NQ) THEN LOCATE 24,1:PRINT"END OF INPUT FIRE";:GOTO 870
580 GOSUB 970
590 Z2=Z1+DZ1*DT
600 P2=P1+DP1*DT
610 IER=0
620 IF Z2<=0! GOTO 670
630 K=C2*QT^(1!/3!)*Z2^(5!/3!)
640 DZ2=-C1*QT-K
650 DP2=P2*(C1*QT-(P2-1!)*K)/(Z0-Z2)
660 GOTO 720
670 DP2=(P2*C1*QT)/(Z0-Z2)
680 IF Z2<=-F GOTO 710
690 DZ2=-C1*QT
700 GOTO 720
710 DZ2=0!
720 Z2C=Z1+(DZ1+DZ2)/2!*DT
730 P2C=P1+(DP1+DP2)/2!*DT
740 IF Z2C<-F THEN Z2=-F:Z2C=-F
750 IF ABS(Z2C-Z2)<.001 AND ABS(P2C-P2)<.001 GOTO 810
760 IF IER>30 THEN LOCATE 24,1:PRINT"WARNING! SOLUTION DID NOT CONVERGE";:GOTO 810
770 Z2=Z2C
780 P2=P2C
790 IER=IER+1
800 GOTO 620
810 Z1=Z2C
820 P1=P2C
830 DZ1=DZ2
840 DP1=DP2
844 PF=(P1*PA)-460!
845 IF PF>3000 THEN LOCATE 24,1:PRINT"TEMPERATURE OUT OF RANGE          ";:GOTO 870
850 GOSUB 1060
860 GOTO 540 
870 L$=INKEY$
880 IF LEN(L$)=0 GOTO 870
890 VIEW (0,0)-(319,199)
900 CLS
910 PRINT " "
920 INPUT"PLOT RESULTS (Y/N)";A$
930 IF A$="Y" OR A$="y" THEN GOSUB 1260
940 SCREEN 2
950 SCREEN 0
960 END
970 IF T2>TQ(1) GOTO 1000
980 QT=Q(1)-((Q(1)-1!)/TQ(1))*(TQ(1)-T2)
990 RETURN 
1000 FOR N=1 TO NQ
1010 IF T2>TQ(N) GOTO 1040
1020 QT=Q(N)-((Q(N)-Q(N-1))/(TQ(N)-TQ(N-1)))*(TQ(N)-T2)
1030 RETURN
1040 NEXT N
1050 RETURN
1060 IF T2<OT THEN RETURN
1070 OT=OT+OI
1080 QK=QT*Q0
1090 QB=QK*.9485
1100 PF=(P1*PA)-460!
1110 PC=(PF-32!)/1.8
1120 RRF=DP1*31800!
1130 RRC=RRF/1.8
1140 X=Z1+F
1150 XM=X*.3048
1160 GOSUB 2680
1170 NG=NG+1
1180 IF NG > 2000 THEN PRINT"TOO MANY VALUES TO GRAPH":STOP
1190 TG(NG)=T2
1200 TMAX=T2
1210 PG(NG)=PF
1220 IF PF > PMAX THEN PMAX=PF
1230 XG(NG)=X
1240 IF X > XMAX THEN XMAX=X
1250 RETURN
1260 CLS
1270 TITL$="ASET-B  "+TITLE$
1280 LOCATE 1,(40-LEN(TITL$))/2
1290 PRINT TITL$
1300 LOCATE 21,17
1310 PRINT"TIME s"
1320 L$="LAYER HEIGHT ft"
1330 FOR I=1 TO 15
1340 LOCATE 3+I,1
1350 PRINT MID$(L$,I,1)
1360 NEXT I
1370 L$="LAYER TEMP F"
1380 FOR I=1 TO 12
1390 LOCATE 5+I,40
1400 PRINT MID$(L$,I,1)
1410 NEXT I
1420 LOCATE 21,3
1430 PRINT"0"
1440 TRANGE=2000!
1450 IF TMAX < 1000! THEN TRANGE=1000!
1460 IF TMAX < 500! THEN TRANGE=500!
1470 IF TMAX < 200! THEN TRANGE=200!
1480 IF TMAX < 100! THEN TRANGE=100!
1490 PRANGE=2000!
1500 IF PMAX < 1000! THEN PRANGE=1000!
1510 IF PMAX < 500! THEN PRANGE=500!
1520 IF PMAX < 200! THEN PRANGE=200!
1530 XRANGE=200!
1540 IF XMAX < 100! THEN XRANGE=100!
1550 IF XMAX < 50! THEN XRANGE=50!
1560 IF XMAX < 20! THEN XRANGE=20!
1570 IF XMAX < 10! THEN XRANGE=10!
1580 L$=STR$(TRANGE)
1590 LOCATE 21,39-LEN(L$)
1600 PRINT L$
1610 L$=STR$(XRANGE)
1620 LOCATE 2,1
1630 PRINT L$
1640 L$=STR$(PRANGE)
1650 LOCATE 2,40-LEN(L$)
1660 PRINT L$
1670 LOCATE 23
1680 VIEW (20,20)-(300,150),,3
1690 WINDOW (0,0)-(100,100)
1700 FOR I=1 TO 9
1710 LINE (10*I,0)-(10*I,4)
1720 LINE (10*I,100)-(10*I,96)
1730 LINE (0,10*I)-(2,10*I)
1740 LINE (100,10*I)-(98,10*I)
1750 NEXT I
1760 WINDOW (0,0)-(TRANGE,XRANGE)
1770 PSET (TG(1),XG(1))
1780 FOR I = 2 TO NG
1790 LINE -(TG(I),XG(I)),,,&HF00F
1800 NEXT I
1810 PNT=(TRANGE/(10*OI))+1
1820 LINE (TG(PNT),XG(PNT))-(TG(PNT),XG(PNT)-XRANGE/10)
1830 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10)
1840 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10*.8)
1850 LINE -(TG(PNT)-TRANGE/10*.6,XG(PNT)-XRANGE/10)
1860 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10*1.2)
1870 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10)
1880 WINDOW (0,0)-(TRANGE,PRANGE)
1890 PSET (TG(1),PG(1))
1900 FOR I = 2 TO NG
1910 LINE -(TG(I),PG(I))
1920 NEXT I
1930 PNT=NG-TRANGE/(10*OI)
1940 LINE (TG(PNT),PG(PNT))-(TG(PNT),PG(PNT)-PRANGE/10)
1950 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10)
1960 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10*.8)
1970 LINE -(TG(PNT)+TRANGE/10*.6,PG(PNT)-PRANGE/10)
1980 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10*1.2)
1990 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10)
2000 L$=INKEY$
2010 IF LEN(L$)=0  GOTO 2000
2020 SCREEN 2
2030 SCREEN 0
2040 RETURN
2050 CLS
2060 DATA 0.,22.,-3.,2.,-1.,1.5,-1.,0.,-6.,0.,-4.5,23.,-10.,32.,-5.,42.5
2070 DATA 5.,42.5,10.,32.,4.5,23.,6.5,2.,8.5,1.5,8.5,0.,3.5,0.,0.,22.
2080 DATA 4.25,39.,7.5,32.,4.25,25.5,4.25,39.,-4.25,39.,-7.5,32.,-4.25,25.5
2090 DATA -4.25,39.,0.,47.5
2100 FOR I=1 TO 25
2110 READ XM(I),YM(I)
2120 NEXT I
2130 SC=(6!)/(51!)
2140 IHEAD=SC*3.1
2150 FOR I=1 TO 25
2160 MX(I)=(H/2)+(SC*XM(I))
2170 MY(I)=(SC*YM(I))
2180 NEXT I
2190 TITL$="ASET-B  "+TITLE$
2200 LOCATE 1,(40-LEN(TITL$))/2
2210 PRINT TITL$
2220 LOCATE 2,1
2230 PRINT "ROOM HEIGHT"
2240 LOCATE 2,12
2250 PRINT USING "#####";H
2260 LOCATE 2,17
2270 PRINT "(ft)"
2280 LOCATE 2,23
2290 PRINT "AREA"
2300 LOCATE 2,27
2310 PRINT USING "#######";A
2320 LOCATE 2,34
2330 PRINT "(sq ft)"
2340 LOCATE 21,1
2350 PRINT "TIME"
2360 LOCATE 21,11
2370 PRINT "(sec)"
2380 LOCATE 21,20
2390 PRINT "TEMPERATURE"
2400 LOCATE 21,37
2410 PRINT "(F)"
2420 LOCATE 23,1
2430 PRINT "INTERFACE"
2440 LOCATE 23,16
2450 PRINT "(ft)"
2460 LOCATE 23,26
2470 PRINT "FIRE"
2480 LOCATE 23,36
2490 PRINT "(kW)"
2500 VIEW (10,20)-(300,150),,3
2510 WINDOW (0,0)-(H,H)
2520 PSET(MX(1),MY(1))
2530 FOR I=2 TO 16
2540 LINE -(MX(I),MY(I))
2550 NEXT I
2560 PSET (MX(17),MY(17))
2570 FOR I=18 TO 20
2580 LINE -(MX(I),MY(I))
2590 NEXT I
2600 PSET (MX(21),MY(21))
2610 FOR I=22 TO 24
2620 LINE -(MX(I),MY(I))
2630 NEXT I
2640 CIRCLE (MX(25),MY(25)),IHEAD
2650 PAINT (MX(25),MY(25))
2660 PAINT ((MX(21)+MX(17))/2,MY(21))
2670 RETURN
2680 LOCATE 21,5
2690 PRINT USING "######";T2
2700 LOCATE 21,31
2710 PRINT USING "######";PF
2720 LOCATE 23,10
2730 PRINT USING "####.#";X
2740 LOCATE 23,30
2750 PRINT USING "######";QK
2760 LINE (0,H)-(H,X),,BF
2770 IF X>F THEN GOTO 2800
2780 LOCATE 22,1
2790 PRINT"INTERFACE AT FUEL"
2800 IF PF<1000 THEN GOTO 2830
2810 LOCATE 22,20
2820 PRINT "FLASHOVER CONDITIONS"
2830 RETURN
