10 KEY OFF
20 CLS
30 SCREEN 1
40 COLOR 0
50 PRINT "ASET-B  VERSION 1.01"
60 PRINT "WRITTEN BY W.D. WALTON  1985"
70 PRINT "CONTRIBUTION OF THE"
80 PRINT "NATIONAL BUREAU OF STANDARDS (U.S.). "
90 PRINT "NOT SUBJECT TO COPYRIGHT."
100 DIM TQ(100),Q(100),TG(500),PG(500),XG(500)
110 INPUT"ENTER RUN TITLE";TITLE$
120 LR=.35
130 INPUT"HEAT LOSS FRACTION";LC
140 INPUT"FIRE HEIGHT (ft)";F
150 INPUT"ROOM CEILING HEIGHT (ft)";H
160 INPUT"ROOM FLOOR AREA (sq ft)";A
170 FM=F*.3048
180 HM=H*.3048
190 AM=A*.0929
200 INPUT"MAXIMUM TIME (sec)";TL
210 Q0=.1
220 PRINT"INPUT FIRE TIMES AND HEAT RELEASE RATES"
230 PRINT"(use -9,-9 to end input)"
240 FOR N=1 TO 100
250 INPUT"TIME (sec), HEAT RELEASE (kW)",TQ(N),QI
260 IF TQ(N) < 0 GOTO 310
270 IF QI < Q0 THEN Q(N)=Q0
280 Q(N)=QI/Q0
290 NEXT N
300 PRINT "MAXIMUM OF 100 INPUT VALUES REACHED"
310 NQ=N-1
320 IF TQ(1)<.1 THEN TQ(1)=.1
330 PA=530!
340 DA=.0735
350 CP=.24
360 C1=(1!-LC)*Q0/(DA*CP*PA*A*1.054)
370 C2=.21/A*((1!-LR)*Q0*32!/(DA*CP*PA*1.054))^(1!/3!)
380 DQ0=(Q(1)-1!)/TQ(1)
390 Z0=H-F
400 Z1=Z0
410 DZ1=-C1-C2*Z0^(5!/3!)
420 P1=1!+C1/C2*Z0^(-5!/3!)
430 DP1=C1/C2*(2!*DQ0+5!*(C1+C2*Z0^(5!/3!)))/(6!*Z0^(8!/3!))
440 T1=0!
450 T2=0!
460 DT=1!
470 QT=1!
480 OI=5!
490 OT=0!
500 NG=0
510 PRINT " "
520 PRINT"ASET-B  VERSION 1.01"
530 PRINT TITLE$
540 PRINT "HEAT LOSS FRACTION=";LC
550 PRINT "FIRE HEIGHT=";F;"ft   ";FM;"m"
560 PRINT "ROOM HEIGHT=";H;"ft   ";HM;"m"
570 PRINT "ROOM AREA=";A;"sq ft   ";AM;"sq m"
580 PRINT " "
590 PRINT"    TIME      TEMP     LAYER      FIRE"
600 PRINT"     sec         F        ft        kW"
610 GOSUB 1070
620 T1=T2
630 T2=T1+DT
640 IF T2>TL THEN PRINT"RUN COMPLETE":GOTO 950
650 IF T2>TQ(NQ) THEN PRINT"END OF INPUT FIRE":GOTO 950
660 GOSUB 980
670 Z2=Z1+DZ1*DT
680 P2=P1+DP1*DT
690 IER=0
700 IF Z2<=0! GOTO 750
710 K=C2*QT^(1!/3!)*Z2^(5!/3!)
720 DZ2=-C1*QT-K
730 DP2=P2*(C1*QT-(P2-1!)*K)/(Z0-Z2)
740 GOTO 800
750 DP2=(P2*C1*QT)/(Z0-Z2)
760 IF Z2<=-F GOTO 790
770 DZ2=-C1*QT
780 GOTO 800
790 DZ2=0!
800 Z2C=Z1+(DZ1+DZ2)/2!*DT
810 P2C=P1+(DP1+DP2)/2!*DT
820 IF Z2C<-F THEN Z2=-F:Z2C=-F
830 IF ABS(Z2C-Z2)<.001 AND ABS(P2C-P2)<.001 GOTO 890
840 IF IER>30 THEN PRINT"WARNING! SOLUTION DID NOT CONVERGE":GOTO 890
850 Z2=Z2C
860 P2=P2C
870 IER=IER+1
880 GOTO 700
890 Z1=Z2C
900 P1=P2C
910 DZ1=DZ2
920 DP1=DP2
930 GOSUB 1070
940 GOTO 620 
950 INPUT"PLOT RESULTS (Y/N)";A$
960 IF A$="Y" OR A$="y" THEN GOSUB 1270
970 END
980 IF T2>TQ(1) GOTO 1010
990 QT=Q(1)-((Q(1)-1!)/TQ(1))*(TQ(1)-T2)
1000 RETURN 
1010 FOR N=1 TO NQ
1020 IF T2>TQ(N) GOTO 1050
1030 QT=Q(N)-((Q(N)-Q(N-1))/(TQ(N)-TQ(N-1)))*(TQ(N)-T2)
1040 RETURN
1050 NEXT N
1060 RETURN
1070 IF T2<OT THEN RETURN
1080 OT=OT+OI
1090 QK=QT*Q0
1100 QB=QK*.9485
1110 PF=(P1*PA)-460!
1120 PC=(PF-32!)/1.8
1130 RRF=DP1*31800!
1140 RRC=RRF/1.8
1150 X=Z1+F
1160 XM=X*.3048
1170 PRINT USING"######.#  ";T2;PF;X;QK
1180 NG=NG+1
1190 IF NG > 500 THEN PRINT"TOO MANY VALUES TO GRAPH":STOP
1200 TG(NG)=T2
1210 TMAX=T2
1220 PG(NG)=PF
1230 IF PF > PMAX THEN PMAX=PF
1240 XG(NG)=X
1250 IF X > XMAX THEN XMAX=X
1260 RETURN
1270 CLS
1280 TITLE$="ASET-B  "+TITLE$
1290 LOCATE 1,(40-LEN(TITLE$))/2
1300 PRINT TITLE$
1310 LOCATE 21,17
1320 PRINT"TIME s"
1330 L$="LAYER HEIGHT ft"
1340 FOR I=1 TO 15
1350 LOCATE 3+I,1
1360 PRINT MID$(L$,I,1)
1370 NEXT I
1380 L$="LAYER TEMP F"
1390 FOR I=1 TO 12
1400 LOCATE 5+I,40
1410 PRINT MID$(L$,I,1)
1420 NEXT I
1430 LOCATE 21,3
1440 PRINT"0"
1450 TRANGE=2000!
1460 IF TMAX < 1000! THEN TRANGE=1000!
1470 IF TMAX < 500! THEN TRANGE=500!
1480 IF TMAX < 200! THEN TRANGE=200!
1490 IF TMAX < 100! THEN TRANGE=100!
1500 PRANGE=2000!
1510 IF PMAX < 1000! THEN PRANGE=1000!
1520 IF PMAX < 500! THEN PRANGE=500!
1530 IF PMAX < 200! THEN PRANGE=200!
1540 XRANGE=200!
1550 IF XMAX < 100! THEN XRANGE=100!
1560 IF XMAX < 50! THEN XRANGE=50!
1570 IF XMAX < 20! THEN XRANGE=20!
1580 IF XMAX < 10! THEN XRANGE=10!
1590 L$=STR$(TRANGE)
1600 LOCATE 21,39-LEN(L$)
1610 PRINT L$
1620 L$=STR$(XRANGE)
1630 LOCATE 2,1
1640 PRINT L$
1650 L$=STR$(PRANGE)
1660 LOCATE 2,40-LEN(L$)
1670 PRINT L$
1680 LOCATE 23
1690 VIEW (20,20)-(300,150),,3
1700 WINDOW (0,0)-(100,100)
1710 FOR I=1 TO 9
1720 LINE (10*I,0)-(10*I,4)
1730 LINE (10*I,100)-(10*I,96)
1740 LINE (0,10*I)-(2,10*I)
1750 LINE (100,10*I)-(98,10*I)
1760 NEXT I
1770 WINDOW (0,0)-(TRANGE,XRANGE)
1780 PSET (TG(1),XG(1))
1790 FOR I = 2 TO NG
1800 LINE -(TG(I),XG(I)),,,&HF00F
1810 NEXT I
1820 PNT=(TRANGE/(10*OI))+1
1830 LINE (TG(PNT),XG(PNT))-(TG(PNT),XG(PNT)-XRANGE/10)
1840 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10)
1850 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10*.8)
1860 LINE -(TG(PNT)-TRANGE/10*.6,XG(PNT)-XRANGE/10)
1870 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10*1.2)
1880 LINE -(TG(PNT)-TRANGE/10*.4,XG(PNT)-XRANGE/10)
1890 WINDOW (0,0)-(TRANGE,PRANGE)
1900 PSET (TG(1),PG(1))
1910 FOR I = 2 TO NG
1920 LINE -(TG(I),PG(I))
1930 NEXT I
1940 PNT=NG-TRANGE/(10*OI)
1950 LINE (TG(PNT),PG(PNT))-(TG(PNT),PG(PNT)-PRANGE/10)
1960 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10)
1970 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10*.8)
1980 LINE -(TG(PNT)+TRANGE/10*.6,PG(PNT)-PRANGE/10)
1990 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10*1.2)
2000 LINE -(TG(PNT)+TRANGE/10*.4,PG(PNT)-PRANGE/10)
2010 L$=INKEY$
2020 IF LEN(L$)=0  GOTO 2010
2030 SCREEN 2
2040 SCREEN 0
2050 RETURN
