--=============================================================================
--
-- Name:		FD32CE
--
-- Purpose:	This module a 32 bits flip-flop.
--
-- Note:		This code is in the public domain, subject to the restriction
--					given in the official notice below
--
-- Author:	Cedrick Rochet, NIST Smart Space Project
--
-- Contact:	crochet@nist.gov or cedrick.rochet@yahoo.fr
--
-- Dependencies:
--
-- 1. INCOMING_MESSAGE_MEM
--
--=============================================================================
-- Revision History
-------------------------------------------------------------------------------
-- August 5, 2003 
-- 
-- - initial version
--
--
--========================= Official Notice ===================================
--
-- "This software was developed at the National Institute of Standards and 
-- Technology by employees of the Federal Government in the course of their 
-- official duties. Pursuant to Title 17 Section 105 of the United States Code 
-- this software is not subject to copyright protection and is in the public 
-- domain.
-- 
-- Capture is an experimental system and is offered AS IS. NIST assumes no 
-- responsibility whatsoever for its use by other parties, and makes no 
-- guarantees and NO WARRANTIES, EXPRESS OR IMPLIED, about its quality, 
-- reliability, fitness for any purpose, or any other characteristic. We would 
-- appreciate acknowledgement if the software is used.
-- 
-- This software can be redistributed and/or modified freely provided that any 
-- derivative works bear some notice that they are derived from it, and any 
-- modified versions bear some notice that they have been modified from the 
-- original."
-- 
--=============================================================================

LIBRARY ieee;
LIBRARY UNISIM;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL;
USE UNISIM.Vcomponents.ALL;

entity FD32CE is
    Port (
					C : in std_logic;
					D : in std_logic_vector(31 downto 0);
					Q : out std_logic_vector(31 downto 0)
					);
end FD32CE;

ARCHITECTURE RTL OF FD32CE IS

begin
--================================================================================================================================
-- this module is just creating a flip-flop on 32 bits.
--================================================================================================================================
	I_31 : FD
      PORT MAP (C=>C, D=>D(31), Q=>Q(31));

	I_30 : FD
      PORT MAP (C=>C, D=>D(30), Q=>Q(30));

	I_29 : FD
      PORT MAP (C=>C, D=>D(29), Q=>Q(29));

	I_28 : FD
      PORT MAP (C=>C, D=>D(28), Q=>Q(28));

	I_27 : FD
      PORT MAP (C=>C, D=>D(27), Q=>Q(27));

	I_26 : FD
      PORT MAP (C=>C, D=>D(26), Q=>Q(26));

	I_25 : FD
      PORT MAP (C=>C, D=>D(25), Q=>Q(25));

	I_24 : FD
      PORT MAP (C=>C, D=>D(24), Q=>Q(24));

	I_23 : FD
      PORT MAP (C=>C, D=>D(23), Q=>Q(23));

	I_22 : FD
      PORT MAP (C=>C, D=>D(22), Q=>Q(22));

	I_21 : FD
      PORT MAP (C=>C, D=>D(21), Q=>Q(21));

	I_20 : FD
      PORT MAP (C=>C, D=>D(20), Q=>Q(20));

	I_19 : FD
      PORT MAP (C=>C, D=>D(19), Q=>Q(19));

	I_18 : FD
      PORT MAP (C=>C, D=>D(18), Q=>Q(18));

	I_17 : FD
      PORT MAP (C=>C, D=>D(17), Q=>Q(17));

	I_16 : FD
      PORT MAP (C=>C, D=>D(16), Q=>Q(16));

	I_15 : FD
      PORT MAP (C=>C, D=>D(15), Q=>Q(15));

	I_14 : FD
      PORT MAP (C=>C, D=>D(14), Q=>Q(14));

	I_13 : FD
      PORT MAP (C=>C, D=>D(13), Q=>Q(13));

	I_12 : FD
      PORT MAP (C=>C, D=>D(12), Q=>Q(12));

	I_11 : FD
      PORT MAP (C=>C, D=>D(11), Q=>Q(11));

	I_10 : FD
      PORT MAP (C=>C, D=>D(10), Q=>Q(10));

	I_Q9 : FD
      PORT MAP (C=>C, D=>D(9), Q=>Q(9));

	I_Q8 : FD
      PORT MAP (C=>C, D=>D(8), Q=>Q(8));

	I_Q7 : FD
      PORT MAP (C=>C, D=>D(7), Q=>Q(7));

   I_Q6 : FD
      PORT MAP (C=>C, D=>D(6), Q=>Q(6));

   I_Q4 : FD
      PORT MAP (C=>C, D=>D(4), Q=>Q(4));

   I_Q5 : FD
      PORT MAP (C=>C, D=>D(5), Q=>Q(5));

   I_Q0 : FD
      PORT MAP (C=>C, D=>D(0), Q=>Q(0));

   I_Q1 : FD
      PORT MAP (C=>C, D=>D(1), Q=>Q(1));

   I_Q2 : FD
      PORT MAP (C=>C, D=>D(2), Q=>Q(2));

   I_Q3 : FD
      PORT MAP (C=>C, D=>D(3), Q=>Q(3));

end RTL;
