#!/usr/bin/perl

# Parse a specially formatted file given as an argument, using an
# extended format similar to that produced by an2k2txt and read by
# txt2an2k, and make substitutions to replace the extensions:
#    comments - remove
#    base64-file - replace with encoded contents

use warnings;
use strict;

use Cwd;
use MIME::Base64;
# The encoding in the standard is the same as that used in MIME,
# according to RFC-2045.

while(<>) {
    if (/^#.*$/ || /^$/) {
	next;			# skip comments and empty lines
    }
    if (/base64\((.*)\)/) {
	my $pwd = cwd();
	#warn "working directory $pwd\n";
	my $filename = $1;
	open(FILE, $filename) or die "open $filename: $!";
	local $/ = undef;
	my $contents = <FILE>;
	close(FILE);
	my $encoded = MIME::Base64::encode($contents);
	s/base64\(.*\)/$encoded/;
    }
    print;
}
