#!/usr/bin/perl

use warnings;
use strict;
#use Data::Dumper;

my $records = [];
my $ri = 1;
my $last_field_id = '';
my $fmt = "%02d.%03d-%02d.%02d %s";

push(@{$records->[$ri]}, sprintf($fmt, 1, 1, 1, 1, 'header'));
while (<>) {
    if (/^\s*<!--.*fieldID: (.*)[ =]*-->\s*$/) {
	my $field_id_comment = $1;
#print "fid: $field_id_comment\n";
	$field_id_comment =~ /^(\d+)\.(\d+)(?:-([a-z]+)(\d+))?(?: (\w+))?/;
	my ($rn, $fn, $ia, $si, $mnm) = ($1, $2, $3, $4, $5);
	$mnm = 'x' unless $mnm;
	next unless $ia;	# skip comments without subfield and item ids
	my $ii = ord($ia) - ord('a') + 1;
	
	my $field_id =
	    sprintf($fmt, $rn, $fn, $si, $ii, $mnm); 
	if ($field_id ne $last_field_id) {
	    if ($rn != 1 && $fn == 2) {
		$ri++;
		push(@{$records->[$ri]}, sprintf($fmt, $rn, 1, 1, 1, 'header'));
	    }
	    push(@{$records->[$ri]}, $field_id);
#print "$field_id\n";
	}
	$last_field_id = $field_id;
    }
}

#print Dumper($records);

my ($old_rn, $old_ri) = (1, 1);
for ($ri = 1; $ri < @$records; $ri++) {
    my @fields = sort @{$records->[$ri]};
    splice(@fields, 0, 0, 'x'); # zeroeth field index not used
#print "ri: $ri\n";   

    my $fi = 1;
    my ($old_fn, $old_fi, $old_si, $old_ii) = (1, 1, 1, 0);
    
    for (my $xfi = 1; $xfi < @fields; $xfi++) {
	my $field = $fields[$xfi];
	$field =~ /^(\d+)\.(\d+)-(\d+)\.(\d+)\s(\w+)/;
	my ($rn, $fn, $si, $ii, $mnm) = ($1, $2, $3, $4, $5);

	$fi++ if $fn != $old_fn;

	# Insert some items that are required in traditional format, but
	# may be omitted in XML.
	if ($old_rn == 1) {
	    # transaction domain version
	    if ($fn != 13 && $old_fn == 13 && $old_ii == 1) {
		print sprintf("%d.%d.%d.%d [%d.%03d] %s\n",
		      $old_ri, $old_fi, 1, 2, 1, 13, 'DVN')
	    }
	} elsif ($old_rn == 4 || $old_rn == 7) {
	    # old fasioned binary records
	    if ($fn != 4 && $old_fn == 4) {
		for (my $i = $old_ii + 1; $i <= 6; $i++) {
		print sprintf("%d.%d.%d.%d [%d.%03d] %s\n",
				  $old_ri, $old_fi, $old_si, $i, $old_rn, $old_fn, 'FGP');
		}
	    }
	}

	# omit excess fields
	if ($old_ri == $ri && $old_fi == $fi
	    && $old_si == $si && $old_ii == $ii) {
	    next;
	}

#print "xfi: $xfi, old_fn: $old_fn, fn: $fn, fi: $fi\n";
	print sprintf("%d.%d.%d.%d [%d.%03d] %s\n",
		      $ri, $fi, $si, $ii, $rn, $fn, $mnm);
	($old_rn, $old_fn, $old_ri, $old_fi, $old_si, $old_ii) = 
	    ($rn, $fn, $ri, $fi, $si, $ii);
    }
}
