<?xml version='1.0' ?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="xsl itl2008 xsi ext xsd s ansi-nist" xmlns:itl2008="http://biometrics.nist.gov/standard/2-2008"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:itl="http://biometrics.nist.gov/standard/2011" xmlns:nc="http://niem.gov/niem/niem-core/2.0" xmlns:s="http://niem.gov/niem/structures/2.0" xmlns:ext="http://example.org/extension" xmlns:ansi-nist="http://niem.gov/niem/ansi-nist/2.0" xmlns:biom="http://niem.gov/niem/biometrics/1.0" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<xsl:output indent="yes" method="xml" encoding="UTF-8"/>
	
	<!-- ******************************************************************************* -->
	<!-- This XSLT converts an instance of ANSI/NIST-ITL version 2008 to version 2011. -->
	<!-- ******************************************************************************* -->
	<!-- 
			******************************
			Assumption of Conformant Input
			******************************
			IMPORTANT NOTE: This stylesheet assumes that it is transforming a 2008
			instance that is not just valid according to the 2008 schema, but that
			also follows all of the rules laid out in the 2008 narrative
			specification.  For example, the 2008 XML schema is not restrictive
			about what kind of image can appear in a record type.  An
			itl:IrisImage can appear inside a itl:PackageFingerprintImageRecord
			record.  However, the 2008 narrative specification forbids this.  This
			stylesheet assumes that the correct images are used inside the record
			types (and that all other rules of the 2008 specification are
			followed.)  If an instance is converted that uses an incorrect image
			type in a record type, it will convert successfully but will fail
			validation against the 2011 schema.

			For more examples, please see the items in the Change Log whose
			"Reason for Change" column shows a 7.

			******************************
			Modified or Discarded Elements
			******************************
			In other cases, there are semantic backward incompatibilities between
			the 2008 and 2011 specifications, and the XSLT must delete or alter
			content so that the 2011 instance will be valid.  In these cases, the
			content is adjusted accordingly and warning messages are delivered.
			These cases are:

			1. Record types 3, 5 and 6 and field 17.018 will be 
			discarded since they are not represented in the 2011 schema.

			2. If there are more than 5 PhysicalFeatureSecondaryColorCode in a
			single PhysicalFeatureColorDetail parent, all but the first 5 will be
			discarded.

			3. If there are more than 5 FingerprintImageSegmentPositionSquare in a
			single FingerImpressionImage parent, all but the first 4 will be
			discarded.

			4. If there are more than 5 FingerprintImageQuality in a single
			FingerImpressionImage parent, all but the first 5 will be discarded.

			5. If there are more than 5 FingerprintImageSegmentationQuality in a
			single FingerImpressionImage parent, all but the first 5 will be
			discarded.

			6. If IrisImageScanCategoryCode contains the value 2 or 3, it will be
			changed to 0 ("Undefined") because these are no longer valid values in
			2011.

			7. If CBEFFCategoryCode contains the value 2, 8, 10, 4000 20000 or
			80000, it will be changed to 0 ("No information given") because these
			are no longer valid values in 2011.

			**********
			Parameters
			**********
			It is possible to pass a parameter called "schemaLocation" to this
			XSLT.  If a value is passed for this parameter, that value is put in
			the xsi:schemaLocation attribute in the output 2011 document.  The
			value should contain the entire contents of the schemaLocation
			attribute (namespace + whitespace + schema file name).  If no value is
			provided, the xsi:schemaLocation attribute (if any) is not copied from
			the 2008 instance, because it would be pointing to the 2008 schemas
			and would therefore be incorrect.

			**********************
			Handling of Extensions
			**********************
			If an element is not in the "ansi-nist" or "itl" namespaces, the
			element itself is copied as is, and its children are then converted.

			This means that for Type-2, Type-9, or user-defined fields that are in
			a different namespace, for example the "ebts" namespace, they will
			stay in the same namespace in the output 2011 document.  However, if
			they contain descendants that are in the itl or ansi-nist namespaces,
			those descendants will be converted to the new 2011 namespaces.

			***********
			Customizing
			***********
			Implementers can extend or override this stylesheet by creating their
			own XSLT stylesheet and importing this one into it. That is the
			appropriate way to write extra templates that handle elements in other
			namespaces.
	
	-->
	<!-- ******************************************************************************* -->
	
	<xsl:param name="schemaLocation"/>
	
	<!-- Example of a parameter that might be passed to schemaLocation: -->
	<!--<xsl:param name="schemaLocation">http://biometrics.nist.gov/standard/2011 ../XMLschemas/exchange/itl.xsd http://example.org/extension ../XMLschemas/extension/example-extension.xsd</xsl:param>-->

	<xsl:template match="itl2008:NISTBiometricInformationExchangePackage">
		<itl:NISTBiometricInformationExchangePackage xmlns:itl="http://biometrics.nist.gov/standard/2011" xmlns:nc="http://niem.gov/niem/niem-core/2.0" xmlns:ext="http://example.org/extension"  xmlns:biom="http://niem.gov/niem/biometrics/1.0">
			<xsl:if test="$schemaLocation != ''">
				<xsl:attribute name="xsi:schemaLocation">
					<xsl:value-of select="$schemaLocation"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*|node()"/>
		</itl:NISTBiometricInformationExchangePackage>
	</xsl:template>

	<xsl:template match="@xsi:schemaLocation">
		<!-- Do nothing.  We do not want to copy it from the 2008 instance because it will be wrong. -->
	</xsl:template>
	
	<xsl:template match="@*|comment()|processing-instruction()|text()">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<!-- All elements that are not in the itl or ansi-nist namespaces are copied,
	     and their children processed -->
	<xsl:template match="*">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="nc:*">
		<xsl:element name="nc:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<!-- Generic namespace changes -->
	<xsl:template match="itl2008:*">
		<xsl:element name="itl:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="ansi-nist:*">
		<xsl:element name="biom:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	
	<!-- Character Encoding -->
	<xsl:template match="ansi-nist:TransactionCharacterSetDirectory">
		<xsl:choose>
			<xsl:when test="preceding-sibling::ansi-nist:TransactionCharacterSetDirectory">
				<xsl:message>Warning: only one biom:TransactionCharacterSetDirectory is allowed in ITL 2011.  All instances of ansi-nist:TransactionCharacterSetDirectory after the first one are being discarded.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<biom:TransactionCharacterSetDirectory>
					<!-- This stylesheet always outputs UTF-8 -->
				   <biom:CharacterSetCommonNameCode>UTF-8</biom:CharacterSetCommonNameCode>
				   <biom:CharacterSetIndexCode>3</biom:CharacterSetIndexCode>
				</biom:TransactionCharacterSetDirectory>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- restricted cardinalities -->
	<xsl:template match="ansi-nist:PhysicalFeatureSecondaryColorCode">
		<xsl:choose>
			<xsl:when test="count(preceding-sibling::ansi-nist:PhysicalFeatureSecondaryColorCode) > 4">
				<xsl:message>Warning: only 5 instances of PhysicalFeatureSecondaryColorCode are allowed in ITL 2011.  Discarding a PhysicalFeatureSecondaryColorCode that contains <xsl:value-of select="."/>.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<biom:PhysicalFeatureSecondaryColorCode>
					<xsl:apply-templates select="@*|node()"/>
				</biom:PhysicalFeatureSecondaryColorCode>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="itl2008:FingerprintImageSegmentPositionSquare">
		<xsl:choose>
			<xsl:when test="count(preceding-sibling::itl2008:FingerprintImageSegmentPositionSquare) > 4">
				<xsl:message>Warning: only 5 instances of FingerprintImageSegmentPositionSquare are allowed in ITL 2011.  Discarding a FingerprintImageSegmentPositionSquare that contains <xsl:value-of select="."/>.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<biom:FingerprintImageSegmentPositionSquare>
					<xsl:apply-templates select="@*|node()"/>
				</biom:FingerprintImageSegmentPositionSquare>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="itl2008:FingerprintImageQuality">
		<xsl:choose>
			<xsl:when test="count(preceding-sibling::itl2008:FingerprintImageQuality) > 4">
				<xsl:message>Warning: only 5 instances of FingerprintImageQuality are allowed in ITL 2011.  Discarding a FingerprintImageQuality that contains <xsl:value-of select="."/>.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<biom:FingerprintImageQuality>
					<xsl:apply-templates select="@*|node()"/>
				</biom:FingerprintImageQuality>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ansi-nist:FingerprintImageSegmentationQuality">
		<xsl:choose>
			<xsl:when test="count(preceding-sibling::ansi-nist:FingerprintImageSegmentationQuality) > 4">
				<xsl:message>Warning: only 5 instances of FingerprintImageSegmentationQuality are allowed in ITL 2011.  Discarding a FingerprintImageSegmentationQuality that contains <xsl:value-of select="."/>.</xsl:message>
			</xsl:when>
			<xsl:otherwise>
				<biom:FingerprintImageSegmentationQuality>
					<xsl:apply-templates select="@*|node()"/>
				</biom:FingerprintImageSegmentationQuality>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Specific element name changes: ansi-nist namespace -->
	<xsl:template match="ansi-nist:OrganizationName">
		<biom:TransactionDomainName>
			<xsl:apply-templates select="@*|node()"/>
		</biom:TransactionDomainName>
	</xsl:template>
	<xsl:template match="ansi-nist:ContentRecordCount">
		<biom:ContentRecordQuantity>
			<xsl:apply-templates select="@*|node()"/>
		</biom:ContentRecordQuantity>
	</xsl:template>
	<xsl:template match="ansi-nist:IrisEyeRotationAngleMeasure">
		<biom:IrisEyeRotationAngleText>
			<xsl:apply-templates select="@*|node()"/>
		</biom:IrisEyeRotationAngleText>
	</xsl:template>
	
	<!-- Specific element name changes: itl namespace -->
	<xsl:template match="itl2008:UserDefinedDescriptiveText">
		<itl:UserDefinedDescriptiveDetail>
			<xsl:apply-templates select="@*|node()"/>
		</itl:UserDefinedDescriptiveDetail>
	</xsl:template>
	<xsl:template match="itl2008:FingerprintImage">
		<biom:FingerImpressionImage>
			<xsl:apply-templates select="@*|node()"/>
		</biom:FingerImpressionImage>
	</xsl:template>
	
	
	<!-- Iris Image Capture reordering -->
	<xsl:template match="itl2008:IrisImage">
		<biom:IrisImage>
			<xsl:apply-templates select="@*"/>
			<!-- everything that is before ImageCaptureDetail -->
			<xsl:apply-templates select="nc:BinaryBase64Object|nc:BinaryDescriptionText|ansi-nist:ImageBitsPerPixelQuantity"/>
			<xsl:choose>
				<xsl:when test="ansi-nist:ImageCaptureDetail">
					<xsl:apply-templates select="ansi-nist:ImageCaptureDetail"/>
				</xsl:when>
				<xsl:when test="ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceGlobalIdentification|
				                ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceIdentification|
				                ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceMakeText|
				                ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceModelText|
				                ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceSerialNumberText">
				   <biom:ImageCaptureDetail>
						<xsl:apply-templates select="ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceGlobalIdentification|
											 ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceIdentification|
											 ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceMakeText|
											 ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceModelText|
											 ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceSerialNumberText"/>
				   </biom:ImageCaptureDetail>
				</xsl:when>
			</xsl:choose>
			<!-- everything that is after ImageCaptureDetail -->
			<xsl:apply-templates select="ansi-nist:ImageColorSpaceCode|ansi-nist:ImageColorSpaceText|ansi-nist:ImageCommentText|ansi-nist:ImageCompressionAlgorithmCode|ansi-nist:ImageCompressionAlgorithmText|ansi-nist:ImageHorizontalLineLengthPixelQuantity|ansi-nist:ImageHorizontalPixelDensityValue|ansi-nist:ImageQuality|ansi-nist:ImageRecordCategoryCode|ansi-nist:ImageReferenceIdentification|ansi-nist:ImageScaleUnitsCode|ansi-nist:ImageCategoryCode|ansi-nist:ImageVerticalLineLengthPixelQuantity|ansi-nist:ImageVerticalPixelDensityValue|ansi-nist:IrisEyePositionCode|ansi-nist:IrisEyePositionText|ansi-nist:IrisEyeRotationAngleMeasure|ansi-nist:IrisEyeRotationUncertaintyValueText|ansi-nist:IrisImageCapture|ansi-nist:IrisEyeColorAttributeCode|ansi-nist:IrisImageAcquisitionLightingSpectrumValue|itl:IrisDiameterPixelQuantity"/>
		</biom:IrisImage>
	</xsl:template>
	
	<xsl:template match="itl2008:IrisImage/ansi-nist:ImageCaptureDetail">
		<biom:ImageCaptureDetail>
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="ansi-nist:CaptureDate|ansi-nist:CaptureDescriptionCode|ansi-nist:CaptureDescriptionText"/>
			<!-- add moved elements here -->
			<xsl:apply-templates select="../ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceGlobalIdentification|
								 ../ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceIdentification|
								 ../ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceMakeText|
								 ../ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceModelText|
								 ../ansi-nist:IrisImageCapture/ansi-nist:CaptureDeviceSerialNumberText"/>
			<xsl:apply-templates select="ansi-nist:CaptureHorizontalPixelDensityValue|ansi-nist:CaptureOrganization|ansi-nist:CaptureResolutionCode|ansi-nist:CaptureResolutionText|ansi-nist:CaptureSourceCode|ansi-nist:CaptureSourceText|ansi-nist:CaptureVerticalPixelDensityValue|ansi-nist:CaptureDeviceMonitoringModeCode|ansi-nist:CaptureDeviceMonitoringModeText"/>
		</biom:ImageCaptureDetail>
	</xsl:template>

	<xsl:template match="ansi-nist:IrisImageCapture">
		<biom:IrisImageCapture>
			<xsl:apply-templates select="@*"/>
			<!-- skip moved elements here - they are included in ImageCaptureDetail -->
			<xsl:apply-templates select="ansi-nist:IrisImageHorizontalOrientationCode|ansi-nist:IrisImageScanCategoryCode|ansi-nist:IrisImageVerticalOrientationCode"/>
		</biom:IrisImageCapture>
	</xsl:template>

	<!-- Move example extensions from itl to ext -->
	<xsl:template match="itl2008:ExampleDomainDefinedDescriptiveText">
		<ext:ExampleDomainDefinedDescriptiveDetail>
			<xsl:apply-templates select="@*|node()"/>
		</ext:ExampleDomainDefinedDescriptiveDetail>
	</xsl:template>
	<xsl:template match="itl2008:ExampleOtherDescriptiveText">
		<ext:ExampleOtherDescriptiveDetail>
			<xsl:apply-templates select="@*|node()"/>
		</ext:ExampleOtherDescriptiveDetail>
	</xsl:template>
	<xsl:template match="itl2008:ExampleUserDefinedFields">
		<ext:ExampleUserDefinedFields>
			<xsl:apply-templates select="@*|node()"/>
		</ext:ExampleUserDefinedFields>
	</xsl:template>
	<xsl:template match="itl2008:ExampleRecordImage">
		<ext:ExampleRecordImage>
			<xsl:apply-templates select="@*|node()"/>
		</ext:ExampleRecordImage>
	</xsl:template>

	<!-- Specific element content changes: ansi-nist namespace -->
	<xsl:template match="ansi-nist:FaceImageDescriptionCode[normalize-space(.) = 'RAISED EYEBROWS']">
		<biom:FaceImageDescriptionCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>RAISED BROWS</xsl:text>
		</biom:FaceImageDescriptionCode>
	</xsl:template>
	<xsl:template match="ansi-nist:CaptureSourceCode[normalize-space(.) = 'ANALOGUE VIDEO']">
		<biom:CaptureSourceCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>ANALOG VIDEO</xsl:text>
		</biom:CaptureSourceCode>
	</xsl:template>
	<xsl:template match="ansi-nist:PhysicalFeatureSubClassCode[normalize-space(.) = 'HEADBND']">
		<biom:PhysicalFeatureSubClassCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>HEDBND</xsl:text>
		</biom:PhysicalFeatureSubClassCode>
	</xsl:template>
	<xsl:template match="ansi-nist:IrisImageAcquisitionLightingSpectrumValue">
		<biom:IrisImageAcquisitionLightingSpectrum>
			<xsl:apply-templates select="@*"/>
			<biom:AcquisitionLightingSpectrumCode>
				<xsl:value-of select="."/>
			</biom:AcquisitionLightingSpectrumCode>
		</biom:IrisImageAcquisitionLightingSpectrum>
	</xsl:template>
	<xsl:template match="ansi-nist:FingerPatternCode">
		<xsl:choose>
			<!-- set codes and user-defined codes were both in FingerPatternCode in 2008.  -->
			<!-- need to be split into two elements in 2011 for NIEM conformance -->
			<xsl:when test="normalize-space(.) = 'PA' or
								 normalize-space(.) = 'TA' or
								 normalize-space(.) = 'RL' or
								 normalize-space(.) = 'UL' or
								 normalize-space(.) = 'PW' or
								 normalize-space(.) = 'CP' or
								 normalize-space(.) = 'DL' or
								 normalize-space(.) = 'AW' or
								 normalize-space(.) = 'WN' or
								 normalize-space(.) = 'RS' or
								 normalize-space(.) = 'LS' or
								 normalize-space(.) = 'SR' or
								 normalize-space(.) = 'XX' or
								 normalize-space(.) = 'UN'">
				<biom:FingerPatternCode>
					<xsl:apply-templates select="@*|node()"/>
				</biom:FingerPatternCode>
			</xsl:when>
			<xsl:otherwise>
				<biom:FingerPatternText>
					<xsl:apply-templates select="@*|node()"/>
				</biom:FingerPatternText>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="ansi-nist:IrisImageScanCategoryCode[(. = 2) or (. = 3)]">
		<biom:IrisImageScanCategoryCode>
			<xsl:apply-templates select="@*"/>
			<xsl:message>Warning: IrisImageScanCategoryCode cannot contain the value 2 or 3 in ITL 2011. The value was modified to 0 ("Undefined").</xsl:message>
			<xsl:text>0</xsl:text>
		</biom:IrisImageScanCategoryCode>
	</xsl:template>
	<xsl:template match="ansi-nist:CBEFFCategoryCode[(. = 2) or (. = 8) or (. = 10) or (. = 4000) or (. = 20000) or (. = 80000)]">
		<xsl:message>Warning: CBEFFCategoryCode cannot contain the value 2, 8, 10, 4000, 20000 or 80000 in ITL 2011. The value was modified to 0 ("No information given").</xsl:message>
		<biom:CBEFFCategoryCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>0</xsl:text>
		</biom:CBEFFCategoryCode>
	</xsl:template>	

	<!-- Turn NIEM deprecated elements into preferred elements -->
	<xsl:template match="itl2008:FaceImage|itl2008:FaceImageAcquisitionSource|itl2008:CaptureSourceDescriptionText|itl2008:PalmprintImage|itl2008:PalmprintImageQuality|itl2008:FingerprintImageFingerMissing|itl2008:FingerMissingCode|itl2008:FingerprintImageSegmentPositionPolygon|itl2008:PositionPolygonVertexQuantity|itl2008:PositionPolygonVertex|itl2008:TestImage|itl2008:IrisDiameterPixelQuantity">
		<xsl:element name="biom:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="ansi-nist:QualityMeasureVendorIdentification">
		<biom:QualityAlgorithmVendorIdentification>
			<xsl:apply-templates select="@*|node()"/>
		</biom:QualityAlgorithmVendorIdentification>
	</xsl:template>



	<!-- Deleted ITL deprected Record Types 3, 5 and 6 and field 17.018 -->
	<xsl:template match="itl2008:PackageLowResolutionGrayscaleImageRecord|itl2008:PackageLowResolutionBinaryImageRecord|itl2008:PackageHighResolutionBinaryImageRecord">
		<xsl:message>Warning: Record type <xsl:value-of select="local-name(.)"/> is not allowed in ITL 2011, and it was deleted.</xsl:message>
	</xsl:template>
	<xsl:template match="ansi-nist:ContentRecordSummary[(ansi-nist:RecordCategoryCode = 3) or (ansi-nist:RecordCategoryCode = 5) or (ansi-nist:RecordCategoryCode = 6)]">
		<xsl:message>Warning: Record type <xsl:value-of select="ansi-nist:RecordCategoryCode"/> is not allowed in ITL 2011, and its ContentRecordSummary was deleted.</xsl:message>
	</xsl:template>
	<xsl:template match="ansi-nist:CaptureDeviceGlobalIdentification">
		<!-- Field 17.018 -->
		<xsl:message>Warning: Element <xsl:value-of select="name(.)"/> is not allowed in ITL 2011, and it was deleted.</xsl:message>
	</xsl:template>

</xsl:stylesheet>