<?xml version='1.0' ?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="xsl itl2011 biom xsi ext" xmlns:itl="http://biometrics.nist.gov/standard/2-2008"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:itl2011="http://biometrics.nist.gov/standard/2011" xmlns:nc="http://niem.gov/niem/niem-core/2.0" xmlns:ext="http://example.org/extension" xmlns:ansi-nist="http://niem.gov/niem/ansi-nist/2.0" xmlns:biom="http://niem.gov/niem/biometrics/1.0" >
	<xsl:output indent="yes" method="xml" encoding="UTF-8"/>
	
	<!-- ******************************************************************************* -->
	<!-- This XSLT converts an instance of ANSI/NIST-ITL version 2011 to version 2008. -->
	<!-- ******************************************************************************* -->
	<!-- 
			******************
			Discarded Elements
			******************
			All elements (representing either fields or records) that do not have 
			a semantic equivalent in 2008 are deleted, and a warning is issued.

			In addition, Type-13 records that contain plantar or undefined latent
			images are removed in their entirety.

			*******************
			Invalid Code Values
			*******************
			This XSLT makes no attempt to fix up elements that contain code values 
			that are new in 2011, because it cannot make any assumptions about how 
			these values should be converted.  If 2011-only code values are 
			encountered, they are copied as is, and the resulting 2008 document 
			will not pass schema validation.

			*********************
			Invalid Cardinalities
			*********************
			This XSLT makes no attempt to correct the cardinality of elements that 
			may be more loosely constrained in 2011, because it cannot make any 
			assumptions about how these elements should be converted. For example, 
			if an element can appear 1 to 4 times in version 2008, and 0 to 9 
			times in 2011. If 9 instances of the element appear in the 2011 
			instance, all 9 are copied, and the resulting 2008 document will not 
			pass schema validation.

			**********
			Parameters
			**********
			It is possible to pass a parameter called "schemaLocation" to this
			XSLT.  If a value is passed for this parameter, that value is put in
			the xsi:schemaLocation attribute in the output 2011 document.  The
			value should contain the entire contents of the schemaLocation
			attribute (namespace + whitespace + schema file name).  If no value is
			provided, the xsi:schemaLocation attribute (if any) is not copied from
			the 2008 instance, because it would be pointing to the 2008 schemas
			and would therefore be incorrect.

			**********************
			Handling of Extensions
			**********************
			If an element is not in the "biom" or "itl" namespaces, the
			element itself is copied as is, and its children are then converted.

			This means that for Type-2, Type-9, or user-defined fields that are in
			a different namespace, for example the "ebts" namespace, they will
			stay in the same namespace in the output 2008 document.  However, if
			they contain descendants that are in the itl or biom namespaces,
			those descendants will be converted to the old 2008 itl or ansi-nist namespaces.

			***********
			Customizing
			***********
			Implementers can extend or override this stylesheet by creating their
			own XSLT stylesheet and importing this one into it. That is the
			appropriate way to write extra templates that handle elements in other
			namespaces.
	
	-->
	<!-- ******************************************************************************* -->

	<!--<xsl:param name="schemaLocation"/>-->
	
	<!-- Example of a parameter that might be passed to schemaLocation: -->
	<xsl:param name="schemaLocation">http://biometrics.nist.gov/standard/2-2008 ITL-2008-Package-Annex-B.xsd</xsl:param>

	<xsl:template match="itl2011:NISTBiometricInformationExchangePackage">
		<itl:NISTBiometricInformationExchangePackage xmlns:itl="http://biometrics.nist.gov/standard/2-2008" xmlns:nc="http://niem.gov/niem/niem-core/2.0" xmlns:ansi-nist="http://niem.gov/niem/ansi-nist/2.0">
			<xsl:if test="$schemaLocation != ''">
				<xsl:attribute name="xsi:schemaLocation">
					<xsl:value-of select="$schemaLocation"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*|node()"/>
		</itl:NISTBiometricInformationExchangePackage>
	</xsl:template>

	<xsl:template match="@xsi:schemaLocation">
		<!-- Do nothing.  We do not want to copy it from the 2008 instance because it will be wrong. -->
	</xsl:template>
	
	<xsl:template match="@*|comment()|processing-instruction()|text()">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<!-- All elements that are not in the itl or biom namespaces are copied,
	     and their children processed -->
	<xsl:template match="*">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="nc:*">
		<xsl:element name="nc:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<!-- Generic namespace changes -->
	<xsl:template match="itl2011:*">
		<xsl:element name="itl:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="biom:*">
		<xsl:element name="ansi-nist:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<!-- Character Encoding -->
	<xsl:template match="biom:TransactionCharacterSetDirectory">
		<ansi-nist:TransactionCharacterSetDirectory>
			<!-- This stylesheet always outputs UTF-8 -->
			<ansi-nist:CharacterSetCommonNameCode>UTF 8-bit</ansi-nist:CharacterSetCommonNameCode>
			<ansi-nist:CharacterSetIndexCode>003</ansi-nist:CharacterSetIndexCode>
		</ansi-nist:TransactionCharacterSetDirectory>
	</xsl:template>

	<!-- Specific element name changes: biom namespace -->
	<xsl:template match="biom:TransactionDomainName">
		<ansi-nist:OrganizationName>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:OrganizationName>
	</xsl:template>
	<xsl:template match="biom:ContentRecordQuantity">
		<ansi-nist:ContentRecordCount>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:ContentRecordCount>
	</xsl:template>
	<xsl:template match="biom:AcquisitionLightingSpectrumCode">
		<ansi-nist:IrisImageAcquisitionLightingSpectrumValue>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:IrisImageAcquisitionLightingSpectrumValue>
	</xsl:template>
	<xsl:template match="biom:FingerPatternText">
		<ansi-nist:FingerPatternCode>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:FingerPatternCode>
	</xsl:template>
	<xsl:template match="biom:IrisEyeRotationAngleText">
		<ansi-nist:IrisEyeRotationAngleMeasure>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:IrisEyeRotationAngleMeasure>
	</xsl:template>
	
	<!-- Specific element name changes: itl2011 namespace -->
	<xsl:template match="itl2011:UserDefinedDescriptiveDetail">
		<itl:UserDefinedDescriptiveText>
			<xsl:apply-templates select="@*|node()"/>
		</itl:UserDefinedDescriptiveText>
	</xsl:template>
	<xsl:template match="biom:FingerImpressionImage">
		<itl:FingerprintImage>
			<xsl:apply-templates select="@*|node()"/>
		</itl:FingerprintImage>
	</xsl:template>
	
	
	<!-- Iris Image Capture reordering -->
	<xsl:template match="itl2011:IrisImage|biom:IrisImage">
		<itl:IrisImage>
			<xsl:apply-templates select="@*"/>
			<!-- everything that is before IrisImageCapture -->
			<xsl:apply-templates select="nc:BinaryBase64Object|nc:BinaryDescriptionText|biom:ImageBitsPerPixelQuantity|biom:ImageCaptureDetail|biom:ImageColorSpaceCode|biom:ImageColorSpaceText|biom:ImageCommentText|biom:ImageCompressionAlgorithmCode|biom:ImageCompressionAlgorithmText|biom:ImageHorizontalLineLengthPixelQuantity|biom:ImageHorizontalPixelDensityValue|biom:ImageQuality|biom:ImageRecordCategoryCode|biom:ImageReferenceIdentification|biom:ImageScaleUnitsCode|biom:ImageCategoryCode|biom:ImageVerticalLineLengthPixelQuantity|biom:ImageVerticalPixelDensityValue|biom:IrisEyePositionCode|biom:IrisEyePositionText|biom:IrisEyeRotationAngleMeasure|biom:IrisEyeRotationUncertaintyValueText"/>
			<xsl:choose>
				<xsl:when test="biom:IrisImageCapture">
					<xsl:apply-templates select="biom:IrisImageCapture"/>
				</xsl:when>
				<xsl:when test="biom:ImageCaptureDetail/biom:CaptureDeviceIdentification|
				                biom:ImageCaptureDetail/biom:CaptureDeviceMakeText|
				                biom:ImageCaptureDetail/biom:CaptureDeviceModelText|
				                biom:ImageCaptureDetail/biom:CaptureDeviceSerialNumberText">
				   <biom:IrisImageCapture>
						<xsl:apply-templates select="biom:ImageCaptureDetail/biom:CaptureDeviceIdentification|
											 biom:ImageCaptureDetail/biom:CaptureDeviceMakeText|
											 biom:ImageCaptureDetail/biom:CaptureDeviceModelText|
											 biom:ImageCaptureDetail/biom:CaptureDeviceSerialNumberText"/>
				   </biom:IrisImageCapture>
				</xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="biom:IrisEyeColorAttributeCode|biom:IrisImageAcquisitionLightingSpectrum|itl2011:IrisDiameterPixelQuantity|biom:IrisDiameterPixelQuantity|biom:IrisImageAcquisitionProfileCode|biom:IrisImageStorageFormatCode|biom:IrisImageIrisPupilBoundary|biom:IrisImageIrisScleraBoundary|biom:IrisImageIrisUpperEyelidBoundary|biom:IrisImageIrisLowerEyelidBoundary|biom:IrisImageOcclusion|biom:IrisImageRangeMeasure|biom:IrisImageGazeAngleMeasure"/>
		</itl:IrisImage>
	</xsl:template>
	
	<xsl:template match="biom:IrisImageCapture">
		<ansi-nist:IrisImageCapture>
			<xsl:apply-templates select="@*"/>
			<!-- add moved elements here -->
			<xsl:apply-templates select="../biom:ImageCaptureDetail/biom:CaptureDeviceIdentification|
								 ../biom:ImageCaptureDetail/biom:CaptureDeviceMakeText|
								 ../biom:ImageCaptureDetail/biom:CaptureDeviceModelText|
								 ../biom:ImageCaptureDetail/biom:CaptureDeviceSerialNumberText"/>
			<xsl:apply-templates/>
		</ansi-nist:IrisImageCapture>
	</xsl:template>

	<xsl:template match="itl2011:IrisImage/biom:ImageCaptureDetail|biom:IrisImage/biom:ImageCaptureDetail">
		<ansi-nist:ImageCaptureDetail>
			<xsl:apply-templates select="@*"/>
			<!-- skip moved elements here - they are included in IrisImageCapture -->
			<xsl:apply-templates select="biom:CaptureDate|biom:CaptureDescriptionCode|biom:CaptureDescriptionText|biom:CaptureHorizontalPixelDensityValue|biom:CaptureOrganization|biom:CaptureResolutionCode|biom:CaptureResolutionText|biom:CaptureSourceCode|biom:CaptureSourceText|biom:CaptureVerticalPixelDensityValue|biom:CaptureDeviceMonitoringModeCode|biom:CaptureDeviceMonitoringModeText"/>
		</ansi-nist:ImageCaptureDetail>
	</xsl:template>


	<!-- Move example extensions from ext to itl  -->
	<xsl:template match="ext:ExampleDomainDefinedDescriptiveDetail">
		<itl:ExampleDomainDefinedDescriptiveText>
			<xsl:apply-templates select="@*|node()"/>
		</itl:ExampleDomainDefinedDescriptiveText>
	</xsl:template>
	<xsl:template match="ext:ExampleOtherDescriptiveDetail">
		<itl:ExampleOtherDescriptiveText>
			<xsl:apply-templates select="@*|node()"/>
		</itl:ExampleOtherDescriptiveText>
	</xsl:template>
	<xsl:template match="ext:ExampleUserDefinedFields">
		<itl:ExampleUserDefinedFields>
			<xsl:apply-templates select="@*|node()"/>
		</itl:ExampleUserDefinedFields>
	</xsl:template>
	<xsl:template match="ext:ExampleRecordImage">
		<itl:ExampleRecordImage>
			<xsl:apply-templates select="@*|node()"/>
		</itl:ExampleRecordImage>
	</xsl:template>


	<!-- Specific element content changes: ansi-nist namespace -->
	<xsl:template match="biom:FaceImageDescriptionCode[normalize-space(.) = 'RAISED BROWS']">
		<ansi-nist:FaceImageDescriptionCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>RAISED EYEBROWS</xsl:text>
		</ansi-nist:FaceImageDescriptionCode>
	</xsl:template>
	<xsl:template match="biom:CaptureSourceCode[normalize-space(.) = 'ANALOG VIDEO']">
		<ansi-nist:CaptureSourceCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>ANALOGUE VIDEO</xsl:text>
		</ansi-nist:CaptureSourceCode>
	</xsl:template>
	<xsl:template match="biom:PhysicalFeatureSubClassCode[normalize-space(.) = 'HEDBND']">
		<ansi-nist:PhysicalFeatureSubClassCode>
			<xsl:apply-templates select="@*"/>
			<xsl:text>HEADBND</xsl:text>
		</ansi-nist:PhysicalFeatureSubClassCode>
	</xsl:template>
	<xsl:template match="biom:IrisImageAcquisitionLightingSpectrum">
		<!-- don't copy it - no equivalent of this structural element in 2-2008 - just process the children -->
		<xsl:apply-templates/>
	</xsl:template>



	<!-- Turn preferred elements into deprecated elements -->
	<xsl:template match="biom:FaceImage|biom:FaceImageAcquisitionSource|biom:CaptureSourceDescriptionText|biom:PalmprintImage|biom:FingerprintImageQuality|biom:PalmprintImageQuality|biom:FingerprintImageFingerMissing|biom:FingerMissingCode|biom:FingerprintImageSegmentPositionSquare|biom:FingerprintImageSegmentPositionPolygon|biom:PositionPolygonVertexQuantity|biom:PositionPolygonVertex|biom:TestImage|biom:IrisDiameterPixelQuantity">
		<xsl:element name="itl:{local-name(.)}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="biom:ImageQuality/biom:QualityAlgorithmVendorIdentification">
		<ansi-nist:QualityMeasureVendorIdentification>
			<xsl:apply-templates select="@*|node()"/>
		</ansi-nist:QualityMeasureVendorIdentification>
	</xsl:template>

	<!-- Record Types that don't exist in 2008 -->
	<xsl:template match="itl2011:PackageDNARecord|itl2011:PackagePlantarImageRecord|itl2011:PackageSourceRepresentationRecord|itl2011:PackageAssociatedContextRecord|itl2011:PackageInformationAssuranceRecord">
		<xsl:message>Warning: Record type <xsl:value-of select="local-name(.)"/> is not allowed in ITL 2008, and it was deleted.</xsl:message>
	</xsl:template>
	<xsl:template match="biom:ContentRecordSummary[(biom:RecordCategoryCode = 18) or (biom:RecordCategoryCode = 19) or (biom:RecordCategoryCode = 20) or (biom:RecordCategoryCode = 21) or (biom:RecordCategoryCode = 98)]">
		<xsl:message>Warning: Record type <xsl:value-of select="biom:RecordCategoryCode"/> is not allowed in ITL 2008, and its ContentRecordSummary was deleted.</xsl:message>
	</xsl:template>

	<!-- Eliminate Type 13 records with plantars or unspecified latent images -->
	<!-- todo find the equivalent record summary and delete that too -->
	<xsl:template match="itl2011:PackageLatentImageRecord[.//biom:PlantarImage]|itl2011:PackageLatentImageRecord[.//biom:FrictionRidgeImage]">
		<xsl:message>Warning: Record type 13 with descendant PlantarImage or FrictionRidgeImage is not allowed in ITL 2008, and it was deleted.</xsl:message>
	</xsl:template>

	<!-- Fields that don't exist in 2008 -->
	<xsl:template match="biom:AcquisitionLightingSpectrumLowerMeasure|biom:AcquisitionLightingSpectrumUpperMeasure|ext:ExampleRecordMinutiae|biom:ProcessAnnotation|biom:AssociatedContext|biom:ImageHashValue|biom:SourceRepresentation|biom:CaptureLocation|biom:CaptureUTCDateTime|biom:ExtendedFeatureSetMinutiae|biom:INCITSMinutiae|biom:OtherMinutiae|biom:TransactionApplicationProfile|biom:IrisImageAcquisitionProfileCode|biom:IrisImageStorageFormatCode|biom:IrisImageIrisPupilBoundary|biom:IrisImageIrisScleraBoundary|biom:IrisImageIrisUpperEyelidBoundary|biom:IrisImageIrisLowerEyelidBoundary|biom:IrisImageOcclusion|biom:IrisImageRangeMeasure|biom:IrisImageGazeAngleMeasure|biom:FingerprintImageStitchedIndicator|biom:FingerprintImageAcquisitionProfileCode|biom:PlantarImage|biom:FrictionRidgeImage|biom:MinutiaeUniversalLatentWorkstationAnnotationText|biom:BiometricCaptureDetail|biom:FaceImageBoundingSquare|biom:FaceImageLightingArtifactsCode|biom:FaceImageFeaturePointTierCode|biom:FaceImageFeaturePointTierNumeric|biom:FaceImage3DFeaturePoint|biom:FaceImageContour|biom:ImageTransformationCode|biom:FaceImageOcclusion|biom:ImageDistortion|biom:PhysicalFeatureReferenceIdentification|biom:CaptureIdentification|biom:FaceImageBoundary|biom:PalmprintImageMissingArea|biom:IrisImageMissingReasonCode|itl2011:FaceImage/biom:ImageCommentText|biom:FaceImage/biom:ImageCommentText|itl2011:PhysicalFeatureImage/biom:ImageCommentText|biom:PhysicalFeatureImage/biom:ImageCommentText">
		<xsl:message>Warning: Element <xsl:value-of select="name(.)"/> has no equivalent in ITL 2008, and it was deleted along with all of its contents.</xsl:message>
	</xsl:template>
	

	<!-- Remove leading zeros -->
	<xsl:template match="biom:CBEFFCategoryCode">
		<ansi-nist:CBEFFCategoryCode>
			<xsl:apply-templates select="@*"/>
			<xsl:number format="0" value="number(.)"/>
		</ansi-nist:CBEFFCategoryCode>
	</xsl:template>

	
</xsl:stylesheet>