C     Last change:  CP    5 Jan 2000    3:00 pm
***********************************************************************
*
*       Program name: MKDATA
*       Version:      3.3 (Revised from Ver.3.2 dated 5/12/00 to include
*                         the option in the provision of Sections 9.10 and
*                         11.3.11.3 of ASHRAE 103-93 (Option of no cool-down
*                         and heat-up cyclic flue loss tests for single stage,
*                         condensing furnace/boiler).
*                     3.2 (Revised from Version 3.1 dated 3/10/98 to
*                         clarify input instructions on variables XCO2S
*                         and TSSSX (both single stage and modulating
*                         cases. There is no other changes.)
*       Date:         August 15, 2001
*    
*       Purpose:      This program interactively generates an input data
*                     file for use as input file to the AFUEBF program.
*
* ---------------------------------------------------------------------
 
      program   MKDATA

      implicit  real(a-z)
      integer   i, k, inp, out, ndata, ios
      integer   NSYS,FUEL,TYPE,CTRL,OPTEST,INST,IFRATE,ipurge,CHOICE
      logical   conden
      character title(2)*80, answer*1, infile*80, indata*80
      character blank*4
      data      blank /'    '/, out/7/

      print *, ' *****************************************************'
c     print *, ' *                                                   *'
      print *, ' *                MKDATA  ver. 3.3 (date:  8/15/01)  *'
      print *, ' *                                                   *'
      print *, ' *  This program generates an input data file inter- *'
      print *, ' *  actively. The generated file can then be used as *'
      print *, ' *  input to the AFUEBF program. Also the input data *'
      print *, ' *  file can be seen in the form as appeared         *'
      print *, ' *  in the output data file of the AFUEBF program.   *'
      print *, ' *                                                   *'
      print *, ' *  Please note that you are responsible for entering*'
      print *, ' *  the correct data SPECIFIED in the ASHRAE 103-1993*'
      print *, ' *  (and the DOE spec. if you are following the DOE  *'
      print *, ' *  test procedure (Appendix N, 10 CFR Part 430).    *'
      print *, ' *  The program does not check for error in the data.*'
      print *
      print *, ' *  To continue, press [ENTER] key.                  *'
      print *, ' *                            (ENTER) = '
      read  3000, answer
      print *, ' *****************************************************'
      print *, ' *                   DISCLAIMER                      *'
      print *, ' *                                                   *'
      print *, ' * This program is furnished by the government and is*'
      print *, ' * accepted and used by any person with the express  *'
      print *, ' * understanding that the United States Government   *'
      print *, ' * makes no warrenty, expressed or implied, concern- *'
      print *, ' * ing the accuracy, completeness, reliability,      *'
      print *, ' * usability, or suitability, for any particular pur-*'
      print *, ' * pose, of the information and data contained in    *'
      print *, ' * this program or furnished in connection therewith,*'
      print *, ' * and the United States shall be under no liability *'
      print *, ' * whatsoever to any person by reason of any use made*'
      print *, ' * thereof.                                          *'
      print *, ' *****************************************************'
      print *
      print *, ' *  To continue, press [ENTER] key.                  *'
      print *, '                              (ENTER) = '
      read 3000, answer
      print *
      print *, '******************************************************'
1     print *, ' Select your choice :'
      print *
      print *, ' CHOICE: ' 
      print *, '    1 =  Create a new input data file to AFUEBF.'
c     print *
      print *, '    2 =  Add more data sets on an old data file.'
c     print *
      print *, '    3 =  Create a file called CHECK.DAT that displays'
      print *, '         the input data in the same form as they are'
      print *, '         displayed in the output of the AFUEBF program.'
c     print *
      print *, ' Enter the number for your choice : '
      read  (*, *, err = 1)   CHOICE
      
      print *, ' Your choice is ', CHOICE
      print *
      print *, ' Is your choice correct ?   '
      print *    
      print *, ' PLEASE NOTE: You must answer "yes" or "no" to all '
      print *, '              such questions. '
      print *, ' To answer "yes", you may hit the [ENTER] key,'
      print *, '   type "y", or type "Y".'
      print *
      print *, ' To answer "no", you MUST enter "n" or "N".'
      print *, '                                       (Yes)  = '
      read 3000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N') then
         goto 1
      endif
     
      if (CHOICE .eq. 1) then
2        print *,' Please enter the new data file name.'
         print *,' =>'
         read 1000, infile

         open(unit=out, file = infile, status='new', iostat=ios)
         if (ios .ne. 0) then
             print *, ' The named file already exists.'
             close (unit=out)
             goto 2
         endif

      else if (CHOICE .eq. 2) then
3        print *,' Please enter the old data file name.'
         print *,' =>'
         read 1000, infile

         open(unit=out, file = infile, status='old', iostat=ios)
         if (ios .ne. 0) then
            print *, ' The named file does not exist.'
            close( unit=out)
            goto 3
         endif
         do 4 k = 1, 1000   
             read (out, 1000, end=6 ) indata
             if ( indata .eq. blank ) goto 5
4        continue
5        backspace (unit=out)
6        print *, ' Adding  one or more data sets. '
  
      else if ( CHOICE .eq. 3) then
         print *, ' A file called CHECK.DAT will be made. '
7        print *,'  Please enter the old data file name.'
         print *,' =>'
         read 1000, infile
         open(unit=out, file = infile, status='old', iostat=ios)
         if (ios .ne. 0) then
            print *, ' The named file does not exist.'
            close( unit=out)
            goto 7
         endif
         close(unit=out)
         goto 700    
      else
         print *, ' Your choice is not valid. Re-enter. '
         goto 1

      endif

*     Entering input data
      
      i = 1

8     print *
      print *, '--------------------------------------------------'
      print *, ' Enter the first line of title up to 80 characters. '
      print *, ' No blank line is allowed.'
      print *, ' =>'
      read 1000, TITLE(1)
      print *, ' Enter the second line of title up to 80 characters. '
      print *, ' No blank line is allowed.'
      print *, ' =>'
      read 1000, TITLE(2)
      print *
      print 1100, TITLE
      print *
      print *, ' Did you answer the data correctly ? (Yes) = '    
      read 3000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N') then
         goto 8
      else
         write(out,1000) TITLE(1)
         write(out,1000) TITLE(2)
      endif
       
9     print *
      print *, '--------------------------------------------------'
      print *, ' Type of heating unit '
      print *, ' TYPE:      1 = Furnace'
      print *, '            2 = Condensing furnace'
      print *, '            3 = Condensing boiler'
      print *, '            4 = Finned tube boiler'
      print *, '            5 = Boiler'
      print * 
10    print *, ' Enter the TYPE number : '
      read  (*, *, err = 10)    TYPE
      print *
      print *, '--------------------------------------------------'
      print *, ' Installation '
      print *, ' INST:      1 = Indoors'
      print *, '            2 = Outdoors'
      print *, '            3 = Isolated combustion'
      print * 
20    print *, ' Enter the INST number : '
      read  (*, *, err = 20)   INST

c     print *, ' ======================================================'
      print *, ' System number, NSYS         1  2  3  4  5  6  8  9  10'
      print *, ' ======================================================'
      print *, ' Indoor Combustion Air       x  x  x  x  x  x  x       '
      print *, ' ------------------------------------------------------'
      print *, ' Outdoor, Direct Vent or                               '
      print *, ' Isolated Combust. System                         x  x '
      print *, ' ------------------------------------------------------'
      print *, ' Direct Exhaust                    x                   '
      print *, ' ------------------------------------------------------'
      print *, ' Draft Hood/Draft Diverter   x  x        x  x          '
      print *, ' ------------------------------------------------------'
      print *, ' Barometric Draft Control             x        x       '
      print *, ' ------------------------------------------------------'
      print *, ' Stack Damper                            x  x  x       '
      print *, ' ------------------------------------------------------'
      print *, ' Atmospheric Burner          x           x        x    '
      print *, ' ------------------------------------------------------'
      print *, ' Power Burner                   x  x  x     x  x    x  '
      print *, ' ------------------------------------------------------'
      print *, ' Atmospheric Burner w/Inlet                            '
      print *, ' or Flue Damper              x                    x    '
      print *, ' ------------------------------------------------------'
      print *, 'NOTE: Atm.burner may/may not include inlet/flue damper'
c     print *
      print *, ' Enter the system number : '
      read  *,   NSYS

      print *
      print *, '--------------------------------------------------'
      print *, ' Type of fuel '
      print *, ' FUEL:       1 = No.1 oil'
      print *, '             2 = No.2 oil'
      print *, '             3 = Natural gas'
      print *, '             4 = Manufactured gas'
      print *, '             5 = Propane'
      print *, '             6 = Butane'
      print * 
30    print *, ' Enter the FUEL number : '
      read  (*, *, err = 30)   FUEL

      print *
      print *, '--------------------------------------------------'
      print *, ' Control Mode '
      print *, ' CTRL:       1 = Single stage control'
      print *, '             2 = Two stage control'
      print *, '             3 = Step modulating control'
      print * 
40    print *, ' Enter the CTRL number : '
      read  (*, *, err = 40)   CTRL

      print *
      print *, '--------------------------------------------------'
      print *, ' Test Option '
      print *, ' OPTEST: 0 = No optional tracer gas test'
      print *, '         1 = Optional tracer gas test'
      print *, '         2 = Direct vent unit with opt. tracer gas test'
      print *, '             or, Atm.burner w/inlet or flue damper'
      print *, '             with tracer gas test measured KL'
      print * 
50    print *, ' Enter the OPTEST number : '
      read  (*, *, err = 50)  OPTEST

      print *
      print *, '---------------------------------------------------'
      print *, 'Post Purge '
      print *, ' IPURGE:     0 = No post purge, or not a power burner'
      print *, '             1 = post purge w/length of time tp min'
      print *
52    print *, 'Enter the IPURGE number : '
      read(*, *, err = 52)  IPURGE

      print *
      print 1400, TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge
      print *
      print *, ' Did you answer the data correctly ? (Yes) = '    
      read 3000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N') then
         goto 9
      else
         write(out,2400) TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge
      endif

55    print *
      print *, '--------------------------------------------------'
60    print *, ' QP: Fuel input rate to pilot light, Btu/h = '
      read  (*, *, err = 60)  QP
70    print *, ' PE: Electric power to burner, kW          = '
      read  (*, *, err = 70)   PE
80    print *, ' BE: Electric power to circulating air blower or water'
      print *, '     pump, Kw                              = '
      read  (*, *, err = 80)   BE
90    print *, ' LJ: Jacket loss, %                        = '
      read  (*, *, err = 90)   LJ

      print *
      print *, '--------------------------------------------------'
      print *, 'Power burner draft factor'
      print *, 'DP = 0.  Atmos. burner without inlet/flue damper'
      print *, '   = 0.  Power burner if OPTEST = 0 or 1'
      print *, '         (default to 0.4 in Prog. AFUEBF if OPTEST = 0)'
      print *, '   = 0.05  For units complying with section 8.8.3'
      print *, '   = 0.  Direct vent system if OPTEST = 2'
      print *, '   = Separately measured KL (0.05 if < 0.1). For atmos'
      print *, '     burner with inlet or flue damper and OPTEST = 2'
      print *, '   = 0.  Atmospheric burner with inlet or flue damper'
      print *, '         but no tracer gas measured KL provided'
      print *, 'DP is set to 0.05 in AFUEBF if measured value < 0.1 or'
      print *, '   if unit complying with sec. 8.8.3 of ASHRAE 103-93'
      print *
100   print *, ' DP: Power burner draft factor             = '
      read  (*, *, err = 100)   DP

102   print *, ' TP: Post purge purging time period, Min.'
      print *, '     (enter 0.0 if IPURGE = 0)             = '
      read  (*, *, err = 102)   tp
      print *

      print 1410, QP,PE,BE,LJ,DP,tp
      print *
      print *, ' Did you answer the data correctly ? (Yes) = '    
      read 3000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N') then
         goto 55
      else
         write(out,2410) QP,PE,BE,LJ,DP,tp
      endif

      if(CTRL .eq. 1) then

105     print *
        print *, '--------------------------------------------------'
110     print *, ' QIN:   Fuel energy nameplate input rate at steady '
        print *, '        state operation'
        print *, '        (including any pilot light input), Btu/h = '
        read  (*, *, err = 110)   QIN
120     print *, ' XCO2S: Concentration by volume of CO2 present in'
        print *, '        dry stack gas for units with draft relief'
        print *, '        (draft hood, integral draft diverter, or'
        print *, '         if oil-fired unit with barometric draft'
        print *, '         regulator eligible and tested with section'
        print *, '         9.1.3 of ASHRAE 103-1993 for the S/F factor)'
        print *, '        (ENTER 0. if no draft relief, or if oil-fired'
        print *, '         and requiring barometric draft regulator'
        print *, '         but not tested with the optional procedure'
        print *, '         of Sec. 9.1.3 of ASHRAE 103-93), %       = '
        read  (*, *, err = 120)   XCO2S
130     print *, ' XCO2F: Concentration by volume of CO2 present'
        print *, '        in dry flue gas, %                       = '
        read  (*, *, err = 130)   XCO2F
140     print *, ' TSSSX: Steady-state stack gas temperature for units'
        print *, '        employing integral draft diverters.'
        print *, '        ENTER 0.0 (mandatory) ALL other types. F = '
        read  (*, *, err = 140)   TSSSX
150     print *, ' TFSS:  Flue gas temperature at steady state, F   = '
        read  (*, *, err = 150)   TFSS
160     print *, ' TRA:   Laboratory room temperature, F            = '
        read  (*, *, err = 160)   TRA

        print *
        print 1420,  QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 105
        else
           write(out,2420) QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
        endif

      endif

      if(CTRL .ge. 2) then

165     print *
        print *, '--------------------------------------------------'
        print *, '=== Enter the high firing rate values === '
        print *
170     print *, ' QIN:    Fuel energy nameplate input rate at steady '
        print *, '         state operation '
        print *, '         (including any pilot light input), Btu/h = '
        read  (*, *, err = 170)   QIN
180     print *, ' XCO2SH: Concentration by volume of CO2 present in'
        print *, '         dry stack gas (Enter 0.0 if no draft relief'
        print *, '         or if oil-fired unit with barometric damper'
        print *, '         but not tested with the optional procedure'
        print *, '         of Sec. 9.1.3 of ASHRAE 103-93), %       = '
        read  (*, *, err = 180)   XCO2SH
190     print *, ' XCO2FH: Concentration by volume of CO2 present'
        print *, '         in dry flue gas, %                       = '
        read  (*, *, err = 190)   XCO2FH
200     print *, ' TSSSXH: Steady-state stack gas temperature for units'
        print *, '         employing integral draft diverters.'
        print *, '         Enter 0.0 (mandatory) for other systems.F = '
        read  (*, *, err = 200)   TSSSXH
210     print *, ' TFSSH:  Flue gas temperature at steady state, F   = '
        read  (*, *, err = 210)   TFSSH
220     print *, ' TRAH:   Laboratory room temperature, F            = '
        read  (*, *, err = 220)   TRAH

        print *
        print 1420,  QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 165
        else
           write(out,2420) QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
        endif

225     print *
        print *, '--------------------------------------------------'
        print *, '=== Enter the reduced firing rate values === '
        print *
230     print *, ' QINR:   Fuel energy nameplate input rate at steady '
        print *, '         state operation'
        print *, '         (including any pilot light input), Btu/h = '
        read  (*, *, err = 230)   QINR
240     print *, ' XCO2SR: Concentration by volume of CO2 present in'
        print *, '         dry stack gas (Enter 0.0 if no draft relief,'
        print *, '         or if oil-fired unit with barometric damper'
        print *, '         but not tested with the optional procedure'
        print *, '         of Sec. 9.1.3 of ASHRAE 103-93), %       = '
        read  (*, *, err = 240)   XCO2SR
250     print *, ' XCO2FR: Concentration by volume of CO2 present in'
        print *, '         dry flue gas, %                          = '
        read  (*, *, err = 250)   XCO2FR
260     print *, ' TSSSXR: Steady-state stack gas temperature for units'
        print *, '         employing integral draft diverters.'
        print *, '         Enter 0.0 (mandatory) for other systems.F = '
        read  (*, *, err = 260)   TSSSXR
270     print *, ' TFSSR:  Flue gas temperature at steady state, F   = '
        read  (*, *, err = 270)   TFSSR
280     print *, ' TRAR:   Laboratory room temperature, F            = '
        read  (*, *, err = 280)   TRAR

        print *
        print 1420, QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 225
        else
           write(out,2420) QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
        endif

      endif

      if(CTRL .eq. 1) then

285     print *
        print *, '--------------------------------------------------'
        print *, 'Enter 0.0 for the next 5 temperature data if the '
        print *, 'option (no cool-down and heat-up tests)in Sec. 9.10'
        print *, 'and 11.3.11.3(single stage unit) of 103-93 is chosen'
        print *, '-----------------------'
290     print *, ' TFON1: On-cycle flue gas temperature after start-up '
        print *, '        of the system at time t1, F        = '
        read  (*, *, err = 290)   TFON1
300     print *, ' TFON2: On-cycle flue gas temperature after start-up'
        print *, '        of the system at time t2, F        = '
        read  (*, *, err = 300)   TFON2 
310     print *, ' TFOF3: Off-cycle flue gas temperature after'
        print *, '        shut-down of the system from steady-state'
        print *, '        operation at time t3,(t3+tp if tp>0), F    = '
        read  (*, *, err = 310)   TFOF3 
320     print *, ' TFOF4: Off-cycle flue gas temperature after '
        print *, '        shut-down of the system from steady-state'
        print *, '        operation at time t4,(t4+tp if tp>0), F    = '
        read  (*, *, err = 320)   TFOF4
330     print *, ' TFOF5: Off-cycle flue gas temperature after'
        print *, '        shut-down of the system from steady-state '
        print *, '        operation at time t5, F                    = '
        read  (*, *, err = 330)   TFOF5

        print *
        print 1450, TFON1,TFON2,TFOF3,TFOF4,TFOF5
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 285
        else
           write(out,2450) TFON1,TFON2,TFOF3,TFOF4,TFOF5
        endif

      endif

      if(CTRL .ge. 2) then

        if(CTRL .eq. 2) then

335       print *
          print *, '--------------------------------------------------'
          print *, '=== Enter the high firing rate values === '
          print *
340       print *,'TFONH1: On-cycle flue gas temperature after start-up'
          print *,'        of the system at time t1, F       = '
          read  (*, *, err = 340)   TFONH1
350       print *,'TFONH2: On-cycle flue gas temperature after start-up'
          print *,'        of the system at time t2, F        = '
          read  (*, *, err = 350)   TFONH2 
360       print *,'TFOFH3: Off-cycle flue gas temperature after'
          print *,'        shut-down of the system from steady-state'
          print *,'        operation at time t3, F           = '
          read  (*, *, err = 360)   TFOFH3 
370       print *,'TFOFH4: Off-cycle flue gas temperature after '
          print *,'        shut-down of the system from steady-state'
          print *,'        operation at time t4, F           = '
          read  (*, *, err = 370)   TFOFH4
380       print *,'TFOFH5: Off-cycle flue gas temperature after'
          print *,'        shut-down of the system from steady-state '
          print *,'        operation at time t5, F           = '
          read  (*, *, err = 380)   TFOFH5

          print *
          print 1460, TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '    
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 335
          else
             write(out,2450) TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
          endif

        endif

385     print *
        print *, '--------------------------------------------------'
        print *, '=== Enter the reduced firing rate values === '
        print *
390     print *, ' TFONR1: On-cycle flue gas temperature after start-up'
        print *, '        of the system at time t1, F        = '
        read  (*, *, err = 390)   TFONR1
400     print *, ' TFONR2: On-cycle flue gas temperature after start-up'
        print *, '        of the system at time t2, F        = '
        read  (*, *, err = 400)   TFONR2 
410     print *, ' TFOFR3: Off-cycle flue gas temperature after'
        print *, '        shut-down of the system from steady-state'
        print *, '        operation at time t3, F            = '
        read  (*, *, err = 410)   TFOFR3 
420     print *, ' TFOFR4: Off-cycle flue gas temperature after '
        print *, '        shut-down of the system from steady-state'
        print *, '        operation at time t4, F            = '
        read  (*, *, err = 420)   TFOFR4
430     print *, ' TFOFR5: Off-cycle flue gas temperature after'
        print *, '        shut-down of the system from steady-state '
        print *, '        operation at time t5, F            = '
        read  (*, *, err = 430)   TFOFR5

        print *
        print 1470, TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 385
        else
           write(out,2450) TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
        endif

      endif

      if(IPURGE .gt. 0) then

        if(CTRL .eq. 1) then
431     print *
        print *, '-----------------------------------------------------'     
432     print *, 'TFOFS: Post purge flue gas temperature before burner'
        print *, '        shuts off (same as steady-state temp), F   = '
        read(*, *, err = 432)   TFOFS
433     print *, 'TFOFP: Flue gas temperature at end of post purge'
        print *, '       when combustion blower shuts off, F      = '
        read(*, *, err = 433)   TFOFP

        print *
        print 1475, TFOFS,TFOFP
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '
        read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 431
          else
             write(out,2475) TFOFS,TFOFP
          endif
        endif

        if(CTRL .ge. 2) then
          if(CTRL .eq. 2) then
434     print *
        print *, '-----------------------------------------------------'
        print *, '=== Enter the high firing rate values ==='
435     print *, 'TFOFSH: Post purge flue gas temperature before burner'
        print *, '        shuts off (same as steady-state temp), F   = '
        read(*, *, err = 435)   TFOFSH
436     print *, 'TFOFPH: Flue gas temperature at end of post purge'
        print *, '       when combustion blower shuts off, F      = '
        read(*, *, err = 436)   TFOFPH

        print *
        print 1476, TFOFSH,TFOFPH
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '
        read 3000, answer
            if (answer .eq. 'n' .or. answer .eq. 'N') then
               goto 434
            else
               write(out,2475) TFOFSH,TFOFPH
            endif
          endif

437     print *
        print *, '-----------------------------------------------------'
        print *, '=== Enter the reduced firing rate values ==='
438     print *, 'TFOFSR: Post purge flue gas temperature before burner'
        print *, '        shuts off (same as steady-state temp), F   = '
        read(*, *, err = 438)   TFOFSR
439     print *, 'TFOFPR: Flue gas temperature at end of post purge'
        print *, '       when combustion blower shuts off, F      = '
        read(*, *, err = 439)   TFOFPR

        print *
        print 1477, TFOFSR,TFOFPR
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '
        read 3000, answer
            if (answer .eq. 'n' .or. answer .eq. 'N') then
               goto 437
            else
               write(out,2475) TFOFSR,TFOFPR
            endif
        endif
      endif

      if(NSYS .eq. 5 .or. NSYS .eq. 6 .or. NSYS .eq. 8) then

445     print *
        print *, '--------------------------------------------------'
450     print *, ' AS: Cross-sectional area of the stack, in2  = '
        read  (*, *, err = 450)   AS
455     print *, ' AD: Net area of the stack damper plate, in2 = '
        read  (*, *, err = 455)   AD
460     print *, ' AOD: Net area of vent holes or cut-outs in'
        print *, '      the damper plate, in2                  = '
        read  (*, *, err = 460)   AOD
465     print *, ' AOL: Leakage area around damper shaft and'
        print *, '      edges when damper is closed, in2       = '
        read  (*, *, err = 465)   AOL
470     print *, ' OMEGA: Angle the damper makes, when closed,'
        print *, '        with a plane perpendicular to the axis'
        print *, '        of the stack, degree                 = ' 
        read  (*, *, err = 470)   OMEGA
475     print *, ' TS: Time when damper starts to close, min   = '
        read  (*, *, err = 475)   TS
480     print *, ' TD: The duration of closing of'
        print *, '                 the stack damper, min       = '
        read  (*, *, err = 480)   TD

        print *
        print 1480, AS,AD,AOD,AOL,OMEGA,TS,TD
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 445
        else
           write(out,2480) AS,AD,AOD,AOL,OMEGA,TS,TD
        endif

      endif

      conden = (TYPE .eq. 2 .or. TYPE .eq. 3)

      if(conden .and. CTRL .eq. 1) then      

485     print *
        print *, '--------------------------------------------------'
490     print *, ' MCSS: Mass of condensate at steady state, lb = '
        read  (*, *, err = 490)   MCSS
500     print *, ' QCSS: Condensing fuel energy input at'
        print *, '       steady state operation, Btu          = '
        read  (*, *, err = 500)   QCSS
510     print *, ' MC:   Mass of condensate, lb                 = '
        read  (*, *, err = 510)   MC
520     print *, ' QC:   Fuel energy input during cyclic '
        print *, '       condensate collection test, Btu      = '
        read  (*, *, err = 520)   QC

        print *
        print 1490, MCSS,QCSS,MC,QC
        print *
        print *, ' Did you answer the data correctly ? (Yes) = '    
        read 3000, answer
        if (answer .eq. 'n' .or. answer .eq. 'N') then
           goto 485
        else
           write(out,2490) MCSS,QCSS,MC,QC
        endif

      endif

      if(conden .and. CTRL .ge. 2) then

        if(CTRL .eq. 2) then
525       print *
          print *, '--------------------------------------------------'
          print *, '=== Enter the high firing rate values === '
          print *, '===   for two stage modulating unit   === '
          print *
530       print *, ' MCSSH: Mass of condensate at steady state, lb = '
          read  (*, *, err = 530)   MCSSH
540       print *, ' QCSSH: Condensing fuel energy input at'
          print *, '       steady state operation, Btu           = '
          read  (*, *, err = 540)   QCSSH
550       print *, ' MCH:   Mass of condensate, lb                 = '
          read  (*, *, err = 550)   MCH
560       print *, ' QCH:   Fuel energy input during cyclic '
          print *, '       condensate collection test, Btu       = '
          read  (*, *, err = 560)   QCH

          print *
          print 1500, MCSSH,QCSSH,MCH,QCH
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '    
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 525
          else
             write(out,2490) MCSSH,QCSSH,MCH,QCH
          endif

        else
561       print *
          print *, '--------------------------------------------------'
          print *, '=== Enter the high firing rate values === '
          print *, '===     for step modulating unit      === '
          print *
562       print *, ' MCSSH: Mass of condensate at steady state, lb = '
          read  (*, *, err = 562)   MCSSH
563       print *, ' QCSSH: Condensing fuel energy input at'
          print *, '       steady state operation, Btu           = '
          read  (*, *, err = 563)   QCSSH
          print *
          print 1501, MCSSH,QCSSH
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '    
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 561
          else
             write(out,2491) MCSSH,QCSSH
          endif
        endif

565       print *
          print *, '--------------------------------------------------'
          print *, '=== Enter the reduced firing rate values === '
          print *
570       print *, ' MCSSR: Mass of condensate at steady state, lb = '
          read  (*, *, err = 570)   MCSSR
580       print *, ' QCSSR: Condensing fuel energy input at'
          print *, '       steady state operation, Btu           = '
          read  (*, *, err = 580)   QCSSR
590       print *, ' MCR:   Mass of condensate, lb                 = '
          read  (*, *, err = 590)   MCR
600       print *, ' QCR:   Fuel energy input during cyclic '
          print *, '       condensate collection test, Btu       = '
          read  (*, *, err = 600)   QCR

          print *
          print 1505, MCSSR,QCSSR,MCR,QCR
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '    
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 565
          else
             write(out,2490) MCSSR,QCSSR,MCR,QCR
          endif

      endif

      if(OPTEST .gt. 0 .and. DP .eq. 0.0) then

        if(CTRL .eq. 1) then
605       print *
          print *, '--------------------------------------------------'
610       print *, ' CTM: Concentration by volume of the tracer gas'
          print *, '      being used                           = '
          read  (*, *, err = 610)   CTM
620       print *, ' CT:  Concentration by volume of the tracer gas'
          print *, '      in the flue gas                      = '
          read  (*, *, err = 620)   CT
630       print *, ' VT:  Flow rate of tracer gas, ft3/min     = '
          read  (*, *, err = 630)   VT
640       print *, ' PB:  Barometric pressure measured, inHg   = '
          read  (*, *, err = 640)   PB
650       print *, ' TT:  Temperature of tracer gas entering'
          print *, '      flow meter, F                        = '
          read  (*, *, err = 650)   TT
660       print *, ' TFOFF: Off-period flue gas temperature when  '
          print *, '        tracer gas concentration is measured, F = '
          read  (*, *, err = 660)   TFOFF
          print *
670       print *, ' IFRATE: 1 = Non-modulating unit, or'
          print *, '             step modulating unit when tracer gas'
          print *, '             test is made at reduced firing rate.'
          print *
          print *, '         2 = Two stage modulating unit when tracer'
          print *, '             gas test is made at both high and'
          print *, '             reduced firing rates.'
          print *, ' Enter IFRATE = '
          read  (*, *, err = 670)   IFRATE

          print *
          print 1510, CTM,CT,VT,PB,TT,TFOFF,IFRATE
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '    
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 605
          else
             write (out, 2510) CTM,CT,VT,PB,TT,TFOFF,IFRATE
          endif
        endif
        if(CTRL .ge. 2) then
          if(CTRL .eq. 2) then
675         print *
            print *, '------------------------------------------------'
            print *, '=== Enter the high firing rate values === '
            print *
680         print *, ' CTMH: Concentration by volume of the tracer gas'
            print *, '      being used                           = '
            read  (*, *, err = 680)   CTMH
681         print *, ' CTH:  Concentration by volume of the tracer gas'
            print *, '      in the flue gas                      = '
            read  (*, *, err = 681)   CTH
682         print *, ' VTH:  Flow rate of tracer gas, ft3/min     = '
            read  (*, *, err = 682)   VTH
683         print *, ' PBH:  Barometric pressure measured, inHg   = '
            read  (*, *, err = 683)   PBH
684         print *, ' TTH:  Temperature of tracer gas entering'
            print *, '      flow meter, F                        = '
            read  (*, *, err = 684)   TTH
685         print *, ' TFOFFH: Off-period flue gas temp. when tracer '
            print *, '        gas concentration is measured, F   = '
            read  (*, *, err = 685)   TFOFFH
            print *
686         print *, ' IFRATE: 1 = Non-modulating unit, or'
            print *, '             Step nodulating unit when tracer gas'
            print *, '             test is made at reduced firing rate.'
            print *
            print *, '         2 = Two stage modulating unit when '
            print *, '             tracer gas test is made at both high'
            print *, '             and reduced firing rates'
            print *, ' Enter IFRATE = '
            read  (*, *, err = 686)   IFRATE

            print *
            print 1515, CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
            print *
            print *, ' Did you answer the data correctly ? (Yes) = '
            read 3000, answer
            if (answer .eq. 'n' .or. answer .eq. 'N') then
               goto 675
            else
               write (out, 2510) CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
            endif
          endif

688       print *
          print *, '-------------------------------------------------'
          print *, '=== Enter the reduced firing rate values === '
          print *
690       print *, ' CTMR: Concentration by volume of the tracer gas'
          print *, '      being used                           = '
          read  (*, *, err = 690)   CTMR
691       print *, ' CTR:  Concentration by volume of the tracer gas'
          print *, '      in the flue gas                      = '
          read  (*, *, err = 691)   CTR
692       print *, ' VTR:  Flow rate of tracer gas, ft3/min     = '
          read  (*, *, err = 692)   VTR
693       print *, ' PBR:  Barometric pressure measured, inHg   = '
          read  (*, *, err = 693)   PBR
694       print *, ' TTR:  Temperature of tracer gas entering'
          print *, '      flow meter, F                        = '
          read  (*, *, err = 694)   TTR
695       print *, ' TFOFFR: Off-period flue gas temp. when tracer '
          print *, '        gas concentration is measured, F   = '
          read  (*, *, err = 695)   TFOFFR
          print *
696       print *, ' IFRATE: 1  Non-modulating unit, or'
          print *, '            step modulating unit when tracer gas'
          print *, '            test is made at reduced firing rate.'
          print *
          print *, '         2 = two stage modulating unit when tracer'
          print *, '             gas test is made at both high and'
          print *, '             reduced firing rates.'
          print *, ' Enter IFRATE = '
          read  (*, *, err = 696)   IFRATE
          print *
          print 1520, CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
          print *
          print *, ' Did you answer the data correctly ? (Yes) = '
          read 3000, answer
          if (answer .eq. 'n' .or. answer .eq. 'N') then
             goto 688
          else
             write (out, 2510) CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
          endif
        endif

      endif

      print *
      print *, ' Do you want to continue to entering next data set ?'
      print *, '                                        (Yes)  = '
      read  3000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N' ) then
         close (unit=out)
         ndata = i
         print *
         print *, '===== You have entered  ', ndata, ' data sets.===='
         print *
         print *, ' Do you want to see the input data sets '
         print *, ' in the form as appeared in the output file'
         print *, ' of AFUEBF program ?                  (Yes) = '
         read 3000, answer
         if ( answer .eq. 'n' .or. answer .eq. 'N') then
            goto 999
         endif
      else
         i = i + 1
        goto 8
      endif                  

* ---------------------------------------------------------------------
*     Reading input data

700   inp = 7
      out = 8
      open(unit=inp, file= infile, status='old')
      open(unit=out, file='CHECK.DAT', status='unknown')

      do 710 I = 1, 100      

      READ(INP,1000,END=720) TITLE
      PRINT *
      PRINT *,'   DATA SET =', I
      PRINT 1100, TITLE
      PRINT *
      WRITE(OUT,1200)
      WRITE(OUT,1300)
      WRITE(OUT,*) '   DATA SET =', I
      WRITE(OUT,1100) TITLE
      WRITE(OUT,*)
      WRITE(OUT,*) ' Input Values:'
      WRITE(OUT,*)
      READ(INP,*) TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge
      WRITE(OUT,1400) TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge

      READ(INP,*) QP,PE,BE,LJ,DP,tp
      WRITE(OUT,1410) QP,PE,BE,LJ,DP,tp

      IF(CTRL .EQ. 1) THEN
          READ(INP,*) QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
          WRITE(OUT,1420) QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
      ENDIF

      IF(CTRL .GE. 2) THEN
          READ(INP,*) QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
          WRITE(OUT,1430) QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
          READ(INP,*) QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
          WRITE(OUT,1440) QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
      ENDIF

      IF(CTRL .EQ. 1) THEN
          READ(INP,*) TFON1,TFON2,TFOF3,TFOF4,TFOF5
          WRITE(OUT,1450) TFON1,TFON2,TFOF3,TFOF4,TFOF5
      ENDIF

      IF(CTRL .GE. 2) THEN
          IF(CTRL .EQ. 2) THEN
              READ(INP,*) TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
              WRITE(OUT,1460) TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
          ENDIF
          READ(INP,*) TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
          WRITE(OUT,1470) TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
      ENDIF

      IF(IPURGE .GT. 0) THEN
          IF(CTRL .EQ. 1) THEN
              READ(INP,*) TFOFS,TFOFP
              WRITE(OUT,1475) TFOFS,TFOFP
          ENDIF

          IF(CTRL .GE. 2) THEN
              IF(CTRL .EQ. 2) THEN
                   READ(INP,*) TFOFSH,TFOFPH
                   WRITE(OUT,1476) TFOFSH,TFOFPH
              ENDIF
              READ(INP,*) TFOFSR,TFOFPR
              WRITE(OUT,1477) TFOFSR,TFOFPR
          ENDIF
      ENDIF

      IF(NSYS .EQ. 5 .OR. NSYS .EQ. 6 .OR. NSYS .EQ. 8) THEN
          READ(INP,*) AS,AD,AOD,AOL,OMEGA,TS,TD
          WRITE(OUT,1480) AS,AD,AOD,AOL,OMEGA,TS,TD
      ENDIF

      CONDEN = (TYPE .EQ. 2 .OR. TYPE .EQ. 3)

            IF(CONDEN .AND. CTRL .EQ. 1) THEN 
          READ(INP,*) MCSS,QCSS,MC,QC
          WRITE(OUT,1490) MCSS,QCSS,MC,QC
      ENDIF

      IF(CONDEN .AND. CTRL .GE. 2) THEN
          IF(CTRL .EQ. 2) THEN
              READ(INP,*) MCSSH,QCSSH,MCH,QCH
              WRITE(OUT,1500) MCSSH,QCSSH,MCH,QCH
          else
              READ(INP,*) MCSSH,QCSSH
              WRITE(OUT,1501) MCSSH,QCSSH
          ENDIF
          READ(INP,*) MCSSR,QCSSR,MCR,QCR
          WRITE(OUT,1505) MCSSR,QCSSR,MCR,QCR
      ENDIF

      IF(OPTEST .GT. 0 .AND. DP .EQ. 0.0) THEN

          IF(CTRL .EQ. 1) THEN
              READ(INP,*) CTM,CT,VT,PB,TT,TFOFF,IFRATE
              WRITE(OUT,1510) CTM,CT,VT,PB,TT,TFOFF,IFRATE
          ENDIF
          IF(CTRL .GE. 2) THEN
              IF(CTRL .EQ. 2) THEN
                  READ(INP,*) CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
                  WRITE(OUT,1515) CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
              ENDIF
              READ(INP,*) CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
              WRITE(OUT,1520) CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
          ENDIF

      ENDIF

      PRINT 1300

710   continue
720   print *, '   =============================================== '  
      print *, '   ======  Please see the file, CHECK.DAT ======== '
      print *, '   =============================================== '
      print *
999   print *
      STOP ' --------- End of MKDATA -----------  '

* ---------------------------------------------------------------------
*     F O R M A T   S T A T E M E N T S

1000  FORMAT(A80)
1100  FORMAT(/(1X,A80))
1200  FORMAT(1H1)
1300  FORMAT(1X,79('*')/)
1400  FORMAT('    TYPE =',I2,'   INST =',I2,'   NSYS =',I2,
     &            '   FUEL =',I2,'   CTRL =',I2,'   OPTEST =',I2,
     &       '   IPURGE =',I2/)
1410  FORMAT(T8,'QP',T20,'PE',T32,'BE',T44,'LJ',T56,'DP',T68,'TP'
     &       /F12.0,3F12.3,2F12.5/)
1420  FORMAT(T8,'QIN',T20,'XCO2S',T32,'XCO2F',T44,'TSSSX',T56,'TFSS',
     &       T68,'TRA'/F12.0,2F12.2,3F12.1/)
1430  FORMAT(T8,'QIN',T20,'XCO2SH',T32,'XCO2FH',T44,'TSSSXH',T56,
     &       'TFSSH',T68,'TRAH'/F12.0,2F12.2,3F12.1/)
1440  FORMAT(T8,'QINR',T20,'XCO2SR',T32,'XCO2FR',T44,'TSSSXR',T56,
     &       'TFSSR',T68,'TRAR'/F12.0,2F12.2,3F12.1/)
1450  FORMAT(T8,'TFON1',T20,'TFON2',T32,'TFOF3',T44,'TFOF4',T56,
     &       'TFOF5'/5F12.1/)
1460  FORMAT(T8,'TFONH1',T20,'TFONH2',T32,'TFOFH3',T44,'TFOFH4',T56,
     &       'TFOFH5'/5F12.1/)
1470  FORMAT(T8,'TFONR1',T20,'TFONR2',T32,'TFOFR3',T44,'TFOFR4',T56,
     &       'TFOFR5'/5F12.1/)
1475  FORMAT(T8,'TFOFS',T20,'TFOFP'/2F12.1/)
1476  FORMAT(T8,'TFOFSH',T20,'TFOFPH'/2F12.1/)
1477  FORMAT(T8,'TFOFSR',T20,'TFOFPR'/2F12.1/)
1480  FORMAT(T8,'AS',T20,'AD',T32,'AOD',T44,'AOL',T56,'OMEGA'/
     &       4F12.4,F12.1/T8,'TS',T20,'TD'/2F12.2/)
1490  FORMAT(T8,'MCSS',T20,'QCSS',T32,'MC',T44,'QC'/2(F12.3,F12.0)/)
1500  FORMAT(T8,'MCSSH',T20,'QCSSH',T32,'MCH',T44,'QCH'/
     &       2(F12.3,F12.0)/)
1501  FORMAT(T8,'MCSSH',T20,'QCSSH'/F12.3,F12.0/)
1505  FORMAT(T8,'MCSSR',T20,'QCSSR',T32,'MCR',T44,'QCR'/
     &       2(F12.3,F12.0)/)
1510  FORMAT(T8,'CTM',T20,'CT',T32,'VT',T44,'PB',T56,'TT',T68,'TFOFF'/
     &       2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1515  FORMAT(T8,'CTMH',T20,'CTH',T32,'VTH',T44,'PBH',T56,'TTH',
     &       T68,'TFOFFH'/2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1520  FORMAT(T8,'CTMR',T20,'CTR',T32,'VTR',T44,'PBR',T56,'TTR',
     &       T68,'TFOFFR'/2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1600  format(5x,a15,3x,a50)
2400  format(7i5)
2410  format(f12.0,3f12.3,2f12.5)
2420  format(f12.0,2f12.2,3f12.1)
2450  format(5f12.1)
2475  format(2f12.1)
2480  format(4f12.4,f12.1,2f12.2)
2490  format(2(f12.3,f12.0))
2491  format(f12.3,f12.0)
2510  format(2f12.4,f12.5,f12.2,2f12.1,i5) 
3000  format(a1)

* ---------------------------------------------------------------------
      end
 