C     Last change:  CP   15 Oct 2003   10:40 am
***********************************************************************
*
*       *****************************************************
*       * CALCULATION OF ANNUAL FUEL UTILIZATION EFFICIENCY *
*       *    OF RESIDENTIAL CENTRAL FURNACES AND BOILERS    *
*       *****************************************************
*
*       Program name: AFUEBF
*       Version:      4.2c (Update from Ver.4.2b dated 5/10/2000):--
*==                   4.2c - Revision to include the AFUE calculation of
*==                   section 11.3.11.3 of 103-93 when the option of
*==                   section 9.10 is chosen (Option of not conducting the
*==                   cool-down and heat-up tests for cyclic flue losses)--
*==                   Note: Any output variables not calculated in this
*==                   program due to this option are set to 0.
*                     (4.2b - Revision to include an iterative procedure to
*                      determine the ambient temperatures of a modulating
*                      AND condensing furnace/boiler under low-fire and
*                      high-fire conditions - section 11.5.7.2)
*       Date:         4.2b - June 15, 1999.
*                     5/10/00: Minor changes to instruction on input
*                              to variables XCO2S and TSSSX to clarify
*                              possible misinterpretation.
*==                   4.2c - 8/15/01
*       Document:     ASHRAE 103-1993
*
*
*       Update:       Version 5.0   October 15, 2003
*                     (1) Corrected the code for electric/mechanical stack
*                         dampers(NSYS = 5, 6, and 7) of modulating units.
*                     (2) Input and output file names can be up to 36 charcters.
*
* --------------------------------------------------------------------
*
*     PREAMBLE:  This computer code was written so that it follows the
*                printed Standard very closely. Therefore, it is rather
*                easy to find the section in the computer code that
*                represents the corresponding section of the printed
*                Standard. This greatly aids in making modifications
*                or updates to the code.
*
*                The code is divided into two main parts:
*
*                    a) the non-modulating case
*                    b) the modulating case
*
*                Since the sections of the Standard dealing with the
*                modulating case make many references to the sections
*                dealing with the non-modulating case, much of the code
*                for the modulating case replicates the code for the
*                non-modulating case. Thus, one should remember that
*                A CHANGE TO THE COMPUTER CODE FOR THE NON-MODULATING
*                CASE WILL ALMOST ALWAYS ENTAIL A CHANGE TO THE COMPUTER
*                CODE FOR THE MODULATING CASE.
*
*     CAUTION:   Error checking of input data is not performed.  It is
*                possible to enter data for systems which are not
*                covered under the calculation procedure in Section 11
*                of the Standard.  This will either crash the program
*                or, even worse, give erroneous results.  The user must
*                be certain that his input data is correct and describes
*                only systems covered in this Standard.
*
*       ============================================
*       INPUT variables in the data file, AFUE.IN
*       ============================================
*
*       TITLE:  Two lines of alphanumeric characters describing the test
*               conditions and data.  Each line can contain up to 80
*               characters.
*       ---------------------------------------------------------------
*       TYPE:   Type of heating unit
*               1 = Furnace
*               2 = Condensing furnace
*               3 = Condensing boiler
*               4 = Finned tube boiler
*               5 = Boiler
*
*       INST:   Installation
*               1 = Indoors
*               2 = Outdoors
*               3 = Isolated combustion
*
*       NSYS:   System number appears in the table below.
*===============================================================================
*
*                     SYSTEM NUMBER TABLE
*
*===============================================================================
*      *       *        *       *        *      *         *      *      *Atmos.*
*      *       *        *       *        *      *         *      *      *Burner*
*      *       *        *       *        *      *         *      *      *with  *
*      *       *Outdoor,*       *        *      *         *      *      *Elec- *
*      *       *Direct  *       *Draft   *      *         *      *      *Mech. *
*      *       *Vent or *       *Hood    *Baro- *         *      *      *Inlet *
*      *Indoor.*Isolated*       *or      *Metric*Elec/Mech*Atmos-*      *or    *
*      *Combus.*Combus. *Direct *Draft   *Draft *Stack    *pheric*Power *Flue  *
* NSYS *Air    *System  *Exhaust*Diverter*Contrl*Damper   *Burner*Burner*Damper*
*==============================================================================*
*  1       X                        X                        X             X   *
*==============================================================================*
*  2       X                        X                                X         *
*==============================================================================*
*  3       X                X                                        X         *
*==============================================================================*
*  4       X                                 X                       X         *
*==============================================================================*
*  5       X                        X                X       X                 *
*==============================================================================*
*  6       X                        X                X               X         *
*==============================================================================*
*  8       X                                 X       X               X         *
*==============================================================================*
*  9                X            Has no effect               X             X   *
*==============================================================================*
* 10                X            on the results                      X         *
*==============================================================================*
*                                       NSYS = 7 : intentionally omitted
*
*       FUEL:   Type of fuel
*               1 = No.1 oil
*               2 = No.2 oil
*               3 = Natural gas
*               4 = Manufactured gas
*               5 = Propane
*               6 = Butane
*
*       CTRL:   Control mode
*               1 = Single stage control
*               2 = Two stage control
*               3 = Step modulating control
*
*       OPTEST: Option
*               0 = No optional tracer gas test for power burner draft
*                   factor, Dp. Dp will be set to its default value in
*                   the program. (Set Dp = 0. below for an input value.)
*               1 = Optional tracer gas test for Dp. Dp below should be
*                   input as 0.
*               2 = Either direct vent units with optional tracer gas
*                   test for Dp, where Dp below should be input as 0.,
*                   or atmospheric burners w/electro-mechanical inlet 
*                   or flue damper with separately tracer gas measured
*                   off-cycle loss factor, where Dp below should be
*                   input as the value of the off-cycle loss factor(KL).
*
*       IPURGE: Induced draft power burner post purge indicator
*               0 = No post purge (period .LE. 5 s) or not a power burner
*               1 = With post purge period after burner shuts off
*+++++          NOTE:  There is a difference between ASHRAE 103-1993
*+++++                 and the revised DOE test procedure (5/12/97)in the
*+++++                 minimum length of the post purge period before the
*+++++                 system is considered to have post purge.
*+++++          (ASHRAE 103-1993 is .LE. 5s.  DOE test proc. is .LE. 30s) 
*       ---------------------------------------------------------------
*       QP:     Fuel input rate to pilot light, Btu/h
*       PE:     Electric power to burner, kW
*       BE:     Electric power to circulating air blower or water
*               pump, Kw
*       LJ:     Jacket loss, %
*       DP:     Draft factor:
*               = 0.   if atmos. burner without inlet or flue damper
*               = 0.   if power burner (OPTEST = 0 or 1)
*               = 0.05 if units fit description of Section 8.8.3 of
*                         ASHRAE 103-1993
*               = 0.   if direct vent system and OPTEST = 2
*               = KL,  the off-cycle loss factor (separately measured),
*                      for atm. burner with elec-mech. inlet or flue damper.
*       TP:     Length of power burner post purge time after burner-off
*               = 0  if no post purge (TP .LE. 5 sec) or not a power burner
*               = Length of post purge time after burner-off, minutes
*+++++          NOTE:  There is a difference between ASHRAE 103-1993
*+++++                 and the 5/12/97 revised DOE test procedure in the
*+++++                 minimum length of the post purge period before the
*+++++                 system is considered to have post purge (See IPURGE).
*       ---------------------------------------------------------------
*       QIN:    Fuel energy nameplate input rate at steady state
*               operation (including any pilot light input), Btu/h
*       XCO2S:  Concentration by volume of CO2 present in dry stack gas, %
*+++++          = 0. if no draft relief, or oil-fired units with
*+++++          barometric draft regulator but not tested with the
*+++++          optional procedure for the S/F factor (Sec.9.1.3, 11.2.3)
*       XCO2F:  Concentration by volume of CO2 present in dry flue gas,  %
*       TSSSX:  Steady-state stack gas temperature for units employing
*+++++          integral draft diverter, F
*+++++          = 0.(mandatory) for all other type of units
*       TFSS:   Flue gas temperature at steady state, F
*       TRA:    Laboratory room temperature, F
*
*       If control mode is two stage or step-modulating control, QIN,
*       XCO2S, XCO2F, TSSSX, TFSS, and TRA at both high and reduced
*       firing rates must be entered (as two data records - at high
*       rate followed by reduced rate).
*       --------------------------------------------------------------
*       TFON1:  On-cycle flue gas temperature after start-up of the
*               system at time, T1, F
*       TFON2:  On-cycle flue gas temperature after start-up of the
*               system at time, T2, F
*       TFOF3:  Off-cycle flue gas temperature after shut-down of the
*               system from steady-state operation at time, T3, or at
*               time (T3 + TP) if power burner with post purge, F
*       TFOF4:  Off-cycle flue gas temperature after shut-down of the
*               system from steady-state operation at time, T4, or at
*               time (T4 + TP) if power burner with post purge, F
*       TFOF5:  Off-cycle flue gas temperature after shut-down of the
*               system from steady-state operation at time, T5, F
*==     
*==     Note: Enter 0.0 for all 5 temperatures if a SINGLE stage condensing
*==           furnace/boiler meets the criterion of Sections 9.10 and
*==           11.3.11.3 of 103-93 AND the option of not conducting the
*==           cool-down and heat-up cyclic flue loss tests is chosen.
*       If control mode is step-modulating control, TFON1, TFON2, TFOF3,
*             TFOF4, and TFOF5 are data at the reduced firing rate.
*       If control mode is two stage modulating control, TFON1, TFON2,
*             TFOF3, TFOF4, and TFOF5 at both high and reduced firing rates
*             must be entered (as two records - at high, then reduced rates).
*       ---------------------------------------------------------------
*       If power vented burner with post purge, the following additional
*       input temperature data must be provided:
*
*       TFOFS: Off-cycle flue gas temperature at the start of the post
*              purge period after burner-off(same value as TFSS), F
*       TFOFP: Off-cycle flue gas temperature at the end of the post
*              purge period after burner-off, F
*
*       If control mode is step-modulating control, TFOFS and TFOFP
*          are data at the reduced firing rate.
*       If control mode is two stage modulating control, TFOFS and
*          TFOFP at both high and reduced firing rates must be entered (as
*          two records - at high, then reduced rates).
*       --------------------------------------------------------------
*       If stack damper is used, the following input data must be
*       provided:
*
*       AS:     Cross-sectional area of the stack, in2
*       AD:     Net area of the stack damper plate, in2
*       AOD:    Net venting area (holes or cut-outs) manufactured on the
*               damper plate, in2
*       AOL:    Net measured leakage area around damper shaft and edges
*               when the damper is closed, in2
*       OMEGA:  Angle the damper makes, when closed, with a plane
*               perpendicular to the axis of the stack, degree
*       TS:     Time when damper starts to close, min
*       TD:     The duration of closing of the stack damper, min
*       ---------------------------------------------------------------
*       If condensing unit is used, the following input data must be
*       entered:
*
*       MCSS:   Mass of condensate at steady state, lb
*       QCSS:   Condensing fuel energy input at steady state
*               operation, Btu
*       MC:     Mass of condensate, lb      
*       QC:     Fuel energy input during cyclic condensate collection
*               test, Btu
*
*       If control mode is step-modulating control, MCSS and QCSS at both
*          high and reduced firing rates are required. However, MC and
*          QC are only required at the reduced firing rate.
*          (as two data records - MCSS and QCSS at high rate followed
*          by MCSS, QCSS, MC, QC at reduced rate).
*       If control mode is two stage modulating control, MCSS, QCSS, MC,
*          and QC at both high and reduced firing rates must be entered.
*          (as two data records - at high followed by reduced rates).
*       ---------------------------------------------------------------
*       If optional tracer gas test for power burner (or direct vents) 
*       draft factor, Dp, is used, the following input data must be
*       provided at the appropriate fuel rates:
*
*       CTM:    Concentration by volume of the tracer gas being used
*       CT:     Concentration by volume of the tracer gas in the flue
*               gas
*       VT:     Flow rate of tracer gas, ft3/min
*       PB:     Barometric pressure measured, in.Hg
*       TT:     temperature of tracer gas entering flow meter, F
*       TFOFF:  Off-period flue gas temperature when tracer gas
*               concentration is measured, F
*       IFRATE: 1 = Non-modulating unit, or
*                   Step modulating unit where tracer gas test is made
*                   at reduced firing rate.
*               2 = Two stage modulating unit where tracer gas tests are
*                   made at both high and reduced firing rates
*
*       If control mode is step-modulating control, CTM, CT, VT, PB, TT,
*          TFOFF, and IFRATE are data at the reduced firing rate.
*       If control mode is two stage modulating control, CTM, CT, VT,
*          PB, TT, TFOFF and IFRATE at both high and reduced firing rates
*          must be entered (as two records - at high, then reduced rates).
*       ---------------------------------------------------------------
*
*       OUTPUT values are listed in the file, AFUE.OUT
*
*       ---------------------------------------------------------------
*
*       Variables used in PARAMETER statement
*
*       MAXDAT  Maximum number of data sets
*       NLBL    Number of labels
*       NFUEL   Number of fuel types
*       MAXDHR  Maximum number of design heating requirements
*       NCAP    Number of output capacities
*
* ---------------------------------------------------------------------

      PROGRAM   AFUEBF

      IMPLICIT  REAL(A-Z)

      INTEGER   I,II,J,NSYS,FUEL,TYPE,CTRL,OPTEST,N,NDHR,INST,INP,
     &          OUT,NLBL,NFUEL,MAXDHR,MAXDAT,IFRATE,ipurge,icond

      LOGICAL   CONDEN

      PARAMETER (MAXDAT=100, NLBL=5, NFUEL=6, MAXDHR=5)

      INTEGER   KDHR(MAXDHR)
      CHARACTER*80 TITLE(2)
      CHARACTER LABEL(NLBL)*15,SELECT(6,NLBL)*50
      CHARACTER*36 IFILE, OFILE
!      CHARACTER*12 IFILE, OFILE

      DIMENSION ALPHA(MAXDHR),TC(MAXDHR),RH(MAXDHR),EFYHS(MAXDHR),
     &          AFUEF(MAXDHR),DHR(MAXDHR),XH(MAXDHR),XR(MAXDHR)
      DIMENSION EFYSSM(MAXDHR),EFYSSW(MAXDHR),EFFYUM(MAXDHR),
     &          TOAR(MAXDHR),TOAH(MAXDHR),qoutm(maxdhr)
      DIMENSION EFFYUR(MAXDHR),EFFYUH(MAXDHR),LIONM(MAXDHR)
      DIMENSION HHVX(NFUEL),AF(NFUEL),Q(NFUEL),ART(NFUEL),BRT(NFUEL)

      DATA      REFTRM,REFTOA,PHI,CP  /70.0,42.0,0.7,0.24/

      DATA HHVX /19800., 19500., 20120., 18500., 21500., 20890./

      DATA AF   / 14.56,  14.49,  14.45,  11.81,  15.58,  15.36/

      DATA Q    /  6.55,   6.50,   9.55,  10.14,   7.99,   7.79/

      DATA ART  / .0679, .06668, .09194, .09646,  .0841,  .0808/

      DATA BRT  / 14.22,  14.34,  10.96,  10.10,  12.60,  12.93/

      DATA LABEL/'Type of unit :', 'Installation :',
     &            'Type of fuel :', 'Control mode :', 'Option :'/

      DATA      ((SELECT(I,J),I=1,6), J=1,NLBL) /
     &              'Furnace','Condensing furnace','Condensing boiler',
     &              'Finned tube boiler','Boiler',' ',
     &              'Indoors','Outdoors','Isolated combustion',' ',' ',
     &              ' ',
     &              '#1 Oil','#2 Oil','Natural gas','Manufactured gas',
     &              'Propane','Butane',
     &              'Single stage','Two stage','Step modulating',' ',
     &              ' ',' ',
     &              'No option','Optional tracer gas measurement',
     &              'Direct vent unit with measurement of Dp',' ',' ',
     &              ' '/

*++   kffd as a form feed character when write to output file
      integer kffd /12/
*++
      PRINT *
      PRINT *,' *****************************************************  '
      PRINT *,' * CALCULATION OF ANNUAL FUEL UTILIZATION EFFICIENCY *  '
      PRINT *,' *    OF RESIDENTIAL CENTRAL FURNACES AND BOILERS    *  '
      PRINT *,' *****************************************************  '
      PRINT *,'                                                        '
      PRINT *,' Program name:      AFUEBF                              '
      PRINT *,'      Version:      5.0                                 '
      PRINT *,'         Date:      Revised October 15, 2003            '
      PRINT *,'     Document:      ANSI/ASHRAE STANDARD 103-1993       '
      PRINT *,'                                                        '
      PRINT *,' ------------------------------------------------------ '

*     Opening the input and output data files

      INP = 7
      OUT = 8
      
      CALL FILEIO ( INP, OUT , IFILE, OFILE)


      DO 40 I= 1, MAXDAT

* ---------------------------------------------------------------------
*     Reading input data

      READ(INP,1000,END=999) TITLE
      PRINT *
      PRINT *,'   DATA SET =', I
      PRINT 1100, TITLE
      PRINT *
*++   Start print output on a new page after each set of data is run
      WRITE(OUT,1200) kffd
*++
      WRITE(OUT,1300)
      WRITE(OUT,*) '   DATA SET =', I
      WRITE(OUT,1100) TITLE
      WRITE(OUT,*)
      WRITE(OUT,*) ' Input Values:'
      WRITE(OUT,*)
      READ(INP,*) TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge
      WRITE(OUT,1400) TYPE,INST,NSYS,FUEL,CTRL,OPTEST,ipurge

      READ(INP,*) QP,PE,BE,LJ,DP,tp
      WRITE(OUT,1410) QP,PE,BE,LJ,DP,tp
      IF(CTRL .GE. 2) DPR = DP
      if(ctrl .eq. 2) dph = dp

      IF(CTRL .EQ. 1) THEN
          READ(INP,*) QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
          WRITE(OUT,1420) QIN,XCO2S,XCO2F,TSSSX,TFSS,TRA
      ENDIF

      IF(CTRL .GE. 2) THEN
          READ(INP,*) QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
          WRITE(OUT,1430) QIN,XCO2SH,XCO2FH,TSSSXH,TFSSH,TRAH
          READ(INP,*) QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
          WRITE(OUT,1440) QINR,XCO2SR,XCO2FR,TSSSXR,TFSSR,TRAR
      ENDIF

      IF(CTRL .EQ. 1) THEN
          READ(INP,*) TFON1,TFON2,TFOF3,TFOF4,TFOF5
          WRITE(OUT,1450) TFON1,TFON2,TFOF3,TFOF4,TFOF5
      ENDIF

      IF(CTRL .GE. 2) THEN
          IF(CTRL .EQ. 2) THEN
              READ(INP,*) TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
              WRITE(OUT,1460) TFONH1,TFONH2,TFOFH3,TFOFH4,TFOFH5
          ENDIF
          READ(INP,*) TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
          WRITE(OUT,1470) TFONR1,TFONR2,TFOFR3,TFOFR4,TFOFR5
      ENDIF
*++
      if(ipurge .gt. 0) then
          if(ctrl .eq. 1) then
              read(inp,*) tfofs,tfofp
              write(out,1475) tfofs,tfofp
          endif

          if(ctrl .ge. 2) then

              if(ctrl .eq. 2) then
                  read(inp,*) tfofsh,tfofph
                  write(out,1476) tfofsh,tfofph
              endif

              read(inp,*) tfofsr,tfofpr
              write(out,1477) tfofsr,tfofpr
          endif
      endif
*++
      IF(NSYS .EQ. 5 .OR. NSYS .EQ. 6 .OR. NSYS .EQ. 8) THEN
          READ(INP,*) AS,AD,AOD,AOL,OMEGA,TS,TD
          WRITE(OUT,1480) AS,AD,AOD,AOL,OMEGA,TS,TD
      ENDIF

      CONDEN = (TYPE .EQ. 2 .OR. TYPE .EQ. 3)

      IF(CONDEN .AND. CTRL .EQ. 1) THEN     
          READ(INP,*) MCSS,QCSS,MC,QC
          WRITE(OUT,1490) MCSS,QCSS,MC,QC
      ENDIF

      IF(CONDEN .AND. CTRL .GE. 2) THEN
          IF(CTRL .EQ. 2) THEN
              READ(INP,*) MCSSH,QCSSH,MCH,QCH
              WRITE(OUT,1505) MCSSH,QCSSH,MCH,QCH
          else
              read(inp,*) mcssh,qcssh
              write(out,1506) mcssh,qcssh
          ENDIF
          READ(INP,*) MCSSR,QCSSR,MCR,QCR
          WRITE(OUT,1500) MCSSR,QCSSR,MCR,QCR
      ENDIF

      IF(OPTEST .GT. 0 .AND. DP .EQ. 0.0) THEN
          IF(CTRL .EQ. 1) THEN
              READ(INP,*) CTM,CT,VT,PB,TT,TFOFF,IFRATE
              WRITE(OUT,1510) CTM,CT,VT,PB,TT,TFOFF,IFRATE
          ENDIF

          IF(CTRL .GE. 2) THEN
              IF(CTRL .EQ. 2) THEN
                  READ(INP,*) CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
                  WRITE(OUT,1520) CTMH,CTH,VTH,PBH,TTH,TFOFFH,IFRATE
              ENDIF
              READ(INP,*) CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
              WRITE(OUT,1530) CTMR,CTR,VTR,PBR,TTR,TFOFFR,IFRATE
          ENDIF
      ENDIF

      WRITE(OUT,*)
      WRITE(OUT,*) ' Unit Characteristics:'
      WRITE(OUT,*)
      WRITE(OUT,1600) LABEL(1),SELECT(TYPE,1),LABEL(2),SELECT(INST,2),
     &              LABEL(3),SELECT(FUEL,3),LABEL(4),SELECT(CTRL,4),
     &              LABEL(5),SELECT(OPTEST+1,5)
      WRITE(OUT,*)  '    System number :   ',NSYS
      WRITE(OUT,*)
      WRITE(OUT,*)

* ----------------------------------------------------------------------


*SEC 11   CALCULATION OF DERIVED RESULTS FROM TEST MEASUREMENTS

*SEC 11.1 Heating Seosonal Efficiency, Steady State Efficiency & AFUE for
*         Electrical Furnaces and Boilers
*
*         No Calculation for electric systems

*SEC 11.2 Heating Seasonal Efficiency, Steady State Efficiency & AFUE for
*         Non-condensing & Non-modulating Gas or Oil Furnaces & Boilers

*SEC 11.3 Heating Seasonal Efficiency, Steady State Efficiency & AFUE for
*         Condensing & Non-modulating Gas or Oil Furnaces & Boilers

*--------------   Non-modulating Units ---------------------------------

      IF(CTRL .EQ. 1) THEN

*SEC 11.2.1 System Number

*SEC 11.3.1 System Number for condensing units
*           Allowable systems are 3, 9 & 10

*SEC 11.2.2 Ratio of combustion air to stoichiometric air

      A = ART(FUEL)
      B = BRT(FUEL)
      IF(XCO2F .GT. 0.0) THEN
          RTF = A + B/XCO2F
      ELSE
          RTF = 0.0
      ENDIF

*SEC 11.2.3 Ratio of combustion and relief air to stoichiometric air

      IF(XCO2S .GT. 0.0) THEN
          RTS = A + B/XCO2S
      ELSE
          RTS = 0.0
      ENDIF

*SEC 11.2.4 and 11.3.4 Average ratio of stack gas mass flow rate to
*                      flue gas mass flow rate

*Sec 11.2.4
      IF(FUEL .GT. 2 .AND. NSYS .NE. 4 .AND. NSYS .NE. 8) THEN
          IF(NSYS .LE.2 .OR. NSYS .EQ. 5 .OR. NSYS .EQ. 6) THEN
              IF(RTS .GT. 0.0 .AND. RTF .GT. 0.0) THEN
                  SFR = 1.3*RTS/RTF
              ELSE
                  SFR = 1.0
              ENDIF
          ELSE
                  SFR = 1.0
          ENDIF
      ELSE
          IF(NSYS .EQ. 4 .OR. NSYS .EQ. 8) THEN
              IF(RTS .GT. 0.0 .AND. RTF .GT. 0.0) THEN
                  SFR = RTS/RTF
              ELSE
                  SFR = 1.4
              ENDIF
          ELSE
                  SFR = 1.4
          ENDIF
      ENDIF

* For direct exhaust system:
      if(nsys .eq. 3) sfr = 1.0
*Sec 11.3.4
      if(conden) sfr = 1.0
*SEC 11.2.5 Stack temperature rise

C     DTSSS = TSSSX - TRA
C     DTFSS = TFSS - TRA

*SEC 11.2.6  Average sensible heat loss at steady-state operation

      HHVA = HHVX(FUEL)
      AFR  = AF(FUEL)
      LLA  = Q(FUEL)

      CALL SENLOS(FUEL,HHVA,AFR,XCO2S,TSSSX,RTS,


     &            TFSS,RTF,TRA,LSSS)

*SEC 11.2.7  Steady state efficiency of non-condensing units

      EFFYSS = 100.0 - LLA - LSSS

*SEC 11.3.7.1  Latent heat gain due to condensation under steady state
*               conditions (condensing units)

      IF(CONDEN) THEN
          LGSS = 100.0*1053.3*MCSS/QCSS

*SEC 11.3.7.2  Steady state heat loss due to hot condensate going down
*               the drain (condensing units)

          LCSS = LGSS*(1.0*(TFSS-REFTRM) - 0.45*(TFSS - REFTOA))/1053.3

*SEC 11.3.7.3  Steady state efficiency of condensing units

          EFFYSS = 100.0 - (LLA + LSSS - LGSS + LCSS)
      ENDIF


*SEC 11.2.8   Heating capacity and part-load constants
*SEC 11.2.8.1 Maximum fuel input rate heating capacity

      IF(INST .EQ. 1) K = 0.0
      IF(INST .EQ. 2) K = 3.3
      IF(inst .eq. 3) K = 1.7
*++++The following line of code is revised from version 4.2 and before
      IF(TYPE .EQ. 4 .and. inst .eq. 2) K = 1.0
*
      QOUT = QIN*(EFFYSS - K*LJ)/100.0

***round off to the nearest 1000 Btu:
      qout = INT((qout + 500)/1000) * 1000.

*SEC 11.2.8.2  Design heating requirement

C      CALL DHRC(QOUT,NDHR,KDHR)
C      IF(CTRL .EQ. 1) NDHR = 1

*SEC 11.2.8.3  Oversize factor

      ALPHAX = 0.7

*SEC 11.2.8.4  Average outdoor temperature
*     REFTOA = 42.0 F set in DATA statement

*SEC 11.2.9  Calculation of part-load, seasonal efficiency

*SEC 11.2.9.1  Multiplication factor for sensible heat loss during
*              burner on-cycle

      KSON = 100.0*CP*(1.0 + RTF*AFR)/HHVA

*SEC 11.2.9.2  Multiplication factor for infiltration loss during
*              burner on-cycle

      IF(NSYS .LE. 8) THEN
          KION = PHI*SFR*KSON
      ELSE
          KION = 0.0
      ENDIF

*SEC 11.2.9.3  Equivalent field stack gas temperature at full-load
*              steady-state operation

      TSSS = (TFSS - TRA)/SFR + TRA

*==SEC 9.10 and 11.3.11.3    Option of no cylic tests for condensing units:

      if(conden .and. tfon1 .le. 0.1) goto 15
*==

*SEC 11.2.9.4  On-cycle time constant

      IF(TYPE .LE. 2) THEN
          T1 = 0.5
          T2 = 2.5
      ELSE
          T1 = 1.0
          T2 = 5.5
      ENDIF

      IF ( TFON1 .GE. TFSS ) THEN
          TFON1 = TFSS - 0.2
      ENDIF
      IF ( TFON2 .GE. TFSS ) THEN
          TFON2 = TFSS - 0.1
      ENDIF
      IF ( TFON1 .GE. TFON2 ) THEN
          TFON1 = TFON2 - 0.1
      ENDIF

      TAON = (T2 - T1)/ALOG((TFSS - TFON1)/(TFSS - TFON2))

*SEC 11.2.9.5  Effective flue gas temperature difference at start-up

      THFOX = (TFSS-TFON1)*EXP(T1/TAON)

*SEC 11.2.9.6  Off-cycle time constant

      IF(TYPE .LE. 2) THEN
          T3 = 1.5
          T4 = 9.0
C         T5 = INFINITY
      ELSE
          T3 = 3.75
          T4 = 22.5
C         T5 = 45.0
      ENDIF

      IF ( TFOF4 .LE. TFOF5 ) THEN
          TFOF4 = TFOF5 + 0.1
      ENDIF
      IF ( TFOF3 .LE. TFOF5 ) THEN
          TFOF3 = TFOF5 + 0.2
      ENDIF
      IF ( TFOF3 .LE. TFOF4 ) THEN
          TFOF3 = TFOF4 + 0.1
      ENDIF

      TAOFF = (T4 - T3)/ALOG((TFOF3 - TFOF5)/(TFOF4 - TFOF5))

*SEC 11.2.9.7  Effective flue gas temperature difference at shut-down

      SIFOX = (TFOF3 - TFOF5)*EXP(T3/TAOFF)

*SEC 11.2.9.8  Minimum flue gas temperature difference above room
*              temperature

      SIFIX = TFOF5 - TRA

*SEC 11.6 Optional tracer gas procedure

      MFON = (RTF*AFR + 1.0)*QIN/(HHVA*60.0)

      IF(OPTEST .GT. 0 .AND. DP .EQ. 0.0) THEN
          RHOF = 1.325*PB/(TT + 460.0)
          MFM = (CTM - CT)*VT*RHOF/CT

*   For units with no draft
          IF(NSYS .EQ. 2 .OR. NSYS .EQ. 3 .OR. NSYS .EQ. 6
     &   .OR. NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN

              MFOFF = MFM*((TFSS - TRA)/(TFOFF - TRA))**0.56*
     &                ((TFOFF + 460.0)/(TFSS + 460.0))**1.19

          ELSE
*   For units with draft, NSYS 4 or 8 only
              MFOFF = MFM
          ENDIF
          DP = MFOFF/MFON
          if(dp .lt. 0.1) dp = 0.05
      ENDIF

*SEC 11.2.9.9  & 11.2.9.10  Minimum stack gas temperature difference
*          above room temperature, and effective stack gas temperature
*          difference at shut-down

      IF(NSYS .EQ. 5) THEN
                  DF = 1.0
      ELSEIF(NSYS .EQ. 2 .OR. NSYS .EQ. 3 .OR. NSYS .EQ. 4 .OR.
     &    NSYS .EQ. 6 .OR. NSYS .EQ. 8 .OR. NSYS .EQ. 10) THEN
              IF(DP .GT. 0.0) THEN
                  DF = DP
              ELSE
                  DF = 0.4
              ENDIF
*++
      ELSEIF(nsys .eq. 1 .or. NSYS .EQ. 9) THEN
          IF(DP .GT. 0.0 .AND. OPTEST .EQ. 2) THEN
                  DF = DP
          ELSE
                  DF = 1.0
          ENDIF
      ENDIF

*++   Input DP as 0.05 for units complying with SEC 8.8.3

      IF(NSYS.EQ.1.OR.NSYS.EQ.2.OR.NSYS.EQ.5.OR.NSYS.EQ.6) THEN
              DS0 = 1.0
      ELSEIF(NSYS .EQ. 3) THEN
              DS0 = 0.4
      ELSEIF(NSYS .EQ. 4 .OR. NSYS .EQ. 8) THEN
          IF(DP .EQ. 0.0) THEN
              DS0 = 0.85
          ELSE
              DS0 = (0.79 + DP)/1.4
          ENDIF
      ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
              DS0 = 0.0
      ENDIF

      IF(CONDEN) THEN
                  SISIX = SIFIX
                  SISOX = 0.0
      ELSE
          IF(NSYS .LE. 8) THEN
              IF(DS0*SFR .GT. DF) THEN
                  SISIX = DF*SIFIX/(SFR*DS0)
                  SISOX = DF*SIFOX/(SFR*DS0)
              ELSE
                  SISIX = SIFIX
                  SISOX = SIFOX
              ENDIF
          ENDIF
      ENDIF

*SEC 11.2.9.11 & 11.2.9.12     Ratio of average burner on-time/off-time
*               per cycle to on-cycle/off-cycle time constant

      IF(TYPE .LE. 2 ) THEN
          TON  = 3.87
          TOFF = 13.3
      ELSE
          TON  = 9.68
          TOFF = 33.26
      ENDIF

      RON = TON/TAON
      ROFF = TOFF/TAOFF

*SEC 11.2.9.13 & 11.2.9.14  Start-up/shut-down burner cycling effect
*               correction factor

      FON = SIFOX*EXP(-ROFF)/(TFSS - TFOF5)
      FOFF = THFOX*EXP(-RON)/(TFSS - TFOF5)
      FONOF = 1.0 - FON*FOFF
      CTON = (1.0 - FON)/FONOF
      IF(QP .LT. 0.1) THEN
          CIID = 0.9
      ELSE
          CIID = 1.0
      ENDIF
      CTOFF = CIID*(1.0 - FOFF)/FONOF

*SEC 11.2.9.15, 11.2.9.16 & 11.2.9.17  Effective gas temperature
*               difference

      CS122 = 1.22
      IF(NSYS .LE. 8) THEN
          SIFO = CTOFF*SIFOX
          SIFI = SIFIX
          SISO = CTOFF*SISOX
          SISI = SISIX
      ELSE
          SIFO = CS122*SIFOX*CTOFF
          SIFI = CS122*SIFIX
          SISO = 0.0
          SISI = 0.0
      ENDIF

*SEC 11.2.9.18  Off-cycle stack gas draft factor

      D0 = 1.0
*++
      d0i = 1.0
*++
      IF(NSYS .EQ. 1 .OR. NSYS .EQ. 2) THEN
                  DS = 1.0
      ELSEIF(NSYS .EQ. 3) THEN
          IF(DP .GT. 0.0) THEN
                  DS = DP
          ELSE
                  DS = 0.4
          ENDIF
      ELSEIF(NSYS .EQ. 4) THEN
          IF(DP .GT. 0.0) THEN
                  DS = (0.79 + DP)/1.4
          ELSE
                  DS = 0.85
          ENDIF
 
      ELSEIF(NSYS .EQ. 5 .OR. NSYS .EQ. 6 .OR. NSYS .EQ. 8) THEN
*++
          CALL DZERO(SFR,DF,AS,AD,AOD,AOL,OMEGA,TS,TD,TOFF,TAOFF,
     &               SISI,SISO,sifi,sifo,ds0,D0,d0i)
*++
          IF(NSYS .EQ. 5 .OR. NSYS .EQ. 6) THEN
                  DS = D0
          ELSEIF(NSYS .EQ. 8) THEN
              IF(DP .GT. 0.0) THEN
                  DS = (0.79 + DP)/1.4 * D0
              ELSE
                  DS = 0.85 * D0
              ENDIF
          ENDIF
      ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
                  DS = 0.0
      ENDIF

*SEC 11.2.9.19 & 11.2.9.20 Off-cycle sensible and  off-cycle
*               infiltration  heat loss integration factors

      F3 = 0.0
      F4 = 0.0
      F5 = 0.0
      F6 = 0.0
      F7 = 0.0
      F8 = 0.0
*++
      ROF = ROFF
      if(ipurge .gt. 0) then
          ROF = (toff - tp)/taoff
      endif
*++
      IF(NSYS .LE. 4) THEN
          N = 4
          CALL FUNT4(N,SIFO,ROF,REFTOA,REFTRM,F3,F4)
          N = 8
          IF(NSYS .EQ. 3) THEN
              CALL FUNT4(N,SIFO,ROF,REFTOA,REFTRM,F7,F8)
          ELSE
              CALL FUNT4(N,SISO,ROF,REFTOA,REFTRM,F7,F8)
          ENDIF
      ELSEIF(NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
          N = 6
          CALL FUNT4(N,SISO,ROF,REFTOA,REFTRM,F5,F6)
          N = 8
          CALL FUNT4(N, SISO, ROF, REFTOA, REFTRM, F7, F8)
      ELSE
          N = 6
          CALL FUNT4(N,SIFO,ROF,REFTOA,REFTRM,F5,F6)
      ENDIF

*SEC 11.2.10 & 11.2.10.1  Correction factor which corrects for use of
*               outside air for combustion ( non-condensing units )

      IF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
          CS = 1.0 + (REFTRM-REFTOA)*EFFYSS/((TFSS-TRA)*100.0)
      ELSE
          CS = 1.0
      ENDIF

*SEC 11.3.10.1  Correction factor which corrects for use of outside air
*               for combustion ( condensing units )

      IF(CONDEN) THEN
          IF(NSYS .EQ. 3) THEN
              CS = 1.0
          ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
              CS = (TFSS - REFTOA)/(TFSS-TRA)
          ENDIF
      ENDIF

*SEC 11.2.10.2  Effective flue gas temperature difference at burner
*               start-up, corrected for burner cycling effect

      IF(NSYS .LE. 8) THEN
          THFO = CTON*THFOX
      ELSE
          THFO = CTON*CS*THFOX
      ENDIF

*SEC 11.2.10.3  Multiplication factor for sensible heat loss during
*               burner off-cycle

      IF(NSYS .LE. 4) THEN
          KSOFF=(TFSS-TRA+460.+REFTRM)**1.19*DF*KSON/(TFSS-TRA)**0.56
      ELSEIF(NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
          KSOFF=(TSSS-TRA+460.+REFTRM)**1.19*DS*SFR*KSON
     &          /(TSSS-TRA+REFTRM-REFTOA)**0.56
      ELSE
          KSOFF=(TFSS-TRA+460.+REFTRM)**1.19*DF*KSON
     &          /(TFSS-TRA+REFTRM-REFTOA)**0.56
      ENDIF

*SEC 11.2.10.4  Multiplication factor for infiltration loss during
*                burner off-cycle
*++
      IF(NSYS .LE. 8 .and. ds .gt. 0.) THEN
          IF(NSYS .EQ. 3) THEN
              KIOFF=(TFSS-TRA+460.+REFTRM)**1.19*DS*KION
     &              /(TFSS-TRA+REFTRM-REFTOA)**0.56
*++
          ELSEIF(nsys .ge. 5 .and. nsys .le. 8) then
              KIOFF=(TSSS-TRA+460.+REFTRM)**1.19*DS*KION*(d0i/d0)
     &              /(TSSS-TRA+REFTRM-REFTOA)**0.56
*++
          else
              KIOFF=(TSSS-TRA+460.+REFTRM)**1.19*DS*KION
     &              /(TSSS-TRA+REFTRM-REFTOA)**0.56
          ENDIF
*++
      ELSE
              KIOFF = 0.0
      ENDIF

*SEC 11.2.10.5 On-cycle sensible heat loss

      IF(NSYS .LE. 8) THEN
          LSON = LSSS - KSON*THFO*(1.0 - EXP(-RON))/RON
      ELSE
          LSON = CS*LSSS - KSON*THFO*(1.0 - EXP(-RON))/RON
      ENDIF
     
*SEC 11.2.10.6 Off-cycle sensible heat loss

*++   Sensible loss during post purge for power vented burner unit

      if(ipurge .gt. 0) then
          if(nsys .eq. 2 .or. nsys .eq. 3 .or. nsys .eq. 4) cts = ctoff
          if(nsys .eq. 10) cts = ctoff*cs122
          lsoff1 = 100.*cp*mfon*tp*(tfss+460)*
     &         (1-((tra+460)/(cts*(tfss-tfofp)))*
     &         ALOG((tra+460+cts*(tfss-tra))/(tra+460+cts*(tfofp-tra))))
     &         /(ton*qin/60.)
      else
          lsoff1 = 0.
      endif

*++  Sensible loss during non-post-purge period of the off-cycle

      IF(NSYS .LE. 4) THEN

          if(ipurge .gt. 0) then
              LSOFF2 = KSOFF*(TOFF-tp)/TON*(F3 + SIFI*F4)
          else
              LSOFF2 = KSOFF*TOFF/TON*(F3 + SIFI*F4)
          endif

      ELSEIF(NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
              LSOFF2 = KSOFF*TOFF/TON*(F5 + SISI*F6)
      ELSE
          if(ipurge .gt. 0) then
              LSOFF2 = KSOFF*(TOFF-tp)/TON*(F5 + SIFI*F6)
          else
              LSOFF2 = KSOFF*TOFF/TON*(F5 + SIFI*F6)
          endif
      ENDIF

*++  Total seneible loss during off-cycle: (powered + non-powered vent)

      lsoff = lsoff1 + lsoff2

*SEC 11.2.10.7 On-cycle infiltration heat loss

      IF(NSYS .LE. 8) THEN
          LION = KION*(REFTRM - REFTOA)
      ELSE
          LION = 0.0
      ENDIF

*SEC 11.2.10.8 Off-cycle infiltration heat loss

      IF(NSYS .LE. 8) THEN

*++     Infiltration loss during post purge for power vented burner

        if(ipurge .gt. 0) then
            lioff1 = 100.*(1./ctoff)*cp*mfon*(reftrm-reftoa)*
     &      tp*((tfss+460)/(tfss-tfofp))*
     &      ALOG((tra+460+ctoff*(tfss-tra))/(tra+460+ctoff*(tfofp-tra)))
     &      /(ton*qin/60.)
        else
            lioff1 = 0.
        endif

*++     Infiltration loss during non-post-purge period of the off-cycle

        if(nsys .ne. 3) then
           if(ipurge .gt. 0) then
               LIOFF2 = KIOFF*(REFTRM-REFTOA)*(TOFF-tp)/TON*(F7+SISI*F8)
           else
               LIOFF2 = KIOFF*(REFTRM-REFTOA)*TOFF/TON*(F7+SISI*F8)
           endif
        endif

        IF(NSYS.EQ.3) THEN
           if(ipurge .gt. 0) then
               LIOFF2 = KIOFF*(REFTRM-REFTOA)*(TOFF-tp)/TON*(F7+SIFI*F8)
           else
               LIOFF2 = KIOFF*(REFTRM-REFTOA)*TOFF/TON*(F7+SIFI*F8)
           endif
        ENDIF

*++   Total infilt. loss during off-cycle: (powered + non-powered vent)

        lioff = lioff1 + lioff2

      ELSE
        LIOFF = 0.0
      ENDIF

*==
15    continue
*==

*SEC 11.2.11  Heating seasonal efficiency of non-condensing units

      IF(INST .EQ. 1) THEN
          CJ = 0.0
      ELSEIF(TYPE .LT. 3 .AND. INST .EQ. 3) THEN
          CJ = 1.7
      ELSEIF((TYPE .EQ. 3 .OR. TYPE .EQ. 5) .AND. INST .EQ. 3) THEN
          CJ = 2.4
      ELSEIF(TYPE .LT. 3 .AND. INST .EQ. 2) THEN
          CJ = 3.3
      ELSEIF((TYPE .EQ. 3 .OR. TYPE .EQ. 5) .AND. INST .EQ. 2) THEN
          CJ = 4.7
      ELSEIF(TYPE .EQ. 4 .and. inst .eq. 2) THEN
          CJ = 1.0
      elseif(type .eq. 4 .and. inst .eq. 3) then
          cj = 0.5
      ENDIF

      PF = QP/QIN

*==   SEC 9.10 and 11.3.11.3  Option of no cool-down and heat-up tests:

      if (conden .and. tfon1 .le. 0.1) goto 16

*==
      EFFYHS = 100.0 - LLA -CJ*LJ - TON*(LSON + LSOFF + LION + LIOFF)
     &         /(TON + PF*TOFF)

*==
16    continue
*==

*SEC 11.3.11.1   Latent heat gain under part-load condition
*                for condensing units

      IF(CONDEN) THEN
          LG = 100.0*1053.3*MC/QC

*SEC 11.3.11.2  Part load heat loss due to condensate going down the
*               drain

          LC = LG*(1.0*(TFSS-REFTRM) - 0.45*(TFSS - REFTOA))/1053.3
*==
*==SEC 9.3 and 11.3.11.3 Option of no cool-down and heat-up flue loss tests:

          if (tfon1 .le. 0.1) goto 17
*==
*SEC 11.3.11.3  Heating seasonal efficiency of condensing units

          EFFYHS = 100.0 - LLA + LG - LC - CJ*LJ - TON*
     &             (LSON + LSOFF + LION + LIOFF)/(TON + PF*TOFF)
      ENDIF
*==
17    continue
*==
*=SEC 9.10 and 11.3.11.3 Option of no cool-down and heat-up flue loss tests:

      if (conden .and. tfon1 .le. 0.1) then
         df = 0.05
         do = 1.0
         ds = 0.
         cs122 = 1.22
         ciid = 0.9
         t1 = 0.
         t2 = 0.
         t3 = 0.
         t4 = 0.
         taon = 0.
         taoff = 0.
         ron = 0.
         roff = 0.
         siso = 0.
         sisi = 0.
         sisox = 0.
         sisix = 0.
         sifo = 0.
         sifi = 0.
         sifox = 0.
         sifix = 0.
         cton = 0.
         ctoff = 0.
         thfo = 0.
         thfox = 0.
         f3 = 0.
         f4 = 0.
         f5 = 0.
         f6 = 0.
         f7 = 0.
         f8 = 0.

*==  SEC 11.2.9.11 and 11.2.9.12 (Table 9) Burner on/off time:
         IF(TYPE .LE. 2 ) THEN
            TON  = 3.87
            TOFF = 13.3
         ELSE
            TON  = 9.68
            TOFF = 33.26
         ENDIF

         ksoff = 0.
         kioff = 0.
         lsoff = 0.
         lioff = 0.

*==  SEC 11.3.10.1  Correction factor which corrects for use of outside air
*==                 for combustion ( condensing units )
         IF(NSYS .EQ. 3) THEN
              CS = 1.0
         ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
              CS = (TFSS - REFTOA)/(TFSS-TRA)
         ENDIF

*==  SEC 11.3.10.5  On-cycle sensible loss
         lson = cs*lsss

*==  SEC 11.3.10.7 On-cycle infiltration heat loss
         IF(NSYS .LE. 8) THEN
             LION = KION*(REFTRM - REFTOA)
         ELSE
             LION = 0.0
         ENDIF
*==   The following line of code(lion=0.)to be deleted when error in 103-93
*==   (no lion for sys=3) will have been corrected after a future revision.
         lion = 0.
*==
         effyhs = 100. - lla + (lg - lc) - cj*lj - ton*
     &            (lson + lion)/(ton + pf*toff)
      endif
*==

*SEC 11.2.12 and 11.3.12   Annual fuel utilization efficiency

      AFUE = 5200.0*EFFYSS*EFFYHS
     &    /(5200.0*EFFYSS + 2.5*(1.0+ALPHAX)*4600.0*EFFYHS*PF)


* --------------------- Modulating Units -----------------------------

      ELSE

*SEC 11.4 Heating Seasonal Efficiency, Steady State Efficiency & AFUE for
*         Non-condensing & Modulating Gas or Oil Furnaces & Boilers

*SEC 11.5 Heating Seasonal Efficiency, Steady State Efficiency & AFUE for
*         Condensing & Modulating Gas or Oil Furnaces & Boilers

*SEC 11.4.1 CTRL > 1 for modulating units

* ---- NOTE: Appended character, H or R, to a variable denotes
*            high firing or reduced firing rate, respectively. However,
*            H is not appended to QIN, and F3,F4,F5,F6,F7,F8 for high
*            firing rate but R is appended to them for reduced rate. ----
*SEC 11.2.2

      A = ART(FUEL)
      B = BRT(FUEL)

*SEC 11.4.2

      IF(XCO2FH .GT. 0.0) THEN
          RTFH = A + B/XCO2FH
      ELSE
          RTFH = 0.0
      ENDIF
      IF(XCO2FR .GT. 0.0) THEN
          RTFR = A + B/XCO2FR
      ELSE
          RTFR = 0.0
      ENDIF

*SEC 11.4.3

*+++ IF(.NOT. CONDEN) THEN
         IF(XCO2SH .GT. 0.0) THEN
             RTSH = A + B/XCO2SH
         ELSE
             RTSH = 0.0
         ENDIF
         IF(XCO2SR .GT. 0.0) THEN
             RTSR = A + B/XCO2SR
         ELSE
             RTSR = 0.0
         ENDIF
*+++ ENDIF

*SEC 11.5.4

      IF(CONDEN) THEN
                  SFRR = 1.0
                  SFRH = 1.0
*SEC 11.4.4

      ELSE IF(FUEL .GT. 2) THEN
          IF(NSYS .LE.2 .OR. NSYS .EQ. 5 .OR. NSYS .EQ. 6) THEN
              IF((RTSR .GT. 0.0 .AND. RTFR .GT. 0.0) .AND.
     &        (RTSH .GT. 0.0 .AND. RTFH .GT. 0.0)) THEN
                  SFRR = 1.3*RTSR/RTFR
                  SFRH = 1.3*RTSH/RTFH
              ELSE
                  SFRR = 1.0
                  SFRH = 1.0
              ENDIF
          ELSE
                  SFRR = 1.0
                  SFRH = 1.0
          ENDIF
      ELSE
          IF(NSYS .EQ. 4 .OR. NSYS .EQ. 8) THEN
              IF((RTSR .GT. 0.0 .AND. RTFR .GT. 0.0) .AND.
     &        (RTSH .GT. 0.0 .AND. RTFH .GT. 0.0)) THEN
                  SFRR = RTSR/RTFR
                  SFRH = RTSH/RTFH
              ELSE
                  SFRR = 1.4
                  SFRH = 1.4
              ENDIF
          ELSE
                  SFRR = 1.4
                  SFRH = 1.4
          ENDIF
      ENDIF

*+++ For direct exhaust system:
      if(nsys .eq. 3) then
          sfrr = 1.0
          sfrh = 1.0
      endif
*+++
*SEC 11.4.5

C     DTSSSH = TSSSXH - TRAH
C     DTSSSR = TSSSXR - TRAR
C     DTFSSH = TFSSH - TRAH
C     DTFSSR = TFSSR - TRAR

*SEC 11.2.6

      HHVA = HHVX(FUEL)
      AFR = AF(FUEL)
      LLA = Q(FUEL)

*SEC 11.2.8.1

      IF(INST .EQ. 1) K = 0.0
      IF(INST .EQ. 2) K = 3.3
      IF(inst .eq. 3) K = 1.7
*++++      IF(TYPE .EQ. 4) K = 1.0
*++++The following line of code is revised from version 4.2
      IF(TYPE .EQ. 4 .and. inst .eq. 2) K = 1.0

*SEC 11.4.6

      CALL SENLOS(FUEL,HHVA,AFR,XCO2SR,TSSSXR,RTSR,
     &                TFSSR,RTFR,TRAR,LSSSR)
      CALL SENLOS(FUEL,HHVA,AFR,XCO2SH,TSSSXH,RTSH,
     &                TFSSH,RTFH,TRAH,LSSSH)

*SEC 11.4.7

      EFYSSR = 100.0 - LLA - LSSSR
      EFFYSS = 100.0 - LLA - LSSSH

*SEC 11.5.7.1

      IF(CONDEN) THEN

*+ Condensing unit case:---

*+ Calculate latent loss down the condensate drain
          LGSSR = 100.0*1053.3*MCSSR/QCSSR
          LGSSH = 100.0*1053.3*MCSSH/QCSSH

*+ Initial assumed ambient temperatures
      rftoar = 42.
      rftoah = 5.

      do 115 icond = 1,100

*SEC 11.5.7.2

      LCSSR = LGSSR*(1.0*(TFSSR-REFTRM) - 0.45*(TFSSR-rftoar))/1053.3
      LCSSH = LGSSH*(1.0*(TFSSH-REFTRM) - 0.45*(TFSSH-rftoah))/1053.3

*SEC 11.5.7.3

          EFYSSR = 100.0 - (LLA + LSSSR - LGSSR + LCSSR)
          EFFYSS = 100.0 - (LLA + LSSSH - LGSSH + LCSSH)

*SEC 11.4.8.1.1 & 11.4.8.1.2 Heating capacity at maximum and reduced
*                            input rates

      QOUTR = QINR*(EFYSSR - K*LJ)/100.0
      QOUT = QIN*(EFFYSS - K*LJ)/100.0
*
*SEC 11.4.8.2, 11.4.8.3, 11.4.8.4, & 11.4.8.5 Design heating
*        requirement, oversize factor, average outdoor temperature,
*        and balance point temperature

      CALL DHRC(QOUT,NDHR,KDHR)
      CALL TOAC(QOUT,QOUTR,NDHR,KDHR,ALPHA,TC,RH,TOAH,TOAR)
         if (abs(rftoar-toar(2)) .le. 1.
     &       .and. abs(rftoah-toah(2)) .le. 1.) goto 116
            rftoar = toar(2)
            rftoah = toah(2)
115   continue
*+++ End of condensing calculation for Qout, Tc, Toar and Toah

      else

*++ Non-condensing case:---  

*SEC 11.4.8.1.1 & 11.4.8.1.2 Heating capacity at maximum and reduced
*                            input rates

      QOUTR = QINR*(EFYSSR - K*LJ)/100.0
      QOUT = QIN*(EFFYSS - K*LJ)/100.0

*SEC 11.4.8.2, 11.4.8.3, 11.4.8.4, & 11.4.8.5 Design heating
*        requirement, oversize factor, average outdoor temperature,
*        and balance point temperature

      CALL DHRC(QOUT,NDHR,KDHR)
      CALL TOAC(QOUT,QOUTR,NDHR,KDHR,ALPHA,TC,RH,TOAH,TOAR)

      rftoar = toar(2)
      rftoah = toah(2)

*+++ End of non-condensing calculation for Qout, Tc, Toar and Toah

      endif

116   continue

***round off to the nearest 1000 Btu:
      qoutr = INT((qoutr + 500)/1000) * 1000.
      qout = INT((qout + 500)/1000) * 1000.

      DO 10 J = 1, NDHR

      DHR(J) = KDHR(J)*1000.0

*SEC 11.4.8.6  Fraction of heating load at maximum fuel input rate
*              operating mode

      XH(J) = 1.0 - RH(J)

*SEC 11.4.8.7  Fraction of heating load at reduced fuel input rate
*              operating mode

      XR(J) = RH(J)

*SEC 11.4.8.8  Average steady-state efficiency for the modulating mode
*              for furnaces and boilers equipped with step-modulating
*              controls

      IF(CTRL .EQ. 3) THEN
          IF ( DHR(J) .GT.  QOUTR ) THEN  
             EFYSSM(J) = ((DHR(J) - QOUTR)/(QOUT - QOUTR))
     &                   *((TC(J)-TOAH(J))/(TC(J)-5.0))
     &                   *(EFFYSS-EFYSSR)+EFYSSR
          ELSE
             EFYSSM(J) = EFYSSR
          ENDIF
      ENDIF

*SEC 11.4.8.9  Weighted-average steady-state efficiency

      IF(CTRL .EQ. 2) THEN
          EFYSSW(J) = XH(J)*EFFYSS + XR(J)*EFYSSR
      ELSEIF(CTRL .EQ. 3) THEN
          EFYSSW(J) = XH(J)*EFYSSM(J) + XR(J)*EFYSSR
      ENDIF

*SEC 11.4.8.10  Average heat output rate for the modulating mode
*               for furnaces and boilers equipped with step-modulating
*               controls

      IF ( DHR(J) .GT.  QOUTR ) THEN  
         QOUTM(J) = ((DHR(J)-QOUTR)*(TC(J)-TOAH(J))/(TC(J)-5.0))+
     &               QOUTR
      ELSE
         QOUTM(J) = QOUTR
      ENDIF

10    CONTINUE

*SEC 11.4.9.1

      KSONR = 100.0*CP*(1.0 + RTFR*AFR)/HHVA
      KSONH = 100.0*CP*(1.0 + RTFH*AFR)/HHVA

*SEC 11.4.9.2.1

      IF(NSYS .LE. 8) THEN
          KIONR = PHI*SFRR*KSONR
          KIONH = PHI*SFRH*KSONH
      ELSE
          KIONR = 0.0
          KIONH = 0.0
      ENDIF

*SEC 11.4.9.2.2  Average on-cycle infiltration heat loss for the units
*                with step-modulating controls

      IF(INST .EQ. 1) THEN
          CJ = 0.0
      ELSEIF(TYPE .LT. 3 .AND. INST .EQ. 3) THEN
          CJ = 1.7
      ELSEIF((TYPE .EQ. 3 .OR. TYPE .EQ. 5) .AND. INST .EQ. 3) THEN
          CJ = 2.4
      ELSEIF(TYPE .LT. 3 .AND. INST .EQ. 2) THEN
          CJ = 3.3
      ELSEIF((TYPE .EQ. 3 .OR. TYPE .EQ. 5) .AND. INST .EQ. 2) THEN
          CJ = 4.7
      ELSEIF(TYPE .EQ. 4 .and. inst .eq. 2) THEN
          CJ = 1.0
      elseif(type .eq. 4 .and. inst .eq. 3) then
          cj = 0.5
      ENDIF

      DO 20 J = 1, NDHR

      IF(CTRL .EQ. 3) THEN
          LIONM(J) = (KIONR*(70.0 - TOAR(J))
     &                 + KIONH*(70.0 - TOAH(J)))/2.0

*SEC 11.4.9.2.3  Average part-load efficiency for the units with
*                step-modulating controls

          IF(INST .EQ. 1 ) THEN
              EFFYUM(J) = EFYSSM(J) - LIONM(J)
          ELSEIF(INST .GE. 2) THEN
              EFFYUM(J) = EFYSSM(J) - CJ*LJ
          ENDIF
      ENDIF

20    CONTINUE

*SEC 11.4.9.3

*+++ IF(.NOT. CONDEN) THEN
              TSSSR = (TFSSR - TRAR)/SFRR + TRAR
          IF(CTRL .EQ. 2) THEN
              TSSSH = (TFSSH - TRAH)/SFRH + TRAH
          ENDIF
*+++ ENDIF

*SEC 11.2.9.4

      IF(TYPE .LE. 2) THEN
          T1 = 0.5
          T2 = 2.5
      ELSE
          T1 = 1.0
          T2 = 5.5
      ENDIF

*SEC 11.4.9.4

      IF ( TFONR1 .GE. TFSSR ) THEN
          TFONR1 = TFSSR - 0.2
      ENDIF
      IF ( TFONR2 .GE. TFSSR ) THEN
          TFONR2 = TFSSR - 0.1
      ENDIF
      IF ( TFONR1 .GE. TFONR2 ) THEN
          TFONR1 = TFONR2 - 0.1
      ENDIF

      TAONR = (T2 - T1)/ALOG((TFSSR - TFONR1)/(TFSSR - TFONR2))

      IF(CTRL .EQ. 2) THEN
          IF ( TFONH1 .GE. TFSSH ) THEN
              TFONH1 = TFSSH - 0.2
          ENDIF
          IF ( TFONH2 .GE. TFSSH ) THEN
              TFONH2 = TFSSH - 0.1
          ENDIF
          IF ( TFONH1 .GE. TFONH2 ) THEN
              TFONH1 = TFONH2 - 0.1
          ENDIF

          TAONH = (T2 - T1)/ALOG((TFSSH - TFONH1)/(TFSSH - TFONH2))
      ENDIF

*SEC 11.4.9.5

      THFOXR = (TFSSR - TFONR1)*EXP(T1/TAONR)
      IF(CTRL .EQ. 2) THEN
          THFOXH = (TFSSH - TFONH1)*EXP(T1/TAONH)
      ENDIF

*SEC 11.4.9.6

      IF(TYPE .LE. 2) THEN
          T3 = 1.5
          T4 = 9.0
C         T5 = INFINITY
      ELSE
          T3 = 3.75
          T4 = 22.5
C         T5 = 45.0
      ENDIF

      IF ( TFOFR4 .LE. TFOFR5 ) THEN
          TFOFR4 = TFOFR5 + 0.1
      ENDIF
      IF ( TFOFR3 .LE. TFOFR5 ) THEN
          TFOFR3 = TFOFR5 + 0.2
      ENDIF
      IF ( TFOFR3 .LE. TFOFR4 ) THEN
          TFOFR3 = TFOFR4 + 0.1
      ENDIF

      TAOFFR = (T4 - T3)/ALOG((TFOFR3 - TFOFR5)/(TFOFR4 - TFOFR5))

      IF(CTRL .EQ. 2) THEN
          IF ( TFOFH4 .LE. TFOFH5 ) THEN
              TFOFH4 = TFOFH5 + 0.1
          ENDIF
          IF ( TFOFH3 .LE. TFOFH5 ) THEN
              TFOFH3 = TFOFH5 + 0.2
          ENDIF
          IF ( TFOFH3 .LE. TFOFH4 ) THEN
              TFOFH3 = TFOFH4 + 0.1
          ENDIF

          TAOFFH = (T4 - T3)/ALOG((TFOFH3 - TFOFH5)/(TFOFH4 - TFOFH5))
      ENDIF

*SEC 11.4.9.7

      SIFOXR = (TFOFR3 - TFOFR5)*EXP(T3/TAOFFR)
      IF(CTRL .EQ. 2) THEN
          SIFOXH = (TFOFH3 - TFOFH5)*EXP(T3/TAOFFH)
      ENDIF

*SEC 11.4.9.8

      SIFIXR = TFOFR5 - TRAR
      IF(CTRL .EQ. 2) THEN
          SIFIXH = TFOFH5 - TRAH
      ENDIF

*SEC 11.6 Optional tracer gas procedure for modulating units

*++   For atmospheric burner with elec-mech inlet or flue damper

      IF(NSYS .EQ. 1 .OR. NSYS .EQ. 9) THEN
          IF(OPTEST .EQ. 2 .AND. DP .GT. 0.0) THEN
              DPR = DP
              IF(CTRL .EQ. 2) DPH = DP
          ENDIF
      ENDIF

      MFONR = (RTFR*AFR + 1.0)*QINR/(HHVA*60.0)
      IF(CTRL .EQ. 2) MFONH = (RTFH*AFR + 1.0)*QIN/(HHVA*60.0)

      IF(OPTEST .GT. 0 .AND. DP .EQ. 0.0) THEN

          RHOFR = 1.325*PBR/(TTR + 460.0)
          MFMR = (CTMR - CTR)*VTR*RHOFR/CTR

          IF(CTRL .EQ. 2) THEN

              RHOFH = 1.325*PBH/(TTH + 460.0)
              MFMH = (CTMH - CTH)*VTH*RHOFH/CTH
          ENDIF

*  For units with no draft
          IF(NSYS .EQ. 2 .OR. NSYS .EQ. 3 .OR. NSYS .EQ. 6
     &      .OR. NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN

              MFOFFR = MFMR*((TFSSR - TRAR)/(TFOFFR - TRAR))**0.56*
     &                 ((TFOFFR + 460.0)/(TFSSR + 460.0))**1.19

              IF(CTRL .EQ. 2) THEN
                  MFOFFH = MFMH*((TFSSH - TRAH)/(TFOFFH - TRAH))**0.56*
     &                     ((TFOFFH + 460.0)/(TFSSH + 460.0))**1.19
              ENDIF
 
          ELSE
*  For units with draft, NSYS 4 or 8 only
              MFOFFR = MFMR
              IF(CTRL .EQ. 2) MFOFFH = MFMH
          ENDIF

          DPR = MFOFFR/MFONR
          if(dpr .lt. 0.1) dpr = 0.05
          IF(CTRL .EQ. 2) THEN
              DPH = MFOFFH/MFONH
              if(dph .lt. 0.1) dph = 0.05
          ENDIF
      ENDIF

*SEC 11.2.9.9 & 11.2.9.10

      IF(NSYS .EQ. 5) THEN
                  DFR = 1.0
                  IF(CTRL .EQ. 2) DFH = 1.0

      ELSEIF(NSYS .EQ. 2 .OR. NSYS .EQ. 3 .OR. NSYS .EQ. 4 .OR.
     &    NSYS .EQ. 6 .OR. NSYS .EQ. 8 .OR. NSYS .EQ. 10) THEN
              IF(DPR .GT. 0.0) THEN
                  DFR = DPR
                  IF(CTRL .EQ. 2) DFH = DPH
              ELSE
                  DFR = 0.4
                  IF(CTRL .EQ. 2) DFH = 0.4
              ENDIF

      ELSEIF(NSYS .EQ. 1 .OR. NSYS .EQ. 9) THEN
          IF(DPR .GT. 0.0 .AND. OPTEST .EQ. 2) THEN
                  DFR = DPR
                  IF(CTRL .EQ. 2) DFH = DPH
          ELSE
                  DFR = 1.0
                  IF(CTRL .EQ. 2) DFH = 1.0
          ENDIF
      ENDIF
*         Input DP as 0.05 for units complying with SEC 8.8.3

      IF(NSYS.EQ.1.OR.NSYS.EQ.2.OR.NSYS.EQ.5.OR.NSYS.EQ.6) THEN
              DS0R = 1.0
              IF(CTRL .EQ. 2) DS0H = 1.0
      ELSEIF(NSYS .EQ. 3) THEN
              DS0R = 0.4
              IF(CTRL .EQ. 2) DS0H = 0.4
      ELSEIF(NSYS .EQ. 4 .OR. NSYS .EQ. 8) THEN
          IF(DPR .EQ. 0.0) THEN
              DS0R = 0.85
              IF(CTRL .EQ. 2) DS0H = 0.85
          ELSE
              DS0R = (0.79 + DPR)/1.4
              IF(CTRL .EQ. 2) DS0H = (0.79 + DPH)/1.4
          ENDIF
      ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
              DS0R = 0.0
              IF(CTRL .EQ. 2) DS0H = 0.0
      ENDIF

      IF(CONDEN) THEN
                      SISIXR = SIFIXR
                      SISOXR = 0.0
          IF(CTRL .EQ. 2) THEN
                      SISIXH = SIFIXH
                      SISOXH = 0.0
          ENDIF
      ELSE
          IF(NSYS .LE. 8) THEN
              IF(DS0R*SFRR .GT. DFR) THEN
                      SISIXR = DFR*SIFIXR/(SFRR*DS0R)
                      SISOXR = DFR*SIFOXR/(SFRR*DS0R)
              ELSE
                      SISIXR = SIFIXR
                      SISOXR = SIFOXR
              ENDIF
              IF(CTRL .EQ. 2) THEN
                  IF(DS0H*SFRH .GT. DFH) THEN
                      SISIXH = DFH*SIFIXH/(SFRH*DS0H)
                      SISOXH = DFH*SIFOXH/(SFRH*DS0H)
                  ELSE
                      SISIXH = SIFIXH
                      SISOXH = SIFOXH
                  ENDIF
              ENDIF
          ENDIF
      ENDIF

*SEC 11.4.9.11 & 11.4.9.12

      IF(TYPE .LE. 2 ) THEN
          TON = 10.0
          TOFF = 10.0
      ELSE
          TON  = 15.0
          TOFF = 15.0
      ENDIF

      RONR = TON/TAONR
      ROFFR = TOFF/TAOFFR

      IF(CTRL .EQ. 2) THEN
          RONH = TON/TAONH
          ROFFH = TOFF/TAOFFH
      ENDIF

*SEC 11.4.9.13 & 11.4.9.14

      FONR = SIFOXR*EXP(-ROFFR)/(TFSSR - TFOFR5)
      FOFFR = THFOXR*EXP(-RONR)/(TFSSR - TFOFR5)
      FONOFR = 1.0 - FONR*FOFFR
      CTONR = (1.0 - FONR)/FONOFR
      IF(QP .LT. 0.1) THEN
          CIID = 0.9
      ELSE
          CIID = 1.0
      ENDIF
      CTOFFR = CIID*(1.0 - FOFFR)/FONOFR
      IF(CTRL .EQ. 2) THEN
          FONH = SIFOXH*EXP(-ROFFH)/(TFSSH - TFOFH5)
          FOFFH = THFOXH*EXP(-RONH)/(TFSSH - TFOFH5)
          FONOFH = 1.0 - FONH*FOFFH
          CTONH = (1.0 - FONH)/FONOFH
          CTOFFH = CIID*(1.0 - FOFFH)/FONOFH
      ENDIF

*SEC 11.4.9.15, 11.4.9.16 & 11.4.9.17

      CS122 = 1.22
      IF(NSYS .LE. 8) THEN
          SIFOR = CTOFFR*SIFOXR
          SIFIR = SIFIXR
          IF(.NOT. CONDEN) SISOR = CTOFFR*SISOXR
          SISIR = SISIXR
          IF(CTRL .EQ. 2) THEN
              SIFOH = CTOFFH*SIFOXH
              SIFIH = SIFIXH
              IF(.NOT. CONDEN) SISOH = CTOFFH*SISOXH
              SISIH = SISIXH
          ENDIF
      ELSE
          SIFOR = CS122*SIFOXR*CTOFFR
          SIFIR = CS122*SIFIXR
          SISOR = 0.0
          SISIR = 0.0
          SIFOH = CS122*SIFOXH*CTOFFH
          SIFIH = CS122*SIFIXH
          SISOH = 0.0
          SISIH = 0.0
      ENDIF

*SEC 11.4.9.18

      IF(NSYS .EQ. 1 .OR. NSYS .EQ. 2) THEN
                   DSR = 1.0
                   IF(CTRL .EQ. 2) DSH = 1.0
      ELSEIF(NSYS .EQ. 3) THEN
          IF(DPR .GT. 0.0) THEN
                   DSR = DPR
                   IF(CTRL .EQ. 2) DSH = DPH
          ELSE
                   DSR = 0.4
                   IF(CTRL .EQ. 2) DSH = 0.4
          ENDIF
      ELSEIF(NSYS .EQ. 4) THEN
          IF(DPR .GT. 0.0) THEN
                   DSR = (0.79 + DPR)/1.4
                   IF(CTRL .EQ. 2) DSH = (0.79 + DPH)/1.4
          ELSE
                   DSR = 0.85
                   IF(CTRL .EQ. 2) DSH = 0.85
          ENDIF
      ENDIF

      D0R = 1.0
      D0H = 1.0
*++
      d0ir = 1.0
      d0ih = 1.0
*++
      IF(NSYS .EQ. 5 .OR. NSYS .EQ. 6 .OR. NSYS .EQ. 8) THEN

*++
         CALL DZERO(sfrr,dfr,AS,AD,AOD,AOL,OMEGA,TS,TD,TOFF,TAOFFR,
     &               SISIR,SISOR,sifir,sifor,ds0r,D0R,d0ir)
          IF(CTRL .EQ. 2) THEN
             CALL DZERO(sfrh,dfh,AS,AD,AOD,AOL,OMEGA,TS,TD,TOFF,TAOFFH,
     &                  SISIH,SISOH,sifih,sifoh,ds0h,D0H,d0ih)
          ENDIF
*++
          IF(NSYS .EQ. 5 .OR. NSYS. EQ. 6) THEN
                                 DSR = D0R
                 IF(CTRL .EQ. 2) DSH = D0H
          ELSEIF(NSYS .EQ. 8) THEN
              IF(DPR .GT. 0.0) THEN
                                 DSR = (0.79 + DPR)/1.4 * D0R
                 IF(CTRL .EQ. 2) DSH = (0.79 + DPH)/1.4 * D0H
              ELSE
                                 DSR = 0.85 * D0R
                 IF(CTRL .EQ. 2) DSH = 0.85 * D0H
              ENDIF
          ENDIF
      ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
                                 D0R = 0.0
                                 DSR = 0.0
                 IF(CTRL .EQ. 2)  THEN
                                 D0H = 0.0
                                 DSH = 0.0
                 ENDIF
      ENDIF

*SEC 11.4.9.19 & 11.4.9.20

      F3 = 0.0
      F4 = 0.0
      F5 = 0.0
      F6 = 0.0
      F7 = 0.0
      F8 = 0.0
      F3R = 0.0
      F4R = 0.0
      F5R = 0.0
      F6R = 0.0
      F7R = 0.0
      F8R = 0.0
*++
      rofr = roffr
      if(ctrl .eq. 2) rofh = roffh
      if(ipurge .gt. 0) then
          rofr = (toff - tp)/taoffr
          if(ctrl .eq. 2) rofh = (toff - tp)/taoffh
      endif

      IF(NSYS .LE. 4) THEN
          N = 4
          CALL FUNT4(N,SIFOR,ROFR,REFTOA,REFTRM,F3R,F4R)
          IF(CTRL.EQ.2)CALL FUNT4(N,SIFOH,ROFH,REFTOA,REFTRM,F3,F4)
          N = 8
          IF(NSYS .EQ. 3) THEN
              CALL FUNT4(N,SIFOR,ROFR,REFTOA,REFTRM,F7R,F8R)
              IF(CTRL .EQ. 2)
     &        CALL FUNT4(N,SIFOH,ROFH,REFTOA,REFTRM,F7,F8)
          ELSE
              CALL FUNT4(N,SISOR,ROFR,REFTOA,REFTRM,F7R,F8R)
              IF(CTRL .EQ. 2)
     &        CALL FUNT4(N,SISOH,ROFH,REFTOA,REFTRM,F7,F8)
          ENDIF
      ELSEIF(NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
          N = 6
          CALL FUNT4(N,SISOR,ROFR,REFTOA,REFTRM,F5R,F6R)
          IF(CTRL .EQ. 2)
     &    CALL FUNT4(N,SISOH,ROFH,REFTOA,REFTRM,F5,F6)
          N = 8
          CALL FUNT4(N,SISOR,ROFR,REFTOA,REFTRM,F7R,F8R)
          IF(CTRL .EQ. 2)
     &    CALL FUNT4(N,SISOH,ROFH,REFTOA,REFTRM,F7,F8)
      ELSE
          N = 6
          CALL FUNT4(N,SIFOR,ROFR,REFTOA,REFTRM,F5R,F6R)
          IF(CTRL .EQ. 2)
     &    CALL FUNT4(N,SIFOH,ROFH,REFTOA,REFTRM,F5,F6)
      ENDIF

*     Iteration for each degin heating load requirement

      DO 30   J = NDHR,1,-1

*SEC 11.4.10 & 11.4.10.1

      IF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
          CSR = 1.0 + (REFTRM-TOAR(J))*EFYSSR/(100.*(TFSSR - TRAR))
          IF(CTRL .EQ. 2)
     &    CSH = 1.0 + (REFTRM-TOAH(J))*EFFYSS/(100.*(TFSSH - TRAH))
      ELSE
          CSR = 1.0
          CSH = 1.0
      ENDIF

      IF(CONDEN) THEN
         IF(NSYS .EQ. 3) THEN
              CSR = 1.0
              CSH = 1.0
         ELSEIF(NSYS .EQ. 9 .OR. NSYS .EQ. 10) THEN
              CSR = (TFSSR - TOAR(J))/(TFSSR-TRAR)
              IF(CTRL .EQ. 2) CSH = (TFSSH - TOAH(J))/(TFSSH - TRAH)
         ENDIF
      ENDIF

*SEC 11.4.10.2

      IF(NSYS .LE. 8) THEN
          THFOR = CTONR*THFOXR
          IF(CTRL .EQ. 2) THFOH = CTONH*THFOXH
      ELSE
          THFOR = CTONR*CSR*THFOXR
          IF(CTRL .EQ. 2) THFOH = CTONH*CSH*THFOXH
      ENDIF

*SEC 11.4.10.3

      IF(NSYS .LE. 4) THEN
              KSOFFR = (TFSSR + 460. + REFTRM - TRAR)**1.19*DFR*KSONR
     &                 /(TFSSR - TRAR)**0.56
          IF(CTRL .EQ. 2) THEN
              KSOFFH = (TFSSH + 460. + REFTRM - TRAH)**1.19*DFH*KSONH
     &                 /(TFSSH - TRAH)**0.56
          ENDIF
      ELSE IF( NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
              KSOFFR = (TSSSR + 460. + REFTRM - TRAR)**1.19
     &            *DSR*SFRR*KSONR/(TSSSR-TRAR + REFTRM - TOAR(J))**0.56
          IF(CTRL .EQ. 2) THEN
              KSOFFH = (TSSSH + 460. +REFTRM - TRAH)**1.19
     &            *DSH*SFRH*KSONH/(TSSSH-TRAH + REFTRM - TOAH(J))**0.56
          ENDIF
      ELSE
              KSOFFR = (TFSSR + 460. + REFTRM - TRAR)**1.19
     &               *DFR*KSONR/(TFSSR - TRAR + REFTRM - TOAR(J))**0.56
          IF(CTRL .EQ. 2) THEN
              KSOFFH = (TFSSH + 460. + REFTRM - TRAH)**1.19
     &               *DFH*KSONH/(TFSSH - TRAH + REFTRM - TOAH(J))**0.56
          ENDIF
      ENDIF

*SEC 11.4.10.4

      IF(NSYS .LE. 8 .and. dsr .gt. 0.) THEN
         IF(NSYS .EQ. 3) THEN
            KIOFFR = (TFSSR - TRAR + 530.)**1.19*DSR*KIONR
     &               /(TFSSR - TRAR + REFTRM - TOAR(J))**0.56
              IF(CTRL .EQ. 2) THEN
                 KIOFFH = (TFSSH - TRAH + 530.)**1.19*DSH*KIONH
     &                    /(TFSSH - TRAH + REFTRM - TOAH(J))**0.56
              ENDIF
         ELSEIF(nsys .ge. 5 .and. nsys .le. 8) then
            dsir = d0ir/d0r
            KIOFFR = (TSSSR - TRAR + 530.)**1.19*DSR*KIONR*dsir
     &               /(TSSSR - TRAR + REFTRM - TOAR(J))**0.56
            IF(CTRL .EQ. 2) THEN
               dsih = d0ih/d0h
               KIOFFH = (TSSSH - TRAH + 530.)**1.19*DSH*KIONH*dsih
     &                  /(TSSSH - TRAH + REFTRM - TOAH(J))**0.56
            ENDIF
         ELSE
              KIOFFR = (TSSSR - TRAR + 530.)**1.19*DSR*KIONR
     &                 /(TSSSR - TRAR + REFTRM - TOAR(J))**0.56
              IF(CTRL .EQ. 2) THEN
                 KIOFFH = (TSSSH - TRAH + 530.)**1.19*DSH*KIONH
     &                    /(TSSSH - TRAH + REFTRM - TOAH(J))**0.56
              ENDIF
         ENDIF
      ELSE
         KIOFFR = 0.0
         KIOFFH = 0.0
      ENDIF

*SEC 11.4.10.5  Sensible loss during on-cycle

      IF(NSYS .LE. 8) THEN
             LSONR = LSSSR - KSONR*THFOR*(1.0 - EXP(-RONR))/RONR
         IF(CTRL .EQ. 2) THEN
             LSONH = LSSSH - KSONH*THFOH*(1.0 - EXP(-RONH))/RONH
         ENDIF
      ELSE
             LSONR = CSR*LSSSR - KSONR*THFOR*(1.0 - EXP(-RONR))/RONR
         IF(CTRL .EQ. 2) THEN
             LSONH = CSH*LSSSH - KSONH*THFOH*(1.0 - EXP(-RONH))/RONH
         ENDIF
      ENDIF

*SEC 11.4.10.6  Sensible loss during off-cycle

*++   Sensible loss during post purge for power vented burner unit

      if(ipurge .gt. 0) then
         if(nsys .eq. 2 .or. nsys .eq. 3 .or. nsys .eq. 4) then
             ctsr = ctoffr
             if(ctrl .eq. 2) ctsh = ctoffh
         endif
         if(nsys .eq. 10) then
             ctsr = ctoffr*cs122
             if(ctrl .eq. 2) ctsh = ctoffh*cs122
         endif
         lsofr1 = 100.*cp*mfonr*tp*(tfssr+460)*
     &            (1-((trar+460)/(ctsr*(tfssr-tfofpr)))*
     &            ALOG((trar+460+ctsr*(tfssr-trar))/
     &                 (trar+460+ctsr*(tfofpr-trar))))
     &            /(ton*qinr/60.)
         
         if(ctrl .eq. 2) then
             lsofh1 = 100.*cp*mfonh*tp*(tfssh+460)*
     &                (1-((trah+460)/(ctsh*(tfssh-tfofph)))*
     &                ALOG((trah+460+ctsh*(tfssh-trah))/
     &                     (trah+460+ctsh*(tfofph-trah))))
     &                /(ton*qin/60.)
         endif
      else
          lsofr1 = 0.
          if(ctrl .eq. 2) lsofh1 = 0.
      endif

*++   Sensible loss during non-post-purge period of the off-cycle

      IF(NSYS .LE. 4) THEN

          if (ipurge .gt. 0) then
              LSOFR2 = KSOFFR*(TOFF-tp)/TON*(F3R + SIFIR*F4R)
              if(ctrl .eq. 2) then
                  LSOFH2 = KSOFFH*(TOFF-tp)/TON*(F3 + SIFIH*F4)
              endif
          else
              LSOFR2 = KSOFFR*TOFF/TON*(F3R + SIFIR*F4R)
              if(ctrl .eq. 2) then
                  LSOFH2 = KSOFFH*TOFF/TON*(F3 + SIFIH*F4)
              endif
          endif

      ELSEIF(NSYS .GE. 5 .AND. NSYS .LE. 8) THEN
              LSOFR2 = KSOFFR*TOFF/TON*(F5R + SISIR*F6R)
              if(ctrl .eq. 2) then
                  LSOFH2 = KSOFFH*TOFF/TON*(F5 + SISIH*F6)
              endif
      ELSE
          if (ipurge .gt. 0) then
              LSOFR2 = KSOFFR*(TOFF-tp)/TON*(F5R + SIFIR*F6R)
              if(ctrl .eq. 2) then
                  LSOFH2 = KSOFFH*(TOFF-tp)/TON*(F5 + SIFIH*F6)
              endif
          else
              LSOFR2 = KSOFFR*TOFF/TON*(F5R + SIFIR*F6R)
              if(ctrl .eq. 2) then
                  LSOFH2 = KSOFFH*TOFF/TON*(F5 + SIFIH*F6)
              endif
          endif
      ENDIF

*++   Total seneible loss during off-cycle:(powered + non-powered vent)

      lsoffr = lsofr1 + lsofr2
      if(ctrl .eq. 2) lsoffh = lsofh1 + lsofh2

*SEC 11.4.10.7  Infiltration loss during on-cycle

      IF(NSYS .LE. 8) THEN
              LIONR = KIONR*(REFTRM - TOAR(J))
          IF(CTRL .EQ. 2) THEN
              LIONH = KIONH*(REFTRM - TOAH(J))
          ENDIF
      ELSE
              LIONR = 0.0
              LIONH = 0.0
      ENDIF

*SEC 11.4.10.8  Infiltration loss during off-cycle
*
      IF(NSYS .LE. 8) THEN

*++     Infiltration loss during post purge for power vented burner

        if(ipurge .gt. 0) then
            liofr1 = 100.*(1./ctoffr)*cp*mfonr*(reftrm-toar(j))*
     &               tp*((tfssr+460)/(tfssr-tfofpr))*
     &               ALOG((trar+460+ctoffr*(tfssr-trar))/
     &                    (trar+460+ctoffr*(tfofpr-trar)))
     &               /(ton*qinr/60.)
            if(ctrl .eq. 2) then
                liofh1 = 100.*(1./ctoffh)*cp*mfonh*(reftrm-toah(j))*
     &                   tp*((tfssh+460)/(tfssh-tfofph))*
     &                   ALOG((trah+460+ctoffh*(tfssh-trah))/
     &                        (trah+460+ctoffh*(tfofph-trah)))
     &                   /(ton*qin/60.)
            endif
        else
          liofr1 = 0.
          if(ctrl .eq. 2) liofh1 = 0.
        endif

*++     Infiltration loss during non-post-purge period of off-cycle

        if(nsys .ne. 3) then
           if(ipurge .gt. 0) then
               LIOFR2 = KIOFFR*(REFTRM-TOAR(J))*(TOFF-tp)/
     &                  TON*(F7R+SISIR*F8R)
               if(ctrl .eq. 2) then
                   LIOFH2 = KIOFFH*(REFTRM-TOAH(J))*(TOFF-tp)/
     &                      TON*(F7+SISIH*F8)
               endif
           else
               LIOFR2 = KIOFFR*(REFTRM-TOAR(J))*TOFF/TON*(F7R+SISIR*F8R)
               if(ctrl .eq. 2) then
                 LIOFH2 = KIOFFH*(REFTRM-TOAH(J))*TOFF/TON*(F7+SISIH*F8)
               endif
           endif
        endif

        IF(NSYS.EQ.3) THEN
           if(ipurge .gt. 0) then
               LIOFR2 = KIOFFR*(REFTRM-TOAR(J))*(TOFF-tp)/
     &                  TON*(F7R+SIFIR*F8R)
               if(ctrl .eq. 2) then
                   LIOFH2 = KIOFFH*(REFTRM-TOAH(J))*(TOFF-tp)/
     &                      TON*(F7+SIFIH*F8)
               endif
           else
               LIOFR2 = KIOFFR*(REFTRM-TOAR(J))*TOFF/
     &                  TON*(F7R+SIFIR*F8R)
               if(ctrl .eq. 2) then
                   LIOFH2 = KIOFFH*(REFTRM-TOAH(J))*TOFF/
     &                      TON*(F7+SIFIH*F8)
               endif
           endif
        ENDIF

*++   Total infilt. loss during off-cycle:(powered + non-powered vent)

          lioffr = liofr1 + liofr2
          if(ctrl .eq. 2) lioffh = liofh1 + liofh2
      ELSE
          LIOFFR = 0.0
          LIOFFH = 0.0
      ENDIF

*SEC 11.4.11.1 Part-load efficiency at the reduced fuel input rate

      PFR = QP/QINR
      IF(.NOT. CONDEN) THEN
        EFFYUR(J)=100.0 - LLA - CJ*LJ - TON*(LSONR+LSOFFR+LIONR+LIOFFR)
     &            /(TON + PFR*TOFF)

*SEC 11.5.11.1  (condensing units)

      ELSE
         LGR = 100.0*1053.3*MCR/QCR
         LCR = LGR*((TFSSR-REFTRM) - 0.45*(TFSSR - TOAR(J)))/1053.3

         EFFYUR(J) = 100.0-LLA+LGR - LCR - CJ*LJ - TON*(LSONR+LSOFFR+
     &               LIONR+LIOFFR)/(TON + PFR*TOFF)
      ENDIF

*SEC 11.4.11.2  Part-load efficiency at the maximum fuel input rate

      PF = QP/QIN
      IF(CTRL .EQ. 2) THEN
          IF(.NOT. CONDEN) THEN
              EFFYUH(J) = 100.0 - LLA - CJ*LJ - TON
     &                  *(LSONH+LSOFFH+LIONH+LIOFFH)/(TON + PF*TOFF)

*SEC 11.5.11.2  (condensing units)
          ELSE
              LGH = 100.0*1053.3*MCH/QCH
              LCH = LGH*((TFSSH-REFTRM) - 0.45*(TFSSH - TOAH(J)))/1053.3
              EFFYUH(J) = 100.0 - LLA + LGH - LCH - CJ*LJ - TON
     &                  *(LSONH+LSOFFH+LIONH+LIOFFH)/(TON + PF*TOFF)
          ENDIF
      ENDIF

*SEC 11.4.11.3  Heating seasonal efficiency

      IF(CTRL .EQ. 2) THEN
          EFYHS(J)=XH(J)*EFFYUH(J)+XR(J)*EFFYUR(J)
      ELSEIF(CTRL .EQ. 3) THEN
          EFYHS(J)=XH(J)*EFFYUM(J)+XR(J)*EFFYUR(J)
      ENDIF

*SEC 11.4.12  Annual fuel utilization efficiency

      AFUEF(J) = 5200.0*EFYSSW(J)*EFYHS(J)
     &   /(5200.0*EFYSSW(J) + 2.5*(1+ALPHA(J))*4600.0*EFYHS(J)*PF)
      IF(J .EQ. NDHR) THEN
        WRITE(OUT,*) ' Calculated Values:'
        WRITE(OUT,*)
        WRITE(OUT,1700) REFTRM,REFTOA,PHI,CP,CS122
        WRITE(OUT,1800) A,B,CJ,K,HHVA,LLA
        if(ctrl .eq. 3) dfh = dfr
        WRITE(OUT,1950) AFR,CIID,DFR,DFH,TON,TOFF
        WRITE(OUT,2100) T1,T2,T3,T4
        write(out,*)
        WRITE(OUT,*) 'Values at Maximum Input Rate:'
        WRITE(OUT,*)
        if(ctrl .eq. 3) then
            write(out,2250) rtsh,rtfh,sfrh,lsssh,effyss,qout
            if(conden) then
                write(out,2760) lgssh,lcssh
            endif
        endif
        IF(CTRL .EQ. 2) THEN
            WRITE(OUT,3000) TOAH
            WRITE(OUT,*)
            WRITE(OUT,3050) NDHR
            WRITE(OUT,*)
            WRITE(OUT,2200) RTSH,RTFH,SFRH,LSSSH,EFFYSS
            WRITE(OUT,2900) QOUT,KSONH,KSOFFH,KIONH,KIOFFH
            WRITE(OUT,2400) TSSSH,TAONH,TAOFFH,RONH,ROFFH,CSH
            WRITE(OUT,2500) SISOH,SISIH,SISOXH,SISIXH,SIFOH,SIFIH,
     &                      SIFOXH,SIFIXH
            WRITE(OUT,2600) D0H,DSH,CTONH,CTOFFH,THFOH,THFOXH
            WRITE(OUT,2700) F3,F4,F5,F6,F7,F8
            if(conden) then
                write(out,2770) lgssh,lcssh,lgh,lch
            endif
            if(ipurge .gt. 0) then
                write(out,2752) lsofh1,lsofh2,liofh1,liofh2
            endif
            WRITE(OUT,3110) LSONH,LSOFFH,LIONH,LIOFFH,EFFYUH(J)
        ENDIF
        WRITE(OUT,*)
        WRITE(OUT,*) 'Values at Reduced Input Rate:'
        WRITE(OUT,*)
        WRITE(OUT,3000) TOAR
        WRITE(OUT,*)
        WRITE(OUT,3050)  NDHR
        WRITE(OUT,*)
        WRITE(OUT,2200) RTSR,RTFR,SFRR,LSSSR,EFYSSR
        WRITE(OUT,2900) QOUTR,KSONR,KSOFFR,KIONR,KIOFFR
        WRITE(OUT,2400) TSSSR,TAONR,TAOFFR,RONR,ROFFR,CSR
        WRITE(OUT,2500) SISOR,SISIR,SISOXR,SISIXR,SIFOR,SIFIR,SIFOXR,
     &                  SIFIXR
        WRITE(OUT,2600) D0R,DSR,CTONR,CTOFFR,THFOR,THFOXR
        WRITE(OUT,2700) F3R,F4R,F5R,F6R,F7R,F8R
        if(conden) then
            write(out,2780) lgssr,lcssr,lgr,lcr
        endif
        if(ipurge .gt. 0) then
            write(out,2754) lsofr1,lsofr2,liofr1,liofr2
        endif
        IF(CTRL .EQ. 2) THEN
            WRITE(OUT,3110) LSONR,LSOFFR,LIONR,LIOFFR,EFFYUR(J)
        ELSE
            WRITE(OUT,3100) LSONR,LSOFFR,LIONR,LIOFFR,
     &                                       LIONM(J),EFFYUR(J)
        ENDIF
        WRITE(OUT,*)
      ENDIF

30    CONTINUE
      ENDIF

* ----------------------------------------------------------------------

      IF(CTRL .EQ. 1) THEN
          WRITE(OUT,*) ' Calculated Values:'
          WRITE(OUT,*)
          WRITE(OUT,1700) REFTRM,REFTOA,PHI,CP,CS122
          WRITE(OUT,1800) A,B,CJ,K,HHVA,LLA
          WRITE(OUT,1900) AFR,CIID,DF,TON,TOFF
          WRITE(OUT,2000) T1,T2,T3,T4,ALPHAX
          WRITE(OUT,2200) RTS,RTF,SFR,LSSS,EFFYSS
          WRITE(OUT,2300) QOUT,KSON,KSOFF,KION,KIOFF
          WRITE(OUT,2400) TSSS,TAON,TAOFF,RON,ROFF,CS
          WRITE(OUT,2500) SISO,SISI,SISOX,SISIX,SIFO,SIFI,SIFOX,
     &                    SIFIX
          WRITE(OUT,2600) D0,DS,CTON,CTOFF,THFO,THFOX
          WRITE(OUT,2700) F3,F4,F5,F6,F7,F8
          if(conden) then
              write(out,2790) lgss,lcss,lg,lc
          endif 
          if(ipurge .gt. 0) write(out,2750) lsoff1,lsoff2,lioff1,lioff2
          WRITE(OUT,2800) LSON,LSOFF,LION,LIOFF,EFFYHS,AFUE
      ENDIF

      IF(CTRL .GE. 2) THEN
          WRITE(OUT,2150) ALPHA,(KDHR(II),II=1,MAXDHR)
          IF(CTRL .EQ. 3) WRITE(OUT,3300) EFYSSM
          WRITE(OUT,3500)                 EFYSSW
          IF(CTRL .EQ. 3) WRITE(OUT,3400) EFFYUM
          WRITE(OUT,3700)                 EFFYUR
          IF(CTRL .EQ. 2) WRITE(OUT,3800) EFFYUH
          WRITE(OUT,3200)                 EFYHS
          WRITE(OUT,3600)                 AFUEF
          WRITE(OUT,*)
      ENDIF

      PRINT 1300

40    CONTINUE
999   CONTINUE
      PRINT 4000, IFILE
      PRINT 4100, OFILE 
      PRINT *
      STOP ' --------- End of execution of AFUEBF -----------  '

* ---------------------------------------------------------------------
*     F O R M A T   S T A T E M E N T S

1000  FORMAT(A80)
1100  FORMAT(/(1X,A80))
1200  FORMAT(1x,1A1)
1300  FORMAT(1X,79('*')/)
1400  FORMAT('    TYPE =',I2,'   INST =',I2,'   NSYS =',I2,
     &            '   FUEL =',I2,'   CTRL =',I2,'   OPTEST =',I2,
     &            '   IPURGE =',I2/) 
1410  FORMAT(T8,'QP',T20,'PE',T32,'BE',T44,'LJ',T56,'DP',T68,'TP'
     &      /F12.0,3F12.3,2F12.5/)
1420  FORMAT(T8,'QIN',T20,'XCO2S',T32,'XCO2F',T44,'TSSSX',T56,'TFSS',
     &       T68,'TRA'/F12.0,2F12.2,3F12.1/)
1430  FORMAT(T8,'QIN',T20,'XCO2SH',T32,'XCO2FH',T44,'TSSSXH',T56,
     &       'TFSSH',T68,'TRAH'/F12.0,2F12.2,3F12.1/)
1440  FORMAT(T8,'QINR',T20,'XCO2SR',T32,'XCO2FR',T44,'TSSSXR',T56,
     &       'TFSSR',T68,'TRAR'/F12.0,2F12.2,3F12.1/)
1450  FORMAT(T8,'TFON1',T20,'TFON2',T32,'TFOF3',T44,'TFOF4',T56,
     &       'TFOF5'/5F12.1/)
1460  FORMAT(T8,'TFONH1',T20,'TFONH2',T32,'TFOFH3',T44,'TFOFH4',T56,
     &       'TFOFH5'/5F12.1/)
1470  FORMAT(T8,'TFONR1',T20,'TFONR2',T32,'TFOFR3',T44,'TFOFR4',T56,
     &       'TFOFR5'/5F12.1/)
1475  FORMAT(T8,'TFSS',T20,'TFOFP'/2F12.1/)
1476  FORMAT(T8,'TFSSh',T20,'TFOFPh'/2F12.1/)
1477  FORMAT(T8,'TFSSr',T20,'TFOFPr'/2F12.1/)
1480  FORMAT(T8,'AS',T20,'AD',T32,'AOD',T44,'AOL',T56,'OMEGA'/
     &       4F12.4,F12.1//T8,'TS',T20,'TD'/2F12.2/)
1490  FORMAT(T8,'MCSS',T20,'QCSS',T32,'MC',T44,'QC'/2(F12.3,F12.0)/)
1500  FORMAT(T8,'MCSSR',T20,'QCSSR',T32,'MCR',T44,'QCR'/
     &       2(F12.3,F12.0)/)
1505  FORMAT(T8,'MCSSH',T20,'QCSSH',T32,'MCH',T44,'QCH'/
     &       2(F12.3,F12.0)/)
1506  FORMAT(T8,'MCSSH',T20,'QCSSH'/F12.3,F12.0/)
1510  FORMAT(T8,'CTM',T20,'CT',T32,'VT',T44,'PB',T56,'TT',T68,'TFOFF'/
     &       2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1520  FORMAT(T8,'CTMH',T20,'CTH',T32,'VTH',T44,'PB',T56,'TT',T68,
     &       'TFOFFH'/2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1530  FORMAT(T8,'CTMR',T20,'CTR',T32,'VTR',T44,'PB',T56,'TT',T68,
     &       'TFOFFR'/2F12.4,F12.5,F12.2,2F12.1//T8,'IFRATE'/I12/)
1600  FORMAT(5X,A15,3X,A50)
1700  FORMAT(T8,'REFTRM',T20,'REFTOA',T32,'PHI',T44,'CP',T56,'CS',1H'/
     &       2F12.1,3F12.2/)
1800  FORMAT(T8,'A',T20,'B',T32,'CJ',T44,'K',T56,'HHVA',T68,'LLA'/
     &       2F12.3,2F12.2,F12.0,F12.2/)
1900  FORMAT(T8,'A/F',T20,'CIID',T32,'DF',T44,'TON',T56,'TOFF'/
     &       2F12.2,F12.3,2F12.2/)
1950  FORMAT(T8,'A/F',T20,'CIID',T32,'DFR',T44,'DFH',T56,'TON',T68,
     &       'TOFF'/2F12.2,2F12.3,2F12.2/)
2000  FORMAT(T8,'T1',T20,'T2',T32,'T3',T44,'T4',T56,'ALPHA'/
     &       5F12.2/)
2100  FORMAT(T8,'T1',T20,'T2',T32,'T3',T44,'T4'/4F12.2/)
2150  FORMAT(T8,'ALPHA(1)',T20,'ALPHA(2)',T32,'ALPHA(3)',T44,'ALPHA(4)',
     &       T56,'ALPHA(5)'/5F12.3//
     &       T8,'KDHR(1)',T20,'KDHR(2)',T32,'KDHR(3)',T44,'KDHR(4)',
     &       T56,'KDHR(5)'/5I12/)
2200  FORMAT(T8,'RTS',T20,'RTF',T32,'S/F',T44,'LSSS',T56,'EFFYSS'/
     &       2F12.3,3F12.2/)
2250  FORMAT(T8,'RTS',T20,'RTF',T32,'S/F',T44,'LSSS',T56,'EFFYSS',
     &       T68,'QOUT'/2F12.3,3F12.2,F12.0/)
2300  FORMAT(T8,'QOUT',T20,'KSON',T32,'KSOFF',T44,'KION',T56,'KIOFF'/
     &       F12.0,1P4E12.3/)
2400  FORMAT(T8,'TSSS',T20,'TAON',T32,'TAOFF',T44,'RON',T56,'ROFF',
     &       T68,'CS'/F12.1,5F12.3/)
2500  FORMAT(T8,'SISO',T20,'SISI',T32,'SISOX',T44,'SISIX',T56,'SIFO',
     &       T68,'SIFI'/1P6E12.3//T8,'SIFOX',T20,'SIFIX'/1P2E12.3/)
2600  FORMAT(T8,'D0',T20,'DS',T32,'CTON',T44,'CTOFF',T56,'THFO',
     &       T68,'THFOX'/4F12.3,2F12.1/)
2700  FORMAT(T8,'F3',T20,'F4',T32,'F5',T44,'F6',T56,'F7 ',T68,'F8'/
     &       1P6E12.3/)
2750  format(T8,'LSOFF1',T20,'LSOFF2',T32,'LIOFF1',T44,'LIOFF2',
     &       /4F12.3/)
2752  format(T8,'LSOFFH1',T20,'LSOFFH2',T32,'LIOFFH1',T44,'LIOFFH2',
     &       /4F12.3/)
2754  format(T8,'LSOFFR1',T20,'LSOFFR2',T32,'LIOFFR1',T44,'LIOFFR2',
     &       /4F12.3/)
2760  format(T8,'LGSSH',T20,'LCSSH'/2F12.3/)
2770  format(T8,'LGSSH',T20,'LCSSH',T32,'LGH',T44,'LCH'/4F12.3/)
2780  format(T8,'LGSSR',T20,'LCSSR',T32,'LGR',T44,'LCR'/4F12.3/)
2790  format(T8,'LGSS',T20,'LCSS',T32,'LG',T44,'LC'/4F12.3/)
2800  FORMAT(T8,'LSON',T20,'LSOFF',T32,'LION',T44,'LIOFF',T56,'EFFYHS',
     &       T68,'AFUE'/4F12.3,2F12.4/)
2900  FORMAT(T8,'QOUT',T20,'KSON',T32,'KSOFF',T44,'KION',T56,'KIOFF'/
     &       F12.0,1P4E12.3/)
3000  FORMAT(T8,'TOA(1)',T20,'TOA(2)',T32,'TOA(3)',T44,'TOA(4)',
     &       T56,'TOA(5)'/5F12.1/)
3050  FORMAT(' ---  With TOA(',I1,') ---')
3100  FORMAT(T8,'LSON',T20,'LSOFF',T32,'LION',T44,'LIOFF',T56,'LIONM',
     &       T68,'EFFYU'/5F12.3,F12.4/)
3110  FORMAT(T8,'LSON',T20,'LSOFF',T32,'LION',T44,'LIOFF',T56,'EFFYU',
     &       /4F12.3,F12.4/)
3200  FORMAT(' Heating Seasonal Efficiency'//
     &       T8,'EFFYHS(1)',T20,'EFFYHS(2)',T32,'EFFYHS(3)',T44,
     &       'EFFYHS(4)',T56,'EFFYHS(5)'/5F12.4/)
3300  FORMAT(' Average Steady-State Efficiency for Modulating Mode'//
     &       T8,'EFFYSSM(1)',T20,'EFFYSSM(2)',T32,'EFFYSSM(3)',T44,
     &       'EFFYSSM(4)',T56,'EFFYSSM(5)'//5F12.4/)
3400  FORMAT(' Average Part-Load Efficiency for Modulating Mode '//
     &       T8,'EFFYUM(1)',T20,'EFFYUM(2)',T32,'EFFYUM(3)',T44,
     &       'EFFYUM(4)',T56,'EFFYUM(5)'/5F12.4/)
3500  FORMAT(' Weighted Average Steady-State Efficiency'//
     &       T8,'EFFYSSW(1)',T20,'EFFYSSW(2)',T32,'EFFYSSW(3)',T44,
     &       'EFFYSSW(4)',T56,'EFFYSSW(5)'/5F12.4/)
3600  FORMAT(' Annual Fuel Utilization Efficiency'//
     &       T8,'AFUE(1)',T20,'AFUE(2)',T32,'AFUE(3)',T44,'AFUE(4)',
     &       T56,'AFUE(5)'/5F12.4/)
3700  FORMAT(' Part-Load Efficiency at Reduced Input Rate'//
     &       T8,'EFFYUR(1)',T20,'EFFYUR(2)',T32,'EFFYUR(3)',T44,
     &       'EFFYUR(4)',T56,'EFFYUR(5)'/5F12.4/)
3800  FORMAT(' Part-Load Efficiency at Maximum Input Rate'//
     &       T8,'EFFYUH(1)',T20,'EFFYUH(2)',T32,'EFFYUH(3)',T44,
     &       'EFFYUH(4)',T56,'EFFYUH(5)'/5F12.4/)
4000  FORMAT(/' ====== The input data file  :    ', A36)
4100  FORMAT(/' ====== The output data file :    ', A36)
! 4000  FORMAT(/' ====== The input data file  :    ', A12)
! 4100  FORMAT(/' ====== The output data file :    ', A12)
  
* ---------------------------------------------------------------------
      END

************************************************************************
      SUBROUTINE SENLOS(FUEL,HHVA,AFR,XCO2S,TSSSX,RTS,
     &           TFSS,RTF,TRA,LSSS)
* ---------------------------------------------------------------------
*
*     Sensible heat loss at steady-state operation
*
************************************************************************

      INTEGER FUEL
      REAL    LSSS

      PARAMETER (NFUEL=6)

      DIMENSION CA(5),CF(NFUEL,5)

      DATA (CA(J),J=1,5)/2.5462121E-1,-3.0260126E-5,2.7608571E-8,
     &                  -7.4253321E-12,6.4307377E-16/
      DATA (CF(1,K),K=1,5)/2.4416834E-01,3.3711449E-6,8.8906305E-9,
     &                    -1.3619019E-12,-1.4367410E-16/
      DATA (CF(2,K),K=1,5)/2.4361163E-1,3.6702686E-6,8.7098897E-9,
     &                    -1.3094378E-12,-1.5029209E-16/
      DATA (CF(3,K),K=1,5)/2.5949478E-01,-4.9475802E-06,1.3885838E-8,
     &                    -2.8059994E-12,3.7682444E-17/
      DATA (CF(4,K),K=1,5)/2.6598442E-1,-7.7561435E-6,1.5833852E-8,
     &                    -3.4194210E-12,1.2158977E-16/
      DATA (CF(5,K),K=1,5)/2.5163639E-1,-6.4144604E-7,1.1315073E-8,
     &                    -2.0656792E-12,-5.4897330E-17/
      DATA (CF(6,K),K=1,5)/2.5011247E-1,1.7737005E-7,1.0820337E-8,
     &                    -1.9220641E-12,-7.3013274E-17/

      IF(XCO2S .GT. 0.0 .AND. TSSSX .GT. 0.0) THEN
          TSS = TSSSX
          RT = RTS
      ELSE
          TSS = TFSS
          RT = RTF
      ENDIF
      QF = 0.0
      QA = 0.0
      DO 10 J = 1,5
          QF = QF + CF(FUEL,J)*((TSS + 460.0)**J - (TRA + 460.0)**J)
          QA = QA + CA(J)*((TSS + 460.0)**J - (TRA + 460.0)**J)
10    CONTINUE
      LSSS = QF*(1.0 + AFR) + QA*AFR*(RT - 1.0)
      LSSS = LSSS*100.0/HHVA
      RETURN
      END

************************************************************************
      SUBROUTINE FUNT4(N,SI,ROFF,REFTOA,REFTRM,FI,FJ)
* ---------------------------------------------------------------------
*
*     Off-cycle sensible heat loss integration factors
*
************************************************************************
*
      DATA    NPOINT/100/
      T1=REFTRM-REFTOA
      C1=1.
      T2=REFTRM+460.
      IF(N.EQ.4) T1=0.
      IF(N.EQ.8) C1=0.0
      X=0.
      FI =0.
      FJ =0.
      DX =ROFF /NPOINT
      FF11=(SI+T1)**0.56*SI**C1/(SI+T2)**1.19
      FF21=(SI+T1+100.)**0.56*(SI+100.)**C1/(SI+T2+100.)**1.19
      MP=NPOINT/2
      DO 10 I=1,MP
        X=X+DX
        XX=SI *EXP(-X)
        FF12=(XX+T1)**0.56*XX**C1/(XX+T2)**1.19
        FF22=(XX+T1+100.)**0.56*(XX+100.)**C1/(XX+T2+100.)**1.19
        X=X+DX
        XX=SI *EXP(-X)
        FF13=(XX+T1)**0.56*(XX)**C1/(XX+T2)**1.19
        FF23=(XX+T1+100.)**0.56*(XX+100.)**C1/(XX+T2+100.)**1.19
        FI =FI +(FF11+4.*FF12+FF13)
        FJ =FJ +(FF21+4.*FF22+FF23)
        FF11=FF13
        FF21=FF23
10    CONTINUE
      IF(ABS(FJ-FI).LE.0.0000001) THEN
        FJ =0.
      ELSE
        FJ =DX *(FJ -FI )/(100.*ROFF ) /3.
      ENDIF
      FI =FI *DX /(3.*ROF F )
      RETURN
      END

************************************************************************
      SUBROUTINE DHRC(QOUT,NDHR,KDHR)
* ----------------------------------------------------------------------
*
*     Design heating requirement
*
*************************************************************************

      PARAMETER (MAXDHR=5, NCAP=14, NCAPP=NCAP+1)

      DIMENSION KDH(NCAP,0:MAXDHR),NNDL(NCAP),ICAP(NCAPP),KDHR(MAXDHR)
      DATA (KDH(1,I),I=0,MAXDHR)  /  5,  5,  0,  0,  0,  0/
      DATA (KDH(2,I),I=0,MAXDHR)  / 10,  5, 10,  0,  0,  0/
      DATA (KDH(3,I),I=0,MAXDHR)  / 15, 10, 15,  0,  0,  0/
      DATA (KDH(4,I),I=0,MAXDHR)  / 20, 15, 20, 25,  0,  0/
      DATA (KDH(5,I),I=0,MAXDHR)  / 30, 25, 30, 35, 40,  0/
      DATA (KDH(6,I),I=0,MAXDHR)  / 40, 35, 40, 45, 50,  0/
      DATA (KDH(7,I),I=0,MAXDHR)  / 50, 40, 45, 50, 60,  0/
      DATA (KDH(8,I),I=0,MAXDHR)  / 60, 50, 60, 70, 80,  0/
      DATA (KDH(9,I),I=0,MAXDHR)  / 70, 60, 70, 80, 90,  0/
      DATA (KDH(10,I),I=0,MAXDHR) / 80, 70, 80, 90,100,  0/
      DATA (KDH(11,I),I=0,MAXDHR) / 90, 80, 90,100,110,120/
      DATA (KDH(12,I),I=0,MAXDHR) /100, 90,100,110,120,130/
      DATA (KDH(13,I),I=0,MAXDHR) /110,100,110,120,130,140/
      DATA (KDH(14,I),I=0,MAXDHR) /130,120,130,140,150,160/
      DATA NNDL/1,2*2,3,6*4,4*5/
      DATA ICAP/  5,  11,  17,  26,  43,  60,  77,  94,
     &          111, 128, 145, 162, 179, 196, 1000000/

      IQOUT=(QOUT+500.0)/1000.0
      DO 10 J=1,NCAP
        IF(IQOUT.GE.ICAP(J).AND.IQOUT.LT.ICAP(J+1)) GO TO 20
10    CONTINUE
20    NDHR=NNDL(J)
      DO 30 K=1,MAXDHR
        KDHR(K)=KDH(J,K)
30    CONTINUE
      RETURN
      END

************************************************************************
      SUBROUTINE TOAC(QOUTH,QOUTL,NDHR,KDHR,ALPHA,TC,RH,TOAH,TOAR)
* ----------------------------------------------------------------------
*
*     Over size factors, balance point tempeatures, fraction of heating
*     loads, average outdoor temperatures at maximum and reduced
*     operating modes
*
*************************************************************************

      PARAMETER (MAXDHR=5)

      DIMENSION KDHR(MAXDHR),ALPHA(MAXDHR),TC(MAXDHR),RH(MAXDHR),
     &          TOAH(MAXDHR),TOAR(MAXDHR)

      RATIO=QOUTL/QOUTH
      DO 10 J=1,NDHR
        DHR=KDHR(J)*1000
        ALPHA(J)=(QOUTH/DHR)-1
        TCC=65.-(60.*(1.+ALPHA(J))*RATIO)
        IF ( TCC .LT. 0.0 ) TCC = 0.0
        X1=.978726-.0317328*TCC+2.59242E-04*TCC**2
        X2=1.0-.0311531*TCC+3.33643E-04*TCC**2
        TC(J)=TCC
        RH(J)=X1/X2
        TOAH(J)=-1.93971+1.01679*TC(J)-0.00506148*TC(J)**2
        TOAR(J)=41.0734-0.0721832*TC(J)+0.0067813*TC(J)**2
10    CONTINUE
      RETURN
      END

************************************************************************
      SUBROUTINE DZERO(SFR,DF,AS,AD,AOD,AOL,OMEGA,TS,TD,TOFF,TAOFF,
     &                 SISI,SISO,sifi,sifo,ds0,D0,d0i)
* ---------------------------------------------------------------------
*
*     Stack damper effectiveness factor
*
************************************************************************

      N = 100
      HJ = 1.0/N
      PI = 4.0*ATAN(1.0)
      TE = TS + TD
      RAD = OMEGA*PI/180.0
      C = COS(RAD)

C      DE = (1.0 - AD*C/AS)*
C           SQRT(5.0/(5.0*(1.0 - AD*C/AS)**2 + 2.6*(AD*C/AS)**1.58))

*  The following uses damper net opening area (when closed) for DE:
      AO = AOL + AOD*C
      DE = (AO/AS)*SQRT(5.0/(5.0*(AO/AS)**2 + 2.6*(1 - AO/AS)**1.58))
*
      SUMT = 0.0
      SUMB = 0.0
*++
      sumti=0.0
      sumbi=0.0
*++
      DO 10 J = 1,N
        T = J*HJ*TOFF
        IF(T .GE. 0.0 .AND. T .LT. TS) THEN
         DSJ = 1.0
        ELSE IF(T .GE. TS .AND. T .Lt. TE) THEN
         TTILDA = (T - TS)/(TE - TS)

         DSJ=(1.0-(AD/AS)*SIN((PI/2.0-RAD)*TTILDA))*
     &        SQRT(5.0 / (5.0*(1.0-(AD/AS)*SIN((PI/2.0-RAD)*TTILDA))**2
     &         + 2.6*((AD/AS)*SIN((PI/2.0-RAD)*TTILDA))**1.58))
        ELSE
         DSJ = DE
        ENDIF
*++
        if(dsj*sfr*ds0 .gt. df) then
            sisij=df*sifi/(sfr*dsj*ds0)
            sisoj=df*sifo/(sfr*dsj*ds0)
        else
            sisij=sifi
            sisoj=sifo
        endif
*++
        G1 = SISO*EXP(-T/TAOFF)
        G2 = (G1 + 28.0)**0.56/(G1 + 530.0)**1.19
        G3 = G1 + 100.0
        G4 = (G1 + 128.0)**0.56/(G1 + 630.0)**1.19
*++
        G1j = SISOj*EXP(-T/TAOFF)
        G2j = (G1j + 28.0)**0.56/(G1j + 530.0)**1.19
        G3j = G1j + 100.0
        G4j = (G1j + 128.0)**0.56/(G1j + 630.0)**1.19
*++
        SUMT = SUMT + DSJ*((100.0 - SISIj)*G1j*G2j + SISIj*G3j*G4j)*HJ
*
        SUMB = SUMB + ((100.0 - SISI)*G1*G2 + SISI*G3*G4)*HJ
*++
        SUMTi = SUMTi + DSJ*((100.0 - SISIj)*G2j + SISIj*G4j)*HJ
*++
        SUMBi = SUMBi + ((100.0 - SISI)*G2 + SISI*G4)*HJ
*++
10    CONTINUE
      D0 = SUMT/SUMB
*++
      d0i = sumti/sumbi
*++
      RETURN
      END

************************************************************************
      SUBROUTINE FILEIO ( inp, out, ifile, ofile )
* ---------------------------------------------------------------------
*
*     Input and output file handling
*
************************************************************************
*
      integer   ios, inp, out

      character*1  answer 
      character*36 ifile, ofile
!      character*12 ifile, ofile

      print *, ' The default name of input data file is AFUE.IN. '
      print *, ' The default name of output data file is AFUE.OUT. ' 
      print *
      print *, ' Do you want to use these default file names? '
      print *, ' To answer "yes", type "Y" or "y", or hit the [ENTER]'
      print *, ' key.'  
      print *, ' To answer "no", you must type "N" or "n" '
      print *, '                                   (Yes) = '

      read 2000, answer
      if (answer .eq. 'n' .or. answer .eq. 'N' ) then

10         print *, ' Enter the name of input data file = '
          read 1000, ifile
          open(unit = inp, file = ifile, status = 'old', iostat = ios)
          if ( ios .ne. 0 ) then
             print *, ' The named file does not exist. '
             close (unit = inp)
             goto 10
          endif

20         print *, ' Enter the name of output data file = '
          read 1000, ofile
          open(unit = out, file = ofile, status = 'new', iostat = ios)
          if ( ios .ne. 0 ) then
             print *, ' The named file already exist. '
             print *, ' Do you want to override the named file ?'
             print *, '                                   (Yes) = '
             read 2000, answer
             if ( answer .eq. 'n' .or. answer .eq. 'N' ) then
                close (unit = out)
                goto 20
             else
                close (unit = out)
                open(unit=out, file = ofile, status='old',
     &               iostat = ios)
             endif
          endif 
          
      else
          
          ifile = 'AFUE.IN'    
          open(unit=inp, file = ifile, status='old', iostat = ios)
          if ( ios .ne. 0 ) then
             print *, ' The input data file AFUE.IN  does not exist. '
             close (unit = inp)
30            print *, ' Enter the name of input data file = '
             read 1000, ifile
             open(unit = inp, file = ifile, status = 'old',
     &            iostat = ios)
             if ( ios .ne. 0 ) then
                print *, ' The named file does not exist. '
                close (unit = inp)
                goto 30
             endif
          endif

          ofile = 'AFUE.OUT'
          open(unit=out, file = ofile, status='new', iostat = ios)
          if ( ios .ne. 0 ) then
             print *, ' The output data file  AFUE.OUT already exists. '
             print *, ' Do you want to override AFUE.OUT ?  (Yes) = '
             read 2000, answer
             if ( answer .eq. 'n' .or. answer .eq. 'N' ) then
                close (unit = out)
40               print *, ' Enter the name of output data file = '
                read 1000, ofile
                open(unit = out, file = ofile, status = 'new',
     &               iostat = ios)
                if ( ios .ne. 0 ) then
                   print *, ' The named file already exist. '
                   print *, ' Do you want to override the named file ?'
                   print *, '                               (Yes) = '
                   read 2000, answer
                   if ( answer .eq. 'n' .or. answer .eq. 'N' ) then
                      close (unit = out)
                      goto 40
                   else
                      close (unit = out)
                      open(unit=out, file = ofile, status='old',
     &                     iostat = ios)
                   endif
                endif
             else
                close(unit = out) 
                open(unit=out, file = 'AFUE.OUT',status='old',
     &               iostat = ios)
             endif
             
          endif 
      endif

1000  format(a36)
!  1000  format(a12)
2000  format(a1)

      return
      end
