      PROGRAM NISTIM
C
C     THIS PROGRAM COMPARES THE LOCAL TIME WITH
C     THE TIME RECEIVED BY CALLING THE NIST ACTS
C     SERVICE.
C
C     RSX11M VERSION 2    9 NOVEMBER 1988
C
C      CONVERSION TO LOCAL TIME ZONE ADDED FOR VERSION
C      2 USING FORTRAN VERSION OF IBM-PC CODE ORIGINALLY
C      WRITTEN IN C
C
      PARAMETER IOATT="1400,ISFSMC="2440
      INTEGER*2 IPRL(6),ISB(2)
      BYTE IBB(14),TELNO(40),PARAM(10)
      BYTE IANS
C
C     FOLLOWING CONSTANTS CONTROL WHAT HAPPENS
C     EACH OPERATION IS ENABLED IF CONSTANT IS 1, DISABLED IF 0
C     NOTE THAT ANY COMBINATION OF OPERATIONS MAY BE SPECIFIED
C
C
C     ILIST     LIST LINES RECEIVED FROM NIST
C     ICHK      COMPARE NIST TIME WITH SYSTEM TIME AND TYPE DIFFERENCE
C     IARC      COMPARE NIST TIME WITH SYSTEM TIME AND WRITE DIFFERENCE
C               TO FILE NISTIME.DIF  IN APPEND MODE
C     ISET      SET SYSTEM TIME TO NIST TIME
C     IDEBUG    TURN ON DIAGNOSTIC MESSAGES FOR DEBUGGING
C     IRATE     COMPARE CURRENT DIFFERENCE WITH PREVIOUS VALUE TO GET RATE
C
      COMMON/OPS/ILIST,ICHK,IARC,ISET,IDEBUG,IRATE
      COMMON/LOCAL/IUTDIF,IDST
C
C    FORCE IBB ARRAY TO BE WORD-ALIGNED
C    USED FOR SETTING PORT CHARACTERISTICS
C
      EQUIVALENCE(IBB(1),IDUMMY)
C
      DATA IBB/ '7'O,1,'50'O,1,'71'O,0,'72'O,0,'64'O,1,3,11,4,11/
C
C     START OUT WITH ALL OPERATIONS DISABLED
C
      ILIST=0
      ICHK=0
      IARC=0
      ISET=0
      IDEBUG=0
      IRATE=0
C
C    OPEN CONFIGURATION FILE AND READ PARAMETERS
C
C    FIRST LINE OF CONFIGURATION FILE HAS FULL TELEPHONE NUMBER
C    INCLUDING LEADING T/P FOR TONE OR PULSE DIALING AND ANY
C    REQUIRED LONG DISTANCE AND ACCOUNTING INFORMATION
C
      OPEN(UNIT=2,NAME='NISTIME.CFG',TYPE='OLD',
     + ACCESS='SEQUENTIAL',FORM='FORMATTED',
     + CARRIAGECONTROL='LIST',READONLY,DISPOSE='SAVE')
      READ(2,1) IL,(TELNO(I),I=1,IL)
      TELNO(IL+1)=0
    1 FORMAT(Q,40A1)
C
C     SECOND LINE OF CONFIGURATION FILE HAS PORT NUMBER IN FIRST
C     TWO PLACES FOLLOWED BY AS MANY OPERATION CODE LETTERS AS
C     NEEDED
C
      READ(2,2) IPORT,IL,(PARAM(I),I=1,IL)
    2 FORMAT(O2,Q,10A1)
C
C     NOW SET OPERATION USING SPECIFIED PARAMETERS
C
C     TURN OFF MS BIT OF EACH CHARACTER AND CONVERT
C     TO UPPER CASE FOR COMPARISON
C
      IF(IL .GE. 1) THEN
      DO 3 I=1,IL
      IF(PARAM(I) .LT. 0) PARAM(I) = PARAM(I) + '200'O
      IF(PARAM(I) .GT. '140'O) PARAM(I)=PARAM(I) - '40'O
      IF(PARAM(I) .EQ. 'L') ILIST=1
      IF(PARAM(I) .EQ. 'A') IARC=1
      IF(PARAM(I) .EQ. 'C') ICHK=1
      IF(PARAM(I) .EQ. 'S') ISET=1
      IF(PARAM(I) .EQ. 'D') IDEBUG=1
      IF(PARAM(I) .EQ. 'R') IRATE=1
    3 CONTINUE
      ENDIF
C
C     THIRD LINE OF CONFIGURATION FILE HAS TIME ZONE AS 
C     LETTER P/p Pacific
C            M/m Mountain
C            C/c Central
C            E/e Eastern
C            Z/z Greenwich 
C     or as (signed) number: +/- j, giving difference between
C     local time and Greenwich.  Locations West of Greenwich are
C     negative, East are Positive.
C
C     optional trailing D/d, specifies conversion to Daylight 
C     savings time if present.
C
      READ(2,4) IL,(PARAM(I),I=1,IL)
    4 FORMAT(Q,10A1)
      DO 5 I=1,IL
      IF(PARAM(I) .LT. 0) PARAM(I) = PARAM(I) + 128
      IF(PARAM(I) .GT. '140'O) PARAM(I)=PARAM(I) - '40'O
    5 CONTINUE
      DO 9 I=IL+1,10
      PARAM(I) = 0
    9 CONTINUE
C
C    IF FIRST CHARACTER IS A ZONE LETTER THEN DECODE IT
C    AND CHECK IF SECOND CHARACTER IS DAYLIGHT SAVINGS FLAG
C   
C    IF FIRST CHARACTER IS A SIGN OR DIGIT, THEN PARSE NUMBER
C
      IF(PARAM(1) .EQ. 'P') THEN
        IUTDIF=-8
      ELSEIF(PARAM(1) .EQ. 'M') THEN
        IUTDIF=-7
      ELSEIF(PARAM(1) .EQ. 'C') THEN
        IUTDIF=-6
      ELSEIF(PARAM(1) .EQ. 'E') THEN
        IUTDIF=-5
      ELSEIF(PARAM(1) .EQ. 'Z') THEN
        IUTDIF=0
      ELSEIF(PARAM(1) .EQ. '-') THEN
        ISIGN=-1
        IUTDIF=0
        GO TO 6
      ELSEIF(PARAM(1) .EQ. '+') THEN
        ISIGN=+1
        IUTDIF=0
        GO TO 6
      ELSEIF((PARAM(1).GE. '0').AND. (PARAM(1).LE. '9'))THEN
        ISIGN=+1
        IUTDIF=(PARAM(1) - '0')
        GO TO 6
      ELSE
        TYPE 7
    7 FORMAT(' Error on third line of configuration file.')
      STOP
      ENDIF
      IS=2
      GO TO 11
C
C    COME HERE IF FIRST CHARACTER WAS SIGN OR DIGIT -- PARSE
C    FOLLOWING CHARACTERS AS UTC OFFSET AS NUMBER
C
    6 IS=2
      IF( (PARAM(2) .GE. '0') .AND. (PARAM(2) .LE. '9'))THEN
        IUTDIF= 10*IUTDIF + (PARAM(2) - '0')
        IS=3
      ENDIF
      IF( (PARAM(3) .GE. '0') .AND. (PARAM(3) .LE. '9'))THEN
        IUTDIF= 10*IUTDIF + (PARAM(3) - '0')
        IS=4
      ENDIF
      IUTDIF=IUTDIF*ISIGN
   11 IF(PARAM(IS) .EQ. 'D') THEN
         IDST=1
      ELSE
         IDST=0
      ENDIF
C
      CLOSE(UNIT=2,DISPOSE='SAVE')
C
      IF(IDEBUG .NE. 0) THEN
      TYPE 18,ILIST,ICHK,IARC,ISET,IDEBUG,IRATE,
     +  IPORT,TELNO,IUTDIF,IDST
   18 FORMAT(' Operations Requested'/
     + ' List ='I2' Check='I2' Archive='I2' Set='I2' Debug='I2/
     + ' Rate ='I2/
     + ' Port ='O2' Telephone Number='40A1/
     + ' UTC offset='I5' Daylight Savings Flag='I2)
      ENDIF
      CALL ASNLUN(1,'TT',IPORT,IDS)
      IF(IDS .NE. 1) CALL STPERR(100,IDS)
C
C     ATTEMPT ATTACH OF DIALER.  IF ATTACH FAILS TO COMPLETE IN 5
C     SECONDS, SOMETHING IS WRONG -- SOMEBODY ELSE HAS THE DIALER
C     IN THAT CASE EXIT WITH ERROR
C
C      ON THE OTHER HAND, IF ATTACH IS OKAY, THEN CANCEL MARK TIME
C     REQUEST SINCE THAT EVENT FLAG WILL BE USED AGAIN LATER.
C
      CALL QIO(IOATT,1,1,,ISB,IPRL,IDS)
      IF(IDS .NE. 1) CALL STPERR(1,IDS)
      CALL MARK(3,5,2,IDS)
      IF(IDS .NE. 1) CALL STPERR(21,IDS)
      CALL WFLOR(1,3)
      CALL READEF(3,IDS)
      IF(IDS .EQ. 2) CALL STPERR(22,IDS)
      CALL CANMT(3,IDS)
      IF(IDS .NE. 1) CALL STPERR(23,IDS)
      CALL GETADR(IPRL(1),IBB(1))
      IPRL(2)=14
      CALL WTQIO(ISFSMC,1,1,,ISB,IPRL,IDS)
C
C    IF SF.SMC IS OKAY THEN PROCEED. 
C    IF SF.SMC IS NOT OKAY AND ERROR IS IN SPEED SET
C     THEN PRINT MESSAGE AND WAIT FOR RESPONSE
C
      IF(ISB(1) .EQ. 1) GO TO 133
      IF(ISB(2) .EQ. 10) THEN
        TYPE 134
  134   FORMAT('$Error -- can''t set speed of requested port.',
     +         '  Proceed ? [y/n] =')
      READ(5,124) IANS
      IF(IANS .LT. 0) IANS= IANS + '200'O
      IF(IANS .GT. '140'O) IANS=IANS - '40'O
      IF(IANS .EQ. 'N') CALL STPERR(0,0)
      ELSE
        CALL STPERR(2,ISB)
      ENDIF
C
C     IF RATE ESTIMATE TO BE MADE, GET LAST VALUE FROM FILE NOW
C
  133 IF(IRATE .NE. 0) CALL GETLST
C
C    IF FIRST DIGIT IS M THEN MANUAL DIALING IS REQUESTED
C    PRINT MESSAGE AND WAIT
C    OTHERWISE CALL DIALING SUBROUTINE
C
      IF(TELNO(1) .LT. 0) TELNO(1)= TELNO(1) + '200'O
      IF( (TELNO(1) .EQ. 'M')  .OR.
     +    (TELNO(1) .EQ. 'm') ) THEN
      TYPE 123
  123 FORMAT(' Dial telephone now. Enter'/
     + '       y<cr> when connection is complete'/
     + '       n<cr> if busy or no answer.')
      TYPE 125
  125 FORMAT('$Ans=')
      READ(5,124) IANS
  124 FORMAT(A1)
      IF(IANS .LT. 0) IANS= IANS + '200'O
      IF(IANS .GT. '140'O) IANS= IANS -'40'O
      IF(IANS .EQ. 'N') CALL STPERR(0,0)
      ELSE
      CALL DIALIT(TELNO)
      ENDIF
      CALL RCVDAT
      CALL HANGUP
      CALL STPERR(0,0)
      END
      SUBROUTINE STPERR(J,JDS)
      INTEGER*2 JDS(2)
C
C     FOLLOWING CODE DETACH PORT
C
      PARAMETER IODET='2000'O
C
      IF(J .NE. 0) TYPE 1,J,JDS
    1 FORMAT(' ERROR 'I3' STATUS='O6,'SECOND STATUS='O6)
      CLOSE(UNIT=2,DISPOSE='SAVE')
C
      CALL QIO(IODET,1,1)
      CALL EXIT
      END
      SUBROUTINE RCVDAT
C
C     RECEIVES DATA FROM THE NIST ACTS SERVICE AND STORES T HE
C     LINES IN A BUFFER.  UP TO 40 LINES ARE RECEIVED
C
      BYTE ILEN(20),LINES(80,20),IJJ
      INTEGER*2 ISB(2),IPRL(6)
      INTEGER*2 JSB(2),JPRL(6)
C
      COMMON/OPS/ ILIST,ICHK,IARC,ISET,IDEBUG,IRATE
C
C     IORNTA IS READ PASS ALL , NO ECHO WITH TIMEOUT
C     IOWLB  IS WRITE LOGICAL BLOCK
C
C
      PARAMETER IORNTA='1230'O,IOWLB='400'O
C
C     PARAMETER BLOCK USED FOR READING
C
      CALL GETADR(IPRL(1),IJJ)
      IPRL(2)=1
      IPRL(3)=1
C
C     PARAMETER BLOCK USED FOR ECHOING ON TIME MARKER
C
      CALL GETADR(JPRL(1),IJJ)
      JPRL(2)=1
      JPRL(3)=0
C
      DO 1 ILIN=1,20
C
      IJJK=0
 9876 CALL WTQIO(IORNTA,1,1,,ISB,IPRL,IDS)
      IF(IDS .NE. 1)CALL STPERR(102,IDS)
C
C     TERMINATE READ LOOP ON A TIMEOUT
C
      IF(ISB(1) .EQ. 2)  GO TO 2
C
C     IGNORE ALL OTHER ERRORS
C
      IF(IAND(ISB(1),"377) .NE. 1) GO TO 9876
      IJJ=IJJ .AND. '177'O
      IF(IJJ .EQ. '15'O) THEN
      ILEN(ILIN)=IJJK
D     WRITE(4,5252) (LINES(MM,ILIN),MM=1,IJJK)
D5252 FORMAT(1X,80A1)
      GO TO 1
      ENDIF
      IF(IJJ .LT. '40'O) GO TO 9876
      IJJK=IJJK+1
      LINES(IJJK,ILIN)=IJJ
      IF( (IJJ .EQ. '*') .OR. (IJJ .EQ. '#') ) THEN
      CALL QIO(IOWLB,1,2,,JSB,JPRL)
      ENDIF
      IF( IJJ .EQ. '#') CALL PARSET(LINES(1,ILIN),MMSTAT)
      IF(MMSTAT .EQ. 0) GO TO 9876
      ILEN(ILIN)=IJJK
      GO TO 33
    1 CONTINUE
      ILIN=21
    2 ILIN=ILIN-1
   33 IF(ILIST .NE. 0) THEN
      DO 5544 I=1,ILIN
      MM=ILEN(I)
      TYPE 5545, (LINES(NN,I),NN=1,MM)
 5545 FORMAT(1X,80A1)
 5544 CONTINUE
      ENDIF
      RETURN
      END
      SUBROUTINE PARSET(BUF,MMSTAT)
C
C     RECEIVES A LINE FROM NIST AND PARSES IT TO EXTRACT TIME
C     IF SECOND IS TOO NEAR END OF MINUTE, WAIT FOR NEW MINUTE
C     CHECKS THAT TIME OF TWO CONSECUTIVE LINES DIFFER BY
C     EXACTLY ONE SECOND
C
      COMMON/OPS/ILIST,ICHK,IARC,ISET,IDEBUG,IRATE
C
C     COMMON BLOCK LVAL HOLDS PREVIOUS VALUES READ FROM ARCHIVE FILE
C     FOR RATE ESTIMATE IF REQUESTED
C
      COMMON/LVAL/IPYR,IPMO,IPDY,IPHR,IPMIN,IPSEC,PDIFF,CUNIT
      BYTE CUNIT
C
      REAL*8 SDIFF
      DATA IYR / 0 /
      BYTE BUF(80)
      INTEGER*2 ISYS(8),JSYS(8)
      INTEGER*2 MON(12)
      DATA MON /0,31,59,90,120,151,181,212,243,273,304,334/
C
C     MMSTAT SETS RETURN STATUS.  IF MMSTAT=0 CONTINUE, =1 FINISHED
C
      MMSTAT=0
      DO 1 I=1,80
      IF(BUF(I) .EQ. '-') GO TO 2
    1 CONTINUE
      RETURN
    2 IF(IYR .EQ. 0) THEN
      IYR=10*(BUF(I-2) - '0')  + (BUF(I-1) - '0')
      IMO=10*(BUF(I+1) - '0')  + (BUF(I+2) - '0')
      IDY=10*(BUF(I+4) - '0')  + (BUF(I+5) - '0')
      IHR=10*(BUF(I+7) - '0')  + (BUF(I+8) - '0')
      IMN=10*(BUF(I+10)- '0')  + (BUF(I+11)- '0')
      ISC=10*(BUF(I+13)- '0')  + (BUF(I+14)- '0')
      IDS=10*(BUF(I+16)- '0')  + (BUF(I+17)- '0')
      IF(IDEBUG .NE. 0) TYPE 3, IYR,IMO,IDY,IHR,IMN,ISC,IDS
    3 FORMAT(7I4)
C
C     IF NEAR END OF MINUTE, SET IYR =0 SO THIS PORTION
C     WILL BE REPEATED IN NEW MINUTE
C
      IF(ISC .GT. 57) IYR=0
      RETURN
      ENDIF
C
C    IF WE GET HERE THIS MUST BE SECOND TIME THROUGH
C    GET THIS TIME AND COMPARE WITH PREVIOUS LINE
C
      JYR=10*(BUF(I-2) - '0')  + (BUF(I-1) - '0')
      JMO=10*(BUF(I+1) - '0')  + (BUF(I+2) - '0')
      JDY=10*(BUF(I+4) - '0')  + (BUF(I+5) - '0')
      JHR=10*(BUF(I+7) - '0')  + (BUF(I+8) - '0')
      JMN=10*(BUF(I+10)- '0')  + (BUF(I+11)- '0')
      JSC=10*(BUF(I+13)- '0')  + (BUF(I+14)- '0')
      JDS=10*(BUF(I+16)- '0')  + (BUF(I+17)- '0')
      IF(IDEBUG .NE. 0) TYPE 3, JYR,JMO,JDY,JHR,JMN,JSC,JDS
C
C    IF TWO LINES NOT CONSECUTIVE SET IYR=0 SO ENTIRE PROCESS
C    WILL BE REPEATED WITH NEXT TWO LINES
C
      IF(  (IYR .NE. JYR)  .OR.
     +     (IMO .NE. JMO)  .OR.
     +     (IDY .NE. JDY)  .OR.
     +     (IHR .NE. JHR)  .OR.
     +     (IMN .NE. JMN)  .OR.
     +     (IDS .NE. JDS)  .OR.
     +     (ISC .NE. (JSC -1))  ) THEN
      IYR = 0
      RETURN
      ENDIF
C
C     IF CHECK OR ARC IS ENABLED, THEN 
C     GET SYSTEM TIME FOR COMPARISONS
C      
C      WE NEED NUMBER OF TICKS PER SECOND FOR SET, BUT REST OF
C      TIME WILL NOT BE USED
C
      CALL GETTIM(ISYS)
C
C     CONVERT RECEIVED TIME TO LOCAL TIME USING DAYLIGHT SAVINGS
C     TIME FLAG IF REQUESTED.  THIS MUST BE DONE BEFORE SYSTEM CAN
C     BE SET OR TIME COMPARED
C
C     NOTE THAT CONVERSION TO LOCAL TIME CANNOT CHANGE MINUTE OR
C     SECOND AND THAT THEY ARE CORRECT NOW
C
      CALL CVTLCL(JYR,JMO,JDY,JHR,JDS)
C
C     IF SET ENABLED THEN SET THE TIME NOW
C
      IF(ISET .NE. 0) THEN
      JSYS(1)=JYR
      JSYS(2)=JMO
      JSYS(3)=JDY
      JSYS(4)=JHR
      JSYS(5)=JMN
      JSYS(6)=JSC
      JSYS(7)=0
      JSYS(8)=ISYS(8)
      CALL SETTIM(JSYS)
      ENDIF
C
C     NOW DEAL WITH COMPARING NIST AND SYSTEM TIMES
C
C     IF ICHK, IARC, IRATE ARE ZERO, THEN WE ARE FINISHED.
C
      IF( (ICHK .EQ. 0) .AND. 
     +    (IARC .EQ. 0) .AND.
     +    (IRATE .EQ. 0) )GO TO 77
C
C    GET ELAPSED TIME SINCE LAST COMPARISON IF RATE ESTIMATE REQUESTED
C
      IF(IRATE .NE. 0) THEN
      ELAPSE=365.*(JYR - IPYR) + MON(JMO) - MON(IPMO)
      IF( ( (JYR .AND. 3) .EQ. 0) .AND. 
     +    (  JMO          .GT. 2) ) ELAPSE=ELAPSE + 1.
      IF( ( (IPYR.AND. 3) .EQ. 0) .AND.
     +    (  IPMO         .GT. 2) ) ELAPSE=ELAPSE - 1.
      ELAPSE=ELAPSE + (JDY - IPDY) +
     +                (JHR - IPHR)/24.D+0 + 
     +                (JMN - IPMIN)/1440.D+0 +
     +                (JSC - IPSEC)/86400.D+0
      IF(CUNIT .EQ. 'D') THEN
        SDIFF=86400.D+0*PDIFF
      ELSEIF(CUNIT .EQ. 'H') THEN
        SDIFF=3600.D+0*PDIFF
      ELSEIF(CUNIT .EQ. 'M') THEN
        SDIFF=60.D+0*PDIFF
      ELSEIF(CUNIT .EQ. 'S') THEN
        SDIFF=PDIFF
      ELSEIF(CUNIT .EQ. 'T') THEN
        SDIFF=PDIFF/ISYS(8)
      ENDIF
      IF(IDEBUG .NE. 0) TYPE 5555,ELAPSE,SDIFF
 5555 FORMAT(1X,F9.4' Days since last comparison which was 'F8.3' sec.')
      ENDIF
      IFRACT=(100.*FLOAT(ISYS(7)))/FLOAT(ISYS(8))
      IDIFF=ISYS(1) - JYR
      IF( ABS(IDIFF) .GT. 1) THEN
      QDIFF=IDIFF
      MDIFF='yr'
      IF(IRATE .NE. 0)SDIFF=(31536000.D+0*QDIFF - SDIFF)/ELAPSE
      GO TO 47
      ENDIF
      III=ISYS(2)
      IDIFF=365*IDIFF + MON(III) - MON(JMO) + ISYS(3) - JDY
      IF( ((JYR .AND. 3) .EQ. 0)  .AND. (JMO .GT. 2))IDIFF=IDIFF-1
      IF( ((ISYS(1).AND.3).EQ.0) .AND. (ISYS(2) .GT.2))IDIFF=IDIFF+1
      IF( ABS(IDIFF) .GT. 1) THEN
      QDIFF=IDIFF
      MDIFF='dy'
      IF(IRATE .NE. 0) SDIFF=(86400.D+0*QDIFF - SDIFF)/ELAPSE
      GO TO 47
      ENDIF
      IDIFF=24*IDIFF + ISYS(4) - JHR
      IF( ABS(IDIFF) .GT. 30) THEN
      QDIFF=IDIFF
      MDIFF='hr'
      IF(IRATE .NE. 0) SDIFF=(3600.D+0*QDIFF - SDIFF)/ELAPSE
      GO TO 47
      ENDIF
      IDIFF=60*IDIFF + ISYS(5) - JMN
      IF( ABS(IDIFF) .GT. 100) THEN
      QDIFF=IDIFF
      MDIFF='m '
      IF(IRATE .NE. 0) SDIFF=(60.D+0*QDIFF - SDIFF)/ELAPSE
      GO TO 47
      ENDIF
      IDIFF=60*IDIFF + ISYS(6) - JSC
      QDIFF=FLOAT(IDIFF) + FLOAT(IFRACT)/100.
      MDIFF='s '
      IF(IRATE .NE. 0) SDIFF=(QDIFF - SDIFF)/ELAPSE
      IF( ABS(QDIFF) .GT. 1.) GO TO 47
      QDIFF=FLOAT(ISYS(8))*QDIFF
      MDIFF='tk'
   47 IF(ICHK .NE. 0) THEN
      TYPE 44,(ISYS(I),I=1,6),IFRACT
   44 FORMAT(' System Time='I2'-'I2.2'-'I2.2,1X,I2.2':'I2.2':'I2.2'.'
     +  I2.2)
      TYPE 45,JYR,JMO,JDY,JHR,JMN,JSC
   45 FORMAT(' NIST Time  ='I2'-'I2.2'-'I2.2,1X,I2.2':'I2.2':'I2.2,
     + '.00')
      IF(QDIFF .GE. 1.) THEN
      TYPE 48,QDIFF,MDIFF
      ELSEIF(QDIFF .LE. -1.) THEN
      TYPE 49,-QDIFF,MDIFF
      ELSE
      TYPE 50
      ENDIF
   48 FORMAT(' System time fast by 'F6.2,A2)
   49 FORMAT(' System time slow by 'F6.2,A2)
   50 FORMAT(' System time correct to within 1 tick')
      ENDIF
      IF(IRATE .NE. 0) THEN
      TYPE 5554,SDIFF
 5554 FORMAT(' Approximate rate offset='F8.3' s/day.')
      ENDIF
      IF(IARC .NE. 0) THEN
      OPEN(UNIT=2,NAME='NISTIME.DIF',TYPE='UNKNOWN',
     + FORM='FORMATTED',ACCESS='APPEND',CARRIAGECONTROL='LIST',
     + DISPOSE='SAVE')
      WRITE(2,51) JYR,JMO,JDY,JHR,JMN,JSC,QDIFF,MDIFF
   51 FORMAT(1X,SS,I2'-'I2.2'-'I2.2,1X,I2.2':'I2.2':'I2.2,1X,
     + SP,F7.2,A2)
      CLOSE(UNIT=2,DISPOSE='SAVE')
      ENDIF
   77 MMSTAT=1
      RETURN
      END
      SUBROUTINE CVTLCL(JYR,JMO,JDY,JHR,JDS)
C
C     CONVERT RECEIVED TIME TO LOCAL TIME BASED ON CONSTANTS IN
C     COMMON BLOCK /LOCAL/
C
      COMMON/LOCAL/IUTDIF,IDST
C
C    FOLLOWING ARRAY HOLDS LAST DAY OF EVERY MONTH
C
      INTEGER*2 LDAY(12)
      DATA LDAY /31,28,31,30,31,30,31,31,30,31,30,31/
C
C     FEB HAS 29 DAYS IN A LEAP YEAR
C
      IF( (JYR .AND. 3) .EQ. 0) LDAY(2)=29
C
C     FIRST CONVERT HOURS TO LOCAL TIME
C
      JHR=JHR + IUTDIF
C
C     ADD DAYLIGHT SAVINGS TIME IF REQUESTED AND IF NEEDED
C
C     IF IDST NON ZERO THEN DST WAS REQUESTED
C     IF JDS IS 2 - 50 INCLUSIVE WE ARE SOLIDLY IN DST
C
C     FLAG KDS SHOWS THAT CONVERSION TO DST HAS BEEN DONE
C
      IF( (IDST .NE. 0)  .AND.
     +    (JDS  .LE.50)  .AND.
     +    (JDS  .GT. 1)  ) THEN
         JHR= JHR + 1
         KDS=1
      ELSE
         KDS=0
      ENDIF
c
c     if conversion to dst was requested and this is the
c     Fall transition day and the transition time has not
c     yet arrived, then we are still on dst.  note that
c     the test uses jhr < 1 even though the transition is
c     at 0200 since jhr has been converted to standard time
c     above so that the transition time will arrive when jhr=1
c
      if( (idst .ne. 0) .and.
     +    (jds  .eq. 1) .and.
     +    (jhr  .lt. 1) ) then
        jhr=jhr + 1
        kds=1
      endif
C
C
C    NOW SEE IF CHANGING THE HOUR AFFECTED THE DAY
C
C    IF HOUR IS NEGATIVE, GO BACK TO PREVIOUS DAY
C    AND THEN PROPAGATE BACKWARDS THROUGH MONTH AND YEAR IF NEEDED
C
C     SINCE THE DAYLIGHT SAVINGS TIME FLAG IS LINKED TO LOCAL TIME
C     A CHANGE IN DAY/DATE MEANS A CHANGE IN FLAG.  THIS IS ONLY
C     IMPORTANT IF WE ARE IN FACT ON A TRANSITION DAY.
C
      IF(JHR .LT. 0) THEN
         JHR=JHR + 24
         JDY=JDY - 1
         JDS=JDS + 1
         IF(JDY .LT. 1) THEN
            JMO=JMO - 1
            IF(JMO .LT. 1) THEN
               JMO=12
               JYR=JYR -1
            ENDIF
            JDY=LDAY(JMO)
         ENDIF
      ENDIF
      IF(JHR .GT. 23) THEN
         JHR=JHR - 24
         JDY=JDY + 1
         JDS=JDS - 1
         IF(JDY .GT. LDAY(JMO)) THEN
            JDY=1
            JMO=JMO + 1
            IF(JMO .GT. 12) THEN
               JMO=1
               JYR=JYR + 1
            ENDIF
         ENDIF
      ENDIF
C
C    IF DST CONVERSION REQUESTED AND IF IT WAS NOT DONE BEFORE
C    THEN NOW CHECK FOR CONVERSION ON TRANSITION DAYS  --
C    AFTER 2 AM ON THE DAY DST STARTS AND BEFORE 2 AM ON THE DAY
C    IT ENDS
C
c    since jhr is set above to standard time by default, the
c    Fall conversion will actuall arrive at jhr=1
C
      IF( (IDST .NE. 0) .AND. (KDS .EQ. 0) ) THEN
         IF( (JDS .EQ. 51) .AND. (JHR .GE. 2) ) JHR=JHR + 1
         IF( (JDS .EQ.  1) .AND. (JHR .LT. 1) ) JHR=JHR + 1
      ENDIF
      RETURN
      END
      SUBROUTINE DIALIT(TELNO)
C
C     THIS SUBROUTINE DIALS A NUMBER USING HAYES COMMANDS
C     THE DIALER IS CONNECTED VIA LUN 1
C     
C     THIS SUBROUTINE ASSUMES THAT THE CALLING TASK HAS
C     PROPERLY SET THE SPEED AND PARITY OF THE LINE CONNECTED TO
C     THE DIALER.
C
      PARAMETER IORNT="1220
      PARAMETER IOWAL="410,ISFSMC="2440
      PARAMETER IOWLB='400'O
C
      INTEGER*2 IPRL(6),ISB(2)
      INTEGER*2 KPRL(6),KSB(2)
      BYTE BUFI(80),BUFO(80)
      BYTE IZ(4),TELNO(40)
C
C     THE FOLLOWING EQUIVALENCES ASSURE THAT THE BYTE ARRAYS
C     USED FOR SET CHARACTERISTICS ARE WORD ALIGNED
C
      BYTE KBB(2)
      EQUIVALENCE(KBB(1),KDUMMY)
C
C     IOPT IS THE OPTION COMMAND STRING FOR THE MODEM
C
      BYTE IOPT(12)
C
C     IZ IS MODEM INTIALIZE STRING
C
      DATA IZ / 'A','T','Z','15'O/
C
C     FOLLOWING CODE CLEARS TYPEAHEAD BUFFER WHEN USED IN SF.SMC
C
      DATA KBB / "71,0 /
      DATA IOPT/ 'A','T',' ','E','1',' ','Q','0',' ','V','0','15'O/
C
C     SET UP K ARRAYS TO CLEAR BUFFER
C
      CALL GETADR(KPRL(1),KBB(1))
      KPRL(2)=2
C
C     SEND RESET STRING TO MODEM
C
      CALL GETADR(IPRL(1),IZ)
      IPRL(2)=4
      IPRL(3)=0
      CALL WTQIO(IOWLB,1,1,,ISB,IPRL,IDS)
      IF(IDS .NE. 1) CALL STPERR(703,IDS)
      IF(ISB(1) .NE. 1) CALL STPERR(704,ISB)
C
C    WAIT FOR MODEM TO FINISH RESET
C
      CALL WAIT(2,2)
C
C     NOW SET MODEM CHARACTERISTICS
C
      CALL GETADR(IPRL(1),IOPT(1))
      IPRL(2)=11
      IPRL(3)='53'O
      CALL WTQIO(IOWLB,1,1,,ISB,IPRL,IDS)
      IF(IDS .NE. 1) CALL STPERR(705,IDS)
      IF( (ISB(1) .AND. '377'O) .NE. 1) CALL STPERR(706,ISB)
      CALL WAIT(2,2)
C
C     CLEAR INPUT BUFFER
C
      CALL WTQIO(ISFSMC,1,1,,KSB,KPRL,KDS)
      IF(KDS .NE. 1) CALL STPERR(707,KDS)
      IF( (KSB(1) .AND. '377'O) .NE. 1) CALL STPERR(708,KSB)
C
      BUFO(1)='A'
      BUFO(2)='T'
      BUFO(3)='D'
      IJ=3
      DO 2 I=1,40
      IF( TELNO(I) .EQ. 0) GO TO 22
      IJ=IJ+1
      BUFO(IJ)=TELNO(I)
    2 CONTINUE
   22 CALL GETADR(IPRL(1),BUFO(1))
      IPRL(2)=IJ
      IPRL(3)="53
      CALL WTQIO(IOWLB,1,1,,ISB,IPRL,IDS)
      IF(ISB(1) .NE. 1) CALL STPERR(3,ISB(1))
      CALL GETADR(IPRL(1),BUFI(1))
      IPRL(2)=70
      IPRL(3)=10
      ILIN=0
  800 CALL WTQIO(IORNT,1,1,,ISB,IPRL,IDS)
C
C      IF THE RESPONSE READ BY THIS QIO IS 3,4,6,7 OR 8, THEN THE CALL DID
C      NOT GO THROUGH -- WE HAVE A FATAL ERROR.  IF THE RESPONSE
C      IS 1,5, OR 10, WE HAVE A LIFT OFF.  OTHER RESPONSES ARE
C      INTERMEDIATE ONES OR ARE RESIDUES OF THE DIALING COMMANDS.
C      IN THAT CASE GO BACK AND READ THE NEXT LINE
C
      ILIN=ILIN+1
D     TYPE 801,ILIN,ISB,BUFI(1),BUFI(1)
D 801 FORMAT(' ILIN,ISB,BUFI,BUFI='1X,I3,2O6,1X,A1,1X,O4)
C
C      IF ENDS ON A TIMEOUT THEN CALL ERROR
C
      IF( (ISB(1) .AND. '377'O) .EQ. 2) CALL STPERR(801,ISB)
C  
C     POSSIBLE INTERMEDIATE RESPONSES ARE 0 OR 2 OR A NON-DIGIT.
C     IN THESE CASES GO BACK AND READ THE NEXT RESPONSE
C
      IF( (BUFI(1) .LT. '0') .OR. (BUFI(1) .GT. '9') .OR.
     +    (BUFI(1) .EQ. '0') .OR. (BUFI(1) .EQ. '2') ) GO TO 800
C
C     ANY OTHER RESPONSE EXCEPT ON LINE IS BAD NEWS
C
      IF(ISB(2) .GT. 0)
     +TYPE 888,(BUFI(K),K=1,ISB(2))
  888 FORMAT(' MODEM ANSWER='40A1)
      ISTAT=0
      IF( (BUFI(1) .EQ. '1') .OR. (BUFI(1) .EQ. '5') )RETURN 
      TYPE 887
  887 FORMAT(' Exit -- No answer from NIST')
      CALL STPERR(0,0)
      END
      SUBROUTINE HANGUP
C
C     HANGS UP THE DIALER.
C
C     THIS FOLLOWING CODE IS IO.WBT, I.E. A BREAKTHROUGH WRITE.
C
      PARAMETER IOWBT='500'O
C
      INTEGER *2 IPRL(6),ISB(2)
      BYTE IQUIT(3),IHANG(3)
C
      DATA IQUIT / '+','+','+' /
      DATA IHANG / 'A','T','H' /
C
      CALL WAIT(3,2)
      CALL GETADR(IPRL(1),IQUIT)
      IPRL(2)=3
      IPRL(3)=0
      CALL WTQIO(IOWBT,1,1,,ISB,IPRL,IDS)
      CALL WAIT(3,2)
      CALL GETADR(IPRL(1),IHANG)
      IPRL(2)=3
      IPRL(3)='53'O
      CALL WTQIO(IOWBT,1,1,,ISB,IPRL,IDS)
      RETURN
      END
      SUBROUTINE GETLST
C
C     THIS SUBROUTINE READS THE ARCHIVE FILE AND GETS THE
C     LAST VALUE STORED THERE FOR SUBSEQUENT ESTIMATE OF 
C     THE RATE OFFSET OF THE COMPUTER CLOCK
C
      COMMON/OPS/ILIST,ICHK,IARC,ISET,IDEBUG,IRATE
      COMMON/LVAL/IPYR,IPMO,IPDY,IPHR,IPMIN,IPSEC,PDIFF,CUNIT
      BYTE CUNIT
      OPEN(UNIT=2,NAME='NISTIME.DIF',TYPE='OLD',ACCESS='SEQUENTIAL',
     + FORM='FORMATTED',CARRIAGECONTROL='LIST',DISPOSE='SAVE',
     + READONLY)
      INUM=0
    1 READ(2,2,END=3,ERR=5)IPYR,IPMO,IPDY,IPHR,IPMIN,IPSEC,
     + PDIFF,CUNIT
    2 FORMAT( 6(1X,I2),F8.2,A1)
      INUM=INUM + 1
      GO TO 1
    5 TYPE 6,INUM
    6 FORMAT(' GETLST -- Error reading archive file at line'I5)
      CALL STPERR(50,INUM)
    3 IF(IDEBUG .NE. 0) TYPE 7,INUM,IPYR,IPMO,IPDY,IPHR,IPMIN,IPSEC,
     +   PDIFF,CUNIT
    7 FORMAT(' Last values read from file at line' I2'=',
     + 6(1X,I2),F7.2,A1)
C
C    CONVERT UNITS TO UPPER CASE IF NECESSARY
C
      IF(CUNIT .GT. '140'O) CUNIT= CUNIT - '40'O
      CLOSE(UNIT=2)
      RETURN
      END
